<?php
/**
 * This file is part of the TelegramBot package.
 *
 * (c) Avtandil Kikabidze aka LONGMAN <akalongman@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Longman\TelegramBot\Commands\SystemCommands;

use Longman\TelegramBot\Commands\SystemCommand;
use Longman\TelegramBot\Conversation;
use Longman\TelegramBot\Entities\InlineKeyboardButton;
use Longman\TelegramBot\Entities\Update;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;
use Longman\TelegramBot\Entities\InlineKeyboard;
use Longman\TelegramBot\Telegram;

/**
 * Callback query command
 *
 * This command handles all callback queries sent via inline keyboard buttons.
 *
 * @see InlinekeyboardCommand.php
 */
class UtilDB extends SystemCommand
{
    public $pdo;

    public function __construct(Telegram $telegram, Update $update = null)
    {
        $pdo = DB::getPdo();
        $this->pdo = $pdo;
        $this->pdo->setAttribute($pdo::ATTR_ERRMODE, $pdo::ERRMODE_WARNING);

        parent::__construct($telegram, $update);
    }

    public function getProditos($produto_id){

        $sql = "SELECT * FROM produtos WHERE idProdutos = $produto_id AND status = 1";
        $query = $this->pdo->query($sql);
        $produto = $query->fetch();

        return $produto;


    }

}

