<?php

/**

 * This file is part of the TelegramBot package.

 *

 * (c) Avtandil Kikabidze aka LONGMAN <akalongman@gmail.com>

 *

 * For the full copyright and license information, please view the LICENSE

 * file that was distributed with this source code.

 */



namespace Longman\TelegramBot\Commands\SystemCommands;



use Longman\TelegramBot\Commands\AdminCommands\ChatsCommand;

use Longman\TelegramBot\Commands\SystemCommand;

use Longman\TelegramBot\Commands\UserCommands\UploadCommand;

use Longman\TelegramBot\Conversation;

use Longman\TelegramBot\Entities\InlineKeyboardButton;

use Longman\TelegramBot\Request;

use Longman\TelegramBot\DB;

use Longman\TelegramBot\DBCommands;

use Longman\TelegramBot\Entities\InlineKeyboard;

use Longman\TelegramBot\Commands\SystemCommands\GenericCommand;



/**

 * Callback query command

 *

 * This command handles all callback queries sent via inline keyboard buttons.

 *

 * @see InlinekeyboardCommand.php

 */

class CallbackqueryCommand extends SystemCommand

{

    /**

     * @var string

     */

    protected $name = 'callbackquery';



    /**

     * @var string

     */

    protected $description = 'Reply to callback query';



    /**

     * @var string

     */

    protected $version = '1.1.1';

    protected $need_mysql = true;

    protected $conversation;

    public $callback_query;

    public $callback_query_id;

    public $callback_method_data;



    public $chat_id;

    public $message_id;

    public $pdo;

    public $user;

    public $notes;

    public $util;



    public $inline_keyboard;



    //DECLARAÇÃO DO METODO

    public $callback_class;

    public $callback_method;

    public $callback_data;





    /**

     * Command execute method

     *

     * @return \Longman\TelegramBot\Entities\ServerResponse

     * @throws \Longman\TelegramBot\Exception\TelegramException

     */

    public function execute()

    {



        //Preenchendo váriaveis

        $this->callback_query = $this->getCallbackQuery();

        $this->callback_query_id = $this->callback_query->getId();

        $this->callback_data = $this->callback_query->getData();



        $callback = explode("_", $this->callback_data);



        $this->callback_class = $callback[0];

        $this->callback_method = $callback[1];





        unset($callback[0]);

        unset($callback[1]);



        $callback_data_array = $callback[2];

        $this->callback_method_data = $callback_data_array;



        $this->chat_id = $this->callback_query->getFrom()->getId();

        $this->message_id = $this->callback_query->getMessage()->getMessageId();



        $pdo = DB::getPdo();

        $this->pdo = $pdo;

        $this->pdo->setAttribute($pdo::ATTR_ERRMODE, $pdo::ERRMODE_WARNING);



        $this->conversation = new Conversation(

            $this->callback_query->getFrom()->getId(),

            $this->callback_query->getFrom()->getId(),

            $this->getName()

        );



        $this->notes = &$this->conversation->notes;

        !is_array($this->notes) && $this->notes = [];



        $lastMsgId = $this->notes['lastMsgId'];

        //Request::sendMessage(array('chat_id' => $this->chat_id, 'text' => "Exec : ".json_encode($this->callback_query)));



        if (($this->notes['msgDadosEnvioId'] != $this->message_id) or ($this->notes['msgStart'] != $this->message_id)) {

            $this->deleteMessage($this->message_id);

        }



        //$this->sendMessage($this->callback_class . $this->callback_method);

        //$this->sendMessage(json_encode($this->notes));



        //VERIFICANDO DADOS DO USUÁRIO

        $this->user = $this->UtilBuscaUsuarioByChat($this->chat_id);



        if (!empty($this->user)) {

            if ($this->user['bloqueado'] == 1) {



                $inline_keyboard = new InlineKeyboard();

                $return_text = "Seu usuário foi Bloqueado\nSeu ID é " . $this->chat_id . "\nEnvie este ID para o suporte";

                $inline_keyboard->addRow(new InlineKeyboardButton([

                    'text' => "\xF0\x9F\x8E\xA7 \xF0\x9F\x91\xA4 Suporte \xF0\x9F\x91\xA4 \xF0\x9F\x8E\xA7",

                    'url' => "https://t.me/MedicinasSagradas"

                ]));



                $this->sendMessage($return_text, $inline_keyboard);

            } else {

                //$this->sendMessage($this->callback_class . $this->callback_method);

                $this->{ucfirst($this->callback_class . $this->callback_method)}($this->callback_method_data);

            }





        } else {

            $text = "\xF0\x9F\x94\x92 <b>Usuário não cadastrado!</b> \xF0\x9F\x94\x92\nDigite o código de cadastro";

            $this->notes['requestData'] = "informarCodigoCadastro";

            $this->conversation->update();

            $this->sendMessage($text);

        }

        $this->conversation->update();



    }



    public function clearNotes()

    {

        $lastMsgId = $this->notes['lastMsgId'];

        $msgInicialId = $this->notes['msgInicialId'];

        unset($this->conversation->notes);

        $this->conversation->update();

        $this->conversation->stop();

        $this->conversation = new Conversation($this->chat_id, $this->chat_id, $this->getName());

        $this->notes = &$this->conversation->notes;

        !is_array($this->notes) && $this->notes = [];

        if (empty($this->notes['msgInicialId'])) {

            $this->notes['msgInicialId'] = $msgInicialId;



        }

        $this->conversation->update();

    }



    public function getMenu()

    {

        $idUsuario = $this->user['idUsuarios'];



        $user = $this->UtilBuscaUsuarioById($idUsuario);

        $idPermissao = $user['permissoes_id'];



        $menu = array();



        if ($idPermissao == 1) {

            $menu["MenuAdmin"] = array('text' => "\xE2\xAD\x90 Admin \xE2\xAD\x90", 'callback_data' => 'Menu_Admin');

            $menu["AdminEnviarAviso"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x93\xA2 Enviar Aviso \xF0\x9F\x93\xA2 \xE2\xAD\x90", 'callback_data' => 'Enviar_Aviso');

            

            $menu["AdminTodosControles"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x93\x96 Ver Todos Controles \xF0\x9F\x93\x96 \xE2\xAD\x90", 'callback_data' => 'Controle_DividasTodos');

            $menu["AdminUsuarios"] = array('text' => "\xF0\x9F\x93\x84 Meus pedidos \xF0\x9F\x93\x84", 'callback_data' => 'Admin_Usuarios');

            $menu["AdminListaUsuarios"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x91\xA4 Lista de usuários \xF0\x9F\x91\xA4 \xE2\xAD\x90", 'callback_data' => "Lista_Usuarios");

            $menu["AdminListarCustos"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x92\xB2 Listar todos os pedidos", 'callback_data' => 'AdminListarPedidos');

            $menu["AdminListarProdutosPendentes"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x93\xA6 Listar produtos pendentes \xF0\x9F\x93\xA6 \xE2\xAD\x90", 'callback_data' => 'AdminListarProdutosPendentes');

            $menu["AdminEstoque"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x93\x96 Estoque", 'callback_data' => 'Controle_Estoque');

            $menu["AdminListarCustos"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x92\xB2 Custos", 'callback_data' => 'Listar_Custos');

            $menu["AdminEnviarRastreio"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x93\xAB Todos pedidos aguardando SRO \xF0\x9F\x93\xAB \xE2\xAD\x90", 'callback_data' => "Enviar_RastreioAdmin");

            $menu["AdminPedidosPendentes"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x93\x84 TODOS PEDIDOS PENDENTES \xF0\x9F\x93\x84 \xE2\xAD\x90", 'callback_data' => 'Listar_PedidosPendentes_1');



        }



        $menu["CadastrarPedido"] = array('text' => "\xF0\x9F\x93\x9D Cadastrar pedido \xF0\x9F\x93\x9D", 'callback_data' => 'Venda_Cadastrar');

        $menu["MeusPedidosPendentes"] = array('text' => "\xF0\x9F\x93\x84 Meus pedidos \xF0\x9F\x93\x84", 'callback_data' => 'Escolher_TipoPedido');

        $menu["ConsultarPedido"] = array('text' => "\xF0\x9F\x93\x84 Consultar pedidos \xF0\x9F\x93\x84", 'callback_data' => 'Consultar_Pedido');



        $menu["AEmpresa"] = array('text' => "\xE2\x9D\xA4 Sobre o Night Company \xE2\x9D\xA4", 'callback_data' => 'A_Empresa');

        $menu["ControleFinanceiro"] = array('text' => "\xF0\x9F\x93\x96 Controle Financeiro \xF0\x9F\x93\x96", 'callback_data' => 'Controle_Dividas');

        $menu["InserirSaldo"] = array('text' => "\xF0\x9F\x92\xB5 Inserir saldo \xF0\x9F\x92\xB5", 'callback_data' => 'Input_ValorComprovante');



        $menu["InserirSaldoCliente"] = array('text' => "\xF0\x9F\x92\xB5 Inserir saldo \xF0\x9F\x92\xB5", 'callback_data' => 'Input_Conta');

        $menu["ConsultarProdutos"] = array('text' => "\xF0\x9F\x93\xA6 Consultar produtos \xF0\x9F\x93\xA6", 'callback_data' => 'Selciona_TipoBusca');

        $menu["EnviarRastreio"] = array('text' => "\xF0\x9F\x93\xAB Pedidos aguardando SRO \xF0\x9F\x93\xAB", 'callback_data' => "Enviar_Rastreio");



        $menu["ComprovantesPendentes"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x92\xB4 Comprovantes Pendentes \xF0\x9F\x92\xB4 \xE2\xAD\x90", 'callback_data' => "Comprovantes_Pendentes");

        $menu["PedidosAguardandoAprovacao"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x92\xB4 Pedidos Aguardando Aprovação \xF0\x9F\x92\xB4 \xE2\xAD\x90", 'callback_data' => "Pedidos_AguardandoAprovacao");

        $menu["ListarContas"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x92\xB4 Lista de Contas \xF0\x9F\x92\xB4 \xE2\xAD\x90", 'callback_data' => "Listar_Contas");

        $menu["ConvidarAmigos"] = array('text' => "\xF0\x9F\x98\x84 Convidar Amigos \xF0\x9F\x98\x84", 'callback_data' => "Listar_Convites");



        $menu["RevendedorConvites"] = array('text' => "\xF0\x9F\x93\x91 Convidar clientes \xF0\x9F\x93\x91", 'callback_data' => "Revendedor_Convites");

        $menu["FornecedorPainel"] = array('text' => "\xF0\x9F\x8F\xA2 \xF0\x9F\x92\xB0 Painel de Fornecedor \xF0\x9F\x92\xB0 \xF0\x9F\x8F\xA2", 'callback_data' => 'Fornecedor_Painel');

        $menu["CadastrarCliente"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x94\x91 Gerar chave de cadastro	\xF0\x9F\x94\x91 \xE2\xAD\x90", 'callback_data' => 'Cadastrar_Cliente');

        //$menu["escreverAviso"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x94\x91 Escrever Aviso \xF0\x9F\x94\x91 \xE2\xAD\x90", 'callback_data' => 'Cadastrar_Cliente');

        $menu["PerguntasFrequentes"] = array('text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => "Perguntas_Frequentes");

        $menu["RevendedorPainel"] = array('text' => "\xF0\x9F\x92\xB2 Painel de Revendedor \xF0\x9F\x92\xB2", 'callback_data' => "Revendedor_Painel");





        $menu["Suporte"] = array('text' => "\xF0\x9F\x8E\xA7 \xF0\x9F\x91\xA4 Suporte \xF0\x9F\x91\xA4 \xF0\x9F\x8E\xA7", 'url' => "https://t.me/MedicinasSagradas");



        return $menu;

    }



    //MENU

    public function MainMenu($data = array())

    {



        if (!empty($this->notes['msgDadosEnvioId'])) {

            $this->deleteMessage($this->notes['msgDadosEnvioId']);

        }



        $this->clearNotes();

        $userId = 1;



        //INFORMANDO MENU DE OPÇÕES

        $inline_keyboard = new InlineKeyboard();

        $idUsuario = $this->user['idUsuarios'];



        $user = $this->UtilBuscaUsuarioById($idUsuario);

        $idPermissao = $user['permissoes_id'];

        $dividaUser = $user['dividas'];



        $permissao = $this->UtilBuscaPermissaoById($idPermissao);

        $return_text = $this->SelecionaEmojiPermissao($idPermissao) . " ";

        $return_text .= "\xF0\x9F\x93\xB1 <b>Menu principal</b>\n\n\xE2\x80\xBC Caso tenha alguma mensagem além de 'start' acima dessa <b>LIMPE O CHAT</b> para evitar erros.\n\n";



        $totalizador = $this->totalizador($idUsuario, $userId);



        if ($totalizador > -1) {

            $totalizador = abs($totalizador);

            $return_text .= "\xF0\x9F\x92\xB2 \xE2\x9C\x85 Saldo: <b>R$$totalizador</b>\n\n";

        } else {

            $totalizador = abs($totalizador);

            $return_text .= "\xF0\x9F\x92\xB2 \xE2\x9D\x8C Você deve: <b>R$$totalizador</b>\n\n";

        }



        $sql = "SELECT * FROM usuarios WHERE usuario_indicador_id = " . $idUsuario;

        $query = $this->pdo->query($sql);

        $amigos = $query->fetchAll();

        $nAmigos = count($amigos);

        $return_text .= "-\n<b>\xF0\x9F\x98\x84 $nAmigos amigo(s) cadastrado(s)</b>\n\n";





        $sql = "SELECT * FROM token_cadastro WHERE criador_id = " . $idUsuario . " AND status = 1 AND recebedor_id IS NULL";

        $query = $this->pdo->query($sql);

        $tokens = $query->fetchAll();





        $nTokens = count($tokens);

        $return_text .= "\xF0\x9F\x94\x96 Você tem <b>$nTokens convite(s)</b> disponíveis.\n<i>Clique em <b>\xF0\x9F\x98\x84 Convidar Amigos \xF0\x9F\x98\x84</b> e saiba mais.</i>\n-\n";



        //$return_text .= "\xF0\x9F\x92\xB2 Saldo: ".$totais['valor'] ."\n\n";



        $sql = "SELECT * FROM vendas WHERE faturado = 1 AND usuarios_id = $idUsuario AND status <> 3 AND motivo_reprovacao IS NULL";

        $query = $this->pdo->query($sql);

        $vendas = $query->fetchAll();

        if (!empty($vendas)) {



            $return_text .= "\xF0\x9F\x9A\x9A <b>Pedidos pendentes</b>:\n\n";



            foreach ($vendas as $venda) {



                $cat = $this->UtilBuscaCategoriaById($venda['categoria_id']);



                $return_text .= "\xF0\x9F\x93\xAB Pedido #" . $venda['idVendas'] . "\n";

                $return_text .= "Data: " . date(('d/m/Y'), strtotime($venda['dataVenda'])) . "\n";

                $return_text .= "CEP: " . $venda['cep'] . "\n";

                $return_text .= $cat['categoria'] . "\n";



                $return_text .= "Envio: ".$venda['tipoEnvio'] . " : R$" . $venda['taxa_envio'] . "\n";



                //$text .= $venda['dadosEnvio'] . "\n";

                $vendaId = $venda['idVendas'];



                $produtos = $this->UtilBuscaItensVendaByVendaId($vendaId);



                $rows = $query->rowCount();

                $total = 0;

                if ($rows > 0) {

                    $listProd = "";

                    foreach ($produtos as $produto) {

                        $produto['subTotal'] = $produto['subTotal'];

                        $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n";

                        $total += $produto['subTotal'];

                    }

                    $listProd .= "<b>Total: R$" . $venda['valorTotal'] . "</b>\n";

                }

                switch ($venda['status']) {

                    case 1:

                        $listProd .= "\n\xF0\x9F\x95\x90 <b>AGUARDANDO APROVAÇÃO!</b> \xF0\x9F\x95\x90\n\xE2\x9A\xA0<i> O valor deste pedido ainda não foi retirado da sua conta!</i> \xE2\x9A\xA0";

                        break;

                    case 2:

                        $listProd .= "\n\xE2\x9C\x85 <b>AGUARDANDO RASTREIO</b> \xE2\x9C\x85\n";

                        break;

                }

                $return_text .= $listProd;

                $return_text .= "\n--------------------------\n";

            }

            //*************



            $return_text .= "Para vizualizar o pedido completo clique em \xF0\x9F\x93\x84 <b>Meus Pedidos</b> \xF0\x9F\x93\x84\n";

        }

        $return_text .= "\n\xE2\x80\xBC Caso tenha alguma mensagem além de 'start' acima dessa <b>LIMPE O CHAT</b> para evitar erros.";



        $menu = $this->getMenu();





        if ($idPermissao == 1) {

            //PERFIL ADMIN



            //$inline_keyboard->addRow(new InlineKeyboardButton($menu["CadastrarPedidoEmMaos"]));



            $inline_keyboard->addRow(new InlineKeyboardButton($menu["MenuAdmin"]));







        }

        $sql = "SELECT * FROM vendas WHERE faturado = 0 AND usuarios_id = $idUsuario AND status = 1 AND motivo_reprovacao IS NULL AND cep IS NOT NULL AND categoria_id IS NOT NULL ORDER BY idVendas DESC";

        $query = $this->pdo->query($sql);

        $vends = $query->fetchAll();

        if (!empty($vends)) {

            //$this->sendMessage(json_encode($vends));

            foreach ($vends as $vend) {

                $menu["PedidoIncompleto_" . $vend['idVendas']] = array('text' => "\xE2\x81\x89 Pedido incompleto - CEP: " . $vend['cep'] . " \xE2\x81\x89", 'callback_data' => "Pedido_Incompleto_" . $vend['idVendas']);

                $inline_keyboard->addRow(new InlineKeyboardButton($menu["PedidoIncompleto_" . $vend['idVendas']]));

            }



        }



        $sql = "SELECT * FROM dividas WHERE status = 0 AND enviador_id = $idUsuario AND aguardando_pag = 1 ORDER BY id DESC";

        $query = $this->pdo->query($sql);

        $pagamentoAbertos = $query->fetchAll();



        if (!empty($pagamentoAbertos)) {

            foreach ($pagamentoAbertos as $pagamentoAberto) {

                $menu["PagamentoAberto"] = array('text' => "\xE2\x81\x89 Pagamento em aberto : R$" . $pagamentoAberto['valor'] . " \xE2\x81\x89", 'callback_data' => "Pagamento_Incompleto_" . $pagamentoAberto['id']);

                $inline_keyboard->addRow(new InlineKeyboardButton($menu["PagamentoAberto"]));

            }



        }

        if ($this->user['fornecedor'] == 1) {

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["FornecedorPainel"]));

        }

        if ($this->user['revendedor'] == 1) {

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["RevendedorPainel"]));

        }

        if ($this->user['enviador'] == 1) {

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["EnviarRastreio"]));



        }





        //PARA TODOS

        $inline_keyboard->addRow(new InlineKeyboardButton($menu["CadastrarPedido"]));

        if ($this->user['dividas'] == 1) {

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["InserirSaldo"]));

        } else {



            if (empty($pagamentoAberto)) {

                $inline_keyboard->addRow(new InlineKeyboardButton($menu["InserirSaldo"]));

            }

        }

        if ($this->user['revendedor'] == 1) {

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["RevendedorConvites"]));

        } else {

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConvidarAmigos"]));

        }



        $inline_keyboard->addRow(new InlineKeyboardButton($menu["MeusPedidosPendentes"]));

        if ($idPermissao == 1) {

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarProdutos"]));

        }



        if ($idPermissao == 2) {

            //PERFIL SÓCIO/CUSTO



            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarPedido"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ControleFinanceiro"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarProdutos"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ListarContas"]));



        } else if ($idPermissao == 3) {

            //SUPER VENDEDOR

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ControleFinanceiro"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarProdutos"]));



        } else if ($idPermissao == 4) {

            //TELECRAZY

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ControleFinanceiro"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarProdutos"]));



        } else if ($idPermissao == 5) {

            //OFICIAIS MEDICINAS

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ControleFinanceiro"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarProdutos"]));





        } else if ($idPermissao == 6) {

            //FINAL

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ControleFinanceiro"]));

            /*

            if ($user['dividas'] == 1) {

                $inline_keyboard->addRow(new InlineKeyboardButton($menu["InserirSaldo"]));

            } else {

                $inline_keyboard->addRow(new InlineKeyboardButton($menu["InserirSaldoCliente"]));

            }

*/





            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarProdutos"]));

        }



        $inline_keyboard->addRow(new InlineKeyboardButton($menu["AEmpresa"]));



        $inline_keyboard->addRow(new InlineKeyboardButton($menu["PerguntasFrequentes"]));

        $inline_keyboard->addRow(new InlineKeyboardButton($menu["Suporte"]));



        return $this->sendMessage($return_text, $inline_keyboard);

    }



    public function MenuAdmin(){



        $inline_keyboard = new InlineKeyboard();

        $idUsuario = $this->user['idUsuarios'];



        $user = $this->UtilBuscaUsuarioById($idUsuario);

        $idPermissao = $user['permissoes_id'];



        if ($idPermissao == 1) {

            //PERFIL ADMIN

            $menu = $this->getMenu();

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminListarProdutosPendentes"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ComprovantesPendentes"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["PedidosAguardandoAprovacao"]));



            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ControleFinanceiro"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminPedidosPendentes"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarPedido"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["CadastrarCliente"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminEnviarRastreio"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminListaUsuarios"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminTodosControles"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ListarContas"]));

            $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminEnviarAviso"]));





            //$inline_keyboard->addRow(new InlineKeyboardButton($menu["EnviarAviso"]));





            /*   $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarProdutos"]));

               $inline_keyboard->addRow(new InlineKeyboardButton($menu["EnviarRastreio"]));

               $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminListaUsuarios"]));

               $inline_keyboard->addRow(new InlineKeyboardButton($menu["ListarContas"]));

               $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminTodosControles"]));

               $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminEstoque"]));

               $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminListarCustos"]));

               $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminEnviarRastreio"]));*/







            $return_text = "Teste";

            return $this->sendMessage($return_text, $inline_keyboard);

        }

    }

    public function AdminListarProdutosPendentes(){



        $sql = "SELECT * FROM produtos WHERE is_bot = 1 AND status = 0 ORDER BY idProdutos asc";

        $query = $this->pdo->query($sql);

        $produtos = $query->fetchAll();

        $rows = $query->rowCount();



        $text = "Selecione o produto que deseja publicar";

        if ($rows > 0) {



            $inline_keyboard = new InlineKeyboard();

            foreach ($produtos as $produto) {





                $inline_keyboard->addRow(new InlineKeyboardButton([

                    'text' => "#" .$produto['idProdutos']." - " . $produto['descricao'],

                    'callback_data' => "Publicar_Produto_" . $produto['idProdutos']

                ]));

            }

            $this->sendMessage($text, $inline_keyboard);

        }

    }



    public function AEmpresa(){

        $inline_keyboard = new InlineKeyboard();

        $text = "\xE2\x9D\xA4 <b>Seja bem vindo ao Night Company</b> \xE2\x9D\xA4\n\n";

        $text .= "Nossa missão é facilitar a adesão de produtos ilegais por opressão estatal.\n\n";

        $text .= "<b>\xF0\x9F\x86\x93 Não acreditamos em crimes sem vítima \xF0\x9F\x86\x93</b>\n\n";

        $text .= "Acreditamos na liberdade de expressão e de consumo. Estamos aqui para te evitar passar por situações contrangedoras e/ou perigosas.\n\n";

        $text .= "Nossa ideia não é incentivar o uso de drogas, porém acreditamos na redução de danos, ";

        $text .= "a partir do momento que cada um toma a decisão de fazer o uso de substâncias, que ao menos não precise correr riscos, e evite ao máximo fazer qualquer tipo de conexão com organizações criminosas.\n\n";



        $text .= "<b>\xE2\x9C\x85 A Honestidade e ética é nossa prioridade \xE2\x9C\x85</b>\n\n";

        $text .= "Não temos nenhuma intenção de ficar com qualquer centavo que não merecemos, prezamos o trabalho duro e a criatividade no mercado, para que todos saiam beneficiados.\n";

        $text .= "Não trabalhamos com drogas que consideramos prejudiciais aos usuários, não por preconceito, mas por preferir não carregar o peso de prejudicar qualquer um.\n\n";

        $text .= "\xF0\x9F\x98\x84 Nossa equipe agradece a todos que confiam no nosso trabalho. \xF0\x9F\x98\x84";



        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas Frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => 'Perguntas_Frequentes'

        ]));

        return $this->sendMessage($text, $inline_keyboard);

    }

    public function PerguntasFrequentes(){

        $inline_keyboard = new InlineKeyboard();

        $text = "<b>Perguntas frequentes</b>\n\n";





        $text .= "<b>\xE2\x9C\x85 Quais produtos estão disponíveis? \xE2\x9C\x85</b>\n\n";

        $text .= "Todos os produtos cadastrados no bot estão disponíveis.\n";

        $text .= "<i>(Para mais detalhe selecione esta pergunta a baixo)</i>\n\n";



        $text .= "<b>\xF0\x9F\x93\x9D Como fazer uma compra? \xF0\x9F\x93\x9D</b>\n\n";

        $text .= "Basta clicar em \xF0\x9F\x93\x9D <b>Cadastrar pedido</b> \xF0\x9F\x93\x9D no menu inicial, escolher o estoque, produto e frete. Não esqueça que para finalizar o pedido você precisa inserir o saldo. \n";

        $text .= "<i>(Para mais detalhes selecione esta pergunta a baixo)</i>\n\n";



        $text .= "<b>\xF0\x9F\x92\xB5 Como efetuar o pagamento? \xF0\x9F\x92\xB5</b>\n\n";

        $text .= "O pagamento pode ser feito por PIX, TED, Depósito no boca do caixa ou Bitcoin.\n";

        $text .= "<i>(Para mais detalhes selecione esta pergunta a baixo)</i>\n\n";





        $text .= "<b>\xF0\x9F\x9A\x9A Como funciona o envio? \xF0\x9F\x9A\x9A</b>\n\n";

        $text .= "Cada estoque possui seu prazo de despache, formas de envios e preço.\n";

        $text .= "<i>(Para mais detalhes selecione esta pergunta a baixo)</i>\n\n";



        $text .= "<b>\xF0\x9F\x94\x92 Refund ou Reship \xF0\x9F\x94\x92</b>\n\n";

        $text .= "Reship apenas para envio com SEGURO.\n";

        $text .= "<i>(Para mais detalhes selecione esta pergunta a baixo)</i>\n\n";





        $text .= "<b>\xE2\x99\xBB Problemas com o produto? \xE2\x99\xBB</b>\n\n";

        $text .= "Para fazer qualquer tipo de reclamação com relação ao produto, você deve <b>FILMAR A ABERTURA DO PACOTE</b>, sem a filmagem não temos como confirmar se sua informação é verdadeira, logo não poderemos resolver o problema.\n";

        $text .= "<i>(Para mais detalhes selecione esta pergunta a baixo)</i>\n\n";



        $text .= "Selecione uma pergunta a baixo.\n";

        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xE2\x9D\xA4 Sobre o Night Company \xE2\x9D\xA4", 'callback_data' => 'A_Empresa'

        ]));



        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xE2\x9C\x85 Quais produtos estão disponíveis? \xE2\x9C\x85", 'callback_data' => 'Pergunta_ProdutosDisponiveis'

        ]));

        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xF0\x9F\x93\x9D Como fazer uma compra? \xF0\x9F\x93\x9D", 'callback_data' => 'Pergunta_EfetuarCompra'

        ]));

        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xF0\x9F\x92\xB5 Como efetuar o pagamento? \xF0\x9F\x92\xB5", 'callback_data' => 'Pergunta_EfetuarPagamento'

        ]));

        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xF0\x9F\x9A\x9A Como funciona o envio? \xF0\x9F\x9A\x9A", 'callback_data' => 'Pergunta_Envio'

        ]));



        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xE2\x99\xBB Problemas com o produto? \xE2\x99\xBB", 'callback_data' => 'Pergunta_ProblemaProduto'

        ]));



        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xF0\x9F\x94\x92 Refund ou Reship \xF0\x9F\x94\x92", 'callback_data' => 'Pergunta_Reship'

        ]));

        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xF0\x9F\x92\xB2 Como me tornar revendedor? \xF0\x9F\x92\xB2", 'callback_data' => 'Pergunta_Revendedor'

        ]));



        return $this->sendMessage($text, $inline_keyboard);

    }



    public function PerguntaProdutosDisponiveis(){

        $inline_keyboard = new InlineKeyboard();

        $text = "<b>\xE2\x9C\x85 Quais produtos estão disponíveis? \xE2\x9C\x85</b>\n\n";

        $text .= "Todos os produtos cadastrados no bot estão disponíveis.\n\n";

        $text .= "Para vizualizar os produtos, clique em \xF0\x9F\x93\xA6 <b>Consultar Produtos</b> \xF0\x9F\x93\xA6 no menu principal, em seguida selecione se você quer ver por categorias ou estoques\n\n";

        $text .= "Clique no estoque/categoria desejado.\n\n";

        $text .= "\xF0\x9F\x93\x83 Você verá uma lista de produtos com preços, você também pode clicar no botão referente ao produto desejado para imagem e mais detalhes.\n\n";

        $text .= "\xF0\x9F\x8E\xA5 Alguns produtos teram um link para um canal com mais imagens e vídeos referentes aquele produto.\n\n";

        $text .= "Atente-se também ao informativa \xE2\x9C\x85 Descrição do produto garantina pela nossa equipe. \xE2\x9C\x85, estes produtos foram testados e validados pela nossa equipe, os outros são informações passadas pelo fornecedor.\n\n";

        $text .= "\xF0\x9F\x98\x94 Infelizmente não existe como testarmos/usarmos cada um dos produtos que passam por aqui.\n\n";



        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => 'Perguntas_Frequentes'

        ]));



        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xF0\x9F\x93\xA6 Consultar Produtos \xF0\x9F\x93\xA6", 'callback_data' => 'Selciona_TipoBusca'

        ]));



        return $this->sendMessage($text, $inline_keyboard);

    }



    public function PerguntaEfetuarCompra(){

        $inline_keyboard = new InlineKeyboard();

        $text = "<b>\xF0\x9F\x93\x9D  Como fazer uma compra? \xF0\x9F\x93\x9D</b>\n\n";



        $text .= "Clique em <b>\xF0\x9F\x93\x9D Cadastrar pedido \xF0\x9F\x93\x9D</b>, insira os dados de envio, selecione o <b>estoque</b> e os <b>produtos</b>, cliquem em <b>Finalizar pedido</b> e escolha o seu tipo de envio.\n\n";

        $text .= "Não esqueça que para finalizar o pedido você precisa <b>inserir o saldo</b>.\n\n";



        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => 'Perguntas_Frequentes'

        ]));

        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xF0\x9F\x93\x9D Cadastrar pedido \xF0\x9F\x93\x9D", 'callback_data' => 'Venda_Cadastrar'

        ]));

        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xF0\x9F\x92\xB5 Inserir saldo \xF0\x9F\x92\xB5", 'callback_data' => 'Input_ValorComprovante'

        ]));

        return $this->sendMessage($text, $inline_keyboard);

    }



    public function PerguntaEfetuarPagamento(){

        $inline_keyboard = new InlineKeyboard();

        $text = "<b>\xF0\x9F\x92\xB5 Como efetuar o pagamento? \xF0\x9F\x92\xB5</b>\n\n";



        $text .= "Para inserir o saldo, basta clicar em \xF0\x9F\x92\xB5 <b>Inserir saldo</b> \xF0\x9F\x92\xB5 no menu principal, coloque o valor que deseja inserir, selecione a forma de pagamento. \n\n";

        $text .= "O pagamento pode ser feito por <b>PIX, TED, Depósito no boca do caixa ou Bitcoin</b>.\n\n";

        $text .= "Será exibido os dados para pagamento, após fazer o pagamento clique no botão \xF0\x9F\x93\xB7 <b>Enviar Comprovante</b> \xF0\x9F\x93\xB7 e nos envie uma imagem do comprovante\n\n";

        $text .= "Caso esteja tudo certo, em no máximo 6 horas úteis seus saldo estará na sua conta do Night Company.\n\n";



        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => 'Perguntas_Frequentes'

        ]));

        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xF0\x9F\x92\xB5 Inserir saldo \xF0\x9F\x92\xB5", 'callback_data' => 'Input_ValorComprovante'

        ]));

        return $this->sendMessage($text, $inline_keyboard);

    }

    public function PerguntaEnvio(){

        $inline_keyboard = new InlineKeyboard();

        $text = "<b>\xF0\x9F\x9A\x9A Como funciona o envio? \xF0\x9F\x9A\x9A</b>\n\n";



        $text .= "Cada estoque possui seu prazo de despache, formas de envio e preço.\n\n";

        $text .= "Para calcular o prazo de entrega acesse o link: \n<b>https://calcularfretecorreios.com/#/calcular-correios</b> e preencha o formulário com as seguintes informações:\n\n";

        $text .= "Apenas produtos em papel podem ser enviados por carta.\n\n";

        $text .= "Cep de Origem: <b>Verifique em cada estoque</b>\n";

        $text .= "Formato: <b>Caixa / Pacote</b>\n";

        $text .= "Altura: <b>5</b>\n";

        $text .= "Largura: <b>11</b>\n";

        $text .= "Comprimento: <b>16</b>\n";

        $text .= "CEP de Origem: <b>COLOQUE O CEP SEU CEP</b>\n\n";

        $text .= "Clique em <b>CALCULAR FRETE</b>\n\n";

        $text .= "Não esqueça do tempo de despache de cada estoque, geralmente sai no dia seguinte ao pagamento. Porém só aceitamos reclamações após expirar o prazo de despache.\n\n";

        $text .= "Informações dos Estoques:\n\n";



        $sql = "SELECT * FROM categorias WHERE status = 1 ORDER BY ordem";

        $query = $this->pdo->query($sql);

        $categorias = $query->fetchAll();

        $rows = $query->rowCount();



        if ($rows > 0) {

            foreach ($categorias as $categoria) {

                $text .= "<b>".$categoria['categoria']."</b>\n";

                $text .= "Prazo: ".$categoria['despache']." dias\n";

                $text .= "Cep de Origem: <b>" . $categoria['cep'] . "</b>\n";

                $text .= "Formas de envio:\n";



                if ($categoria['gratis'] == 1) {

                    $text .= "Frete Gráris (apenas promoção)\n";

                }

                if ($categoria['sedex']) {

                    $text .= "<b>Sedex</b>: R$" . $categoria['sedex'] . "\n";

                }

                if ($categoria['carta']) {

                    $text .= "<b>Carta</b>: R$" . $categoria['carta'] . "\n";

                }

                if ($categoria['pac']) {

                    $text .= "<b>PAC</b>: R$" . $categoria['pac'] . "\n";

                }

                if ($categoria['jadlog']) {

                    $text .= "<b>Jadlog</b>: R$" . $categoria['jadlog'] . "\n";

                }

                if ($categoria['envio_seguro']) {

                    $text .= "<b>Envio com seguro</b>: R$" . $categoria['envio_seguro'] . " + 15% do total da compra.\n";



                }

                $text .= "\n";

            }

        }

        $text .= "\n\n";



        $inline_keyboard->addRow(new InlineKeyboardButton([

            'text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => 'Perguntas_Frequentes'

        ]));

        return $this->sendMessage($text, $inline_keyboard);

    }



}



