<?php

namespace Longman\TelegramBot\Commands\UserCommands;

use Longman\TelegramBot\Commands\UserCommand;

use Longman\TelegramBot\Conversation;

use Longman\TelegramBot\DB;

use Longman\TelegramBot\Entities\Chat;

use Longman\TelegramBot\Entities\Keyboard;

use Longman\TelegramBot\Entities\KeyboardButton;

use Longman\TelegramBot\Request;



/**

 * "/conver" Command

 */

class ConverCommand extends UserCommand

{

    protected $name = 'conver';

    protected $description = 'Survery for bot users';

    protected $usage = '/conver';

    protected $version = '0.1.0';



    protected $need_mysql = true;

    protected $conversation;



    public function execute()

    {

        $message = $this->getMessage();

        $chat = $message->getChat();

        $user = $message->getFrom();

        $text = trim($message->getText(true));

        $chat_id = $chat->getId();

        $user_id = $user->getId();



        // preparing a query

        $data = [

            'chat_id' => $chat_id,

        ];





        if ($chat->isGroupChat() || $chat->isSuperGroup()) {

            //reply to message id is applied by default

            //Force reply is applied by default so it can work with privacy on

            $data['reply_markup'] = Keyboard::forceReply(['selective' => true]);

        }



        /**

         * Start conversation

         */

        $this->conversation = new Conversation($user_id, $chat_id, $this->getName());

        $notes = &$this->conversation->notes;

        !is_array($notes) && $notes = [];

        // cache data from the tracking session if any

        $state = 0;

        if (isset($notes['state'])) {

            $state = $notes['state'];

        }

        $result = Request::emptyResponse();



        $keyboards = [];

        $keyboards[] = new Keyboard(

            ['Text'],

            ['Feedback', 'Avia']

        );

        $keyboard = $keyboards[0]

            ->setResizeKeyboard(true)

            ->setOneTimeKeyboard(false)

            ->setSelective(false);



        switch ($state) {

            case 0:

                if ($text === '') {

                    $notes['state'] = 0;

                    $this->conversation->update();

                    $data['text']         = 'Choose a section:';

                    $data['reply_markup'] = $keyboard;

                    $result = Request::sendMessage($data);

                    break;

                }

                elseif ($text === 'Text') {

                    $notes['state'] = 0;

                    $this->conversation->update();

                    $data['text']         = 'Text! :)';

                    $data['reply_markup'] = $keyboard;

                    $result = Request::sendMessage($data);

                    break;

                }

                elseif ($text === 'Feedback') {

                    $this->conversation->stop();

                    $this->feedback();

                    break;

                }

                elseif ($text === 'Avia') {

                    $notes['state'] = 0;

                    $this->conversation->update();

                    $data['text']         = 'Avia text.';

                    $data['reply_markup'] = $keyboard;

                    $result = Request::sendMessage($data);

                    break;

                }

                $notes['command'] = $text;

                $text          = '';

        }

        return $result;

    }



    public function feedback()

    {

        $message = $this->getMessage();

        $chat = $message->getChat();

        $user = $message->getFrom();

        $text = trim($message->getText(true));

        $chat_id = $chat->getId();

        $user_id = $user->getId();



        $data = [

            'chat_id' => $chat_id,

        ];



        $conversation = new Conversation(

            $this->getMessage()->getFrom()->getId(),

            $this->getMessage()->getChat()->getId()

        );

        $conversation->cancel();



        if ($chat->isGroupChat() || $chat->isSuperGroup()) {

            //reply to message id is applied by default

            //Force reply is applied by default so it can work with privacy on

            $data['reply_markup'] = Keyboard::forceReply(['selective' => true]);

        }



        /**

         * start a new conversation

         */

        $this->conversation = new Conversation($user_id, $chat_id, $this->getName());

        $notes = &$this->conversation->notes;

        !is_array($notes) && $notes = [];

        // cache data from the tracking session if any

        $state = 0;

        if (isset($notes['state'])) {

            $state = $notes['state'];

        }

        $result = Request::emptyResponse();



        switch ($state) {

            case 0:

                if ($text === '' || !is_numeric($text)) {

                    $notes['state'] = 0;

                    $this->conversation->update();

                    $data['text'] = 'Please write your message:';



                    $result = Request::sendMessage($data);

                    break;

                }

                $notes['message'] = $text;

                $text         = '';



            case 1:

                if ($text === '') {

                    $notes['state'] = 1;

                    $this->conversation->update();

                    $data['text'] = 'Please say your name';

                    $result = Request::sendMessage($data);

                    break;

                }

                $notes['name'] = $text;

                $text             = '';

        }

        return $result;

    }

}