<?php

class Contas extends CI_Controller
{

    /**
     * author: Ramon Silva
     * email: silva018-mg@yahoo.com.br
     *
     */

    function __construct()
    {
        parent::__construct();
        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }

        $this->load->helper(array('form', 'codegen_helper'));

        $this->load->model('Contas_model', '', TRUE);

        $this->data['menuCategorias'] = 'Contas';
    }

    function index()
    {
        $this->gerenciar();
    }

    function gerenciar()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vCategoria')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar categorias');
            redirect(base_url());
        }

        $this->load->library('table');
        $this->load->library('pagination');


        $config['base_url'] = base_url() . 'index.php/categorias/gerenciar/';

        $config['total_rows'] = $this->Contas_model->count('categorias');
        $config['per_page'] = 10;
        $config['next_link'] = 'Próxima';
        $config['prev_link'] = 'Anterior';
        $config['full_tag_open'] = '<div class="pagination alternate"><ul>';
        $config['full_tag_close'] = '</ul></div>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li><a style="color: #2D335B"><b>';
        $config['cur_tag_close'] = '</b></a></li>';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['first_link'] = 'Primeira';
        $config['last_link'] = 'Última';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';

        $this->pagination->initialize($config);

        $this->data['results'] = $this->Contas_model->get('contas', '*', '', $config['per_page'], $this->uri->segment(3));

        $this->data['view'] = 'contas/contas';
        $this->load->view('tema/topo', $this->data);


    }

    function adicionar()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'aCategoria')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para adicionar categoria.');
            redirect(base_url());
        }


        if (!empty($_POST['nome'])) {

            $dataHoje = date('Y-m-d');
            $data = array(
                'nome' => set_value('nome'),
                'conta' => set_value('conta'),
                'usuario_id' => set_value('usuario_id'),
                'cadastro' => set_value($dataHoje),
                'status' =>  1,

            );

            if ($this->Contas_model->add('contas', $data) == TRUE) {
                $this->session->set_flashdata('success', 'Conta adicionada com sucesso!');
                redirect(base_url() . 'index.php/contas/adicionar');
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>An Error Occured.</p></div>';
            }
        }

        $users = $this->db->get('usuarios')->result();

        foreach ($users as $u) {
            $this->data['users'][$u->idUsuarios] = $u->nome;
        }


        $this->data['view'] = 'contas/adicionarContas';
        $this->load->view('tema/topo', $this->data);

    }

    function editar()
    {

        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'eCategoria')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para editar tipo de unidade.');
            redirect(base_url());
        }
        if (!empty($_POST['nome'])) {

            $dataHoje = date('Y-m-d');
            $data = array(
                'categoria' => $this->input->post('nome'),
                'cadastro' => set_value($dataHoje),
                'status' =>  0,

            );


            if ($this->Categorias_model->edit('categorias', $data, 'idCategorias', $this->input->post('idCategorias')) == TRUE) {
                $this->session->set_flashdata('success', 'Categoria editada com sucesso!');
                redirect(base_url() . 'index.php/categorias/editar/' . $this->input->post('idCategorias'));
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>An Error Occured</p></div>';
            }
        }

        $this->data['result'] = $this->Categorias_model->getById($this->uri->segment(3));
        $this->data['view'] = 'categorias/editarCategorias';
        $this->load->view('tema/topo', $this->data);

    }


    function visualizar()
    {

        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vCategoria')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar categoria.');
            redirect(base_url());
        }

        $this->data['result'] = $this->Categorias_model->getById($this->uri->segment(3));

        if ($this->data['result'] == null) {
            $this->session->set_flashdata('error', 'Categoria não encontrado.');
            redirect(base_url() . 'index.php/categorias/editar/' . $this->input->post('idCategorias'));
        }

        $this->data['view'] = 'tipounidade/visualizarCategorias';
        $this->load->view('tema/topo', $this->data);

    }

    function excluir()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'dCategoria')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para excluir categoria.');
            redirect(base_url());
        }


        $id = $this->input->post('id');


        if ($id == null) {

            $this->session->set_flashdata('error', 'Erro ao tentar excluir tipo de unidade.');
            redirect(base_url() . 'index.php/categorias/gerenciar/');
        }

        $this->db->where('idCategorias', $id);
        $this->db->delete('categorias');


        $this->Categorias_model->delete('categorias', 'idCategorias', $id);


        $this->session->set_flashdata('success', 'Categoria excluido com sucesso!');
        redirect(base_url() . 'index.php/tipounidade/gerenciar/');
    }
}

