<?php

class Dividas extends CI_Controller
{

    /**
     * author: Ramon Silva
     * email: silva018-mg@yahoo.com.br
     *
     */

    function __construct()
    {
        parent::__construct();
        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }

        $this->load->helper(array('form', 'codegen_helper'));

        $this->load->model('Dividas_model', '', TRUE);
        $this->load->model('usuarios_model', '', TRUE);
        $this->data['menuDividas'] = 'Dividas';
    }

    function index()
    {
        $this->gerenciar();
    }

    function gerenciar()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vDividas')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar tipo de unidade.');
            redirect(base_url());
        }

        $this->load->library('table');
        $this->load->library('pagination');

        $idUsuario = $this->session->userdata('id');

        $users = $this->usuarios_model->get('usuarios', '*',false, '');
        $this->data['custo'] = array();
        foreach ($users as $u) {
            $this->data['users'][$u->idUsuarios] = $u->nome;
            $this->data['usersTelegram'][$u->idUsuarios] = $u->user_telegram;
        }

        $totalizador = array();
        foreach ($users as $u) {

            $totalizador[$u->idUsuarios]['saldo'] = 0;
            $totalizador[$u->idUsuarios]['nome'] = $u->nome;
            $dividasEnviadas = $this->Dividas_model->get('dividas', '*', "status = 1 AND enviador_id = $idUsuario AND recebedor_id = $u->idUsuarios");

            foreach ($dividasEnviadas as $de) {
                if ($de->tipo == 'POSITIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] += $de->valor;
                } else if ($de->tipo == 'NEGATIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] -= $de->valor;
                }
            }

            $dividasRecebidas = $this->Dividas_model->get('dividas', '*', "status = 1 AND enviador_id = $u->idUsuarios AND recebedor_id = $idUsuario");

            foreach ($dividasRecebidas as $dr) {
                if ($dr->tipo == 'POSITIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] -= $dr->valor;
                } else if ($dr->tipo == 'NEGATIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] += $dr->valor;
                }
            }


        }
        $this->data['totalizador'] = $totalizador;
        $this->data['usuarios'] = $users;
        //$this->data['usersArray'] = $usersArray;
        $this->data['idUsuario'] = $idUsuario;
        $where = "status = 1 AND (enviador_id = $idUsuario OR recebedor_id = $idUsuario)";

        if(!empty($_GET['usuario_id'])){
            $usuario_id = $_GET['usuario_id'];
            $where .= " AND (enviador_id = $usuario_id OR recebedor_id = $usuario_id)";
            $this->data['cliente_id'] = $usuario_id;
        }


        $config['base_url'] = base_url() . 'index.php/dividas/gerenciar/';

        $config['total_rows'] = $this->Dividas_model->count('dividas', $where);
        $config['per_page'] = 9999;

        $this->pagination->initialize($config);

        $this->data['results'] = $this->Dividas_model->get('dividas', '*', $where, $config['per_page'], $this->uri->segment(3));

  

        $this->data['view'] = 'dividas/dividas';
        $this->load->view('tema/topo', $this->data);


    }
    function comprovantesPendentes()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vDividas')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar tipo de unidade.');
            redirect(base_url());
        }

        $this->load->library('table');
        $this->load->library('pagination');



        $idUsuario = $this->session->userdata('id');

        $users = $this->usuarios_model->get('usuarios', '*',false, '');
        $this->data['custo'] = array();
        foreach ($users as $u) {
            $this->data['users'][$u->idUsuarios] = $u->nome;
            $this->data['usersTelegram'][$u->idUsuarios] = $u->user_telegram;
        }
        $contas = $this->db->get('contas')->result();

        foreach ($contas as $conta) {
            $this->data['contas'][$conta->idContas] = $conta;
        }
        $totalizador = array();
        foreach ($users as $u) {

            $totalizador[$u->idUsuarios]['saldo'] = 0;
            $totalizador[$u->idUsuarios]['nome'] = $u->nome;
            $dividasEnviadas = $this->Dividas_model->get('dividas', '*', "status = 0 AND enviador_id = $idUsuario AND recebedor_id = $u->idUsuarios AND aguardando_pag = 1");

            foreach ($dividasEnviadas as $de) {
                if ($de->tipo == 'POSITIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] += $de->valor;
                } else if ($de->tipo == 'NEGATIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] -= $de->valor;
                }
            }

            $dividasRecebidas = $this->Dividas_model->get('dividas', '*', "status = 0 AND enviador_id = $u->idUsuarios AND recebedor_id = $idUsuario AND aguardando_pag = 1");

            foreach ($dividasRecebidas as $dr) {
                if ($dr->tipo == 'POSITIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] -= $dr->valor;
                } else if ($dr->tipo == 'NEGATIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] += $dr->valor;
                }
            }


        }
        $this->data['totalizador'] = $totalizador;
        $this->data['usuarios'] = $users;
        //$this->data['usersArray'] = $usersArray;
        $this->data['idUsuario'] = $idUsuario;
        $where = "status = 0 AND (enviador_id = $idUsuario OR recebedor_id = $idUsuario) AND aguardando_pag = 1";

        if(!empty($_GET['usuario_id'])){
            $usuario_id = $_GET['usuario_id'];
            $where .= " AND status = 0 AND (enviador_id = $usuario_id OR recebedor_id = $usuario_id) AND aguardando_pag = 1";
        }

        $config['base_url'] = base_url() . 'index.php/dividas/dividas/comprovantesPendentes/';

        $config['total_rows'] = $this->Dividas_model->count('dividas', $where);
        $config['per_page'] = 200;

        $this->pagination->initialize($config);

        $this->data['results'] = $this->Dividas_model->get('dividas', '*', $where, $config['per_page'], $this->uri->segment(3));

        $this->data['view'] = 'dividas/comprovantesPendentes';
        $this->load->view('tema/topo', $this->data);


    }
    function usuario()
    {
        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vDividas')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar tipo de unidade.');
            redirect(base_url());
        }


        $this->load->library('table');
        $this->load->library('pagination');

        $idAdm = $this->session->userdata('id');

        $idUsuario = $_GET['usuario_id'];
        $this->data['idUsuario'] = $idUsuario;

        $this->data['cliente'] = $this->usuarios_model->getById($idUsuario);
        $users = $this->usuarios_model->get('usuarios', '*',false, '');
        $this->data['custo'] = array();
        foreach ($users as $u) {
            $this->data['users'][$u->idUsuarios] = $u->nome;
            $this->data['usersTelegram'][$u->idUsuarios] = $u->user_telegram;
        }

        $saldoDivida = array();
        $totalizador = array();

        $totalizador['saldo'] = 0;
        $this->data['usuarios'] = $users;
        //$this->data['usersArray'] = $usersArray;
        $where = "status = 1 AND (enviador_id = $idAdm OR recebedor_id = $idAdm)";

        if(!empty($_GET['usuario_id'])){
            $usuario_id = $_GET['usuario_id'];
            $where .= " AND (enviador_id = $usuario_id OR recebedor_id = $usuario_id)";
        }

        $dividas = $this->Dividas_model->get('dividas', '*', $where,99999999,0,0,false,'ordem');

        foreach ($dividas as $d) {

            if ($d->enviador_id == $idUsuario) {
                if ($d->tipo == "POSITIVO") {
                    $totalizador['saldo'] += $d->valor;
                } else if ($d->tipo == "NEGATIVO") {
                    $totalizador['saldo'] -= $d->valor;
                }
            } else {
                if ($d->tipo == "POSITIVO") {
                    $totalizador['saldo'] -= $d->valor;
                } else if ($d->tipo == "NEGATIVO") {
                    $totalizador['saldo'] += $d->valor;
                }
            }
            $this->data['saldoDivida'][$d->id] = $totalizador['saldo'];

        }



        $this->data['totalizador'] = $totalizador['saldo'];

        $config['base_url'] = base_url() . 'index.php/dividas/gerenciar/';

        $config['total_rows'] = $this->Dividas_model->count('dividas', $where);
        $config['per_page'] = 999999;

        $this->pagination->initialize($config);

        $this->data['results'] = $this->Dividas_model->get('dividas', '*', $where, $config['per_page'], $this->uri->segment(3));

        $this->data['view'] = 'dividas/usuario';
        $this->load->view('tema/topo', $this->data);

    }
    function todasDividas()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vDividas')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar tipo de unidade.');
            redirect(base_url());
        }

        $this->load->library('table');
        $this->load->library('pagination');

        $idUsuario = $this->session->userdata('id');
        $users = $this->usuarios_model->get(0, 0, false, 'idUsuarios <> ' . $idUsuario);
        $usersTotal = $this->usuarios_model->get(0, 0, false);
        $usersArray = array();
        foreach ($usersTotal as $ut) {
            $usersArray[$ut->idUsuarios] = $ut->nome;
        }

        $totalizador = array();
        foreach ($users as $u) {

            $totalizador[$u->idUsuarios]['saldo'] = 0;
            $totalizador[$u->idUsuarios]['nome'] = $u->nome;
            $dividasEnviadas = $this->Dividas_model->get('dividas', '*', "status = 1 AND enviador_id = $idUsuario AND recebedor_id = $u->idUsuarios");

            foreach ($dividasEnviadas as $de) {
                if ($de->tipo == 'POSITIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] += $de->valor;
                } else if ($de->tipo == 'NEGATIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] -= $de->valor;
                }
            }

            $dividasRecebidas = $this->Dividas_model->get('dividas', '*', "enviador_id = $u->idUsuarios AND recebedor_id = $idUsuario");

            foreach ($dividasRecebidas as $dr) {
                if ($dr->tipo == 'POSITIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] -= $dr->valor;
                } else if ($dr->tipo == 'NEGATIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] += $dr->valor;
                }
            }


        }
        $this->data['totalizador'] = $totalizador;
        $this->data['usuarios'] = $users;
        $this->data['usersArray'] = $usersArray;
        $this->data['idUsuario'] = $idUsuario;
        $where = "status = 1";

        $config['base_url'] = base_url() . 'index.php/dividas/todasDividas/';

        $config['total_rows'] = $this->Dividas_model->count('dividas', $where);
        $config['per_page'] = 200;
        $config['next_link'] = 'Próxima';
        $config['prev_link'] = 'Anterior';
        $config['full_tag_open'] = '<div class="pagination alternate"><ul>';
        $config['full_tag_close'] = '</ul></div>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li><a style="color: #2D335B"><b>';
        $config['cur_tag_close'] = '</b></a></li>';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['first_link'] = 'Primeira';
        $config['last_link'] = 'Última';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';

        $this->pagination->initialize($config);

        $this->data['results'] = $this->Dividas_model->get('dividas', '*', $where, $config['per_page'], $this->uri->segment(3));

        $this->data['view'] = 'dividas/todasDividas';
        $this->load->view('tema/topo', $this->data);


    }


    function adicionar()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vDividas')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para Dividas.');
            redirect(base_url());
        }
        $idUsuario = $this->session->userdata('id');

        if(!empty($_GET['usuario_id'])){
            $this->data['cliente_id'] = $_GET['usuario_id'];
        }

        $this->data['usuarios'] = $this->usuarios_model->get(0, 0, false, 'idUsuarios <> ' . $idUsuario);
        $date = date('Y-m-d h:i:s');
        if (!empty($_POST)) {
            $data = array(
                'data' => $date,
                'enviador_id' => $idUsuario,
                'recebedor_id' => $_POST['recebedor_id'],
                'valor' => $_POST['valor'],
                'descricao' => $_POST['descricao'],
                'tipo' => $_POST['tipo'],
                'status' => 1,
                'manual' => 1,

            );

            if ($this->Dividas_model->add('dividas', $data) == TRUE) {
                $this->session->set_flashdata('success', 'Controle de divida adicionado com sucesso!');
                redirect(base_url() . 'index.php/dividas/usuario?usuario_id='.$_POST['recebedor_id']);
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>An Error Occured.</p></div>';
            }
        }

        $this->data['view'] = 'dividas/adicionarDividas';
        $this->load->view('tema/topo', $this->data);

    }

    function editar()
    {

        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'eDividas')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para editar tipo de unidade.');
            redirect(base_url());
        }
        if (!empty($_POST['nome'])) {
            $data = array(
                'nomeDividas' => $this->input->post('nome'),
                'siglaDividas' => set_value('sigla'),
            );

            if ($this->Dividas_model->edit('dividas', $data, 'idDividas', $this->input->post('idDividas')) == TRUE) {
                $this->session->set_flashdata('success', 'Tipo de Unidade editado com sucesso!');
                redirect(base_url() . 'index.php/dividas/editar/' . $this->input->post('idDividas'));
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>An Error Occured</p></div>';
            }
        }

        $this->data['result'] = $this->Dividas_model->getById($this->uri->segment(3));
        $this->data['view'] = 'tipounidade/editarDividas';
        $this->load->view('tema/topo', $this->data);

    }


    function visualizar()
    {

        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vDividas')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar tipo de unidade.');
            redirect(base_url());
        }

        $this->data['result'] = $this->Dividas_model->getById($this->uri->segment(3));

        if ($this->data['result'] == null) {
            $this->session->set_flashdata('error', 'Tipo de Unidade não encontrado.');
            redirect(base_url() . 'index.php/dividas/editar/' . $this->input->post('idDividas'));
        }

        $this->data['view'] = 'tipounidade/visualizarDividas';
        $this->load->view('tema/topo', $this->data);

    }

    function excluir()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'dDividas')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para excluir tipo de unidade.');
            redirect(base_url());
        }


        $id = $this->input->post('id');


        if ($id == null) {

            $this->session->set_flashdata('error', 'Erro ao tentar excluir tipo de unidade.');
            redirect(base_url() . 'index.php/dividas/gerenciar/');
        }

        $this->db->where('idDividas', $id);
        $this->db->delete('dividas');


        $this->Dividas_model->delete('dividas', 'idDividas', $id);


        $this->session->set_flashdata('success', 'Tipo de Unidade excluido com sucesso!');
        redirect(base_url() . 'index.php/tipounidade/gerenciar/');
    }
}

