<?php if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Mapos extends CI_Controller
{


    /**
     * author: Ramon Silva
     * email: silva018-mg@yahoo.com.br
     *
     */

    public function __construct()
    {
        parent::__construct();
        $this->load->model('mapos_model', '', TRUE);
        $this->load->model('produtos_model', '', TRUE);
        $this->load->model('categorias_model', '', TRUE);
    }

    public function index()
    {
        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }
        $usuario_id = $this->session->userdata('id');
        $this->data['ordens'] = $this->mapos_model->getOsAbertas();
        $this->data['produtos'] = $this->mapos_model->getProdutosMaisVendidos($usuario_id);
        $this->data['os'] = $this->mapos_model->getOsEstatisticas();
        $this->data['estatisticas_financeiro'] = $this->mapos_model->getEstatisticasFinanceiro();
        $this->data['menuPainel'] = 'Painel';
        $this->data['view'] = 'mapos/painel';
        $this->load->view('tema/topo', $this->data);

    }

    public function catalogo()
    {
        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }

        $catalogos = array();
        $catalogos[0] = array();
        $catalogos[0]['telegram'] = "@CrazyGandalf";
        $catalogos[0]['background'] = "bg_med.png";
        $catalogos[0]['faixa'][0] = "NOVO CANAL, FALAR COM: @CrazyGandalf";
        $catalogos[0]['faixa'][1] = "NOVO CANAL, FALAR COM: @CrazyGandalf";

        $catalogos[1] = array();
        $catalogos[1]['telegram'] = "@JaiminhoCartero";
        $catalogos[1]['background'] = "bg_jaime.png";
        $catalogos[1]['faixa'][0] = "@JaiminhoCartero";
        $catalogos[1]['faixa'][1] = "@JaiminhoCartero";


        $usuario_id = $this->session->userdata('id');
        $categorias = $this->categorias_model->get('categorias', '*', 'status = 1');


        if (empty($_GET['estoque'])) {
            foreach ($catalogos as $key => $catalogo) {
                foreach ($categorias as $categoria) {
                    $produtos = $this->produtos_model->get('produtos', '*', 'status = 1 AND categoriaId = ' . $categoria->idCategorias);
                    $paginas = ceil(count($produtos) / 12);

                    if ($paginas > 1) {
                        $this->data['parte'] = $paginas;
                    }
                    for ($i = 1; $i <= $paginas; $i++) {
                        $url = base_url() . "index.php/mapos/catalogo?catalogo=$key&estoque=" . $categoria->idCategorias . "&parte=" . $i;
                        echo "<a href='".$url."'>" . $url."</a><br />";
                        //echo "<a href='" . base_url() . "index.php/mapos/catalogo?catalogo=$key&estoque=" . $categoria->idCategorias . "&parte=" . $i . "'>" . $catalogo['telegram'] . ": " . $categoria->categoria . " - Parte $i</a><br />";

                    }

                }
                echo "<br />";
                echo "<br />";
            }
            exit;
        } else {
            $estoque = $_GET['estoque'];
            $parte = $_GET['parte'] - 1;

        }

        $catalogo_id = $_GET['catalogo'];
        $this->data['catalogos'] = $catalogos;
        $this->data['catalogo_id'] = $catalogo_id;
        $cat = $this->categorias_model->get('categorias', '*', 'idCategorias = ' . $estoque);
        $this->data['categoria'] = $cat[0];


        $numPage = $parte * 12;




        $produtos = $this->produtos_model->get('produtos', '*', 'status = 1 AND categoriaId = ' . $cat[0]->idCategorias);


        $paginas = ceil(count($produtos) / 12);

        if ($paginas > 1) {
            $this->data['parte'] = $_GET['parte'];
        }

        $i = 0;

        $produtos = $this->produtos_model->get('produtos', '*', 'status = 1 AND categoriaId = ' . $estoque, 99999, 0, false, array('order' => 'ordem'));
        $sql = $this->db->last_query();

        foreach ($produtos as $produto) {
            $this->data['produtos'][$i]['valor'] = "";
            $valores = $this->produtos_model->getValorProdutoPerfil($produto->idProdutos, 6, 5);
            $this->data['produtos'][$i]['model'] = $produto;
            $this->data['produtos'][$i]['nome'] = $produto->nomeCatalogo;
            $this->data['produtos'][$i]['descricao'] = $produto->descricaoCatalogo;
            foreach ($valores as $valor) {
                if ($valor->de <> $valor->ate) {
                    @$this->data['produtos'][$i]['valor'] .= $valor->de . "<span class='unidade'>" . $produto->unidade . " a </span>" . $valor->ate . "<span class='unidade'>" . $produto->unidade . "</span>: R$" . $valor->valor . "<br />";
                } else {
                    @$this->data['produtos'][$i]['valor'] .= $valor->de . "<span class='unidade'>" . $produto->unidade . "</span>: R$" . $valor->valor . "<br />";
                }

                //$this->data['produtos'][$i]['valor'][$valor->id] .= $valor->de." a ".$valor->ate.": R$".$valor->valor."<br />";
            }
            $i++;
        }
        $this->data['menuPainel'] = 'Painel';
        //$this->data['view'] = 'mapos/catalogo';
        $this->load->view('mapos/catalogo', $this->data);

    }

    public function minhaConta()
    {
        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }

        $this->data['usuario'] = $this->mapos_model->getById($this->session->userdata('id'));
        $this->data['view'] = 'mapos/minhaConta';
        $this->load->view('tema/topo', $this->data);

    }

    public function alterarSenha()
    {
        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }

        $this->load->library('encryption');
        $this->encryption->initialize(array('driver' => 'openssl'));

        $oldSenha = $this->input->post('oldSenha');
        $senha = $this->input->post('novaSenha');
        $result = $this->mapos_model->alterarSenha($senha, $oldSenha, $this->session->userdata('id'));
        if ($result) {
            $this->session->set_flashdata('success', 'Senha Alterada com sucesso!');
            redirect(base_url() . 'index.php/mapos/minhaConta');
        } else {
            $this->session->set_flashdata('error', 'Ocorreu um erro ao tentar alterar a senha!');
            redirect(base_url() . 'index.php/mapos/minhaConta');

        }
    }

    public function pesquisar()
    {
        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }

        $termo = $this->input->get('termo');

        $data['results'] = $this->mapos_model->pesquisar($termo);
        $this->data['produtos'] = $data['results']['produtos'];
        $this->data['servicos'] = $data['results']['servicos'];
        $this->data['os'] = $data['results']['os'];
        $this->data['clientes'] = $data['results']['clientes'];
        $this->data['view'] = 'mapos/pesquisa';
        $this->load->view('tema/topo', $this->data);

    }


    public function login()
    {
        $this->load->view('mapos/login');
    }


    public function sair()
    {
        $this->session->sess_destroy();
        redirect('mapos/login');
    }


    public function verificarLogin()
    {

        header('Access-Control-Allow-Origin: ' . base_url());
        header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
        header('Access-Control-Max-Age: 1000');
        header('Access-Control-Allow-Headers: Content-Type');

        $this->load->library('form_validation');
        $this->form_validation->set_rules('email', 'E-mail', 'required|trim');
        $this->form_validation->set_rules('senha', 'Senha', 'required|trim');
        if ($this->form_validation->run() == false) {
            $json = array('result' => false, 'message' => validation_errors());
            echo json_encode($json);
        } else {
            $email = $this->input->post('email');
            $password = $this->input->post('senha');
            $this->load->model('Mapos_model');
            $user = $this->Mapos_model->check_credentials($email);


            if ($user) {

                $this->load->library('encryption');
                $this->encryption->initialize(array('driver' => 'openssl'));

                $password_stored = $this->encryption->decrypt($user->senha);


                if ($password == $password_stored) {
                    $session_data = array('nome' => $user->nome, 'email' => $user->email, 'id' => $user->idUsuarios, 'permissao' => $user->permissoes_id, 'logado' => TRUE);
                    $this->session->set_userdata($session_data);
                    $json = array('result' => true, 'permissao' => $user->permissoes_id);
                    echo json_encode($json);
                } else {
                    $json = array('result' => false, 'message' => 'Os dados de acesso estão incorretos.');
                    echo json_encode($json);
                }
            } else {
                $json = array('result' => false, 'message' => 'Usuário não encontrado, verifique se suas credenciais estão corretass.');
                echo json_encode($json);
            }
        }
        die();
    }


    public function backup()
    {

        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'cBackup')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para efetuar backup.');
            redirect(base_url());
        }


        $this->load->dbutil();
        $prefs = array(
            'format' => 'zip',
            'foreign_key_checks' => false,
            'filename' => 'backup' . date('d-m-Y') . '.sql'
        );

        $backup = $this->dbutil->backup($prefs);

        $this->load->helper('file');
        write_file(base_url() . 'backup/backup.zip', $backup);

        $this->load->helper('download');
        force_download('backup' . date('d-m-Y H:m:s') . '.zip', $backup);
    }


    public function emitente()
    {

        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'cEmitente')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para configurar emitente.');
            redirect(base_url());
        }

        $data['menuConfiguracoes'] = 'Configuracoes';
        $data['dados'] = $this->mapos_model->getEmitente();
        $data['view'] = 'mapos/emitente';
        $this->load->view('tema/topo', $data);
        $this->load->view('tema/rodape');
    }

    function do_upload()
    {

        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'cEmitente')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para configurar emitente.');
            redirect(base_url());
        }

        $this->load->library('upload');

        $image_upload_folder = FCPATH . 'assets/uploads';

        if (!file_exists($image_upload_folder)) {
            mkdir($image_upload_folder, DIR_WRITE_MODE, true);
        }

        $this->upload_config = array(
            'upload_path' => $image_upload_folder,
            'allowed_types' => 'png|jpg|jpeg|bmp',
            'max_size' => 2048,
            'remove_space' => TRUE,
            'encrypt_name' => TRUE,
        );

        $this->upload->initialize($this->upload_config);

        if (!$this->upload->do_upload()) {
            $upload_error = $this->upload->display_errors();
            print_r($upload_error);
            exit();
        } else {
            $file_info = array($this->upload->data());
            return $file_info[0]['file_name'];
        }

    }


    public function cadastrarEmitente()
    {

        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'cEmitente')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para configurar emitente.');
            redirect(base_url());
        }

        $this->load->library('form_validation');
        $this->form_validation->set_rules('nome', 'Razão Social', 'required|trim');
        $this->form_validation->set_rules('cnpj', 'CNPJ', 'required|trim');
        $this->form_validation->set_rules('ie', 'IE', 'required|trim');
        $this->form_validation->set_rules('logradouro', 'Logradouro', 'required|trim');
        $this->form_validation->set_rules('numero', 'Número', 'required|trim');
        $this->form_validation->set_rules('bairro', 'Bairro', 'required|trim');
        $this->form_validation->set_rules('cidade', 'Cidade', 'required|trim');
        $this->form_validation->set_rules('uf', 'UF', 'required|trim');
        $this->form_validation->set_rules('telefone', 'Telefone', 'required|trim');
        $this->form_validation->set_rules('email', 'E-mail', 'required|trim');


        if ($this->form_validation->run() == false) {

            $this->session->set_flashdata('error', 'Campos obrigatórios não foram preenchidos.');
            redirect(base_url() . 'index.php/mapos/emitente');

        } else {

            $nome = $this->input->post('nome');
            $cnpj = $this->input->post('cnpj');
            $ie = $this->input->post('ie');
            $logradouro = $this->input->post('logradouro');
            $numero = $this->input->post('numero');
            $bairro = $this->input->post('bairro');
            $cidade = $this->input->post('cidade');
            $uf = $this->input->post('uf');
            $telefone = $this->input->post('telefone');
            $email = $this->input->post('email');
            $site = $this->input->post('site');
            $image = $this->do_upload();
            $logo = base_url() . 'assets/uploads/' . $image;


            $retorno = $this->mapos_model->addEmitente($nome, $cnpj, $ie, $logradouro, $numero, $bairro, $cidade, $uf, $telefone, $email, $logo, $site);
            if ($retorno) {

                $this->session->set_flashdata('success', 'As informações foram inseridas com sucesso.');
                redirect(base_url() . 'index.php/mapos/emitente');
            } else {
                $this->session->set_flashdata('error', 'Ocorreu um erro ao tentar inserir as informações.');
                redirect(base_url() . 'index.php/mapos/emitente');
            }

        }
    }


    public function editarEmitente()
    {

        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'cEmitente')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para configurar emitente.');
            redirect(base_url());
        }

        $this->load->library('form_validation');
        $this->form_validation->set_rules('nome', 'Razão Social', 'required|trim');
        $this->form_validation->set_rules('cnpj', 'CNPJ', 'required|trim');
        $this->form_validation->set_rules('ie', 'IE', 'required|trim');
        $this->form_validation->set_rules('logradouro', 'Logradouro', 'required|trim');
        $this->form_validation->set_rules('numero', 'Número', 'required|trim');
        $this->form_validation->set_rules('bairro', 'Bairro', 'required|trim');
        $this->form_validation->set_rules('cidade', 'Cidade', 'required|trim');
        $this->form_validation->set_rules('uf', 'UF', 'required|trim');
        $this->form_validation->set_rules('telefone', 'Telefone', 'required|trim');
        $this->form_validation->set_rules('email', 'E-mail', 'required|trim');


        if ($this->form_validation->run() == false) {

            $this->session->set_flashdata('error', 'Campos obrigatórios não foram preenchidos.');
            redirect(base_url() . 'index.php/mapos/emitente');

        } else {

            $nome = $this->input->post('nome');
            $cnpj = $this->input->post('cnpj');
            $ie = $this->input->post('ie');
            $logradouro = $this->input->post('logradouro');
            $numero = $this->input->post('numero');
            $bairro = $this->input->post('bairro');
            $cidade = $this->input->post('cidade');
            $uf = $this->input->post('uf');
            $telefone = $this->input->post('telefone');
            $email = $this->input->post('email');
            $site = $this->input->post('site');
            $id = $this->input->post('id');


            $retorno = $this->mapos_model->editEmitente($id, $nome, $cnpj, $ie, $logradouro, $numero, $bairro, $cidade, $uf, $telefone, $email, $site);
            if ($retorno) {

                $this->session->set_flashdata('success', 'As informações foram alteradas com sucesso.');
                redirect(base_url() . 'index.php/mapos/emitente');
            } else {
                $this->session->set_flashdata('error', 'Ocorreu um erro ao tentar alterar as informações.');
                redirect(base_url() . 'index.php/mapos/emitente');
            }

        }
    }


    public function editarLogo()
    {

        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'cEmitente')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para configurar emitente.');
            redirect(base_url());
        }

        $id = $this->input->post('id');
        if ($id == null || !is_numeric($id)) {
            $this->session->set_flashdata('error', 'Ocorreu um erro ao tentar alterar a logomarca.');
            redirect(base_url() . 'index.php/mapos/emitente');
        }
        $this->load->helper('file');
        delete_files(FCPATH . 'assets/uploads/');

        $image = $this->do_upload();
        $logo = base_url() . 'assets/uploads/' . $image;

        $retorno = $this->mapos_model->editLogo($id, $logo);
        if ($retorno) {

            $this->session->set_flashdata('success', 'As informações foram alteradas com sucesso.');
            redirect(base_url() . 'index.php/mapos/emitente');
        } else {
            $this->session->set_flashdata('error', 'Ocorreu um erro ao tentar alterar as informações.');
            redirect(base_url() . 'index.php/mapos/emitente');
        }

    }


}