<?php

class Vendas extends CI_Controller
{


    /**
     * author: Ramon Silva
     * email: silva018-mg@yahoo.com.br
     *
     */

    function __construct()
    {
        parent::__construct();

        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }

        $this->load->helper(array('form', 'codegen_helper'));
        $this->load->model('vendas_model', '', TRUE);
        $this->load->model('categorias_model', '', TRUE);
        $this->load->model('usuarios_model', '', TRUE);
        $this->load->model('produtos_model', '', TRUE);
        $this->load->model('Permissoes_model', '', TRUE);
        $this->load->model('UsuarioValor_model', '', TRUE);
        $this->load->model('Dividas_model', '', TRUE);
        $this->data['menuVendas'] = 'Vendas';
    }

    function index()
    {
        $this->gerenciar();
    }

    function teste(){
        $brlValue = 500;
        $apiService = file_get_contents("https://api.binance.com/api/v3/ticker/price?symbol=BTCBRL");
        $arrayResult = json_decode($apiService);
        $sellValue = $arrayResult->price;
        $sellNewValue = $sellValue - ($sellValue * 0.05);
        $bitcoinValue = $brlValue / $sellNewValue;
        $result = number_format($bitcoinValue, 6, '.', '');

        echo "<pre>";
        print_r($result);
        echo "</pre>";
        exit;

    }
    function testeHTML(){
        require "../../telegram/lib/pdfcrowd/pdfcrowd.php";

        try
        {
            // create the API client instance
            $client = new \Pdfcrowd\HtmlToImageClient("demo", "ce544b6ea52a5621fb9d55f8b542d14d");

            // configure the conversion
            $client->setOutputFormat("png");

            // run the conversion and write the result to a file
            $client->convertUrlToFile("http://www.example.com", "example.png");
        }
        catch(\Pdfcrowd\Error $why)
        {
            error_log("Pdfcrowd Error: {$why}\n");
            throw $why;
        }
    }
    function testeEnviarMultiplasImagens()
    {
        $apiToken = "5204611256:AAET3v7jKEH5Wz51n6Je8E2G7-4jd_tKbL4";
        $url = "https://api.telegram.org/bot" . $apiToken . "/sendMediaGroup";
        $postContent = [
            'chat_id' => 889423113,
            'media' => json_encode([
                ['type' => 'photo', 'media' => 'https://agenciacolors.digital/wp-content/uploads/2023/03/ff-e1679614868308.jpg' ],
                ['type' => 'photo', 'media' => 'https://wbweb.com.br/images/blog/sua-empresa-precisa-ter-um-site.jpg' ],
            ]),

        ];

        echo "<pre>";
        print_r($postContent    );
        echo "</pre>";

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $postContent);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, ['Content-Type: multipart/form-data']);
        $result = curl_exec($curl);
        curl_close($curl);
        return $result;




        $data = [
            'chat_id' => $usuario->chat_id,
            'text' =>"Infelizmente tivemos um problema com o seu pedido. Favor entrar em contato com @CrazyGandalf"
        ];
        $response = file_get_contents("https://api.telegram.org/bot$apiToken/sendMessage?" . http_build_query($data) );
    }

    function gerenciar()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar vendas.');
            redirect(base_url());
        }


        $this->load->library('pagination');
        $idUsuario = $this->session->userdata('id');
        $venda_id = $this->input->get('idVenda');
        $status = $this->input->get('status');
        $estoque = $this->input->get('estoque');
        $enviador = $this->input->get('enviador');
        $this->data['estoques'] = $this->categorias_model->get('categorias', '*', 'status = 1', 999, 0, 0, false, 'desc');
        $this->data['enviadores'] = $this->usuarios_model->get('usuarios', '*',false, 'enviador = 1');

        $this->data['status'] = $status;
        $this->data['estoque'] = $estoque;
        $this->data['enviador'] = $enviador;
        $where = "";
        if($this->session->userdata('permissao') == 1){
            $where = "1 = 1";
        }else{
            $where = "faturado = 1 AND (enviador_id = $idUsuario OR usuarios_id = $idUsuario)";
        }
        if (!empty($venda_id)) {
            $where .= " AND idVendas = $venda_id";
        }

        if(!empty($_POST['data_inicio']) && !empty($_POST['data_fim'])){
            $data_inicio = explode('/', $_POST['data_inicio']);
            $data_inicio = $data_inicio[2] . '-' . $data_inicio[1] . '-' . $data_inicio[0];

            $data_fim = explode('/', $_POST['data_fim']);
            $data_fim = $data_fim[2] . '-' . $data_fim[1] . '-' . $data_fim[0];


            $where .= " AND dataVenda BETWEEN '$data_inicio' AND '$data_fim'";
        }else if(!empty($_POST['dias_atras'])){
            $dias_atras = $_POST['dias_atras'];
            $where .= " AND dataVenda BETWEEN DATE_SUB(NOW(), INTERVAL $dias_atras DAY) AND NOW()";
            $this->data['dias_atras'] = $_POST['dias_atras'];
        }

        $where .= " AND enviador_id <> 0";


        if (!empty($status) && $status != 9) {
            $where .= " AND status = $status";
            $this->data['status'] = $status;
        }else{
            $this->data['status'] = $status;
        }

        if(!empty($estoque) && $estoque != 0){
            $where .= " AND categoria_id = $estoque";
        }

        if(!empty($enviador) && $enviador != 0){
            $where .= " AND enviador_id = $enviador";
        }

        $config['base_url'] = base_url() . 'index.php/vendas/gerenciar/';
        $config['total_rows'] = $this->vendas_model->count('vendas', $where);
        $config['per_page'] = 9999;


        $this->pagination->initialize($config);
        $users = $this->usuarios_model->get('usuarios', '*',false, '');
        $this->data['custo'] = array();
        foreach ($users as $u) {
            $this->data['users'][$u->idUsuarios] = $u->nome;
            $this->data['usersTelegram'][$u->idUsuarios] = $u->user_telegram;
            $this->data['usuarios'][$u->idUsuarios] = $u;
            $permissao = $this->Permissoes_model->get('permissoes', '*','idPermissao = '.$u->permissoes_id, '');
            $this->data['usersPermissao'][$u->idUsuarios] = $permissao[0];
        }
        $categorias = $this->categorias_model->get('categorias', '*',false, '');
        foreach ($categorias as $categoria){
            $this->data['categorias'][$categoria->idCategorias] = $categoria;
        }



        $vendas = $this->vendas_model->get('vendas', '*', $where, 99999, $this->uri->segment(3));
        $this->data['produtosVenda'] = array();
        $this->data['atraso'] = array();
        foreach ($vendas as $v){
            $this->data['custo'][$v->idVendas] = 0;
            $diferenca = strtotime(date('Y-m-d')) - strtotime($v->dataVenda);
            $tempo_espera = floor($diferenca / (60 * 60 * 24));
            $this->data['atraso'][$v->idVendas]['tempo_espera'] = $tempo_espera;

            if(empty($v->categoria_id)){
                $this->data['atraso'][$v->idVendas]['atraso'] = 0;

            }else{
                $prazo_despache =  $this->data['categorias'][$v->categoria_id]->despache;
                if($tempo_espera >= $prazo_despache){
                    $this->data['atraso'][$v->idVendas]['atraso'] = 1;
                    $this->data['atraso'][$v->idVendas]['dias'] = $tempo_espera - $prazo_despache;
                }else{
                    $this->data['atraso'][$v->idVendas]['atraso'] = 0;
                }
            }

            $itensVenda = $this->vendas_model->getProdutos($v->idVendas);

            $listProd = "";

            foreach ($itensVenda as $iv) {
                @$listProd .="<div class='row' style='margin-bottom: 5px'>";
                $quantidade = $iv->quantidade;

                $produto = $this->produtos_model->getById($iv->produtos_id);

                $whereC = "produto_id = " . $iv->produtos_id . " AND usuario_id = 1 AND de <= " . $quantidade . " AND ate >= " .$quantidade;
                $valorCusto = $this->UsuarioValor_model->get('usuario_valor', '*', $whereC);


                $styleBorder="";
                if($produto->status == 0){
                    $style="border: 3px solid red";
                }
                @$this->data['custo'][$v->idVendas] += $valorCusto[0]->valor * $quantidade;
                @$listProd.= "<img src='".$produto->imagem."' class='img_produto' style='$style'/>".$quantidade . " - <a href='".base_url()."index.php/produtos/editar/".$produto->idProdutos."'>" . $produto->descricao .  "</a> - Valor: R$". $iv->subTotal ."<span class='sensivel_admin'> : Custo: R$" . $valorCusto[0]->valor . "</span>\n";
                @$listProd .="</div>";
            }

            $this->data['produtosVenda'][$v->idVendas] = $listProd;
        }

        $this->data['results'] = $this->vendas_model->get('vendas', '*, vendas.cep as cep_venda', $where, $config['per_page'], $this->uri->segment(3));
        $this->data['view'] = 'vendas/vendas';
        $this->load->view('tema/topo', $this->data);


    }

    function todasVendas()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar vendas.');
            redirect(base_url());
        }



        $this->load->library('pagination');
        $status = $this->input->get('status');

        $where = "";

        if (!empty($_GET['vendedor'])) {
            $vendedor = $_GET['vendedor'];
            $where = "usuarios_id = $vendedor";
            $this->data['vendedorSelect'] = $vendedor;
        }
        $this->data['status'] = $status;

        $config['base_url'] = base_url() . 'index.php/vendas/gerenciar/';
        $config['total_rows'] = $this->vendas_model->count('vendas', $where);
        $config['per_page'] = 999;
        $config['next_link'] = 'Próxima';
        $config['prev_link'] = 'Anterior';
        $config['full_tag_open'] = '<div class="pagination alternate"><ul>';
        $config['full_tag_close'] = '</ul></div>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li><a style="color: #2D335B"><b>';
        $config['cur_tag_close'] = '</b></a></li>';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['first_link'] = 'Primeira';
        $config['last_link'] = 'Última';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';

        $this->pagination->initialize($config);
        $users = $this->usuarios_model->get('usuarios', '*');
        foreach ($users as $u) {
            $this->data['users'][$u->idUsuarios] = $u->nome;
        }



        $produtos = $this->produtos_model->get('produtos', '*', "", 999);

        $vendasPorProduto = array();
        foreach ($produtos as $p) {
            $produtosArray[$p->idProdutos]['nome'] = $p->descricao;
            $produtosArray[$p->idProdutos]['vendas'] = 0;
        }


        $vendasArray = array();
        foreach ($vendas as $v) {

            $produtosVenda = $this->vendas_model->getProdutos($v->idVendas);
            $vendasArray[$v->idVendas]['venda'] = $v;
            $vendasArray[$v->idVendas]['produtos'] = "";
            if (!empty($produtosVenda)) {
                foreach ($produtosVenda as $pv) {
                    $vendasArray[$v->idVendas]['produtos'] .= "$pv->quantidade - " . $produtosArray[$pv->idProdutos]['nome'] . "<br />";
                    $produtosArray[$pv->idProdutos]['vendas'] += $pv->quantidade;
                }
            }
        }

        $this->data['vendasArray'] = $vendasArray;
        $this->data['produtosArray'] = $produtosArray;

        $vendedores = $this->db->get('usuarios')->result();

        foreach ($vendedores as $vendedor) {
            $this->data['vendedores'][$vendedor->idUsuarios] = $vendedor->nome;
        }

        $this->data['view'] = 'vendas/todasVendas';

        $this->load->view('tema/topo', $this->data);


    }


    function adicionar()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'aVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para adicionar Vendas.');
            redirect(base_url());
        }

        $this->load->library('form_validation');
        $this->data['custom_error'] = '';
        $dataVenda = date('Y/m/d');

        $vendedor_id = $this->session->userdata('id');
        $data = array(
            'dataVenda' => $dataVenda,
            'clientes_id' => 1,
            'usuarios_id' => $vendedor_id,
            'faturado' => 0,
            'desconto' => 0.00
        );

        if (is_numeric($id = $this->vendas_model->add('vendas', $data, true))) {
            $this->session->set_flashdata('success', 'Venda iniciada com sucesso, adicione os produtos.');
            redirect('vendas/editar/' . $id);
        }
    }


    function editar()
    {

        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'eVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para editar vendas');
            redirect(base_url());
        }


        $this->load->library('form_validation');
        $this->data['custom_error'] = '';

        if (!empty($_POST)) {
            $dataVenda = date('Y-m-d H:i:s');


            $data = array(
                'dataVenda' => $dataVenda,
                'usuarios_id' => $this->input->post('usuarios_id'),
                'clientes_id' => $this->input->post('clientes_id'),
                'desconto' => $this->input->post('desconto'),
                'tipoEnvio' => $this->input->post('tipoEnvio'),
                'dadosEnvio' => $this->input->post('dadosEnvio'),
                'observacoes' => $this->input->post('observacoes'),
            );

            if ($this->vendas_model->edit('vendas', $data, 'idVendas', $this->input->post('idVendas')) == TRUE) {



                $venda_id = $this->uri->segment(3);
                $idUsuario = $this->session->userdata('id');

                $venda = $venda_id;
                $this->db->set('faturado', 1);
                $this->db->where('idVendas', $venda);

                if ($this->db->update('vendas')) {


                    $vendedor = $this->usuarios_model->getById($idUsuario);

                    $itensVenda = $this->vendas_model->getProdutos($venda);

                    $enviador = 0;
                    $taxaEnvio = 0;
                    foreach ($itensVenda as $iv) {
                        $taxaEnvio = $iv->taxaEnvio;
                        if ($iv->idFornecedor != $idUsuario) {

                            $valorCusto = ($iv->precoCompra * $iv->quantidade);
                            $descricao = "Venda #$venda + $iv->quantidade $iv->descricao | R$$iv->precoCompra cada";
                            $data = array(
                                'data' => date('Y-m-d h:i:s'),
                                'enviador_id' => $idUsuario,
                                'recebedor_id' => $iv->idFornecedor,
                                'valor' => $valorCusto,
                                'descricao' => $descricao,
                                'tipo' => "NEGATIVO",
                                'venda_id' => $venda_id,
                            );

                            if ($this->vendas_model->add('dividas', $data) != TRUE) {

                                $this->session->set_flashdata('error', 'Ocorreu um erro ao incluir a divida');
                                $json = array('result' => false);
                                echo json_encode($json);
                                die();
                            } else {

                                $fornecedorModel = $this->usuarios_model->getById($iv->idFornecedor);
                                if (!empty($fornecedorModel->chat_id)) {

                                    $totalizadorDivida = $this->totalizador($idUsuario, $iv->idFornecedor);
                                    $text = "O vendedor $vendedor->nome fez uma venda!\nValor total: R$$valorCusto\n$descricao\nSaldo do $vendedor->nome com você: R$$totalizadorDivida";

                                    $this->sendMessage("sendMessage", array('chat_id' => $fornecedorModel->chat_id, "text" => $text));
                                }


                            }
                        }
                        if ($iv->usuarioEnvio_id != $idUsuario) {


                            if ($enviador != $iv->usuarioEnvio_id) {
                                $enviador = $iv->usuarioEnvio_id;
                                $this->db->set('enviador_id', $enviador);
                                $vendaModel = $this->vendas_model->getById($venda);

                                switch ($vendaModel->tipoEnvio) {
                                    case "CARTA":
                                        $frete = 20;
                                        break;
                                    case "SEDEX":
                                        $frete = 60;
                                        break;
                                    case "SEDEX10":
                                        $frete = 60;
                                        break;
                                }

                                $freteTotal = $frete + $taxaEnvio;
                                $descricao = "FRETE! Venda #$venda + $taxaEnvio de taxa - $vendaModel->tipoEnvio";
                                $data = array(
                                    'data' => date('Y-m-d h:i:s'),
                                    'enviador_id' => $idUsuario,
                                    'recebedor_id' => $iv->usuarioEnvio_id,
                                    'valor' => $freteTotal,
                                    'descricao' => $descricao,
                                    'tipo' => "NEGATIVO",
                                    'venda_id' => $venda
                                );
                                if ($this->vendas_model->add('dividas', $data) != TRUE) {
                                    $this->session->set_flashdata('error', 'Ocorreu um erro ao incluir a divida');
                                    $json = array('result' => false);
                                    echo json_encode($json);
                                    die();
                                } else {

                                    $enviadorModel = $this->usuarios_model->getById($iv->usuarioEnvio_id);
                                    if (!empty($enviadorModel->chat_id)) {
                                        $totalizadorDivida = $this->totalizador($idUsuario, $iv->usuarioEnvio_id);
                                        $text = "O vendedor $vendedor->nome solicitou um novo envio!\nValor Total: R$$freteTotal\n$descricao\nSaldo do $vendedor->nome com você: R$$totalizadorDivida";

                                        $this->sendMessage("sendMessage", array('chat_id' => $enviadorModel->chat_id, "text" => $text));

                                        $this->sendMessage("sendMessage", array('chat_id' => $enviadorModel->chat_id, "text" => $vendaModel->dadosEnvio));
                                    }
                                }
                            }
                        }
                    }


                }
                $this->db->set('enviador_id', $enviador);
                $this->db->where('idVendas', $venda);

                if ($this->db->update('vendas')) {
                    /*$this->session->set_flashdata('success', 'Venda faturada com sucesso!');
                    $json = array('result' => true);
                    echo json_encode($json);
                    die();*/
                }


                $this->session->set_flashdata('success', 'Venda criada com sucesso!');

                redirect(base_url() . 'index.php/vendas?status=1');
                //redirect(base_url() . 'index.php/vendas?status=0');
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro</p></div>';
            }
        }


        $this->data['result'] = $this->vendas_model->getById($this->uri->segment(3));


        $this->data['produtos'] = $this->vendas_model->getProdutos($this->uri->segment(3));
        $this->data['view'] = 'vendas/editarVenda';
        $this->load->view('tema/topo', $this->data);

    }

    public function visualizar()
    {

        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar vendas.');
            redirect(base_url());
        }

        $this->data['custom_error'] = '';
        $this->load->model('mapos_model');
        $this->data['result'] = $this->vendas_model->getById($this->uri->segment(3));
        $this->data['produtos'] = $this->vendas_model->getProdutos($this->uri->segment(3));
        $this->data['emitente'] = $this->mapos_model->getEmitente();

        $this->data['view'] = 'vendas/visualizarVenda';
        $this->load->view('tema/topo', $this->data);

    }

    public function prontoDespache()
    {

        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar vendas.');
            redirect(base_url());
        }

        $data = array(
            'status' => 2,
        );

        if ($this->vendas_model->edit('vendas', $data, 'idVendas', $this->uri->segment(3)) == TRUE) {
            redirect(base_url() . 'index.php/vendas?status=2');
        }
    }


    public function enviadoCliente()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar vendas.');
            redirect(base_url());
        }

        $data = array(
            'status' => 4,
        );

        if ($this->vendas_model->edit('vendas', $data, 'idVendas', $_POST['id']) == TRUE) {
            $this->session->set_flashdata('success', 'Venda finalizada!');
            redirect(base_url() . 'index.php/vendas?status=3');
        }
    }


    public function excluir()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'dVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para excluir vendas');
            redirect(base_url());
        }

        $id = $this->input->post('id');
        if ($id == null) {

            $this->session->set_flashdata('error', 'Erro ao tentar excluir venda.');
            redirect(base_url() . 'index.php/vendas/gerenciar/');
        }

        $itensVenda = $this->vendas_model->getProdutos($id);

        foreach ($itensVenda as $iv) {

            $quantidade = $iv->quantidade;
            $prod = $this->produtos_model->getById($iv->produtos_id);
            $data = array(
                'estoque' => $prod->estoque + $quantidade,
            );

            if ($this->produtos_model->edit('produtos', $data, 'idProdutos', $iv->produtos_id) == TRUE) {
                $this->db->where('vendas_id', $id);
                $this->db->delete('itens_de_vendas');
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>An Error Occured</p></div>';

            }
        }


        $this->db->where('idVendas', $id);
        $this->db->delete('vendas');

        $this->db->where('venda_id', $id);
        $this->db->delete('dividas');

        $this->session->set_flashdata('success', 'Venda excluída com sucesso!');
        redirect(base_url() . 'index.php/vendas/gerenciar/');

    }

    public function autoCompleteProduto()
    {

        if (isset($_GET['term'])) {
            $q = strtolower($_GET['term']);
            $this->vendas_model->autoCompleteProduto($q);
        }

    }

    public function autoCompleteCliente()
    {

        if (isset($_GET['term'])) {
            $q = strtolower($_GET['term']);
            $this->vendas_model->autoCompleteCliente($q);
        }

    }

    public function autoCompleteUsuario()
    {

        if (isset($_GET['term'])) {
            $q = strtolower($_GET['term']);
            $this->vendas_model->autoCompleteUsuario($q);
        }

    }


    public function adicionarProduto()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'eVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para editar vendas.');
            redirect(base_url());
        }


        $this->load->library('form_validation');
        $this->form_validation->set_rules('quantidade', 'Quantidade', 'trim|required');
        $this->form_validation->set_rules('idProduto', 'Produto', 'trim|required');
        $this->form_validation->set_rules('idVendasProduto', 'Vendas', 'trim|required');

        if ($this->form_validation->run() == false) {
            echo json_encode(array('result' => false));
        } else {


            $preco = $this->input->post('preco');
            $quantidade = $this->input->post('quantidade');
            $subtotal = $preco * $quantidade;
            $produto = $this->input->post('idProduto');
            $data = array(
                'quantidade' => $quantidade,
                'subTotal' => $subtotal,
                'produtos_id' => $produto,
                'vendas_id' => $this->input->post('idVendasProduto'),
            );

            if ($this->vendas_model->add('itens_de_vendas', $data) == true) {
                $sql = "UPDATE produtos set estoque = estoque - ? WHERE idProdutos = ?";
                $this->db->query($sql, array($quantidade, $produto));

                $produtoModel = $this->produtos_model->getById($produto);

                echo json_encode(array('result' => true, 'enviador_id' => $produtoModel->usuarioEnvio_id));
            } else {
                echo json_encode(array('result' => false));
            }

        }


    }

    function excluirProduto()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'eVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para editar Vendas');
            redirect(base_url());
        }

        $ID = $this->input->post('idProduto');
        if ($this->vendas_model->delete('itens_de_vendas', 'idItens', $ID) == true) {

            $quantidade = $this->input->post('quantidade');
            $produto = $this->input->post('produto');


            $sql = "UPDATE produtos set estoque = estoque + ? WHERE idProdutos = ?";

            $this->db->query($sql, array($quantidade, $produto));

            echo json_encode(array('result' => true));
        } else {
            echo json_encode(array('result' => false));
        }
    }


    public function faturar()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'eVenda')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para editar Vendas');
            redirect(base_url());
        }

        $this->load->library('form_validation');
        $this->data['custom_error'] = '';

        if ($this->form_validation->run('receita') == false) {
            $this->data['custom_error'] = (validation_errors() ? '<div class="form_error">' . validation_errors() . '</div>' : false);
        } else {

            $venda_id = $this->input->post('vendas_id');
            $vencimento = $this->input->post('vencimento');
            $recebimento = $this->input->post('recebimento');
            $parcelado = $this->input->post('parcelado');
            $idUsuario = $this->session->userdata('id');

            $valor = $this->input->post('valor');
            try {

                $vencimento = explode('/', $vencimento);
                $vencimento = $vencimento[2] . '-' . $vencimento[1] . '-' . $vencimento[0];

                if ($recebimento != null) {
                    $recebimento = explode('/', $recebimento);
                    $recebimento = $recebimento[2] . '-' . $recebimento[1] . '-' . $recebimento[0];

                }
            } catch (Exception $e) {
                $vencimento = date('Y/m/d');
            }

            $venda = $this->input->post('vendas_id');
            $this->db->set('faturado', 1);
            $this->db->set('valorTotal', $this->input->post('valor'));
            $this->db->where('idVendas', $venda);

            if ($this->db->update('vendas')) {


                $vendedor = $this->usuarios_model->getById($idUsuario);

                $itensVenda = $this->vendas_model->getProdutos($venda);


                $enviador = 0;
                $taxaEnvio = 0;

                foreach ($itensVenda as $iv) {
                    $taxaEnvio = $iv->taxaEnvio;
                    if ($iv->idFornecedor != $idUsuario) {

                        $valorCusto = ($iv->precoCompra * $iv->quantidade);
                        $descricao = "Venda #$venda + $iv->quantidade $iv->descricao | R$$iv->precoCompra cada";
                        $data = array(
                            'data' => date('Y-m-d h:i:s'),
                            'enviador_id' => $idUsuario,
                            'recebedor_id' => $iv->idFornecedor,
                            'valor' => $valorCusto,
                            'descricao' => $descricao,
                            'tipo' => "NEGATIVO",
                            'venda_id' => $venda_id,
                        );

                        if ($this->vendas_model->add('dividas', $data) != TRUE) {
                            Request::sendMessage([
                                'chat_id' => 617711684,
                                'text'    => "errooo",
                            ]);
                            $this->session->set_flashdata('error', 'Ocorreu um erro ao incluir a divida');
                            $json = array('result' => false);
                            echo json_encode($json);
                            die();
                        } else {

                            $fornecedorModel = $this->usuarios_model->getById($iv->idFornecedor);
                            if (!empty($fornecedorModel->chat_id)) {

                                $totalizadorDivida = $this->totalizador($idUsuario, $iv->idFornecedor);
                                $text = "O vendedor $vendedor->nome fez uma venda!\nValor total: R$$valorCusto\n$descricao\nSaldo do $vendedor->nome com você: R$$totalizadorDivida";

                                $this->sendMessage("sendMessage", array('chat_id' => $fornecedorModel->chat_id, "text" => $text));
                            }


                        }
                    }
                    Request::sendMessage([
                        'chat_id' => 617711684,
                        'text'    => "passo",
                    ]);
                    if ($iv->usuarioEnvio_id != $idUsuario) {


                        if ($enviador != $iv->usuarioEnvio_id) {
                            $enviador = $iv->usuarioEnvio_id;
                            $this->db->set('enviador_id', $enviador);
                            $vendaModel = $this->vendas_model->getById($venda);

                            switch ($vendaModel->tipoEnvio) {
                                case "CARTA":
                                    $frete = 20;
                                    break;
                                case "SEDEX":
                                    $frete = 60;
                                    break;
                                case "SEDEX10":
                                    $frete = 60;
                                    break;
                            }

                            $freteTotal = $frete + $taxaEnvio;
                            $descricao = "FRETE! Venda #$venda + $taxaEnvio de taxa - $vendaModel->tipoEnvio";
                            $data = array(
                                'data' => date('Y-m-d h:i:s'),
                                'enviador_id' => $idUsuario,
                                'recebedor_id' => $iv->usuarioEnvio_id,
                                'valor' => $freteTotal,
                                'descricao' => $descricao,
                                'tipo' => "NEGATIVO",
                                'venda_id' => $venda
                            );

                            if ($this->vendas_model->add('dividas', $data) != TRUE) {
                                $this->session->set_flashdata('error', 'Ocorreu um erro ao incluir a divida');
                                $json = array('result' => false);
                                echo json_encode($json);
                                die();
                            } else {

                                $enviadorModel = $this->usuarios_model->getById($iv->usuarioEnvio_id);
                                if (!empty($enviadorModel->chat_id)) {
                                    $totalizadorDivida = $this->totalizador($idUsuario, $iv->usuarioEnvio_id);
                                    $text = "O vendedor $vendedor->nome solicitou um novo envio!\nValor Total: R$$freteTotal\n$descricao\nSaldo do $vendedor->nome com você: R$$totalizadorDivida";

                                    $this->sendMessage("sendMessage", array('chat_id' => $enviadorModel->chat_id, "text" => $text));

                                    $this->sendMessage("sendMessage", array('chat_id' => $enviadorModel->chat_id, "text" => $vendaModel->dadosEnvio));
                                }
                            }
                        }
                    }
                }


            }
            $this->db->set('enviador_id', $enviador);
            $this->db->where('idVendas', $venda);

            if ($this->db->update('vendas')) {
                $this->session->set_flashdata('success', 'Venda faturada com sucesso!');
                $json = array('result' => true);
                echo json_encode($json);
                die();
            }


        }

        $this->session->set_flashdata('error', 'Ocorreu um erro ao tentar faturar venda.');
        $json = array('result' => false);
        echo json_encode($json);

    }

    function sendMessage($method, $parameters)
    {
        $options = array(
            'http' => array(
                'method' => 'POST',
                'content' => json_encode($parameters),
                'header' => "Content-Type: application/json\r\n" .
                    "Accept: application/json\r\n"
            )
        );
        $context = stream_context_create($options);
        file_get_contents(WARNYJ_API . $method, false, $context);
    }

    public function totalizador($usr1, $usr2)
    {
        $totalizador = 0;

        $dividasEnviadas = $this->Dividas_model->get('dividas', '*', "enviador_id = $usr1 AND recebedor_id = $usr2");

        foreach ($dividasEnviadas as $de) {
            if ($de->tipo == 'POSITIVO') {
                $totalizador += $de->valor;
            } else if ($de->tipo == 'NEGATIVO') {
                $totalizador -= $de->valor;
            }
        }

        $dividasRecebidas = $this->Dividas_model->get('dividas', '*', "enviador_id = $usr2 AND recebedor_id = $usr1");

        foreach ($dividasRecebidas as $dr) {
            if ($dr->tipo == 'POSITIVO') {
                $totalizador -= $dr->valor;
            } else if ($dr->tipo == 'NEGATIVO') {
                $totalizador += $dr->valor;
            }
        }

        return $totalizador;
    }
}

