<div class="row-fluid" style="margin-top:0">
    <div class="span12">
        <div class="widget-box">
            <div class="widget-title">
                <span class="icon">
                    <i class="icon-user"></i>
                </span>
                <h5>Editar Cliente</h5>
            </div>
            <div class="widget-content nopadding">
                <?php if ($custom_error != '') {
                    echo '<div class="alert alert-danger">' . $custom_error . '</div>';
                } ?>
                <form action="<?php echo current_url(); ?>" id="formCliente" method="post" class="form-horizontal" >
                    <div class="control-group">
                        <?php echo form_hidden('idClientes',$result->idClientes) ?>
                        <label for="nomeCliente" class="control-label">Nome<span class="required">*</span></label>
                        <div class="controls">
                            <input id="nomeCliente" type="text" name="nomeCliente" value="<?php echo $result->nomeCliente; ?>"  />
                        </div>
                    </div>
                    <div class="control-group">
                        <label for="documento" class="control-label">CPF/CNPJ<span class="required">*</span></label>
                        <div class="controls">
                            <input id="documento" type="text" name="documento" value="<?php echo $result->documento; ?>"  />
                        </div>
                    </div>
                    <div class="control-group">
                        <label for="telefone" class="control-label">Telefone<span class="required">*</span></label>
                        <div class="controls">
                            <input id="telefone" type="text" name="telefone" value="<?php echo $result->telefone; ?>"  />
                        </div>
                    </div>

                    <div class="control-group">
                        <label for="celular" class="control-label">Celular</label>
                        <div class="controls">
                            <input id="celular" type="text" name="celular" value="<?php echo $result->celular; ?>"  />
                        </div>
                    </div>

                    <div class="control-group">
                        <label for="email" class="control-label">Email<span class="required">*</span></label>
                        <div class="controls">
                            <input id="email" type="text" name="email" value="<?php echo $result->email; ?>"  />
                        </div>
                    </div>
                    
                    <div class="control-group" class="control-label">
                        <label for="cep" class="control-label">CEP<span class="required">*</span></label>
                        <div class="controls">
                            <input id="cep" type="text" name="cep" value="<?php echo $result->cep; ?>"  />
                        </div>
                    </div>
                    
                    <div class="control-group">
                        <label for="numero" class="control-label">Número<span class="required">*</span></label>
                        <div class="controls">
                            <input id="numero" type="text" name="numero" value="<?php echo $result->numero; ?>"  />
                        </div>
                    </div>
                    
                    <div class="control-group" class="control-label">
                        <label for="rua" class="control-label">Rua<span class="required">*</span></label>
                        <div class="controls">
                            <input id="rua" type="text" name="rua" value="<?php echo $result->rua; ?>"  />
                        </div>
                    </div>

                    <div class="control-group" class="control-label">
                        <label for="bairro" class="control-label">Bairro<span class="required">*</span></label>
                        <div class="controls">
                            <input id="bairro" type="text" name="bairro" value="<?php echo $result->bairro; ?>"  />
                        </div>
                    </div>

                    <div class="control-group" class="control-label">
                        <label for="cidade" class="control-label">Cidade<span class="required">*</span></label>
                        <div class="controls">
                            <input id="cidade" type="text" name="cidade" value="<?php echo $result->cidade; ?>"  />
                        </div>
                    </div>

                    <div class="control-group" class="control-label">
                        <label for="estado" class="control-label">Estado<span class="required">*</span></label>
                        <div class="controls">
                            <input id="estado" type="text" name="estado" value="<?php echo $result->estado; ?>"  />
                        </div>
                    </div>

                    <div class="control-group" class="control-label">
                        <label for="cliente_mensalista" class="control-label">Mensalista</label>
                        <div class="controls">
                            <input id="cliente_mensalista" type="checkbox" <?=$result->cliente_mensalista == 1 ? "checked" : ""; ?> name="cliente_mensalista" value="1"/>
                        </div>
                    </div>

                    <div class="mensalistas" style="display: none">
                        <div class="control-group" class="control-label">
                            <label for="valor_mensalidade" class="control-label">Valor da Mensalidade<span
                                        class="required">*</span></label>
                            <div class="controls">
                                <input id="valor_mensalidade" type="text" class="money" name="valor_mensalidade"
                                       value="<?php echo $result->valor_mensalidade; ?>"/>
                            </div>
                        </div>
                        <div class="control-group" class="control-label">
                            <label for="dia_vencimento" class="control-label">Dia de Vencimento<span
                                        class="required">*</span></label>
                            <div class="controls">
                                <input id="dia_vencimento" min="01" max="28" type="number" name="dia_vencimento"
                                       value="<?php echo $result->dia_vencimento; ?>"/>
                            </div>
                        </div>

                    </div>





                    <div class="form-actions">
                        <div class="span12">
                            <div class="span6 offset3">
                                <button type="submit" class="btn btn-primary"><i class="icon-ok icon-white"></i> Alterar</button>
                                <a href="<?php echo base_url() ?>index.php/clientes" id="" class="btn"><i class="icon-arrow-left"></i> Voltar</a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>



<script src="<?php echo base_url()?>assets/js/jquery.validate.js"></script>
<script src="<?php echo base_url(); ?>assets/js/maskmoney.js"></script>
<script type="text/javascript">
      $(document).ready(function(){

          $(".money").maskMoney();


          if ($('#cliente_mensalista').prop("checked") == true) {
              $('.mensalistas').slideDown();
              $("#valor_mensalidade").prop('required', true);
              $("#dia_vencimento").prop('required', true);

          } else {
              $('.mensalistas').slideUp();
              $("#valor_mensalidade").val('');
              $("#dia_vencimento").val('');
          }



          $('#cliente_mensalista').click(function () {

              if ($('#cliente_mensalista').prop("checked") == true) {
                  $('.mensalistas').slideDown();
                  $("#valor_mensalidade").prop('required', true);
                  $("#dia_vencimento").prop('required', true);

              } else {
                  $('.mensalistas').slideUp();
                  $("#valor_mensalidade").val('');
                  $("#dia_vencimento").val('');
              }

          });


           $('#formCliente').validate({
               rules :{
                   nomeCliente:{ required: true},
                   documento:{ required: true},
                   /*telefone:{ required: true},
                   email:{ required: true},
                   rua:{ required: true},
                   numero:{ required: true},
                   bairro:{ required: true},
                   cidade:{ required: true},
                   estado:{ required: true},
                   cep:{ required: true}*/
               },
               messages:{
                   nomeCliente :{ required: 'Campo Requerido.'},
                   documento :{ required: 'Campo Requerido.'},
                   /* telefone:{ required: 'Campo Requerido.'},
                    email:{ required: 'Campo Requerido.'},
                    rua:{ required: 'Campo Requerido.'},
                    numero:{ required: 'Campo Requerido.'},
                    bairro:{ required: 'Campo Requerido.'},
                    cidade:{ required: 'Campo Requerido.'},
                    estado:{ required: 'Campo Requerido.'},
                    cep:{ required: 'Campo Requerido.'}*/

               },

            errorClass: "help-inline",
            errorElement: "span",
            highlight:function(element, errorClass, validClass) {
                $(element).parents('.control-group').addClass('error');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).parents('.control-group').removeClass('error');
                $(element).parents('.control-group').addClass('success');
            }
           });
      });
</script>

<script type="text/javascript" >

        $(document).ready(function() {

            function limpa_formulario_cep() {
                // Limpa valores do formulário de cep.
                $("#rua").val("");
                $("#bairro").val("");
                $("#cidade").val("");
                $("#estado").val("");
            }
            
            //Quando o campo cep perde o foco.
            $("#cep").blur(function() {

                //Nova variável "cep" somente com dígitos.
                var cep = $(this).val().replace(/\D/g, '');

                //Verifica se campo cep possui valor informado.
                if (cep != "") {

                    //Expressão regular para validar o CEP.
                    var validacep = /^[0-9]{8}$/;

                    //Valida o formato do CEP.
                    if(validacep.test(cep)) {

                        //Preenche os campos com "..." enquanto consulta webservice.
                        $("#rua").val("...");
                        $("#bairro").val("...");
                        $("#cidade").val("...");
                        $("#estado").val("...");

                        //Consulta o webservice viacep.com.br/
                        $.getJSON("https://viacep.com.br/ws/"+ cep +"/json/?callback=?", function(dados) {

                            if (!("erro" in dados)) {
                                //Atualiza os campos com os valores da consulta.
                                $("#rua").val(dados.logradouro);
                                $("#bairro").val(dados.bairro);
                                $("#cidade").val(dados.localidade);
                                $("#estado").val(dados.uf);
                                document.getElementById("numero").focus();
                            } //end if.
                            else {
                                //CEP pesquisado não foi encontrado.
                                limpa_formulario_cep();
                                alert("CEP não encontrado.");
                            }
                        });
                    } //end if.
                    else {
                        //cep é inválido.
                        limpa_formulario_cep();
                        alert("Formato de CEP inválido.");
                    }
                } //end if.
                else {
                    //cep sem valor, limpa formulário.
                    limpa_formulario_cep();
                }
            });
        });

    </script>
