<style>
/* Hiding the checkbox, but allowing it to be focused */
.badgebox
{
    opacity: 0;
}

.badgebox + .badge
{
    /* Move the check mark away when unchecked */
    text-indent: -999999px;
    /* Makes the badge's width stay the same checked and unchecked */
	width: 27px;
}

.badgebox:focus + .badge
{
    /* Set something to make the badge looks focused */
    /* This really depends on the application, in my case it was: */
    
    /* Adding a light border */
    box-shadow: inset 0px 0px 5px;
    /* Taking the difference out of the padding */
}

.badgebox:checked + .badge
{
    /* Move the check mark back when checked */
	text-indent: 0;
}
</style>
<div class="row-fluid" style="margin-top:0">
    <div class="span12">
        <div class="widget-box">
            <div class="widget-title">
                <span class="icon">
                    <i class="icon-align-justify"></i>
                </span>
                <h5>Cadastro de Produto</h5>
            </div>
            <div class="widget-content nopadding">
                <?php if ($custom_error != '') {
                    echo '<div class="alert alert-danger">' . $custom_error . '</div>';
                } ?>
                <form action="<?php echo current_url(); ?>" id="formProduto" method="post" class="form-horizontal" >
                     <div class="control-group">
                        <label for="descricao" class="control-label">Descrição<span class="required">*</span></label>
                        <div class="controls">
                            <input id="descricao" type="text" name="descricao" value="<?php echo set_value('descricao'); ?>"  />
                        </div>
                    </div>
                    <div class="control-group">
                        <label for="sigla" class="control-label">Sigla</label>
                        <div class="controls">
                            <input id="sigla" type="text" name="sigla" value="<?php echo set_value('sigla'); ?>"  />
                        </div>
                    </div>

                    <div class="control-group">
                        <label for="precoCompra" class="control-label">Preço de Custo<span class="required">*</span></label>
                        <div class="controls">
                            <input id="precoCompra" class="money" type="text" name="precoCompra" value="<?php echo set_value('precoCompra'); ?>"  />
                        </div>
                    </div>

                    <div class="control-group">
                        <label for="precoVenda" class="control-label">Preço Padrão<span class="required">*</span></label>
                        <div class="controls">
                            <input id="precoVenda" class="money" type="text" name="precoVenda" value="<?php echo set_value('precoVenda'); ?>"  />
                        </div>
                    </div>
                    <div class="control-group">
                        <label for="unidade" class="control-label">Categoria<span class="required">*</span></label>
                        <div class="controls">

                            <?php
                            if(!empty($categorias)) {
                                echo form_dropdown('categoria', $categorias, '');
                            }else{
                                echo "Nenhuma categoria cadastrada";
                            }?>


                        </div>
                    </div>

                    <div class="control-group">
                        <label for="tipo_id" class="control-label">Tipo<span class="required">*</span></label>
                        <div class="controls">

                            <?php
                            if(!empty($tipos)) {
                                echo form_dropdown('tipo_id', $tipos, '');
                            }else{
                                echo "Nenhum tipo cadastrado";
                            }?>


                        </div>
                    </div>
                    <div class="control-group">
                        <label for="idFornecedor" class="control-label">Fornecedor<span class="required">*</span></label>
                        <div class="controls">

                            <?php
                            if(!empty($fornecedores)) {
                                echo form_dropdown('idFornecedor', $fornecedores, '');
                            }else{
                                echo "Nenhum fornecedor cadastrado";
                            }?>


                        </div>
                    </div>


                    <div class="control-group">
                        <label for="usuarioEnvio_id" class="control-label">Responsavel de Envio<span class="required">*</span></label>
                        <div class="controls">

                            <?php
                            if(!empty($fornecedores)) {
                                echo form_dropdown('usuarioEnvio_id', $fornecedores, '');
                            }else{
                                echo "Nenhum usuario cadastrado";
                            }?>


                        </div>
                    </div>


                    <div class="control-group">
                        <label for="estoque" class="control-label">Estoque<span class="required">*</span></label>
                        <div class="controls">
                            <input id="estoque" type="text" name="estoque" value="<?php echo set_value('estoque'); ?>"  />
                        </div>
                    </div>

                    <div class="control-group">
                        <label for="estoqueMinimo" class="control-label">Estoque Mínimo</label>
                        <div class="controls">
                            <input id="estoqueMinimo" type="text" name="estoqueMinimo" value="<?php echo set_value('estoqueMinimo'); ?>"  />
                        </div>
                    </div>

                    <div class="control-group">
                        <label for="status" class="control-label">Status<span class="required">*</span></label>
                        <div class="controls">

                            <?php

                            echo form_dropdown('status', array(1=>'Ativo',0=>'Inativo'), '');
                           ?>


                        </div>
                    </div>




                    <div class="control-group">
                        <label for="taxaEnvio" class="control-label">Taxa de Envio<span1 class="required">*</span1></label>
                        <div class="controls">
                            <input id="taxaEnvio" class="money" type="text" name="taxaEnvio" value="<?php echo set_value('taxaEnvio'); ?>"  />
                        </div>
                    </div>

                    <div class="control-group">
                    <?php foreach ($permissoes as $idPermissao => $p) {?>
                    <div class="control-group">
                        <label  class="control-label"><?=$p?><span class="required">*</span></label>
                        <div class="controls">

                            <div id="opcoes_1">
                            <input id="de_<?=$idPermissao?>_1" opcao="1" type="text" name="de_<?=$idPermissao?>_1" style="width: 20px" />

                            <input id="ate_<?=$idPermissao?>_1" opcao="1" type="text" name="ate_<?=$idPermissao?>_1" style="width: 20px" />


                            <input id="usuario_valor_<?=$idPermissao?>_1" opcao="1" class="money" type="text" name="usuario_valor_<?=$idPermissao?>_1" value="0.00"  />
                            <button type="button" class="btn btn-success"><i class="icon-plus icon-white"></i></button>
                            <button type="button" class="btn btn-danger"><i class="icon-remove icon-white"></i></button>
                            </div>
                        </div>
                    </div>
                        <?php } ?>
                    </div>
                    <div class="form-actions">
                        <div class="span12">
                            <div class="span6 offset3">
                                <button type="submit" class="btn btn-success"><i class="icon-plus icon-white"></i> Adicionar</button>
                                <a href="<?php echo base_url() ?>index.php/produtos" id="" class="btn"><i class="icon-arrow-left"></i> Voltar</a>
                            </div>
                        </div>
                    </div>

                    
                </form>
            </div>

         </div>
     </div>
</div>

<script src="<?php echo base_url()?>assets/js/jquery.validate.js"></script>
<script src="<?php echo base_url();?>assets/js/maskmoney.js"></script>
<script type="text/javascript">
    $(document).ready(function(){
        $(".money").maskMoney();

        $('#formProduto').validate({
            rules :{
                  descricao: { required: true},
                  unidade: { required: true},
                  precoCompra: { required: true},
                  precoVenda: { required: true},
                  estoque: { required: true}
            },
            messages:{
                  descricao: { required: 'Campo Requerido.'},
                  unidade: {required: 'Campo Requerido.'},
                  precoCompra: { required: 'Campo Requerido.'},
                  precoVenda: { required: 'Campo Requerido.'},
                  estoque: { required: 'Campo Requerido.'}
            },

            errorClass: "help-inline",
            errorElement: "span",
            highlight:function(element, errorClass, validClass) {
                $(element).parents('.control-group').addClass('error');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).parents('.control-group').removeClass('error');
                $(element).parents('.control-group').addClass('success');
            }
           });
    });
</script>



