<!DOCTYPE html>
<html>
  <head>
    <title>Relatório de Vendas</title>
    <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <style>
        body {
            font-family: 'Helvetica', Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background: #f8f9fa;
        }
        
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            max-width: 1200px;
            margin: 0 auto;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #2D335B;
        }

        .header h2 {
            color: #2D335B;
            font-size: 28px;
            margin: 0;
            margin-bottom: 10px;
        }

        .header p {
            color: #6c757d;
            font-size: 14px;
            margin: 0;
        }

        .table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
            margin-bottom: 20px;
        }

        .table th {
            background: #2D335B;
            color: white;
            font-weight: 500;
            padding: 12px;
            text-align: left;
            font-size: 14px;
        }

        .table th:first-child {
            border-top-left-radius: 8px;
        }

        .table th:last-child {
            border-top-right-radius: 8px;
        }

        .table td {
            padding: 12px;
            border-bottom: 1px solid #e9ecef;
            color: #495057;
            font-size: 13px;
        }

        .table tbody tr:hover {
            background-color: #f8f9fa;
        }

        .table tbody tr:last-child td {
            border-bottom: none;
        }

        .status {
            padding: 5px 10px;
            border-radius: 15px;
            font-size: 12px;
            font-weight: 500;
        }

        .status-aguardando {
            background: #fff3cd;
            color: #856404;
        }

        .status-aprovado {
            background: #d4edda;
            color: #155724;
        }

        .status-finalizado {
            background: #cce5ff;
            color: #004085;
        }

        .total-section {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 2px solid #e9ecef;
        }

        .total-row {
            background: #2D335B !important;
            color: white;
            font-weight: bold;
        }

        .total-row td {
            padding: 15px !important;
            color: white !important;
            font-size: 14px !important;
        }

        .valor {
            font-weight: 600;
            color: #2D335B;
        }

        .footer {
            margin-top: 30px;
            text-align: center;
            color: #6c757d;
            font-size: 12px;
        }

        .totalizadores {
            margin-top: 20px;
        }

        .total-card {
            background: white;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .total-info {
            display: flex;
            flex-direction: column;
        }

        .total-label {
            color: #6c757d;
            font-size: 14px;
            margin-bottom: 10px;
        }

        .total-value {
            color: #2D335B;
            font-size: 24px;
            font-weight: 600;
            margin: 0;
        }

        .status-counts {
            display: flex;
            flex-direction: column;
            gap: 5px;
        }

        .detail-list {
            margin-top: 10px;
        }

        .detail-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 8px 0;
            border-bottom: 1px solid #e9ecef;
        }

        .detail-item:last-child {
            border-bottom: none;
        }

        .detail-label {
            color: #495057;
            font-weight: 500;
        }

        .detail-count {
            color: #6c757d;
            font-size: 13px;
        }

        .detail-value {
            color: #2D335B;
            font-weight: 600;
        }

        .mt-4 {
            margin-top: 1.5rem;
        }

        .row {
            display: flex;
            flex-wrap: wrap;
            margin-right: -15px;
            margin-left: -15px;
        }

        .col-md-3 {
            flex: 0 0 25%;
            max-width: 25%;
            padding: 0 15px;
        }

        .col-md-6 {
            flex: 0 0 50%;
            max-width: 50%;
            padding: 0 15px;
        }

        @media print {
            body {
                background: white;
                padding: 0;
            }
            
            .container {
                box-shadow: none;
                padding: 20px;
            }
            
            .table th {
                background-color: #2D335B !important;
                color: white !important;
                -webkit-print-color-adjust: exact;
            }

            .total-row {
                background-color: #2D335B !important;
                color: white !important;
                -webkit-print-color-adjust: exact;
            }

            .total-card {
                break-inside: avoid;
            }
        }

        .totalizadores-topo {
            margin-bottom: 30px;
        }

        .total-info-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
        }

        .total-card.destaque {
            background: linear-gradient(135deg, #2D335B, #3a4175);
            color: white;
        }

        .total-card.destaque .total-label {
            color: rgba(255,255,255,0.8);
        }

        .total-card.destaque .total-value {
            color: white;
        }

        .total-item {
            text-align: center;
            padding: 20px;
        }

        .detail-item {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid rgba(0,0,0,0.1);
        }

        .detail-count {
            font-weight: 600;
            color: #2D335B;
        }

        .filtros {
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .filtros form {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }

        .filtro-item {
            margin-bottom: 10px;
        }

        .filtro-item label {
            display: block;
            margin-bottom: 5px;
            color: #495057;
            font-weight: 500;
        }

        .filtro-item select, .filtro-item input {
            width: 100%;
            padding: 8px;
            border: 1px solid #ced4da;
            border-radius: 4px;
        }

        .filtro-buttons {
            grid-column: 1 / -1;
            display: flex;
            gap: 10px;
        }

        .btn-filtrar {
            background: #2D335B;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
        }

        .btn-limpar {
            background: #6c757d;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
        }

        .faturado-badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: 500;
        }

        .faturado-sim {
            background: #d4edda;
            color: #155724;
        }

        .faturado-nao {
            background: #f8d7da;
            color: #721c24;
        }

        .lucro-value {
            color: #28a745;
            font-weight: bold;
        }

        .lucro {
            font-weight: 600;
        }

        .lucro-positivo {
            color: #28a745;
        }

        .lucro-negativo {
            color: #dc3545;
        }

        .total-info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
        }

        @media (min-width: 1200px) {
            .total-info-grid {
                grid-template-columns: repeat(4, 1fr);
            }
        }

        .voltar-container {
            margin-bottom: 20px;
        }

        .btn-voltar {
            display: inline-flex;
            align-items: center;
            padding: 10px 20px;
            background: #6c757d;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            font-size: 14px;
            transition: background 0.2s;
        }

        .btn-voltar:hover {
            background: #5a6268;
            color: white;
            text-decoration: none;
        }

        .btn-voltar i {
            margin-right: 8px;
        }
    </style>
</head>
<body>
    <?php
    // Filtra apenas vendas faturadas
    $vendasFaturadas = array_filter($vendas, function($v) {
        return $v->faturado == 1;
    });

    // Cálculos iniciais
    $totalVendas = 0;
    $statusCounts = [1 => 0, 2 => 0, 3 => 0];
    $tipoEnvioTotals = [];
    $categoriaTotals = [];

    foreach ($vendasFaturadas as $v) {
        // Total geral
        $totalVendas += $v->total;

        // Contagem de status
        if (isset($statusCounts[$v->status])) {
            $statusCounts[$v->status]++;
        }

        // Totais por tipo de envio
        $tipo = $v->tipoEnvio ?: 'Não definido';
        if(!isset($tipoEnvioTotals[$tipo])) {
            $tipoEnvioTotals[$tipo] = ['count' => 0, 'total' => 0];
        }
        $tipoEnvioTotals[$tipo]['count']++;
        $tipoEnvioTotals[$tipo]['total'] += $v->total;

        // Totais por categoria
        $cat = $v->nome_categoria ?: 'Não definida';
        if(!isset($categoriaTotals[$cat])) {
            $categoriaTotals[$cat] = ['count' => 0, 'total' => 0];
        }
        $categoriaTotals[$cat]['count']++;
        $categoriaTotals[$cat]['total'] += $v->total;
    }
    ?>

    <div class="container">
        <div class="header">
            <h2>Relatório de Vendas</h2>
            <p>Gerado em: <?php echo date('d/m/Y H:i'); ?></p>
        </div>

        <!-- Adicionar no topo, logo após a div header -->
        <div class="voltar-container">
            <a href="<?php echo base_url('index.php/relatorios'); ?>" class="btn-voltar">
                <i class="fas fa-arrow-left"></i> Voltar para Relatórios
            </a>
        </div>

        <!-- Filtros -->
        <div class="filtros">
            <form method="get" id="filtroForm">
                <div class="filtro-item">
                    <label>Data Inicial</label>
                    <input type="date" name="dataInicial" value="<?php echo $this->input->get('dataInicial'); ?>">
                </div>
                <div class="filtro-item">
                    <label>Data Final</label>
                    <input type="date" name="dataFinal" value="<?php echo $this->input->get('dataFinal'); ?>">
                </div>
                <div class="filtro-item">
                    <label>Status</label>
                    <select name="status">
                        <option value="">Todos</option>
                        <option value="1" <?php echo $this->input->get('status') == '1' ? 'selected' : ''; ?>>Aguardando</option>
                        <option value="2" <?php echo $this->input->get('status') == '2' ? 'selected' : ''; ?>>Aprovado</option>
                        <option value="3" <?php echo $this->input->get('status') == '3' ? 'selected' : ''; ?>>Finalizado</option>
                    </select>
                </div>
                <div class="filtro-item">
                    <label>Faturado</label>
                    <select name="faturado">
                        <option value="">Todos</option>
                        <option value="1" <?php echo $this->input->get('faturado') == '1' ? 'selected' : ''; ?>>Sim</option>
                        <option value="0" <?php echo $this->input->get('faturado') == '0' ? 'selected' : ''; ?>>Não</option>
                    </select>
                </div>
                <div class="filtro-item">
                    <label>Tipo de Envio</label>
                    <select name="tipoEnvio">
                        <option value="">Todos</option>
                        <option value="CARTA" <?php echo $this->input->get('tipoEnvio') == 'CARTA' ? 'selected' : ''; ?>>Carta</option>
                        <option value="SEDEX" <?php echo $this->input->get('tipoEnvio') == 'SEDEX' ? 'selected' : ''; ?>>Sedex</option>
                        <option value="SEDEX10" <?php echo $this->input->get('tipoEnvio') == 'SEDEX10' ? 'selected' : ''; ?>>Sedex 10</option>
                        <option value="JADLOG" <?php echo $this->input->get('tipoEnvio') == 'JADLOG' ? 'selected' : ''; ?>>Jadlog</option>
                        <option value="SEGURO" <?php echo $this->input->get('tipoEnvio') == 'SEGURO' ? 'selected' : ''; ?>>Seguro</option>
                    </select>
                </div>
                <div class="filtro-buttons">
                    <button type="submit" class="btn-filtrar">Aplicar Filtros</button>
                    <button type="button" class="btn-limpar" onclick="limparFiltros()">Limpar Filtros</button>
                </div>
            </form>
        </div>

        <!-- Totalizadores no Topo -->
        <div class="totalizadores-topo">
            <div class="row">
                <!-- Bloco 1: Totais Gerais -->
                <div class="col-md-12">
                    <div class="total-card destaque">
                        <div class="total-info-grid">
                            <div class="total-item">
                                <span class="total-label">Total de Vendas</span>
                                <h3 class="total-value"><?php echo count($vendas); ?></h3>
                            </div>
                            <div class="total-item">
                                <span class="total-label">Valor Total</span>
                                <h3 class="total-value">R$ <?php echo number_format($totalVendas, 2, ',', '.'); ?></h3>
                            </div>
                            <div class="total-item">
                                <span class="total-label">Lucro Total</span>
                                <h3 class="total-value lucro-value">R$ <?php 
                                    $lucroTotal = array_sum(array_column($vendas, 'lucro'));
                                    echo number_format($lucroTotal, 2, ',', '.'); 
                                ?></h3>
                            </div>
                            <div class="total-item">
                                <span class="total-label">Média por Venda</span>
                                <h3 class="total-value">R$ <?php echo number_format(($totalVendas/max(count($vendas), 1)), 2, ',', '.'); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt-4">
                <!-- Bloco 2: Status -->
                <div class="col-md-4">
                    <div class="total-card">
                        <div class="total-info">
                            <span class="total-label">Por Status</span>
                            <div class="status-counts">
                                <?php 
                                if($statusCounts[1] > 0) echo "<span class='status status-aguardando'>Aguardando: {$statusCounts[1]}</span>";
                                if($statusCounts[2] > 0) echo "<span class='status status-aprovado'>Aprovado: {$statusCounts[2]}</span>";
                                if($statusCounts[3] > 0) echo "<span class='status status-finalizado'>Finalizado: {$statusCounts[3]}</span>";
                                ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Bloco 3: Tipo de Envio -->
                <div class="col-md-4">
                    <div class="total-card">
                        <div class="total-info">
                            <span class="total-label">Por Tipo de Envio</span>
                            <div class="detail-list">
                                <?php
                                foreach($tipoEnvioTotals as $tipo => $info) {
                                    echo "<div class='detail-item'>";
                                    echo "<span class='detail-label'>$tipo</span>";
                                    echo "<span class='detail-count'>{$info['count']} - R$ " . number_format($info['total'], 2, ',', '.') . "</span>";
                                    echo "</div>";
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Bloco 4: Categorias -->
                <div class="col-md-4">
                    <div class="total-card">
                        <div class="total-info">
                            <span class="total-label">Por Categoria</span>
                            <div class="detail-list">
                                <?php
                                foreach($categoriaTotals as $cat => $info) {
                                    echo "<div class='detail-item'>";
                                    echo "<span class='detail-label'>$cat</span>";
                                    echo "<span class='detail-count'>{$info['count']} - R$ " . number_format($info['total'], 2, ',', '.') . "</span>";
                                    echo "</div>";
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
                      </div>

        <!-- Tabela de Vendas -->
        <table class="table mt-4">
                      <thead>
                          <tr>
                    <th>ID</th>
                    <th>Cliente</th>
                    <th>Valor Total</th>
                    <th>Lucro</th>
                    <th>Data</th>
                    <th>Vendedor</th>
                    <th>Permissão</th>
                    <th>Estoque</th>
                    <th>Tipo Envio</th>
                    <th>Status</th>
                    <th>Faturado</th>
                          </tr>
                      </thead>
                      <tbody>
                          <?php
                foreach ($vendasFaturadas as $v) {
                    $statusClass = '';
                    $status = '';
                    switch($v->status){
                        case 1: 
                            $status = 'Aguardando'; 
                            $statusClass = 'status-aguardando';
                            break;
                        case 2: 
                            $status = 'Aprovado'; 
                            $statusClass = 'status-aprovado';
                            break;
                        case 3: 
                            $status = 'Finalizado'; 
                            $statusClass = 'status-finalizado';
                            break;
                        default: 
                            $status = 'N/D'; 
                            break;
                    }

                              echo '<tr>';
                    echo '<td>#' . str_pad($v->idVendas, 4, '0', STR_PAD_LEFT) . '</td>';
                    echo '<td>' . $v->cliente . '</td>';
                    echo '<td class="valor">R$ ' . number_format($v->total, 2, ',', '.') . '</td>';
                    echo '<td class="lucro ' . ($v->lucro >= 0 ? 'lucro-positivo' : 'lucro-negativo') . '">
                        R$ ' . number_format($v->lucro, 2, ',', '.') . '
                    </td>';
                    echo '<td>' . $v->data_venda . '</td>';
                    echo '<td>
                        <a href="' . base_url('index.php/relatorios/vendedor?vendedor=' . $v->usuarios_id) . '" target="_blank">
                            ' . $v->vendedor . '
                        </a>
                    </td>';
                    echo '<td>' . $v->permissao . '</td>';
                    echo '<td>' . $v->nome_categoria . '</td>';
                    echo '<td>' . $v->tipoEnvio . '</td>';
                    echo '<td><span class="status ' . $statusClass . '">' . $status . '</span></td>';
                    echo '<td>
                        <span class="faturado-badge ' . ($v->faturado == 1 ? 'faturado-sim' : 'faturado-nao') . '">
                            ' . ($v->faturado == 1 ? 'Sim' : 'Não') . '
                        </span>
                    </td>';
                              echo '</tr>';
                          }
                          ?>
                      </tbody>
                  </table>

        <div class="footer">
            <p>Este relatório é confidencial e contém informações privilegiadas.</p>
            <p><small>* Apenas vendas faturadas são exibidas neste relatório</small></p>
      </div>
</div>

    <script>
    function limparFiltros() {
        document.querySelectorAll('#filtroForm select, #filtroForm input').forEach(element => {
            element.value = '';
        });
        document.getElementById('filtroForm').submit();
    }

    // Mantém os filtros após recarregar a página
    document.addEventListener('DOMContentLoaded', function() {
        const urlParams = new URLSearchParams(window.location.search);
        urlParams.forEach((value, key) => {
            const element = document.querySelector(`[name="${key}"]`);
            if (element) element.value = value;
        });
    });
    </script>
  </body>
</html>







