<!DOCTYPE html>
<html>
<head>
    <title>Relatório de Vendedor</title>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <style>
        body {
            font-family: 'Helvetica', Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background: #f8f9fa;
            color: #333;
        }
        
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            max-width: 1200px;
            margin: 0 auto;
        }

        .header {
            background: #2D335B;
            color: white;
            padding: 30px;
            border-radius: 8px;
            margin-bottom: 30px;
            position: relative;
            overflow: hidden;
        }

        .header::after {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            bottom: 0;
            width: 30%;
            background: linear-gradient(135deg, transparent, rgba(255,255,255,0.1));
        }

        .header h2 {
            margin: 0;
            font-size: 28px;
            font-weight: 600;
        }

        .header p {
            margin: 5px 0 0;
            opacity: 0.8;
        }

        .vendedor-info {
            margin-top: 15px;
            padding-top: 15px;
            border-top: 1px solid rgba(255,255,255,0.2);
        }

        .vendedor-info span {
            display: inline-block;
            margin-right: 20px;
            font-size: 14px;
        }

        .filtros {
            background: white;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
            border: 1px solid #e9ecef;
        }

        .filtros form {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            align-items: end;
        }

        .filtro-item {
            margin-bottom: 0;
        }

        .filtro-item label {
            display: block;
            margin-bottom: 8px;
            color: #495057;
            font-weight: 500;
            font-size: 14px;
        }

        .filtro-item select, 
        .filtro-item input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ced4da;
            border-radius: 6px;
            font-size: 14px;
            transition: border-color 0.2s;
        }

        .filtro-item select:focus, 
        .filtro-item input:focus {
            border-color: #2D335B;
            outline: none;
        }

        .filtro-buttons {
            display: flex;
            gap: 10px;
        }

        .btn-filtrar {
            background: #2D335B;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 6px;
            cursor: pointer;
            transition: background 0.2s;
            flex: 1;
        }

        .btn-limpar {
            background: #6c757d;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 6px;
            cursor: pointer;
            transition: background 0.2s;
        }

        .btn-filtrar:hover {
            background: #373d6d;
        }

        .btn-limpar:hover {
            background: #5a6268;
        }

        .total-card {
            background: white;
            border-radius: 8px;
            padding: 25px;
            margin-bottom: 30px;
            border: 1px solid #e9ecef;
            transition: transform 0.2s;
        }

        .total-card:hover {
            transform: translateY(-2px);
        }

        .total-card.destaque {
            background: linear-gradient(135deg, #2D335B, #373d6d);
            color: white;
            border: none;
        }

        .total-info-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 30px;
        }

        .total-item {
            text-align: center;
        }

        .total-label {
            display: block;
            margin-bottom: 10px;
            font-size: 14px;
            color: inherit;
            opacity: 0.8;
        }

        .total-value {
            font-size: 28px;
            font-weight: 600;
            margin: 0;
            color: inherit;
        }

        .table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
            margin-top: 30px;
        }

        .table th {
            background: #f8f9fa;
            color: #495057;
            font-weight: 600;
            padding: 15px;
            text-align: left;
            font-size: 14px;
            border-bottom: 2px solid #e9ecef;
        }

        .table td {
            padding: 15px;
            border-bottom: 1px solid #e9ecef;
            font-size: 14px;
            vertical-align: middle;
        }

        .table tbody tr:hover {
            background-color: #f8f9fa;
        }

        .status, .faturado-badge {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
            display: inline-block;
        }

        .status-aguardando {
            background: #fff3cd;
            color: #856404;
        }

        .status-aprovado {
            background: #d4edda;
            color: #155724;
        }

        .status-finalizado {
            background: #cce5ff;
            color: #004085;
        }

        .faturado-sim {
            background: #d4edda;
            color: #155724;
        }

        .faturado-nao {
            background: #f8d7da;
            color: #721c24;
        }

        .lucro-positivo {
            color: #28a745;
            font-weight: 600;
        }

        .lucro-negativo {
            color: #dc3545;
            font-weight: 600;
        }

        .valor {
            font-weight: 600;
            color: #2D335B;
        }

        @media (max-width: 768px) {
            .total-info-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .filtros form {
                grid-template-columns: 1fr;
            }
        }

        .voltar-container {
            margin-bottom: 20px;
        }

        .btn-voltar {
            display: inline-flex;
            align-items: center;
            padding: 10px 20px;
            background: #6c757d;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            font-size: 14px;
            transition: background 0.2s;
            border: none;
            cursor: pointer;
        }

        .btn-voltar:hover {
            background: #5a6268;
            color: white;
            text-decoration: none;
        }

        .btn-voltar i {
            margin-right: 8px;
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Relatório de Vendedor</h2>
            <div class="vendedor-info">
                <span><strong>Vendedor:</strong> <?php echo $vendedor->nome; ?></span>
                <span><strong>Permissão:</strong> <?php 
                    // Verifica se existe permissão antes de exibir
                    echo isset($vendas[0]->permissao_nome) ? $vendas[0]->permissao_nome : 'N/D'; 
                ?></span>
                <span><strong>Data:</strong> <?php echo date('d/m/Y H:i'); ?></span>
            </div>
        </div>

        <!-- Adicionar logo após a div header -->
        <div class="voltar-container">
            <a href="<?php echo base_url('index.php/relatorios'); ?>" class="btn-voltar">
                <i class="fas fa-arrow-left"></i> Voltar para Relatórios
            </a>
        </div>

        <!-- Filtros -->
        <div class="filtros">
            <form method="get" id="filtroForm">
                <input type="hidden" name="vendedor" value="<?php echo $vendedor->idUsuarios; ?>">
                <div class="filtro-item">
                    <label>Data Inicial</label>
                    <input type="date" name="dataInicial" value="<?php echo $this->input->get('dataInicial'); ?>">
                </div>
                <div class="filtro-item">
                    <label>Data Final</label>
                    <input type="date" name="dataFinal" value="<?php echo $this->input->get('dataFinal'); ?>">
                </div>
                <div class="filtro-item">
                    <label>Status</label>
                    <select name="status">
                        <option value="">Todos</option>
                        <option value="1">Aguardando</option>
                        <option value="2">Aprovado</option>
                        <option value="3">Finalizado</option>
                    </select>
                </div>
                <div class="filtro-item">
                    <label>Faturado</label>
                    <select name="faturado">
                        <option value="">Todos</option>
                        <option value="1">Sim</option>
                        <option value="0">Não</option>
                    </select>
                </div>
                <div class="filtro-buttons">
                    <button type="submit" class="btn-filtrar">Aplicar Filtros</button>
                    <button type="button" class="btn-limpar" onclick="limparFiltros()">Limpar Filtros</button>
                </div>
            </form>
        </div>

        <!-- Totalizadores -->
        <div class="total-card destaque">
            <div class="total-info-grid">
                <div class="total-item">
                    <span class="total-label">Total de Vendas</span>
                    <h3 class="total-value"><?php echo count($vendas); ?></h3>
                </div>
                <div class="total-item">
                    <span class="total-label">Valor Total</span>
                    <h3 class="total-value">R$ <?php 
                        $totalVendas = array_sum(array_column($vendas, 'total'));
                        echo number_format($totalVendas, 2, ',', '.'); 
                    ?></h3>
                </div>
                <div class="total-item">
                    <span class="total-label">Lucro Total</span>
                    <h3 class="total-value lucro-value">R$ <?php 
                        $lucroTotal = array_sum(array_column($vendas, 'lucro'));
                        echo number_format($lucroTotal, 2, ',', '.'); 
                    ?></h3>
                </div>
                <div class="total-item">
                    <span class="total-label">Média por Venda</span>
                    <h3 class="total-value">R$ <?php 
                        echo number_format($totalVendas/max(count($vendas), 1), 2, ',', '.'); 
                    ?></h3>
                </div>
            </div>
        </div>

        <!-- Tabela de Vendas -->
        <table class="table mt-4">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Cliente</th>
                    <th>Valor Total</th>
                    <th>Lucro</th>
                    <th>Data</th>
                    <th>Status</th>
                    <th>Faturado</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($vendas as $v): ?>
                    <tr>
                        <td>#<?php echo str_pad($v->idVendas, 4, '0', STR_PAD_LEFT); ?></td>
                        <td><?php echo $v->cliente; ?></td>
                        <td class="valor">R$ <?php echo number_format($v->total, 2, ',', '.'); ?></td>
                        <td class="lucro <?php echo $v->lucro >= 0 ? 'lucro-positivo' : 'lucro-negativo'; ?>">
                            R$ <?php echo number_format($v->lucro, 2, ',', '.'); ?>
                        </td>
                        <td><?php echo $v->data_venda; ?></td>
                        <td>
                            <span class="status status-<?php echo strtolower($v->status); ?>">
                                <?php 
                                switch($v->status){
                                    case 1: echo 'Aguardando'; break;
                                    case 2: echo 'Aprovado'; break;
                                    case 3: echo 'Finalizado'; break;
                                    default: echo 'N/D'; break;
                                }
                                ?>
                            </span>
                        </td>
                        <td>
                            <span class="faturado-badge <?php echo $v->faturado == 1 ? 'faturado-sim' : 'faturado-nao'; ?>">
                                <?php echo $v->faturado == 1 ? 'Sim' : 'Não'; ?>
                            </span>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <script>
    function limparFiltros() {
        const vendedorId = document.querySelector('input[name="vendedor"]').value;
        document.querySelectorAll('#filtroForm select, #filtroForm input[type="date"]').forEach(element => {
            element.value = '';
        });
        document.querySelector('input[name="vendedor"]').value = vendedorId;
        document.getElementById('filtroForm').submit();
    }

    document.addEventListener('DOMContentLoaded', function() {
        const urlParams = new URLSearchParams(window.location.search);
        urlParams.forEach((value, key) => {
            const element = document.querySelector(`[name="${key}"]`);
            if (element) element.value = value;
        });
    });
    </script>
</body>
</html> 