<div class="row-fluid" style="margin-top:0">
    <div class="span12">
        <div class="widget-box">
            <div class="widget-title">
                <span class="icon">
                    <i class="icon-user"></i>
                </span>
                <h5>Cadastro de Tarefa</h5>
            </div>
            <div class="widget-content nopadding">
                <?php if ($custom_error != '') {
                    echo '<div class="alert alert-danger">' . $custom_error . '</div>';
                } ?>
                <form action="<?php echo current_url(); ?>" id="formTarefa" method="post" class="form-horizontal">
                    <div class="control-group">
                        <label for="titulo" class="control-label">Título<span class="required">*</span></label>
                        <div class="controls">
                            <input id="titulo" type="text" name="titulo"
                                   value="<?php echo set_value('titulo'); ?>"/>
                        </div>
                    </div>
                    <div class="control-group">
                        <label for="descricao" class="control-label">Descrição<span class="required">*</span></label>
                        <div class="controls">
                            <textarea rows="8" cols="20" name="descricao"><?php echo set_value('descricao'); ?></textarea>
                        </div>
                    </div>
                    <div class="control-group">
                        <label for="usuario" class="control-label">Usuário resposável<span class="required">*</span></label>
                        <div class="controls">

                            <?php
                            if(!empty($usuarios)) {
                                echo form_dropdown('usuario', $usuarios, '');
                            }?>


                        </div>
                    </div>



                    <div class="form-actions">
                        <div class="span12">
                            <div class="span6 offset3">
                                <button type="submit" class="btn btn-success"><i class="icon-plus icon-white"></i>
                                    Adicionar
                                </button>
                                <a href="<?php echo base_url() ?>index.php/tarefas" id="" class="btn"><i
                                            class="icon-arrow-left"></i> Voltar</a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<script src="<?php echo base_url() ?>assets/js/jquery.validate.js"></script>

<script type="text/javascript">
    $(document).ready(function () {


        $('#formTarefa').validate({
            rules: {
                titulo: {required: true},
                descricao: {required: true},

            },
            messages: {
                titulo: {required: 'Campo Requerido.'},
                descricao: {required: 'Campo Requerido.'},


            },

            errorClass: "help-inline",
            errorElement: "span",
            highlight: function (element, errorClass, validClass) {
                $(element).parents('.control-group').addClass('error');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).parents('.control-group').removeClass('error');
                $(element).parents('.control-group').addClass('success');
            }
        });
    });
</script>

