

--
-- Estrutura para tabela `categorias`
--

CREATE TABLE `categorias` (
  `idCategorias` int NOT NULL,
  `categoria` varchar(80) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `cadastro` date DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `tipo` varchar(15) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `sedex` int DEFAULT NULL,
  `carta` int DEFAULT NULL,
  `pac` int DEFAULT NULL,
  `cep` varchar(15) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `jadlog` int DEFAULT NULL,
  `gratis` int DEFAULT NULL,
  `despache` int DEFAULT NULL,
  `imagemCor` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `ordem` int DEFAULT NULL,
  `envio_seguro` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Despejando dados para a tabela `categorias`
--

INSERT INTO `categorias` (`idCategorias`, `categoria`, `cadastro`, `status`, `tipo`, `sedex`, `carta`, `pac`, `cep`, `jadlog`, `gratis`, `despache`, `imagemCor`, `ordem`, `envio_seguro`) VALUES
(1, 'Estoque 1', '0000-00-00', 1, NULL, 100, 50, NULL, '01310-200', NULL, NULL, 3, 'estoque1.jpg', 2, 100),
;

-- --------------------------------------------------------

--
-- Estrutura para tabela `dividas`
--

CREATE TABLE `dividas` (
  `id` int NOT NULL,
  `data` datetime NOT NULL,
  `enviador_id` int NOT NULL,
  `recebedor_id` int NOT NULL,
  `valor` decimal(10,2) NOT NULL,
  `descricao` text COLLATE utf8mb3_unicode_ci NOT NULL,
  `tipo` enum('POSITIVO','NEGATIVO') COLLATE utf8mb3_unicode_ci NOT NULL,
  `venda_id` int DEFAULT NULL,
  `comprovante` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int NOT NULL DEFAULT '0',
  `motivo_reprovacao` text COLLATE utf8mb3_unicode_ci,
  `conta_id` int DEFAULT NULL,
  `aguardando_pag` int DEFAULT NULL,
  `ocultar_dados` int DEFAULT '0',
  `bloqueado` int DEFAULT '0',
  `manual` int DEFAULT NULL,
  `comissao` int DEFAULT NULL,
  `frete` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Despejando dados para a tabela `dividas`
--

INSERT INTO `dividas` (`id`, `data`, `enviador_id`, `recebedor_id`, `valor`, `descricao`, `tipo`, `venda_id`, `comprovante`, `status`, `motivo_reprovacao`, `conta_id`, `aguardando_pag`, `ocultar_dados`, `bloqueado`, `manual`, `comissao`, `frete`) VALUES
(4758, '2023-01-20 19:17:26', 1, 325, 275.00, 'Venda #2350 : Toalinha\n1 Zodiáco Fogo | R$325.00 cada', 'NEGATIVO', 2350, NULL, 1, NULL, NULL, NULL, 0, 0, NULL, NULL, NULL),
(4759, '2023-01-20 19:17:26', 6, 1, 50.00, 'Venda #2350 - Frete: CARTA - Valor R$50', 'NEGATIVO', 2350, NULL, 1, NULL, NULL, NULL, 0, 0, NULL, NULL, NULL);

-- --------------------------------------------------------

CREATE TABLE `produtos` (
  `idProdutos` int NOT NULL,
  `descricao` varchar(80) NOT NULL,
  `unidade` varchar(10) DEFAULT NULL,
  `precoCompra` decimal(10,2) DEFAULT NULL,
  `precoVenda` decimal(10,2) DEFAULT NULL,
  `estoque` int DEFAULT NULL,
  `estoqueMinimo` int DEFAULT NULL,
  `saida` tinyint(1) DEFAULT NULL,
  `entrada` tinyint(1) DEFAULT NULL,
  `codigoInterno` varchar(255) DEFAULT NULL,
  `codigoBarras` varchar(255) DEFAULT NULL,
  `idFornecedor` int DEFAULT NULL,
  `usuarioEnvio_id` int DEFAULT NULL,
  `taxaEnvio` decimal(10,2) DEFAULT '0.00',
  `categoriaId` int DEFAULT NULL,
  `status` int NOT NULL DEFAULT '1',
  `controleEstoque` int DEFAULT '0',
  `sigla` varchar(20) DEFAULT NULL,
  `observacao` text,
  `ordem` int DEFAULT NULL,
  `tipo_id` int DEFAULT NULL,
  `imagem` varchar(255) DEFAULT NULL,
  `imagemCatalogo` varchar(255) DEFAULT NULL,
  `nomeCatalogo` varchar(255) DEFAULT NULL,
  `descricaoCatalogo` varchar(255) DEFAULT NULL,
  `novidade` int DEFAULT NULL,
  `promocao` int DEFAULT NULL,
  `mais_vendido` int DEFAULT NULL,
  `pesado` int DEFAULT NULL,
  `create_user_id` int DEFAULT NULL,
  `link` varchar(255) DEFAULT NULL,
  `is_bot` int NOT NULL DEFAULT '0',
  `produto_confiavel` int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Despejando dados para a tabela `produtos`
--

INSERT INTO `produtos` (`idProdutos`, `descricao`, `unidade`, `precoCompra`, `precoVenda`, `estoque`, `estoqueMinimo`, `saida`, `entrada`, `codigoInterno`, `codigoBarras`, `idFornecedor`, `usuarioEnvio_id`, `taxaEnvio`, `categoriaId`, `status`, `controleEstoque`, `sigla`, `observacao`, `ordem`, `tipo_id`, `imagem`, `imagemCatalogo`, `nomeCatalogo`, `descricaoCatalogo`, `novidade`, `promocao`, `mais_vendido`, `pesado`, `create_user_id`, `link`, `is_bot`, `produto_confiavel`) VALUES
(51, 'Flor da Vida (215ug)', 'un', 225.00, 400.00, -470, 0, 0, 0, NULL, NULL, 423, 423, NULL, 1, 1, 1, 'F', 'Substância: LSD\r\nDosagem: 215ug por blotter\r\nCristal: NeedlePoint\r\nCartela com 25 blotters (doses)', 1, 4, 'https://receitasdarkblog.icu/shop/assets/imagem_produto/21-02-2025/62f2d0670d4fd72d02bb0f73afc6afab.jpg', '', 'Flor da Vida', '215ug Needlepoint', NULL, NULL, NULL, 0, NULL, '', 0, 0);
-- --------------------------------------------------------

--
-- Estrutura para tabela `tipo_produto`
--

CREATE TABLE `tipo_produto` (
  `id` int NOT NULL,
  `nome` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int NOT NULL,
  `ordem` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Despejando dados para a tabela `tipo_produto`
--

INSERT INTO `tipo_produto` (`id`, `nome`, `icone`, `status`, `ordem`) VALUES
(15, 'Seeds', '\\xF0\\x9F\\x8C\\xB3', 0, 9),

-- --------------------------------------------------------

--
-- Estrutura para tabela `user`
--

CREATE TABLE `user` (
  `id` bigint NOT NULL COMMENT 'Unique user identifier',
  `is_bot` tinyint(1) DEFAULT '0' COMMENT 'True if this user is a bot',
  `first_name` char(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '' COMMENT 'User''s first name',
  `last_name` char(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'User''s last name',
  `username` char(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'User''s username',
  `language_code` char(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL COMMENT 'User''s system language',
  `created_at` timestamp NULL DEFAULT NULL COMMENT 'Entry date creation',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Entry date update'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `usuarios`
--

CREATE TABLE `usuarios` (
  `idUsuarios` int NOT NULL,
  `nome` varchar(80) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `senha` varchar(200) DEFAULT NULL,
  `celular` varchar(20) DEFAULT NULL,
  `situacao` tinyint(1) NOT NULL,
  `dataCadastro` date NOT NULL,
  `permissoes_id` int NOT NULL,
  `chat_id` bigint DEFAULT NULL,
  `usuario_representante_id` int DEFAULT '1',
  `controle_completo` int NOT NULL DEFAULT '0',
  `dividas` int NOT NULL DEFAULT '0',
  `enviador` int DEFAULT '0',
  `saldo` varchar(45) DEFAULT NULL,
  `bloqueado` int DEFAULT '0',
  `user_telegram` varchar(255) DEFAULT NULL,
  `fornecedor` int NOT NULL DEFAULT '0',
  `usuario_indicador_id` int DEFAULT NULL,
  `revendedor` int DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Despejando dados para a tabela `usuarios`
--

INSERT INTO `usuarios` (`idUsuarios`, `nome`, `email`, `senha`, `celular`, `situacao`, `dataCadastro`, `permissoes_id`, `chat_id`, `usuario_representante_id`, `controle_completo`, `dividas`, `enviador`, `saldo`, `bloqueado`, `user_telegram`, `fornecedor`, `usuario_indicador_id`, `revendedor`) VALUES
(1, 'Chico', 'chico', '69305cc9dd7a3a538ebfc8aceeb91bc0bc52468a7e33f76a985f2d22424dd8ee12cd33c707c8cb148ee39785f282afa7d5022f1e13afd9d3bf832bc5f0787a5czzmY77KFbct+l+aHxGBszdxuUpKy01FPTjSbqfeKyIs=', '', 1, '2013-11-22', 1, 889423113, NULL, 0, 1, 1, NULL, 0, '', 1, NULL, NULL),
(78, 'Cleyson', NULL, NULL, NULL, 1, '2022-04-26', 6, 1077494228, 1, 0, 0, 0, NULL, 0, '', 0, 1, NULL);


-- --------------------------------------------------------

--
-- Estrutura para tabela `usuario_valor`
--

CREATE TABLE `usuario_valor` (
  `id` int NOT NULL,
  `de` int DEFAULT '1',
  `ate` int DEFAULT '1000',
  `usuario_id` int NOT NULL,
  `produto_id` int NOT NULL,
  `valor` double(8,2) NOT NULL,
  `quantidade_vendido` int NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

-- IMPORANTE! ESSA TABELA ESTA COM A COLUNA usuario_id COM O NOME ERRADO. DEVERIA SER permissao_id.
NÃO PRECISA ALTERAR POREM SAIBA QUE NESSA TABELA A REFERENCIA A TABELA DE PERMISSOES
-- Despejando dados para a tabela `usuario_valor`
--

INSERT INTO `usuario_valor` (`id`, `de`, `ate`, `usuario_id`, `produto_id`, `valor`, `quantidade_vendido`) VALUES
(7, 1, 1000, 6, 132, 30.00, 0),
(8, 1, 1000, 5, 132, 25.00, 0)
-- --------------------------------------------------------

--
-- Estrutura para tabela `vendas`
--

CREATE TABLE `vendas` (
  `idVendas` int NOT NULL,
  `dataVenda` date DEFAULT NULL,
  `valorTotal` varchar(45) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `valorCusto` varchar(45) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `faturado` tinyint(1) DEFAULT NULL,
  `clientes_id` int NOT NULL,
  `usuarios_id` int DEFAULT NULL,
  `lancamentos_id` int DEFAULT NULL,
  `desconto` varchar(45) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `tipoEnvio` enum('CARTA','SEDEX','SEDEX10','JADLOG','SEGURO') COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `enviador_id` int NOT NULL,
  `observacoes` text COLLATE utf8mb3_unicode_ci NOT NULL,
  `dadosEnvio` text COLLATE utf8mb3_unicode_ci NOT NULL,
  `rastreioDigitado` varchar(255) COLLATE utf8mb3_unicode_ci NOT NULL,
  `imagem_sro` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `status` int NOT NULL DEFAULT '1' COMMENT '0 - nada| 1 -pronto para despache | 2 - enviado correios | 3 - enviado cliente',
  `imagem_comprovante` varchar(255) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `cep` varchar(10) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `taxa_envio` int DEFAULT NULL,
  `motivo_reprovacao` text COLLATE utf8mb3_unicode_ci,
  `idAnexos` int NOT NULL,
  `dadosEditar` text COLLATE utf8mb3_unicode_ci,
  `categoria_id` int DEFAULT NULL,
  `ocultar_dados` int DEFAULT '0',
  `data_envio` datetime DEFAULT NULL,
  `data_aprovacao` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

--
-- Despejando dados para a tabela `vendas`
--
CREATE TABLE `itens_de_vendas` (
  `idItens` int NOT NULL,
  `subTotal` varchar(45) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `quantidade` int DEFAULT NULL,
  `vendas_id` int NOT NULL,
  `produtos_id` int NOT NULL,
  `valorUnidade` varchar(45) COLLATE utf8mb3_unicode_ci DEFAULT NULL,
  `totalCusto` varchar(45) COLLATE utf8mb3_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;


INSERT INTO `vendas` (`idVendas`, `dataVenda`, `valorTotal`, `valorCusto`, `faturado`, `clientes_id`, `usuarios_id`, `lancamentos_id`, `desconto`, `tipoEnvio`, `enviador_id`, `observacoes`, `dadosEnvio`, `rastreioDigitado`, `imagem_sro`, `status`, `imagem_comprovante`, `cep`, `taxa_envio`, `motivo_reprovacao`, `idAnexos`, `dadosEditar`, `categoria_id`, `ocultar_dados`, `data_envio`, `data_aprovacao`) VALUES
(1343, '2022-09-08', '6800', NULL, 1, 1, 16, NULL, '0', 'SEDEX', 1, '', 'Nome: Fabricio La Cruz Pacheco \nEndereço: RUA DOM GIOCONDO MARIA GROTTE\nNúmero: 230\nComplemento: Posta restante pedida\nBairro: Centro\nCidade: Assis Brasil\nEstado: Acre\nCep: 69935-959\nProduto:\n\nEstoque 1\n- Tubo x 2\n- The vision x 20\n- Juggler x 6\n- Flor da vida x 6\n- Lisergin x 1\n\n\n\nSedex ou Carta: Sedex', '', 'https://twyiart.tech/maektassets/sro/photos/2022093047.jpg', 3, NULL, '69935-959', 100, NULL, 0, NULL, 1, 0, '2022-09-08 00:00:00', '2022-09-08 00:00:00'),
(6730, '2025-03-26', '2410', NULL, 1, 1, 318, NULL, '0', 'SEDEX', 502, '', 'Nome: Ludmila Karina Jacinto \nCPF: 07378894621\nEndereço: Antônio Jardim\nNúmero: 228\nComplemento: A\nBairro: Rosário \nCidade: Nova Lima\nEstado: MG\nCep: 34000-372', '', NULL, 2, NULL, '34000-372', 250, NULL, 0, NULL, 17, 0, NULL, '2025-03-26 18:57:52'),
(6731, '2025-03-26', '1300', NULL, 1, 1, 1059, NULL, '0', 'SEDEX', 544, '', 'Informe aqui os dados de envio no seguinte padrão:\n\nNome: André Luiz Pelluzi Brandão Silva\nEndereço: Praça Ministro Gabriel Passos\nNúmero: 154\nComplemento: \nBairro: Centro\nCidade: São Tiago\nEstado: Minas Gerais\nCep: 36350-000', '', NULL, 2, NULL, '36350-000', 100, NULL, 0, NULL, 13, 0, NULL, '2025-03-26 18:58:13'),
(6732, '2025-03-26', NULL, NULL, 0, 1, 1057, NULL, '0', NULL, 0, '', '', '', NULL, 1, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, NULL);

