-- MySQL Script generated by MySQL Workbench
-- Sat Dec  9 00:21:54 2023
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION';

-- -----------------------------------------------------
-- Schema mydb
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Schema mydb
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `mydb` DEFAULT CHARACTER SET utf8 ;
USE `mydb` ;

-- -----------------------------------------------------
-- Table `mydb`.`estoque`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`estoque` (
  `id` VARCHAR(255) NOT NULL,
  `nome` VARCHAR(255) NOT NULL,
  `created_at` DATETIME NOT NULL,
  `status` ENUM('ATIVO', 'INATIVO') NOT NULL,
  `cep` VARCHAR(15) NOT NULL,
  `ordem` INT(11) NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`permissao`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`permissao` (
  `id` INT(11) NOT NULL,
  `nome` VARCHAR(255) NOT NULL,
  `compra_ativa` INT(11) NOT NULL DEFAULT 0,
  `ordem` INT(11) NULL DEFAULT 0,
  `avatar` VARCHAR(255) NULL DEFAULT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`usuario`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`usuario` (
  `id` VARCHAR(255) NOT NULL,
  `nome` VARCHAR(80) NOT NULL,
  `data_cadastro` DATE NOT NULL,
  `permissoes_id` VARCHAR(255) NOT NULL,
  `chat_id` BIGINT(20) NULL,
  `usuario_telegram` VARCHAR(255) NULL DEFAULT NULL,
  `usuario_indicador_id` INT(11) NULL DEFAULT NULL,
  `username` VARCHAR(45) NULL,
  `is_enviador` INT(11) NOT NULL DEFAULT 0,
  `is_bloqueado` INT(11) NOT NULL DEFAULT 0,
  `is_fornecedor` INT(11) NOT NULL DEFAULT 0,
  `is_revendedor` INT(11) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_usuarios_permissoes1_idx` (`permissoes_id` ASC) VISIBLE,
  CONSTRAINT `fk_usuarios_permissoes1`
    FOREIGN KEY (`permissoes_id`)
    REFERENCES `mydb`.`permissao` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `mydb`.`conta`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`conta` (
  `idContas` VARCHAR(255) NOT NULL,
  `nome` VARCHAR(255) NULL DEFAULT NULL,
  `conta` TEXT NULL DEFAULT NULL,
  `cadastro` DATE NULL,
  `tipo` VARCHAR(80) NULL DEFAULT NULL,
  `status` TINYINT(1) NULL DEFAULT NULL,
  `confianca` INT(11) NULL DEFAULT 0,
  `prioridade` VARCHAR(255) NULL DEFAULT 0,
  `usuario_id` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`idContas`),
  INDEX `fk_contas_usuario1_idx` (`usuario_id` ASC) VISIBLE,
  CONSTRAINT `fk_contas_usuario1`
    FOREIGN KEY (`usuario_id`)
    REFERENCES `mydb`.`usuario` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`pedido`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`pedido` (
  `id` VARCHAR(255) NOT NULL,
  `data` DATETIME NULL,
  `valor` VARCHAR(45) NULL,
  `valor_custo` VARCHAR(45) NULL,
  `observacao` VARCHAR(45) NULL,
  `dados_envio` VARCHAR(45) NULL,
  `cep` VARCHAR(45) NULL,
  `taxa_envio` VARCHAR(45) NULL,
  `pedido_envio_id` VARCHAR(255) NOT NULL,
  `forma_envio_id` VARCHAR(255) NOT NULL,
  `usuario_id` VARCHAR(255) NOT NULL,
  `estoque_id` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_pedido_pedido_envio1_idx` (`pedido_envio_id` ASC) VISIBLE,
  INDEX `fk_pedido_forma_envio1_idx` (`forma_envio_id` ASC) VISIBLE,
  INDEX `fk_pedido_usuario3_idx` (`usuario_id` ASC) VISIBLE,
  INDEX `fk_pedido_estoque2_idx` (`estoque_id` ASC) VISIBLE,
  CONSTRAINT `fk_pedido_pedido_envio1`
    FOREIGN KEY (`pedido_envio_id`)
    REFERENCES `mydb`.`pedido_envio` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_pedido_forma_envio1`
    FOREIGN KEY (`forma_envio_id`)
    REFERENCES `mydb`.`forma_envio` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_pedido_usuario3`
    FOREIGN KEY (`usuario_id`)
    REFERENCES `mydb`.`usuario` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_pedido_estoque2`
    FOREIGN KEY (`estoque_id`)
    REFERENCES `mydb`.`estoque` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`pagamento`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`pagamento` (
  `id` INT(11) NOT NULL,
  `data_criacao` DATETIME NOT NULL,
  `valor` DECIMAL(10,2) NOT NULL,
  `descricao` TEXT NOT NULL,
  `comprovante` VARCHAR(255) NULL DEFAULT NULL,
  `status` INT(11) NOT NULL DEFAULT 0,
  `is_manual` INT(11) NULL DEFAULT NULL,
  `is_comissao` INT(11) NULL DEFAULT NULL,
  `is_frete` INT(11) NULL DEFAULT NULL,
  `usuario_id` INT(11) NOT NULL,
  `conta_id` INT(11) NULL,
  `pedido_id` INT(11) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_pagamento_usuario1_idx` (`usuario_id` ASC) VISIBLE,
  INDEX `fk_pagamento_conta1_idx` (`conta_id` ASC) VISIBLE,
  INDEX `fk_pagamento_pedido1_idx` (`pedido_id` ASC) VISIBLE,
  CONSTRAINT `fk_pagamento_usuario1`
    FOREIGN KEY (`usuario_id`)
    REFERENCES `mydb`.`usuario` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_pagamento_conta1`
    FOREIGN KEY (`conta_id`)
    REFERENCES `mydb`.`conta` (`idContas`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_pagamento_pedido1`
    FOREIGN KEY (`pedido_id`)
    REFERENCES `mydb`.`pedido` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`produto`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`produto` (
  `id` VARCHAR(255) NOT NULL,
  `nome` VARCHAR(255) NOT NULL,
  `data_criacao` DATETIME NULL,
  `link_canal` VARCHAR(255) NULL DEFAULT NULL,
  `descricao` TEXT NULL,
  `unidade` VARCHAR(3) NULL DEFAULT NULL,
  `quantidade_vendas` INT(11) NULL DEFAULT NULL,
  `imagem` VARCHAR(255) NULL DEFAULT NULL,
  `nome_catalogo` VARCHAR(255) NULL DEFAULT NULL,
  `subtitulo_catalogo` VARCHAR(255) NULL DEFAULT NULL,
  `novidade` INT(11) NULL DEFAULT NULL,
  `promocao` INT(11) NULL DEFAULT NULL,
  `mais_vendido` INT(11) NULL DEFAULT NULL,
  `is_pesado` INT(11) NULL DEFAULT NULL,
  `ordem` INT(11) NULL DEFAULT NULL,
  `status` INT(11) NOT NULL DEFAULT 1,
  `enviador_id` VARCHAR(255) NOT NULL,
  `fornecedor_id` VARCHAR(255) NOT NULL,
  `estoque_id` VARCHAR(255) NOT NULL,
  `usuario_criador_id` VARCHAR(255) NOT NULL,
  `adicional_envio` DOUBLE(8,2) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_produtos_usuarios1_idx` (`enviador_id` ASC) VISIBLE,
  INDEX `fk_produtos_usuario1_idx` (`fornecedor_id` ASC) VISIBLE,
  INDEX `fk_produtos_estoque1_idx` (`estoque_id` ASC) VISIBLE,
  INDEX `fk_produtos_usuario2_idx` (`usuario_criador_id` ASC) VISIBLE)
ENGINE = FEDERATED
DEFAULT CHARACTER SET = latin1;


-- -----------------------------------------------------
-- Table `mydb`.`pedido_envio`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`pedido_envio` (
  `id` VARCHAR(255) NOT NULL,
  `rastreio` VARCHAR(255) NOT NULL,
  `tipo_rastreio` ENUM('IMAGEM', 'TEXTO') NOT NULL,
  `data_hora` DATETIME NOT NULL,
  `pedido_id` INT(11) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_pedido_envio_pedido1_idx` (`pedido_id` ASC) VISIBLE,
  CONSTRAINT `fk_pedido_envio_pedido1`
    FOREIGN KEY (`pedido_id`)
    REFERENCES `mydb`.`pedido` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`forma_envio`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`forma_envio` (
  `id` VARCHAR(255) NOT NULL,
  `nome` VARCHAR(255) NULL,
  `status` INT NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`pedido`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`pedido` (
  `id` VARCHAR(255) NOT NULL,
  `data` DATETIME NULL,
  `valor` VARCHAR(45) NULL,
  `valor_custo` VARCHAR(45) NULL,
  `observacao` VARCHAR(45) NULL,
  `dados_envio` VARCHAR(45) NULL,
  `cep` VARCHAR(45) NULL,
  `taxa_envio` VARCHAR(45) NULL,
  `pedido_envio_id` VARCHAR(255) NOT NULL,
  `forma_envio_id` VARCHAR(255) NOT NULL,
  `usuario_id` VARCHAR(255) NOT NULL,
  `estoque_id` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_pedido_pedido_envio1_idx` (`pedido_envio_id` ASC) VISIBLE,
  INDEX `fk_pedido_forma_envio1_idx` (`forma_envio_id` ASC) VISIBLE,
  INDEX `fk_pedido_usuario3_idx` (`usuario_id` ASC) VISIBLE,
  INDEX `fk_pedido_estoque2_idx` (`estoque_id` ASC) VISIBLE,
  CONSTRAINT `fk_pedido_pedido_envio1`
    FOREIGN KEY (`pedido_envio_id`)
    REFERENCES `mydb`.`pedido_envio` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_pedido_forma_envio1`
    FOREIGN KEY (`forma_envio_id`)
    REFERENCES `mydb`.`forma_envio` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_pedido_usuario3`
    FOREIGN KEY (`usuario_id`)
    REFERENCES `mydb`.`usuario` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_pedido_estoque2`
    FOREIGN KEY (`estoque_id`)
    REFERENCES `mydb`.`estoque` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`item_pedido`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`item_pedido` (
  `id` VARCHAR(255) NOT NULL,
  `pedido_id` VARCHAR(255) NOT NULL,
  `produto_id` VARCHAR(255) NOT NULL,
  `quantidade` INT(11) NULL DEFAULT NULL,
  `valor_unidade` DOUBLE(11,2) NULL DEFAULT NULL,
  `sub_total` DOUBLE(11,2) NULL DEFAULT NULL,
  `custo_sub_total` DOUBLE(11,2) NULL DEFAULT NULL,
  `custo_unidade` DOUBLE(11,2) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_itens_de_vendas_produtos1` (`produto_id` ASC) VISIBLE,
  INDEX `fk_item_pedido_pedido1_idx` (`pedido_id` ASC) VISIBLE,
  CONSTRAINT `fk_itens_de_vendas_produtos1`
    FOREIGN KEY (`produto_id`)
    REFERENCES `mydb`.`produto` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_item_pedido_pedido1`
    FOREIGN KEY (`pedido_id`)
    REFERENCES `mydb`.`pedido` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`reclamacao`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`reclamacao` (
  `id` VARCHAR(255) NOT NULL,
  `datahora` DATETIME NULL DEFAULT NULL,
  `tipo` VARCHAR(255) NULL DEFAULT NULL,
  `observacao` TEXT NULL DEFAULT NULL,
  `imagem` VARCHAR(255) NULL DEFAULT NULL,
  `status` INT(11) NULL DEFAULT NULL,
  `pedido_id` VARCHAR(255) NOT NULL,
  `usuario_id` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_reclamacao_pedido1_idx` (`pedido_id` ASC) VISIBLE,
  INDEX `fk_reclamacao_usuario1_idx` (`usuario_id` ASC) VISIBLE,
  CONSTRAINT `fk_reclamacao_pedido1`
    FOREIGN KEY (`pedido_id`)
    REFERENCES `mydb`.`pedido` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_reclamacao_usuario1`
    FOREIGN KEY (`usuario_id`)
    REFERENCES `mydb`.`usuario` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `mydb`.`categoria`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`categoria` (
  `id` VARCHAR(255) NOT NULL,
  `nome` VARCHAR(255) NULL DEFAULT NULL,
  `icone` VARCHAR(255) NOT NULL,
  `status` VARCHAR(255) NOT NULL,
  `ordem` VARCHAR(255) NULL DEFAULT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `mydb`.`token_cadastro`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`token_cadastro` (
  `id` VARCHAR(255) NOT NULL,
  `token` VARCHAR(255) NOT NULL,
  `status` INT(11) NOT NULL,
  `datahora_criacao` DATETIME NOT NULL,
  `usuario_criador_id` VARCHAR(255) NOT NULL,
  `recebedor_id` VARCHAR(255) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_token_cadastro_usuario1_idx` (`usuario_criador_id` ASC) VISIBLE,
  INDEX `fk_token_cadastro_usuario2_idx` (`recebedor_id` ASC) VISIBLE,
  CONSTRAINT `fk_token_cadastro_usuario1`
    FOREIGN KEY (`usuario_criador_id`)
    REFERENCES `mydb`.`usuario` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_token_cadastro_usuario2`
    FOREIGN KEY (`recebedor_id`)
    REFERENCES `mydb`.`usuario` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8mb4
COLLATE = utf8mb4_unicode_ci;


-- -----------------------------------------------------
-- Table `mydb`.`permissao_valor`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`permissao_valor` (
  `id` VARCHAR(255) NOT NULL,
  `de` INT(11) NULL DEFAULT 1,
  `ate` INT(11) NULL DEFAULT 1000,
  `valor` DOUBLE(8,2) NOT NULL,
  `produto_id` VARCHAR(255) NOT NULL,
  `permissao_id` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_permissao_valor_produtos1_idx` (`produto_id` ASC) VISIBLE,
  INDEX `fk_permissao_valor_permissao1_idx` (`permissao_id` ASC) VISIBLE,
  CONSTRAINT `fk_permissao_valor_produtos1`
    FOREIGN KEY (`produto_id`)
    REFERENCES `mydb`.`produto` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_permissao_valor_permissao1`
    FOREIGN KEY (`permissao_id`)
    REFERENCES `mydb`.`permissao` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`estoque_layout`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`estoque_layout` (
  `id` VARCHAR(255) NOT NULL,
  `imagem_topo` VARCHAR(45) NULL,
  `estoque_id` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_estoque_layout_estoque1_idx` (`estoque_id` ASC) VISIBLE,
  CONSTRAINT `fk_estoque_layout_estoque1`
    FOREIGN KEY (`estoque_id`)
    REFERENCES `mydb`.`estoque` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`avaliacao_produto`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`avaliacao_produto` (
  `id` VARCHAR(255) NOT NULL,
  `produto_id` VARCHAR(255) NOT NULL,
  `usuario_id` VARCHAR(255) NOT NULL,
  `pergunta_id` VARCHAR(255) NOT NULL,
  `nota` INT NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`avaliacao_estoque`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`avaliacao_estoque` (
  `id` VARCHAR(255) NOT NULL,
  `produto_id` VARCHAR(255) NOT NULL,
  `estoque_id` VARCHAR(255) NOT NULL,
  `pergunta_id` VARCHAR(255) NOT NULL,
  `nota` INT NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`avaliacao_pergunta`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`avaliacao_pergunta` (
  `id` VARCHAR(255) NOT NULL,
  `pergunta` TEXT NOT NULL,
  `status` INT NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`estoque_envio`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`estoque_envio` (
  `id` VARCHAR(255) NOT NULL,
  `estoque_id` VARCHAR(255) NOT NULL,
  `forma_envio_id` VARCHAR(255) NOT NULL,
  `valor` DOUBLE(11,2) NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_estoque_envio_estoque1_idx` (`estoque_id` ASC) VISIBLE,
  INDEX `fk_estoque_envio_forma_envio1_idx` (`forma_envio_id` ASC) VISIBLE,
  CONSTRAINT `fk_estoque_envio_estoque1`
    FOREIGN KEY (`estoque_id`)
    REFERENCES `mydb`.`estoque` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_estoque_envio_forma_envio1`
    FOREIGN KEY (`forma_envio_id`)
    REFERENCES `mydb`.`forma_envio` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mydb`.`produto_categoria`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `mydb`.`produto_categoria` (
  `produto_id` INT(11) NOT NULL,
  `categoria_id` INT(11) NOT NULL,
  PRIMARY KEY (`produto_id`, `categoria_id`),
  INDEX `fk_produto_has_categoria_categoria1_idx` (`categoria_id` ASC) VISIBLE,
  INDEX `fk_produto_has_categoria_produto1_idx` (`produto_id` ASC) VISIBLE)
ENGINE = FEDERATED
DEFAULT CHARACTER SET = latin1;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
