<?php
/**
 * This file is part of the TelegramBot package.
 *
 * (c) Avtandil Kikabidze aka LONGMAN <akalongman@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Longman\TelegramBot\Commands\SystemCommands;

use Longman\TelegramBot\Commands\AdminCommands\ChatsCommand;
use Longman\TelegramBot\Commands\SystemCommand;
use Longman\TelegramBot\Commands\UserCommands\UploadCommand;
use Longman\TelegramBot\Conversation;
use Longman\TelegramBot\Entities\InlineKeyboardButton;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;
use Longman\TelegramBot\DBCommands;
use Longman\TelegramBot\Entities\InlineKeyboard;
use Longman\TelegramBot\Commands\SystemCommands\GenericCommand;
use Telegram\Repository\UsuarioUtil;

class CallbackqueryCommand extends SystemCommand
{

    protected $name = 'callbackquery';
    protected $description = 'Reply to callback query';
    protected $version = '1.1.1';
    protected $need_mysql = true;
    protected $conversation;
    public $callback_query;
    public $callback_query_id;
    public $callback_method_data;

    public $chat_id;
    public $message_id;
    public $pdo;
    public $user;
    public $notes;
    public $util;

    public $inline_keyboard;

    //DECLARAÇÃO DO METODO
    public $callback_class;
    public $callback_method;
    public $callback_data;


    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {

        //Preenchendo váriaveis
        $this->callback_query = $this->getCallbackQuery();
        $this->callback_query_id = $this->callback_query->getId();
        $this->callback_data = $this->callback_query->getData();

        $callback = explode("_", $this->callback_data);

        $this->callback_class = $callback[0];
        $this->callback_method = $callback[1];


        unset($callback[0]);
        unset($callback[1]);

        $callback_data_array = $callback[2];
        $this->callback_method_data = $callback_data_array;

        $this->chat_id = $this->callback_query->getFrom()->getId();
        $this->message_id = $this->callback_query->getMessage()->getMessageId();

        $pdo = DB::getPdo();
        $this->pdo = $pdo;
        $this->pdo->setAttribute($pdo::ATTR_ERRMODE, $pdo::ERRMODE_WARNING);

        $this->conversation = new Conversation(
            $this->callback_query->getFrom()->getId(),
            $this->callback_query->getFrom()->getId(),
            $this->getName()
        );

        $this->notes = &$this->conversation->notes;
        !is_array($this->notes) && $this->notes = [];

        $lastMsgId = $this->notes['lastMsgId'];
        //Request::sendMessage(array('chat_id' => $this->chat_id, 'text' => "Exec : ".json_encode($this->callback_query)));

        if (($this->notes['msgDadosEnvioId'] != $this->message_id) or ($this->notes['msgStart'] != $this->message_id)) {
            $this->deleteMessage($this->message_id);
        }

        //$this->sendMessage($this->callback_class . $this->callback_method);
        //$this->sendMessage(json_encode($this->notes));

        //VERIFICANDO DADOS DO USUÁRIO
        $usuarioRepository = new UsuarioRepository($this->pdo);
        $this->user = $usuarioRepository->buscaUsuarioByChat($this->chat_id); 
        //$this->user = $this->UtilBuscaUsuarioByChat($this->chat_id);

        if (!empty($this->user)) {
            if ($this->user['bloqueado'] == 1) {

                $inline_keyboard = new InlineKeyboard();
                $return_text = "Seu usuário foi Bloqueado\nSeu ID é " . $this->chat_id . "\nEnvie este ID para o suporte";
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x8E\xA7 \xF0\x9F\x91\xA4 Suporte \xF0\x9F\x91\xA4 \xF0\x9F\x8E\xA7",
                    'url' => "https://t.me/MedicinasSagradas"
                ]));

                $this->sendMessage($return_text, $inline_keyboard);
            } else {
                //$this->sendMessage($this->callback_class . $this->callback_method);
                $this->{ucfirst($this->callback_class . $this->callback_method)}($this->callback_method_data);
            }


        } else {
            $text = "\xF0\x9F\x94\x92 <b>Usuário não cadastrado!</b> \xF0\x9F\x94\x92\nDigite o código de cadastro";
            $this->notes['requestData'] = "informarCodigoCadastro";
            $this->conversation->update();
            $this->sendMessage($text);
        }
        $this->conversation->update();

    }

    public function clearNotes()
    {
        $lastMsgId = $this->notes['lastMsgId'];
        $msgInicialId = $this->notes['msgInicialId'];
        unset($this->conversation->notes);
        $this->conversation->update();
        $this->conversation->stop();
        $this->conversation = new Conversation($this->chat_id, $this->chat_id, $this->getName());
        $this->notes = &$this->conversation->notes;
        !is_array($this->notes) && $this->notes = [];
        if (empty($this->notes['msgInicialId'])) {
            $this->notes['msgInicialId'] = $msgInicialId;

        }
        $this->conversation->update();
    }

    public function getMenu()
    {
        $idUsuario = $this->user['idUsuarios'];

        $user = $this->UtilBuscaUsuarioById($idUsuario);
        $idPermissao = $user['permissoes_id'];

       
        $menu = array();

        if ($idPermissao == 1) {
            $menu["MenuAdmin"] = array('text' => "\xE2\xAD\x90 Admin \xE2\xAD\x90", 'callback_data' => 'Menu_Admin');
            $menu["AdminEnviarAviso"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x93\xA2 Enviar Aviso \xF0\x9F\x93\xA2 \xE2\xAD\x90", 'callback_data' => 'Enviar_Aviso');
            
            $menu["AdminTodosControles"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x93\x96 Ver Todos Controles \xF0\x9F\x93\x96 \xE2\xAD\x90", 'callback_data' => 'Controle_DividasTodos');
            $menu["AdminUsuarios"] = array('text' => "\xF0\x9F\x93\x84 Meus pedidos \xF0\x9F\x93\x84", 'callback_data' => 'Admin_Usuarios');
            $menu["AdminListaUsuarios"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x91\xA4 Lista de usuários \xF0\x9F\x91\xA4 \xE2\xAD\x90", 'callback_data' => "Lista_Usuarios");
            $menu["AdminListarCustos"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x92\xB2 Listar todos os pedidos", 'callback_data' => 'AdminListarPedidos');
            $menu["AdminListarProdutosPendentes"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x93\xA6 Listar produtos pendentes \xF0\x9F\x93\xA6 \xE2\xAD\x90", 'callback_data' => 'AdminListarProdutosPendentes');
            $menu["AdminEstoque"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x93\x96 Estoque", 'callback_data' => 'Controle_Estoque');
            $menu["AdminListarCustos"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x92\xB2 Custos", 'callback_data' => 'Listar_Custos');
            $menu["AdminEnviarRastreio"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x93\xAB Todos pedidos aguardando SRO \xF0\x9F\x93\xAB \xE2\xAD\x90", 'callback_data' => "Enviar_RastreioAdmin");
            $menu["AdminPedidosPendentes"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x93\x84 TODOS PEDIDOS PENDENTES \xF0\x9F\x93\x84 \xE2\xAD\x90", 'callback_data' => 'Listar_PedidosPendentes_1');

        }

        $menu["CadastrarPedido"] = array('text' => "\xF0\x9F\x93\x9D Cadastrar pedido \xF0\x9F\x93\x9D", 'callback_data' => 'Venda_Cadastrar');
        $menu["MeusPedidosPendentes"] = array('text' => "\xF0\x9F\x93\x84 Meus pedidos \xF0\x9F\x93\x84", 'callback_data' => 'Escolher_TipoPedido');
        $menu["ConsultarPedido"] = array('text' => "\xF0\x9F\x93\x84 Consultar pedidos \xF0\x9F\x93\x84", 'callback_data' => 'Consultar_Pedido');

        $menu["AEmpresa"] = array('text' => "\xE2\x9D\xA4 Sobre o Night Company \xE2\x9D\xA4", 'callback_data' => 'A_Empresa');
        $menu["ControleFinanceiro"] = array('text' => "\xF0\x9F\x93\x96 Controle Financeiro \xF0\x9F\x93\x96", 'callback_data' => 'Controle_Dividas');
        $menu["InserirSaldo"] = array('text' => "\xF0\x9F\x92\xB5 Inserir saldo \xF0\x9F\x92\xB5", 'callback_data' => 'Input_ValorComprovante');

        $menu["InserirSaldoCliente"] = array('text' => "\xF0\x9F\x92\xB5 Inserir saldo \xF0\x9F\x92\xB5", 'callback_data' => 'Input_Conta');
        $menu["ConsultarProdutos"] = array('text' => "\xF0\x9F\x93\xA6 Consultar produtos \xF0\x9F\x93\xA6", 'callback_data' => 'Selciona_TipoBusca');
        $menu["EnviarRastreio"] = array('text' => "\xF0\x9F\x93\xAB Pedidos aguardando SRO \xF0\x9F\x93\xAB", 'callback_data' => "Enviar_Rastreio");

        $menu["ComprovantesPendentes"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x92\xB4 Comprovantes Pendentes \xF0\x9F\x92\xB4 \xE2\xAD\x90", 'callback_data' => "Comprovantes_Pendentes");
        $menu["PedidosAguardandoAprovacao"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x92\xB4 Pedidos Aguardando Aprovação \xF0\x9F\x92\xB4 \xE2\xAD\x90", 'callback_data' => "Pedidos_AguardandoAprovacao");
        $menu["ListarFornecedores"] = array('text' => "\xE2\xAD\x90 🏭 Listar Fornecedores 🏭 \xE2\xAD\x90", 'callback_data' => "Listar_Fornecedores");

        $menu["ListarContas"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x92\xB4 Lista de Contas \xF0\x9F\x92\xB4 \xE2\xAD\x90", 'callback_data' => "Listar_Contas");
        $menu["ConvidarAmigos"] = array('text' => "\xF0\x9F\x98\x84 Convidar Amigos \xF0\x9F\x98\x84", 'callback_data' => "Listar_Convites");

        $menu["RevendedorConvites"] = array('text' => "\xF0\x9F\x93\x91 Convidar clientes \xF0\x9F\x93\x91", 'callback_data' => "Revendedor_Convites");
        $menu["FornecedorPainel"] = array('text' => "\xF0\x9F\x8F\xA2 \xF0\x9F\x92\xB0 Painel de Fornecedor \xF0\x9F\x92\xB0 \xF0\x9F\x8F\xA2", 'callback_data' => 'Fornecedor_Painel');
        $menu["CadastrarCliente"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x94\x91 Gerar chave de cadastro	\xF0\x9F\x94\x91 \xE2\xAD\x90", 'callback_data' => 'Cadastrar_Cliente');
        //$menu["escreverAviso"] = array('text' => "\xE2\xAD\x90 \xF0\x9F\x94\x91 Escrever Aviso \xF0\x9F\x94\x91 \xE2\xAD\x90", 'callback_data' => 'Cadastrar_Cliente');
        $menu["PerguntasFrequentes"] = array('text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => "Perguntas_Frequentes");
        $menu["RevendedorPainel"] = array('text' => "\xF0\x9F\x92\xB2 Painel de Revendedor \xF0\x9F\x92\xB2", 'callback_data' => "Revendedor_Painel");


        $menu["Suporte"] = array('text' => "\xF0\x9F\x8E\xA7 \xF0\x9F\x91\xA4 Suporte \xF0\x9F\x91\xA4 \xF0\x9F\x8E\xA7", 'url' => "https://t.me/MedicinasSagradas");

        return $menu;
    }

    //MENU
    public function MainMenu($data = array())
    {

        try{
            if (!empty($this->notes['msgDadosEnvioId'])) {
                $this->deleteMessage($this->notes['msgDadosEnvioId']);
            }
    
            $this->clearNotes();
            $userId = 1;
    
            //INFORMANDO MENU DE OPÇÕES
            $inline_keyboard = new InlineKeyboard();
            $idUsuario = $this->user['idUsuarios'];
    
    
            $user = $this->UtilBuscaUsuarioById($idUsuario);
          
    
            $idPermissao = $user['permissoes_id'];
            $dividaUser = $user['dividas'];
    
            $permissao = $this->UtilBuscaPermissaoById($idPermissao);
            
            $return_text = $this->SelecionaEmojiPermissao($idPermissao) . " ";
            $return_text .= "\xF0\x9F\x93\xB1 <b>Menu principal</b>\n\n\xE2\x80\xBC Caso tenha alguma mensagem além de 'start' acima dessa <b>LIMPE O CHAT</b> para evitar erros.\n\n";
           
    
            $totalizador = $this->totalizador($idUsuario, $userId);
           
            
            if ($totalizador > -1) {
                $totalizador = abs($totalizador);
                $return_text .= "\xF0\x9F\x92\xB2 \xE2\x9C\x85 Saldo: <b>R$$totalizador</b>\n\n";
            } else {
                $totalizador = abs($totalizador);
                $return_text .= "\xF0\x9F\x92\xB2 \xE2\x9D\x8C Você deve: <b>R$$totalizador</b>\n\n";
            }
          
            $sql = "SELECT * FROM usuarios WHERE usuario_indicador_id = " . $idUsuario;
            $query = $this->pdo->query($sql);
            $amigos = $query->fetchAll();
            $nAmigos = count($amigos);
          
            $return_text .= "-\n<b>\xF0\x9F\x98\x84 $nAmigos amigo(s) cadastrado(s)</b>\n\n";
          
           
            $sql = "SELECT * FROM token_cadastro WHERE criador_id = " . $idUsuario . " AND status = 1 AND recebedor_id IS NULL";
            $query = $this->pdo->query($sql);
            $tokens = $query->fetchAll();
          
    
            $nTokens = count($tokens);
            $return_text .= "\xF0\x9F\x94\x96 Você tem <b>$nTokens convite(s)</b> disponíveis.\n<i>Clique em <b>\xF0\x9F\x98\x84 Convidar Amigos \xF0\x9F\x98\x84</b> e saiba mais.</i>\n-\n";
    
            //$return_text .= "\xF0\x9F\x92\xB2 Saldo: ".$totais['valor'] ."\n\n";
          
            $sql = "SELECT * FROM vendas WHERE faturado = 1 AND usuarios_id = $idUsuario AND status <> 3 AND motivo_reprovacao IS NULL";
            $query = $this->pdo->query($sql);
            $vendas = $query->fetchAll();
          
            if (!empty($vendas)) {
              
                $return_text .= "\xF0\x9F\x9A\x9A <b>Pedidos pendentes</b>:\n\n";
    
                foreach ($vendas as $venda) {
                   
                    $cat = $this->UtilBuscaCategoriaById($venda['categoria_id']);
    
                    $return_text .= "\xF0\x9F\x93\xAB Pedido #" . $venda['idVendas'] . "\n";
                    $return_text .= "Data: " . date(('d/m/Y'), strtotime($venda['dataVenda'])) . "\n";
                    $return_text .= "CEP: " . $venda['cep'] . "\n";
                    $return_text .= $cat['categoria'] . "\n";
    
                    $return_text .= "Envio: ".$venda['tipoEnvio'] . " : R$" . $venda['taxa_envio'] . "\n";
    
                    //$text .= $venda['dadosEnvio'] . "\n";
                    $vendaId = $venda['idVendas'];
    
                    $produtos = $this->UtilBuscaItensVendaByVendaId($vendaId);
    
                    $rows = $query->rowCount();
                    $total = 0;
                    if ($rows > 0) {
                        $listProd = "";
                        foreach ($produtos as $produto) {
                            $produto['subTotal'] = $produto['subTotal'];
                            $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n";
                            $total += $produto['subTotal'];
                        }
                        $listProd .= "<b>Total: R$" . $venda['valorTotal'] . "</b>\n";
                       
                    }
                  
                    switch ($venda['status']) {
                        case 1:
                            $listProd .= "\n\xF0\x9F\x95\x90 <b>AGUARDANDO APROVAÇÃO!</b> \xF0\x9F\x95\x90\n\xE2\x9A\xA0<i> O valor deste pedido ainda não foi retirado da sua conta!</i> \xE2\x9A\xA0";
                            break;
                        case 2:
                            $listProd .= "\n\xE2\x9C\x85 <b>AGUARDANDO RASTREIO</b> \xE2\x9C\x85\n";
                            break;
                    }
                    $return_text .= $listProd;
                    $return_text .= "\n--------------------------\n";
                    
                }
                //*************
    
                $return_text .= "Para vizualizar o pedido completo clique em \xF0\x9F\x93\x84 <b>Meus Pedidos</b> \xF0\x9F\x93\x84\n";
            }
            $return_text .= "\n\xE2\x80\xBC Caso tenha alguma mensagem além de 'start' acima dessa <b>LIMPE O CHAT</b> para evitar erros.";
    
          
            $menu = $this->getMenu();
    
    
            if ($idPermissao == 1) {
                //PERFIL ADMIN
                //$inline_keyboard->addRow(new InlineKeyboardButton($menu["CadastrarPedidoEmMaos"]));
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["MenuAdmin"]));
            }
            $sql = "SELECT * FROM vendas WHERE faturado = 0 AND usuarios_id = $idUsuario AND status = 1 AND motivo_reprovacao IS NULL AND cep IS NOT NULL AND categoria_id IS NOT NULL ORDER BY idVendas DESC LIMIT 10";
            $query = $this->pdo->query($sql);
            $vends = $query->fetchAll();
            if (!empty($vends)) {
                //$this->sendMessage(json_encode($vends));
                foreach ($vends as $vend) {
                    $menu["PedidoIncompleto_" . $vend['idVendas']] = array('text' => "\xE2\x81\x89 \xF0\x9F\x93\x9D Pedido incompleto - CEP: " . $vend['cep'] . " \xF0\x9F\x93\x9D \xE2\x81\x89", 'callback_data' => "Pedido_Incompleto_" . $vend['idVendas']);
                    $inline_keyboard->addRow(new InlineKeyboardButton($menu["PedidoIncompleto_" . $vend['idVendas']]));
                }
                
            }
           
    
            $sql = "SELECT * FROM dividas WHERE status = 0 AND enviador_id = $idUsuario AND aguardando_pag = 1 ORDER BY id DESC LIMIT 10";
            $query = $this->pdo->query($sql);
            $pagamentoAbertos = $query->fetchAll();
    
            if (!empty($pagamentoAbertos)) {
    
                foreach ($pagamentoAbertos as $pagamentoAberto) {
                    $menu["PagamentoAberto"] = array('text' => "\xE2\x81\x89 \xF0\x9F\x92\xB5  Pagamento em aberto : R$" . $pagamentoAberto['valor'] . " \xF0\x9F\x92\xB5  \xE2\x81\x89", 'callback_data' => "Pagamento_Incompleto_" . $pagamentoAberto['id']);
                    $inline_keyboard->addRow(new InlineKeyboardButton($menu["PagamentoAberto"]));
                }
              
    
            }
            if ($this->user['fornecedor'] == 1) {
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["FornecedorPainel"]));
            }
            if ($this->user['revendedor'] == 1) {
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["RevendedorPainel"]));
            }
            if ($this->user['enviador'] == 1) {
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["EnviarRastreio"]));
    
            }
    
    
            //PARA TODOS
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["CadastrarPedido"]));
            if ($this->user['dividas'] == 1) {
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["InserirSaldo"]));
            } else {
    
                if (empty($pagamentoAberto)) {
                    $inline_keyboard->addRow(new InlineKeyboardButton($menu["InserirSaldo"]));
                }
            }
            if ($this->user['revendedor'] == 1) {
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["RevendedorConvites"]));
            } else {
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConvidarAmigos"]));
            }
    
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["MeusPedidosPendentes"]));
            if ($idPermissao == 1) {
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarProdutos"]));
            }
    
            if ($idPermissao == 2) {
                //PERFIL SÓCIO/CUSTO
    
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarPedido"]));
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["ControleFinanceiro"]));
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarProdutos"]));
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["ListarContas"]));
    
            } else if ($idPermissao == 3) {
                //SUPER VENDEDOR
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["ControleFinanceiro"]));
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarProdutos"]));
    
            } else if ($idPermissao == 4) {
                //TELECRAZY
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["ControleFinanceiro"]));
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarProdutos"]));
    
            } else if ($idPermissao == 5) {
                //OFICIAIS MEDICINAS
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["ControleFinanceiro"]));
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarProdutos"]));
    
    
            } else if ($idPermissao == 6) {
                //FINAL
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["ControleFinanceiro"]));
                /*
                if ($user['dividas'] == 1) {
                    $inline_keyboard->addRow(new InlineKeyboardButton($menu["InserirSaldo"]));
                } else {
                    $inline_keyboard->addRow(new InlineKeyboardButton($menu["InserirSaldoCliente"]));
                }
    */
    
    
                $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarProdutos"]));
            }
    
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["AEmpresa"]));
    
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["PerguntasFrequentes"]));
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["Suporte"]));
    
            return $this->sendMessage($return_text, $inline_keyboard);
        }catch(Exception $e){
            if($idUsuario == 551){
                $this->sendMessage("ERROR!!!!!!!!");
                $this->sendMessage("ERROR: " . $e->getMessage());
            }
        }
        
    }

    public function ListarFornecedores(){

        $sql = "SELECT * FROM usuarios WHERE fornecedor = 1";
        $query = $this->pdo->query($sql);
        $fornecedores = $query->fetchAll();

        $text = "🏭 <b>FORNECEDORES!</b> 🏭\n\n";
        $inline_keyboard = new InlineKeyboard();
//colocar quais estoques cada um tem cada fornecedor
        foreach ($fornecedores as $fornecedor){

            $sql = "SELECT * FROM produtos WHERE idFornecedor = ".$fornecedor['idUsuarios']. " AND status = 1";
            $query = $this->pdo->query($sql);
            $count = $query->rowCount();

            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => $fornecedor['nome']." ($count)",
                'callback_data' => "Vizualizar_Usuario_" . $fornecedor['idUsuarios']
            ]));

            $sql = "SELECT * FROM produtos INNER JOIN categorias as c 
ON c.idCategorias = produtos.categoriaId 
WHERE idFornecedor = ".$fornecedor['idUsuarios']. " 
AND produtos.status = 1 GROUP BY produtos.categoriaId";

            $query = $this->pdo->query($sql);
            $produtos = $query->fetchAll();
            $text_estoques = "";
            foreach ($produtos as $produto){
                $text_estoques .= $produto['categoria']. " | ";
            }
            $text .= "\n<b>".$fornecedor['nome']."</b>\n";
            $text .= $count . " produtos ativos\n";
            $text .= $text_estoques;
            $text .= "\n---\n";


        }
        $this->sendMessage($text, $inline_keyboard);
    }
    public function VizualizarUsuario($usuario_id){
        $sql = "SELECT * FROM usuarios WHERE idUsuarios = " . $usuario_id;
        $query = $this->pdo->query($sql);
        $usuario = $query->fetch();
        $inline_keyboard = new InlineKeyboard();
        if($usuario['fornecedor'] == 1){
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "Ver todos produtos", 'callback_data' => 'Lista_ProdutosFornecedor_'.$usuario_id
            ]));
        }
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "Ver clientes X", 'callback_data' => 'xxxxxxxxx'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "Ver pedidos X", 'callback_data' => 'xxxxxxxxx'
        ]));
        $text = "<b>USUÁRIO</b>\n";
        $text .= "Nome: <b>".$usuario['nome']."</b>\n";
        $text .= "Revendedor, Fornecedor, Enviador\n";
        $text .= "Perfil: \n";
        $text .= "Compras: \n";
        $text .= "Última compra: \n";
        $text .= "Clientes: \n";
        $text .= "Saldo: \n";
        $this->sendMessage($text, $inline_keyboard);
    }
    public function ListaProdutosFornecedor($usuario_id){

        $sql = "SELECT * FROM produtos INNER JOIN categorias as c 
ON c.idCategorias = produtos.categoriaId 
WHERE idFornecedor = ".$usuario_id. " 
AND produtos.status = 1 GROUP BY produtos.categoriaId";

        $query = $this->pdo->query($sql);
        $produtoEstoques = $query->fetchAll();
        $text_estoques = "<b>PRODUTOS DO FORNECEDOR</b>";
        foreach ($produtoEstoques as $produtoEstoque){
            $text_estoques .= "<b>".$produtoEstoque['categoria']."</b>\n\n";
            $sql = "SELECT * FROM produtos
WHERE idFornecedor = ".$usuario_id. " AND categoriaId = ".$produtoEstoque['categoriaId']."
AND produtos.status = 1";

            $query = $this->pdo->query($sql);
            $produtos = $query->fetchAll();
            foreach ($produtos as $produto){
                $text_estoques .= $produto['descricao']."\n";
            }
            $text_estoques .= "-\n";
        }
        $this->sendMessage($text_estoques);

    }
    public function MenuAdmin(){

        $inline_keyboard = new InlineKeyboard();
        $idUsuario = $this->user['idUsuarios'];

        $user = $this->UtilBuscaUsuarioById($idUsuario);
        $idPermissao = $user['permissoes_id'];

        if ($idPermissao == 1) {
            //PERFIL ADMIN
            $menu = $this->getMenu();
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminListarProdutosPendentes"]));
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ComprovantesPendentes"]));
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["PedidosAguardandoAprovacao"]));
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ListarFornecedores"]));
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ControleFinanceiro"]));
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminPedidosPendentes"]));
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarPedido"]));
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["CadastrarCliente"]));
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminEnviarRastreio"]));
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminListaUsuarios"]));
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminTodosControles"]));
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["ListarContas"]));
            $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminEnviarAviso"]));


            //$inline_keyboard->addRow(new InlineKeyboardButton($menu["EnviarAviso"]));


            /*   $inline_keyboard->addRow(new InlineKeyboardButton($menu["ConsultarProdutos"]));
               $inline_keyboard->addRow(new InlineKeyboardButton($menu["EnviarRastreio"]));
               $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminListaUsuarios"]));
               $inline_keyboard->addRow(new InlineKeyboardButton($menu["ListarContas"]));
               $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminTodosControles"]));
               $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminEstoque"]));
               $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminListarCustos"]));
               $inline_keyboard->addRow(new InlineKeyboardButton($menu["AdminEnviarRastreio"]));*/



            $return_text = "Painel Admin";
            return $this->sendMessage($return_text, $inline_keyboard);
        }
    }
    public function AdminListarProdutosPendentes(){

        $sql = "SELECT * FROM produtos WHERE is_bot = 1 AND status = 0 ORDER BY idProdutos asc";
        $query = $this->pdo->query($sql);
        $produtos = $query->fetchAll();
        $rows = $query->rowCount();

        $text = "Selecione o produto que deseja publicar";
        if ($rows > 0) {

            $inline_keyboard = new InlineKeyboard();
            foreach ($produtos as $produto) {


                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "#" .$produto['idProdutos']." - " . $produto['descricao'],
                    'callback_data' => "Publicar_Produto_" . $produto['idProdutos']
                ]));
            }
            $this->sendMessage($text, $inline_keyboard);
        }
    }

    public function AEmpresa(){
        $inline_keyboard = new InlineKeyboard();
        $text = "\xE2\x9D\xA4 <b>Seja bem vindo ao Night Company</b> \xE2\x9D\xA4\n\n";
        $text .= "Nossa missão é facilitar a adesão de produtos ilegais por opressão estatal.\n\n";
        $text .= "<b>\xF0\x9F\x86\x93 Não acreditamos em crimes sem vítima \xF0\x9F\x86\x93</b>\n\n";
        $text .= "Acreditamos na liberdade de expressão e de consumo. Estamos aqui para te evitar passar por situações contrangedoras e/ou perigosas.\n\n";
        $text .= "Nossa ideia não é incentivar o uso de drogas, porém acreditamos na redução de danos, ";
        $text .= "a partir do momento que cada um toma a decisão de fazer o uso de substâncias, que ao menos não precise correr riscos, e evite ao máximo fazer qualquer tipo de conexão com organizações criminosas.\n\n";

        $text .= "<b>\xE2\x9C\x85 A Honestidade e ética é nossa prioridade \xE2\x9C\x85</b>\n\n";
        $text .= "Não temos nenhuma intenção de ficar com qualquer centavo que não merecemos, prezamos o trabalho duro e a criatividade no mercado, para que todos saiam beneficiados.\n";
        $text .= "Não trabalhamos com drogas que consideramos prejudiciais aos usuários, não por preconceito, mas por preferir não carregar o peso de prejudicar qualquer um.\n\n";
        $text .= "\xF0\x9F\x98\x84 Nossa equipe agradece a todos que confiam no nosso trabalho. \xF0\x9F\x98\x84";

        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas Frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => 'Perguntas_Frequentes'
        ]));
        return $this->sendMessage($text, $inline_keyboard);
    }
    public function PerguntasFrequentes(){
        $inline_keyboard = new InlineKeyboard();
        $text = "<b>Perguntas frequentes</b>\n\n";


        $text .= "<b>\xE2\x9C\x85 Quais produtos estão disponíveis? \xE2\x9C\x85</b>\n\n";
        $text .= "Todos os produtos cadastrados no bot estão disponíveis.\n";
        $text .= "<i>(Para mais detalhe selecione esta pergunta a baixo)</i>\n\n";

        $text .= "<b>\xF0\x9F\x93\x9D Como fazer uma compra? \xF0\x9F\x93\x9D</b>\n\n";
        $text .= "Basta clicar em \xF0\x9F\x93\x9D <b>Cadastrar pedido</b> \xF0\x9F\x93\x9D no menu inicial, escolher o estoque, produto e frete. Não esqueça que para finalizar o pedido você precisa inserir o saldo. \n";
        $text .= "<i>(Para mais detalhes selecione esta pergunta a baixo)</i>\n\n";

        $text .= "<b>\xF0\x9F\x92\xB5 Como efetuar o pagamento? \xF0\x9F\x92\xB5</b>\n\n";
        $text .= "O pagamento pode ser feito por PIX, TED, Depósito no boca do caixa ou Bitcoin.\n";
        $text .= "<i>(Para mais detalhes selecione esta pergunta a baixo)</i>\n\n";


        $text .= "<b>\xF0\x9F\x9A\x9A Como funciona o envio? \xF0\x9F\x9A\x9A</b>\n\n";
        $text .= "Cada estoque possui seu prazo de despache, formas de envios e preço.\n";
        $text .= "<i>(Para mais detalhes selecione esta pergunta a baixo)</i>\n\n";

        $text .= "<b>\xF0\x9F\x94\x92 Refund ou Reship \xF0\x9F\x94\x92</b>\n\n";
        $text .= "Reship apenas para envio com SEGURO.\n";
        $text .= "<i>(Para mais detalhes selecione esta pergunta a baixo)</i>\n\n";


        $text .= "<b>\xE2\x99\xBB Problemas com o produto? \xE2\x99\xBB</b>\n\n";
        $text .= "Para fazer qualquer tipo de reclamação com relação ao produto, você deve <b>FILMAR A ABERTURA DO PACOTE</b>, sem a filmagem não temos como confirmar se sua informação é verdadeira, logo não poderemos resolver o problema.\n";
        $text .= "<i>(Para mais detalhes selecione esta pergunta a baixo)</i>\n\n";

        $text .= "Selecione uma pergunta a baixo.\n";
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x9D\xA4 Sobre o Night Company \xE2\x9D\xA4", 'callback_data' => 'A_Empresa'
        ]));

        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x9C\x85 Quais produtos estão disponíveis? \xE2\x9C\x85", 'callback_data' => 'Pergunta_ProdutosDisponiveis'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x93\x9D Como fazer uma compra? \xF0\x9F\x93\x9D", 'callback_data' => 'Pergunta_EfetuarCompra'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x92\xB5 Como efetuar o pagamento? \xF0\x9F\x92\xB5", 'callback_data' => 'Pergunta_EfetuarPagamento'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x9A\x9A Como funciona o envio? \xF0\x9F\x9A\x9A", 'callback_data' => 'Pergunta_Envio'
        ]));

        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x99\xBB Problemas com o produto? \xE2\x99\xBB", 'callback_data' => 'Pergunta_ProblemaProduto'
        ]));

        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x94\x92 Refund ou Reship \xF0\x9F\x94\x92", 'callback_data' => 'Pergunta_Reship'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x92\xB2 Como me tornar revendedor? \xF0\x9F\x92\xB2", 'callback_data' => 'Pergunta_Revendedor'
        ]));

        return $this->sendMessage($text, $inline_keyboard);
    }

    public function PerguntaProdutosDisponiveis(){
        $inline_keyboard = new InlineKeyboard();
        $text = "<b>\xE2\x9C\x85 Quais produtos estão disponíveis? \xE2\x9C\x85</b>\n\n";
        $text .= "Todos os produtos cadastrados no bot estão disponíveis.\n\n";
        $text .= "Para vizualizar os produtos, clique em \xF0\x9F\x93\xA6 <b>Consultar Produtos</b> \xF0\x9F\x93\xA6 no menu principal, em seguida selecione se você quer ver por categorias ou estoques\n\n";
        $text .= "Clique no estoque/categoria desejado.\n\n";
        $text .= "\xF0\x9F\x93\x83 Você verá uma lista de produtos com preços, você também pode clicar no botão referente ao produto desejado para imagem e mais detalhes.\n\n";
        $text .= "\xF0\x9F\x8E\xA5 Alguns produtos teram um link para um canal com mais imagens e vídeos referentes aquele produto.\n\n";
        $text .= "Atente-se também ao informativa \xE2\x9C\x85 Descrição do produto garantina pela nossa equipe. \xE2\x9C\x85, estes produtos foram testados e validados pela nossa equipe, os outros são informações passadas pelo fornecedor.\n\n";
        $text .= "\xF0\x9F\x98\x94 Infelizmente não existe como testarmos/usarmos cada um dos produtos que passam por aqui.\n\n";

        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => 'Perguntas_Frequentes'
        ]));

        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x93\xA6 Consultar Produtos \xF0\x9F\x93\xA6", 'callback_data' => 'Selciona_TipoBusca'
        ]));

        return $this->sendMessage($text, $inline_keyboard);
    }

    public function PerguntaEfetuarCompra(){
        $inline_keyboard = new InlineKeyboard();
        $text = "<b>\xF0\x9F\x93\x9D  Como fazer uma compra? \xF0\x9F\x93\x9D</b>\n\n";

        $text .= "Clique em <b>\xF0\x9F\x93\x9D Cadastrar pedido \xF0\x9F\x93\x9D</b>, insira os dados de envio, selecione o <b>estoque</b> e os <b>produtos</b>, cliquem em <b>Finalizar pedido</b> e escolha o seu tipo de envio.\n\n";
        $text .= "Não esqueça que para finalizar o pedido você precisa <b>inserir o saldo</b>.\n\n";

        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => 'Perguntas_Frequentes'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x93\x9D Cadastrar pedido \xF0\x9F\x93\x9D", 'callback_data' => 'Venda_Cadastrar'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x92\xB5 Inserir saldo \xF0\x9F\x92\xB5", 'callback_data' => 'Input_ValorComprovante'
        ]));
        return $this->sendMessage($text, $inline_keyboard);
    }

    public function PerguntaEfetuarPagamento(){
        $inline_keyboard = new InlineKeyboard();
        $text = "<b>\xF0\x9F\x92\xB5 Como efetuar o pagamento? \xF0\x9F\x92\xB5</b>\n\n";

        $text .= "Para inserir o saldo, basta clicar em \xF0\x9F\x92\xB5 <b>Inserir saldo</b> \xF0\x9F\x92\xB5 no menu principal, coloque o valor que deseja inserir, selecione a forma de pagamento. \n\n";
        $text .= "O pagamento pode ser feito por <b>PIX, TED, Depósito no boca do caixa ou Bitcoin</b>.\n\n";
        $text .= "Será exibido os dados para pagamento, após fazer o pagamento clique no botão \xF0\x9F\x93\xB7 <b>Enviar Comprovante</b> \xF0\x9F\x93\xB7 e nos envie uma imagem do comprovante\n\n";
        $text .= "Caso esteja tudo certo, em no máximo 6 horas úteis seus saldo estará na sua conta do Night Company.\n\n";

        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => 'Perguntas_Frequentes'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x92\xB5 Inserir saldo \xF0\x9F\x92\xB5", 'callback_data' => 'Input_ValorComprovante'
        ]));
        return $this->sendMessage($text, $inline_keyboard);
    }
    public function PerguntaEnvio(){
        $inline_keyboard = new InlineKeyboard();
        $text = "<b>\xF0\x9F\x9A\x9A Como funciona o envio? \xF0\x9F\x9A\x9A</b>\n\n";

        $text .= "Cada estoque possui seu prazo de despache, formas de envio e preço.\n\n";
        $text .= "Para calcular o prazo de entrega acesse o link: \n<b>https://calcularfretecorreios.com/#/calcular-correios</b> e preencha o formulário com as seguintes informações:\n\n";
        $text .= "Apenas produtos em papel podem ser enviados por carta.\n\n";
        $text .= "Cep de Origem: <b>Verifique em cada estoque</b>\n";
        $text .= "Formato: <b>Caixa / Pacote</b>\n";
        $text .= "Altura: <b>5</b>\n";
        $text .= "Largura: <b>11</b>\n";
        $text .= "Comprimento: <b>16</b>\n";
        $text .= "CEP de Origem: <b>COLOQUE O CEP SEU CEP</b>\n\n";
        $text .= "Clique em <b>CALCULAR FRETE</b>\n\n";
        $text .= "Não esqueça do tempo de despache de cada estoque, geralmente sai no dia seguinte ao pagamento. Porém só aceitamos reclamações após expirar o prazo de despache.\n\n";
        $text .= "Informações dos Estoques:\n\n";

        $sql = "SELECT * FROM categorias WHERE status = 1 ORDER BY ordem";
        $query = $this->pdo->query($sql);
        $categorias = $query->fetchAll();
        $rows = $query->rowCount();

        if ($rows > 0) {
            foreach ($categorias as $categoria) {
                $text .= "<b>".$categoria['categoria']."</b>\n";
                $text .= "Prazo: ".$categoria['despache']." dias\n";
                $text .= "Cep de Origem: <b>" . $categoria['cep'] . "</b>\n";
                $text .= "Formas de envio:\n";

                if ($categoria['gratis'] == 1) {
                    $text .= "Frete Gráris (apenas promoção)\n";
                }
                if ($categoria['sedex']) {
                    $text .= "<b>Sedex</b>: R$" . $categoria['sedex'] . "\n";
                }
                if ($categoria['carta']) {
                    $text .= "<b>Carta</b>: R$" . $categoria['carta'] . "\n";
                }
                if ($categoria['pac']) {
                    $text .= "<b>PAC</b>: R$" . $categoria['pac'] . "\n";
                }
                if ($categoria['jadlog']) {
                    $text .= "<b>Jadlog</b>: R$" . $categoria['jadlog'] . "\n";
                }
                if ($categoria['envio_seguro']) {
                    $text .= "<b>Envio com seguro</b>: R$" . $categoria['envio_seguro'] . " + 15% do total da compra.\n";

                }
                $text .= "\n";
            }
        }
        $text .= "\n\n";

        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => 'Perguntas_Frequentes'
        ]));
        return $this->sendMessage($text, $inline_keyboard);
    }

    public function PerguntaProblemaProduto(){

        $inline_keyboard = new InlineKeyboard();
        $text = "<b>\xE2\x99\xBB Problemas com o produto? \xE2\x99\xBB</b>\n\n";

        $text .= "Para fazer qualquer tipo de reclamação com relação ao produto, você deve <b>FILMAR A ABERTURA DO PACOTE</b>, sem a filmagem não temos como confirmar se sua informação é verdadeira, logo não poderemos resolver o problema.\n";

        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => 'Perguntas_Frequentes'
        ]));
        return $this->sendMessage($text, $inline_keyboard);
    }

    public function PerguntaReship(){
        $inline_keyboard = new InlineKeyboard();
        $text = "<b>\xF0\x9F\x94\x92 Refund ou Reship \xF0\x9F\x94\x92</b>\n\n";

        $text .= "<b>\xE2\x9A\xA0 ATENÇÃO \xE2\x9A\xA0</b>\n\n";
        $text .= "Para estar seguro e garantir seu reship selecione a forma de envio SEGURO, este modo de envio custa 15% a mais de todo seu pedido.\n\n";
        $text .= "Neste modo de envio, caso ocorra qualquer problema nos correios você terá o reenvio de 100% do pedido.\n\n";
        $text .= "Só não cobrimos problemas com endereço errado.\n\n";

        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => 'Perguntas_Frequentes'
        ]));
        return $this->sendMessage($text, $inline_keyboard);
    }

    public function PerguntaRevendedor(){
        $inline_keyboard = new InlineKeyboard();
        $text = "<b>\xF0\x9F\x92\xB2 Como me tornar revendedor? \xF0\x9F\x92\xB2</b>\n\n";

        $text .= "Para se tornar revendedor você deve ter R$50.000 (cenquenta mil reais) em compras ou possui uma lojinha online com credibilidade.\n\n";
        $text .= "Sendo revendedor você recebe desconto em <b>TODOS os produtos</b> e também recebe diversos convites para clientes. Podendo trazer seus clientes para o Night Company e recebendo sempre que seus clientes comprarem.\n\n";
        $text .= "Você recebe a diferença entre o preço de revendedor e de clientes\n\n";
        $text .= "Para solicitar a mudança de perfil clique em <b>\xF0\x9F\x92\xB2 Solicitar revenda \xF0\x9F\x92\xB2</b> abaixo.\n\n";


        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x92\xB2 Solicitar revenda \xF0\x9F\x92\xB2", 'callback_data' => 'Solicitar_Revenda'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => 'Perguntas_Frequentes'
        ]));
        return $this->sendMessage($text, $inline_keyboard);
    }

    public function SolicitarRevenda(){
        $inline_keyboard = new InlineKeyboard();
        $text = "<b>\xF0\x9F\x92\xB2 Solicitar revenda \xF0\x9F\x92\xB2</b>\n\n";

        $text .= "Caso você possua mais de R$50000 em compras envie: <b>BATI A META</b>\n\n";
        $text .= "Caso você tenha uma lojinha online preencha os dados a seguir:\n\n";
        $text .= "<b>Nome da loja:\n";

        $text .= "Rede Social:\n";
        $text .= "Link da loja: \n";
        $text .= "Seu telegram:\n";
        $text .= "Produtos que mais se interessa: \n";
        $text .= "Está a quanto tempo no mercado?</b>\n\n";

        $text .= "Digite as informações para continuar\n\n";
        $this->notes['requestData'] = "InformacoesRevenda";


        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x9D\x94\xE2\x9D\x94 Perguntas frequentes \xE2\x9D\x94\xE2\x9D\x94", 'callback_data' => 'Perguntas_Frequentes'
        ]));
        return $this->sendMessage($text, $inline_keyboard);
    }
    public function PedidosAguardandoAprovacao()
    {

        $usuario_id = $this->user['idUsuarios'];

        $sql = "SELECT * FROM vendas WHERE faturado = 1 AND status = 1 AND motivo_reprovacao IS NULL";
        $query = $this->pdo->query($sql);
        $vendas = $query->fetchAll();
        if (!empty($vendas)) {
            $msg = "Vendas Aguardando Aprovação\n\n";

            $inline_keyboard = new InlineKeyboard();
            //$this->sendMessage(json_encode($vends));
            foreach ($vendas as $vend) {
                $venda_id = $vend['idVendas'];

                $sql = "SELECT * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $venda_id";
                $query = $this->pdo->query($sql);
                $produtos = $query->fetchAll();

                $rows = $query->rowCount();

                $total = 0;
                $listProd = "";

                if ($rows > 0) {
                    foreach ($produtos as $produto) {
                        $produto['subTotal'];
                        $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n-\n";

                    }
                }
                $text .= $listProd;

                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xE2\x9C\x85 Aprovar Pedido #$venda_id \xE2\x9C\x85",
                    'callback_data' => "Aprovar_Pedido_" . $venda_id
                ]));
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xE2\x9D\x8C Reprovar Pedido #$venda_id \xE2\x9D\x8C",
                    'callback_data' => "Reprovar_Pedido_" . $venda_id
                ]));

            }

        }
        $this->sendMessage($text, $inline_keyboard);

    }

    public function RevendedorPainel()
    {
        $usuario = $this->user;
        $usuario_id = $usuario['idUsuarios'];

        $text = "\xF0\x9F\x92\xB2 Painel de Revendedor \xF0\x9F\x92\xB2\n\n";

        $sql = "SELECT * FROM usuarios WHERE usuario_indicador_id = " . $usuario_id;
        $query = $this->pdo->query($sql);
        $clientes = $query->fetchAll();
        $nClientes = count($clientes);
        $text .= "<b>\xF0\x9F\x91\xA4 $nClientes cliente(s) cadastrado(s)</b>\n\n";

        $sql = "SELECT * FROM dividas WHERE status = 1 AND (enviador_id = 1 OR recebedor_id = 1) AND (enviador_id = $usuario_id OR recebedor_id = $usuario_id) ORDER BY id ASC";
        $query = $this->pdo->query($sql);
        $dividasTotal = $query->fetchAll();

        $totalizador = 0;
        foreach ($dividasTotal as $d) {
            if ($d['enviador_id'] == $usuario_id) {
                if ($d['tipo'] == "POSITIVO") {
                    $totalizador += $d['valor'];
                } else if ($d['tipo'] == "NEGATIVO") {
                    $totalizador -= $d['valor'];
                }
            } else {
                if ($d['tipo'] == "POSITIVO") {
                    $totalizador -= $d['valor'];
                } else if ($d['tipo'] == "NEGATIVO") {
                    $totalizador += $d['valor'];
                }
            }
            //$saldoDivida[$userId][$d['id']] = $totais[$userId]['valor'];
        }

        if ($totalizador < 0) {
            $totalizador = abs($totalizador);
            $text .= "\xF0\x9F\x92\xB2 \xE2\x9D\x8C Você deve R$$totalizador";
        } else {
            $text .= "\xF0\x9F\x92\xB2 \xE2\x9C\x85 Seu saldo é de R$$totalizador";
        }


        $text .= "\n\nSelecione a opção desejada";

        $inline_keyboard = new InlineKeyboard();
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x93\x91 Meus convites \xF0\x9F\x93\x91", 'callback_data' => 'Revendedor_Convites'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x93\x8A Minhas comissões \xF0\x9F\x93\x8A", 'callback_data' => 'Revendedor_Comissoes'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x93\x96 Controle Financeiro \xF0\x9F\x93\x96", 'callback_data' => 'Controle_Dividas'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x93\x88 Tabela de lucro \xF0\x9F\x93\x88", 'callback_data' => 'Revendedor_TipoBusca'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x93\xA6 Valores dos clientes \xF0\x9F\x93\xA6", 'callback_data' => 'Revendedor_TipoBuscaCliente'
        ]));
        //$inline_keyboard->addRow(new InlineKeyboardButton([
        //    'text' => "\xF0\x9F\x94\x92 Bloquear cliente \xF0\x9F\x94\x92", 'callback_data' => 'Revendedor_BloquearCliente'
        //]));


        $this->sendMessage($text, $inline_keyboard);
    }


    public function RevendedorTipoBusca()
    {
        $inline_keyboard = new InlineKeyboard();

        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x92\xB2 Painel de Revendedor \xF0\x9F\x92\xB2", 'callback_data' => 'Revendedor_Painel'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x93\xA6 Por categoria \xF0\x9F\x93\xA6",
            'callback_data' => "Revendedor_ConsultarProdutos_CATEGORIA"
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x93\xA4 Por estoque \xF0\x9F\x93\xA4",
            'callback_data' => "Revendedor_ConsultarProdutos_ESTOQUE"
        ]));

        $text = "\xF0\x9F\x93\x88 <b>Tabela de Lucros</b> \xF0\x9F\x93\x88\n\nEscolha como deseja listar os produtos.\n";
        $this->sendMessage($text, $inline_keyboard);
    }

    public function RevendedorTipoBuscaCliente()
    {
        $inline_keyboard = new InlineKeyboard();

        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x92\xB2 Painel de Revendedor \xF0\x9F\x92\xB2", 'callback_data' => 'Revendedor_Painel'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x93\xA6 Por categoria - Clientes \xF0\x9F\x93\xA6",
            'callback_data' => "Revendedor_ConsultarProdutosCliente_CATEGORIA"
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x93\xA4 Por estoque - Clientes \xF0\x9F\x93\xA4",
            'callback_data' => "Revendedor_ConsultarProdutosCliente_ESTOQUE"
        ]));

        $text = "\xF0\x9F\x93\xA6 <b>Valores dos clientes</b> \xF0\x9F\x93\xA6\n\nEscolha como deseja listar os produtos com preços para clientes.\n";
        $this->sendMessage($text, $inline_keyboard);
    }

    public function RevendedorConsultarProdutosCliente($tipo)
    {
        $text = "\xF0\x9F\x93\xA6 <b>Valores dos clientes</b> \xF0\x9F\x93\xA6\n\n";

        if ($tipo == "ESTOQUE") {
            $sql = "SELECT * FROM categorias WHERE status = 1 ORDER BY ordem";
            $query = $this->pdo->query($sql);
            $categorias = $query->fetchAll();
            $rows = $query->rowCount();

            if ($rows > 0) {

                $inline_keyboard = new InlineKeyboard();

                foreach ($categorias as $categoria) {
                    $sql = "SELECT * FROM produtos WHERE categoriaId = ". $categoria['idCategorias']." AND status = 1 ORDER BY idProdutos asc";
                    $query = $this->pdo->query($sql);
                    $count = $query->rowCount();
                    $inline_keyboard->addRow(new InlineKeyboardButton([
                        'text' => $categoria['categoria'] . " ($count) - Clientes",
                        'callback_data' => "Revendedor_ListarProdutosCliente_estoque," . $categoria['idCategorias']
                    ]));
                }

                //SOLICITA A CATEGORIA
                $text .= "Qual estoque você deseja consultar?\n\n<b>\xE2\x9D\x97 Todos os estoques enviam para todo Brasil \xE2\x9D\x97</b>";
                $this->sendMessage($text, $inline_keyboard);
            } else {
                $text = "Nenhum produto encontrado :/";
                return $this->sendMessage($text);
            }
        } else {

            $sql = "SELECT * FROM tipo_produto WHERE status = 1 ORDER BY ordem ASC";
            $query = $this->pdo->query($sql);
            $categorias = $query->fetchAll();
            $rows = $query->rowCount();
            $total = 0;
            $text = "";

            if ($rows > 0) {

                $inline_keyboard = new InlineKeyboard();


                foreach ($categorias as $categoria) {
                    $icone = $this->SelecionaIcone($categoria['id']);
                $sql = "SELECT * FROM produtos INNER JOIN categorias ON idCategorias = categoriaId WHERE tipo_id = ". $categoria['id']." AND status = 1 AND categorias.status = 1 ORDER BY idProdutos asc";
                    $query = $this->pdo->query($sql);
                    $count = $query->rowCount();

                    $inline_keyboard->addRow(new InlineKeyboardButton([
                        'text' => $icone . " " . $categoria['nome'] . " ($count) - Cliente " . $icone,
                        'callback_data' => "Revendedor_ListarProdutosCliente_tipo," . $categoria['id']
                    ]));
                }

                //SOLICITA A CATEGORIA
                $text .= "Qual categoria você deseja consultar?\n\n<b>\xE2\x9D\x97 Todos os estoques enviam para todo Brasil \xE2\x9D\x97</b>";
                $this->sendMessage($text, $inline_keyboard);
            } else {
                $text = "Nenhum produto encontrado :/";
                return $this->sendMessage($text);
            }
        }

    }

    public function RevendedorListarProdutosCliente($filter)
    {
        $text = "\xF0\x9F\x93\xA6 Valores dos clientes \xF0\x9F\x93\xA6\n\n";
        //$text .= "<b>Quantidade = Valor de Revenda - Valor do Cliente</b>\n\n";
        $filter = explode(",", $filter);

        $filtro = $filter[0];
        $categoria_id = $filter[1];

        $cliente = $this->UtilBuscaUsuarioById($this->user['idUsuarios']);

        $inline_keyboard = new InlineKeyboard();

        if ($filtro == 'estoque') {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\xA4 Voltar a lista de estoques - Cliente \xF0\x9F\x93\xA4",
                'callback_data' => "Revendedor_ConsultarProdutosCliente_ESTOQUE"
            ]));

            $sql = "SELECT * FROM categorias WHERE status = 1 AND idCategorias = $categoria_id ORDER BY idCategorias ASC";
            $query = $this->pdo->query($sql);
            $categoria = $query->fetch();


            $text .= "\xF0\x9F\x93\xA6 " . $categoria['categoria'] . "\n\n";
            $sql = "SELECT * FROM produtos WHERE status = 1 AND categoriaId = " . $categoria_id . " ORDER BY tipo_id, ordem ASC";
            $query = $this->pdo->query($sql);
            $produtos = $query->fetchAll();
            $rows = $query->rowCount();
            $total = 0;


        } else if ($filtro == 'tipo') {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\xA6 Voltar a lista de categorias - Cliente \xF0\x9F\x93\xA6",
                'callback_data' => "Revendedor_ConsultarProdutosCliente_CATEGORIA"
            ]));

            $sql = "SELECT * FROM tipo_produto WHERE id = " . $categoria_id;
            $query = $this->pdo->query($sql);
            $categoria = $query->fetch();
            $cat_nome = $categoria['nome'];
            $icone = $this->SelecionaIcone($categoria_id);
            $text .= "<b>" . $categoria['nome'] . "</b> $icone\n\n";
            $sql = "SELECT * FROM produtos WHERE status = 1 AND tipo_id = " . $categoria['id'] . " ORDER BY categoriaId, ordem ASC";
            $query = $this->pdo->query($sql);
            $produtos = $query->fetchAll();
            $rows = $query->rowCount();
            $total = 0;
            $cat = 0;
        }

        if ($rows > 0) {

            $pesado = 0;
            foreach ($produtos as $produto) {

                if ($produto['pesado'] == 1) {
                    $pesado = 1;
                }
                $unidade = $produto['unidade'];
                $icone = $this->SelecionaIcone($produto['tipo_id']);
                if (isset($cat)) {
                    if ($cat != $produto['categoriaId']) {
                        $sql = "SELECT * FROM categorias WHERE idCategorias = " . $produto['categoriaId'];
                        $query = $this->pdo->query($sql);
                        $categ = $query->fetch();

                        $text .= "<b>" . $categ['categoria'] . "</b>\n\n";
                        $cat = $produto['categoriaId'];
                        $cat_nome = $categ['categoria'];
                    }
                }


                $sql = "SELECT * FROM usuario_valor WHERE produto_id = " . $produto['idProdutos'] . " AND usuario_id = 6 ORDER BY de ASC";
                $query = $this->pdo->query($sql);
                $valores = $query->fetchAll();

                $text .= "$icone " . $produto['descricao'] . "\n";

                foreach ($valores as $valor) {
                    $preco = $valor['valor'];
                    $de = $valor['de'];
                    $ate = $valor['ate'];

                    $text .= "<i>de $de" . $unidade . " até $ate" . $unidade . " = <b>R$" . $preco . "</b></i>\n";

                }
                $text .= "-\n";

                if (!empty($cat_nome)) {
                    $inline_keyboard->addRow(new InlineKeyboardButton([
                        'text' => $icone . " " . $produto['descricao'] . " - " . $cat_nome . " " . $icone,
                        'callback_data' => "Vizualizar_Produto_" . $produto['idProdutos']
                    ]));
                } else {
                    $inline_keyboard->addRow(new InlineKeyboardButton([
                        'text' => $icone . " " . $produto['descricao'] . " " . $icone,
                        'callback_data' => "Vizualizar_Produto_" . $produto['idProdutos']
                    ]));
                }

            }

            if ($filtro == 'estoque') {
                $text .= "-\nTempo limite de despache: " . $categoria['despache'] . " dias úteis após a aprovação do pedido.\n-\n";
                $text .= "CEP para consultar prazo: <b>" . $categoria['cep'] . "</b>\n\n";
                $text .= "<b>Valor do Frete</b>:\n";
                if ($categoria['gratis'] == 1) {
                    $text .= "Frete Gráris (apenas promoção)\n";
                }
                if ($categoria['sedex']) {
                    $text .= "Sedex: R$" . $categoria['sedex'] . "\n";
                }
                if ($categoria['carta']) {
                    if ($produto['pesado'] == 1) {
                        $text .= "<b>Este produto não pode ser enviado por carta.</b>\n";
                    } else {
                        $text .= "<b>Carta</b>: R$" . $categoria['carta'] . "\n";
                    }

                }
                if ($categoria['pac']) {
                    $text .= "PAC: R$" . $categoria['pac'] . "\n";
                }
                if ($categoria['jadlog']) {
                    $text .= "Jadlog: R$" . $categoria['jadlog'] . "\n";
                    $text .= "<i>(Jadlog: Coloque o CPF na observação do pedido)</i>\n";
                }
                if ($categoria['envio_seguro']) {
                    $text .= "Envio com seguro: R$" . $categoria['envio_seguro'] . " + 15% do total da compra.\n";
                    $text .= "<i>Envio com seguro cobre qualquer tipo de perca nos correios, caso seus pedido não tenha seguro não cubrimos imprevistos no envio</i>\n";
                }

                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x93\xA4 Voltar a lista de estoques - Cliente \xF0\x9F\x93\xA4",
                    'callback_data' => "Revendedor_ConsultarProdutosCliente_ESTOQUE"
                ]));
            } else if ($filtro == 'tipo') {
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x93\xA6 Voltar a lista de categorias - Cliente \xF0\x9F\x93\xA6",
                    'callback_data' => "Revendedor_ConsultarProdutosCliente_CATEGORIA"
                ]));
            }
            //$text .= "\n<b>Quantidade = Valor de Revenda - Valor do Cliente</b>";

            $this->sendMessage($text, $inline_keyboard);
        }
    }

    public function RevendedorConsultarProdutos($tipo)
    {
        $text = "\xF0\x9F\x93\x88 <b>Tabela de Lucros</b> \xF0\x9F\x93\x88\n\n";

        if ($tipo == "ESTOQUE") {
            $sql = "SELECT * FROM categorias WHERE status = 1 ORDER BY ordem";
            $query = $this->pdo->query($sql);
            $categorias = $query->fetchAll();
            $rows = $query->rowCount();

            if ($rows > 0) {

                $inline_keyboard = new InlineKeyboard();

                foreach ($categorias as $categoria) {
                    $sql = "SELECT * FROM produtos WHERE categoriaId = ". $categoria['idCategorias']." AND status = 1 ORDER BY idProdutos asc";
                    $query = $this->pdo->query($sql);
                    $count = $query->rowCount();
                    $inline_keyboard->addRow(new InlineKeyboardButton([
                        'text' => $categoria['categoria']."($count)",
                        'callback_data' => "Revendedor_ListarProdutos_estoque," . $categoria['idCategorias']
                    ]));
                }

                //SOLICITA A CATEGORIA
                $text .= "Qual estoque você deseja consultar?\n\n<b>\xE2\x9D\x97 Todos os estoques enviam para todo Brasil \xE2\x9D\x97</b>";
                $this->sendMessage($text, $inline_keyboard);
            } else {
                $text = "Nenhum produto encontrado :/";
                return $this->sendMessage($text);
            }
        } else {

            $sql = "SELECT * FROM tipo_produto WHERE status = 1 ORDER BY ordem ASC";
            $query = $this->pdo->query($sql);
            $categorias = $query->fetchAll();
            $rows = $query->rowCount();
            $total = 0;
            $text = "";

            if ($rows > 0) {

                $inline_keyboard = new InlineKeyboard();


                foreach ($categorias as $categoria) {
                    $icone = $this->SelecionaIcone($categoria['id']);
                    $sql = "SELECT * FROM produtos INNER JOIN categorias ON idCategorias = categoriaId WHERE tipo_id = ". $categoria['id']." AND status = 1 AND categorias.status = 1 ORDER BY idProdutos asc";
                    $query = $this->pdo->query($sql);
                    $count = $query->rowCount();
                    $inline_keyboard->addRow(new InlineKeyboardButton([
                        'text' => $icone . " " . $categoria['nome'] . "($count) " . $icone,
                        'callback_data' => "Revendedor_ListarProdutos_tipo," . $categoria['id']
                    ]));
                }

                //SOLICITA A CATEGORIA
                $text .= "Qual categoria você deseja consultar?\n\n<b>\xE2\x9D\x97 Todos os estoques enviam para todo Brasil \xE2\x9D\x97</b>";
                $this->sendMessage($text, $inline_keyboard);
            } else {
                $text = "Nenhum produto encontrado :/";
                return $this->sendMessage($text);
            }
        }

    }

    public function RevendedorListarProdutos($filter)
    {
        $text = "\xF0\x9F\x93\x88 <b>Tabela de Lucros</b> \xF0\x9F\x93\x88\n\n";
        $text .= "<b>Quantidade = Valor do Cliente - Valor de Revenda</b>\n\n";
        $filter = explode(",", $filter);

        $filtro = $filter[0];
        $categoria_id = $filter[1];

        $cliente = $this->UtilBuscaUsuarioById($this->user['idUsuarios']);

        $inline_keyboard = new InlineKeyboard();

        if ($filtro == 'estoque') {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\xA4 Voltar a lista de estoques \xF0\x9F\x93\xA4",
                'callback_data' => "Revendedor_ConsultarProdutos_ESTOQUE"
            ]));

            $sql = "SELECT * FROM categorias WHERE status = 1 AND idCategorias = $categoria_id ORDER BY idCategorias ASC";
            $query = $this->pdo->query($sql);
            $categoria = $query->fetch();


            $text .= "\xF0\x9F\x93\xA6 " . $categoria['categoria'] . "\n\n";
            $sql = "SELECT * FROM produtos WHERE status = 1 AND categoriaId = " . $categoria_id . " ORDER BY tipo_id, ordem ASC";
            $query = $this->pdo->query($sql);
            $produtos = $query->fetchAll();
            $rows = $query->rowCount();
            $total = 0;


        } else if ($filtro == 'tipo') {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\xA6 Voltar a lista de categorias \xF0\x9F\x93\xA6",
                'callback_data' => "Revendedor_ConsultarProdutos_CATEGORIA"
            ]));

            $sql = "SELECT * FROM tipo_produto WHERE id = " . $categoria_id;
            $query = $this->pdo->query($sql);
            $categoria = $query->fetch();
            $cat_nome = $categoria['nome'];
            $icone = $this->SelecionaIcone($categoria_id);
            $text .= "<b>" . $categoria['nome'] . "</b> $icone\n\n";
            $sql = "SELECT * FROM produtos WHERE status = 1 AND tipo_id = " . $categoria['id'] . " ORDER BY categoriaId, ordem ASC";
            $query = $this->pdo->query($sql);
            $produtos = $query->fetchAll();
            $rows = $query->rowCount();
            $total = 0;
            $cat = 0;
        }

        if ($rows > 0) {

            $pesado = 0;
            foreach ($produtos as $produto) {

                if ($produto['pesado'] == 1) {
                    $pesado = 1;
                }
                $unidade = $produto['unidade'];
                $icone = $this->SelecionaIcone($produto['tipo_id']);
                if (isset($cat)) {
                    if ($cat != $produto['categoriaId']) {
                        $sql = "SELECT * FROM categorias WHERE idCategorias = " . $produto['categoriaId'];
                        $query = $this->pdo->query($sql);
                        $categ = $query->fetch();

                        $text .= "<b>" . $categ['categoria'] . "</b>\n\n";
                        $cat = $produto['categoriaId'];
                        $cat_nome = $categ['categoria'];
                    }
                }


                $sql = "SELECT * FROM usuario_valor WHERE produto_id = " . $produto['idProdutos'] . " AND usuario_id = " . $this->user['permissoes_id'] . " ORDER BY de ASC";
                $query = $this->pdo->query($sql);
                $valor = $query->fetch();

                $text .= "$icone " . $produto['descricao'] . "\n";

                $preco = $valor['valor'];
                $de = $valor['de'];
                $ate = $valor['ate'];

                $text .= "$de" . $unidade . " = ";

                //CONSULTAR VALOR FINAL
                $valorCliente = $this->UtilBuscaValor($produto['idProdutos'], 6, $de);
                if (!empty($valorCliente)) {
                    $lucro = $valorCliente['valor'] - $preco;
                    $text .= "<b>R$" . $valorCliente['valor'] . "</b> - <b>R$" . $preco . "</b>\n";
                    if (!empty($lucro)) {
                        $text .= "<b>Lucro médio: R$" . $lucro . "</b>\n";
                    }

                }

                $text .= "-\n";

                if (!empty($cat_nome)) {
                    $inline_keyboard->addRow(new InlineKeyboardButton([
                        'text' => $icone . " " . $produto['descricao'] . " - " . $cat_nome . " " . $icone,
                        'callback_data' => "Vizualizar_Produto_" . $produto['idProdutos']
                    ]));
                } else {
                    $inline_keyboard->addRow(new InlineKeyboardButton([
                        'text' => $icone . " " . $produto['descricao'] . " " . $icone,
                        'callback_data' => "Vizualizar_Produto_" . $produto['idProdutos']
                    ]));
                }

            }

            if ($filtro == 'estoque') {
                $text .= "-\nTempo limite de despache: " . $categoria['despache'] . " dias úteis após a aprovação do pedido.\n-\n";
                $text .= "CEP para consultar prazo: <b>" . $categoria['cep'] . "</b>\n\n";
                $text .= "<b>Valor do Frete</b>:\n";
                if ($categoria['gratis'] == 1) {
                    $text .= "Frete Gráris (apenas promoção)\n";
                }
                if ($categoria['sedex']) {
                    $text .= "Sedex: R$" . $categoria['sedex'] . "\n";
                }
                if ($categoria['carta']) {
                    if ($produto['pesado'] == 1) {
                        $text .= "<b>Este produto não pode ser enviado por carta.</b>\n";
                    } else {
                        $text .= "<b>Carta</b>: R$" . $categoria['carta'] . "\n";
                    }

                }
                if ($categoria['pac']) {
                    $text .= "PAC: R$" . $categoria['pac'] . "\n";
                }
                if ($categoria['jadlog']) {
                    $text .= "Jadlog: R$" . $categoria['jadlog'] . "\n";
                    $text .= "<i>(Jadlog: Coloque o CPF na observação do pedido)</i>\n";
                }
                if ($categoria['envio_seguro']) {
                    $text .= "Envio com seguro: R$" . $categoria['envio_seguro'] . " + 15% do total da compra.\n";
                    $text .= "<i>Envio com seguro cobre qualquer tipo de perca nos correios, caso seus pedido não tenha seguro não cubrimos imprevistos no envio</i>\n";
                }

                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x93\xA4 Voltar a lista de estoques \xF0\x9F\x93\xA4",
                    'callback_data' => "Revendedor_ConsultarProdutos_ESTOQUE"
                ]));
            } else if ($filtro == 'tipo') {
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x93\xA6 Voltar a lista de categorias \xF0\x9F\x93\xA6",
                    'callback_data' => "Revendedor_ConsultarProdutos_CATEGORIA"
                ]));
            }
            $text .= "\n<b>Quantidade = Valor de Revenda - Valor do Cliente</b>";

            $this->sendMessage($text, $inline_keyboard);
        }
    }

    public function RevendedorComissoes()
    {
        $usuario = $this->user;
        $usuario_id = $usuario['idUsuarios'];

        $sql = "SELECT 
       di.venda_id, valor as total, di.id, di.data, di.descricao, di.comprovante, 
       di.ocultar_dados FROM dividas as di 
WHERE 
      ((di.enviador_id = $usuario_id AND di.tipo = 'POSITIVO') 
           OR (di.recebedor_id = $usuario_id AND di.tipo = 'NEGATIVO')) 
  AND di.status = 1 AND comissao = 1
  AND venda_id IS NOT NULL 
ORDER BY di.data DESC";

        $query = $this->pdo->query($sql);
        $dividas = $query->fetchAll();
        $rows = $query->rowCount();
        if (!empty($dividas)) {
            $text = "<b>Comissões de Vendas</b>\n\n";
            $listProd = "";
            foreach ($dividas as $d) {

                $divida_id = $d['id'];
                $venda_id = $d['venda_id'];
                $sql = "SELECT * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $venda_id";
                $query = $this->pdo->query($sql);
                $produtos = $query->fetchAll();
                foreach ($produtos as $produto) {
                    $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " - Subtotal: <b>R$" . $produto['subTotal'] . "</b>\n";
                }

                $text .= "\xF0\x9F\x92\xB0 Comissão: #" . $divida_id .
                    "\nPedido: #$venda_id" .
                    "\nData: " . date(('d/m/Y'), strtotime($d['data'])) . "\n\n" .
                    $listProd .
                    "\n<b>Valor da Comissão: R$" . $d['total'] . "</b>" .
                    "\n-----\n";

                //$listDividas[$divida_id] = $textComprovantes;

            }
        } else {
            $text = "Infelizmente você não possui nenhuma comissão\n<b>Convide seus clientes</b> com convites, a cada pedido finalizado, você recebe uma comissão,\n\n";
        }

        $inline_keyboard = new InlineKeyboard(
            [['text' => "\xF0\x9F\x92\xB2 Painel de Revendedor \xF0\x9F\x92\xB2", 'callback_data' => "Revendedor_Painel"]]
        );
        $this->sendMessage($text, $inline_keyboard);

    }

    public function RevendedorConvites()
    {
        $usuario = $this->user;
        $usuario_id = $usuario['idUsuarios'];
        if ($usuario['revendedor'] == 1) {

            $inline_keyboard = new InlineKeyboard();
            $text = "\xF0\x9F\x92\xB0 <b>CONVIDE SEUS CLIENTES GANHE SALDO!</b>\xF0\x9F\x92\xB0\n\n";

            $text .= "\xF0\x9F\x92\xB2<b>Recompensa</b>:\n";
            $text .= "Você pode convidar seus clientes para usar o Night Company e receber por cada compra que eles efetuarem.\n\n";
            $text .= "<b>Você tem os valores dos produtos com o desconto de revenda, seus clientes não.</b>\n";
            $text .= "\xF0\x9F\x92\xB0<b>Você recebe a diferença entre o que você paga e o que ele paga.</b>\n\n";
            $text .= "O valor muda de produto para produto, você pode consultar a tabela de lucros para ver o lucro por unidade.\n\n";
            $text .= "<i>\xE2\x9A\xA0 Nenhum saldo pode ser retirado ou transferido, apenas utilizado em compras.</i>\n-\n";

            $sql = "SELECT * FROM usuarios WHERE usuario_indicador_id = " . $usuario_id;
            $query = $this->pdo->query($sql);
            $amigos = $query->fetchAll();
            $nAmigos = count($amigos);
            $text .= "<b>\xF0\x9F\x98\x84 $nAmigos amigo(s) cadastrado(s)</b>\n\n";

            $sql = "SELECT * FROM token_cadastro WHERE criador_id = " . $usuario_id . " AND status = 1 AND recebedor_id IS NULL";
            $query = $this->pdo->query($sql);
            $tokens = $query->fetchAll();


            $nTokens = count($tokens);
            $text .= "\xF0\x9F\x94\x96 Você tem <b>$nTokens convite(s)</b> disponíveis.\n";
            foreach ($tokens as $token) {
                $text .= "\nConvite: " . $token['token'];
            }

            $text .= "\n-\n<i>\xE2\x99\xA5 Basta enviar o bot @NightCompany_Bot com um dos convites para um cliente. Cada código só pode ser utilizado uma vez.</i>\n";
            $text .= "\n<i>\xE2\x9A\xA0 Evite desperdiçar seus convites com clientes que não vão fazer um pedido.</i>\n";

            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\x84 Solicitar 10 convites", 'callback_data' => 'Revendedor_SolicitaConvite'
            ]));
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x92\xB2 Painel de Revendedor \xF0\x9F\x92\xB2", 'callback_data' => 'Revendedor_Painel'
            ]));
            $this->sendMessage($text, $inline_keyboard);
        }
    }

//totalizarSaldo
    public function UtilTotalizarSaldo($usuario_id)
    {

        $sql = "SELECT * FROM dividas WHERE status = 1 AND (enviador_id = 1 OR recebedor_id = 1) AND (enviador_id = $usuario_id OR recebedor_id = $usuario_id) ORDER BY id ASC";
        $query = $this->pdo->query($sql);
        $dividasTotal = $query->fetchAll();
        $totalizador = 0;
        $retorno = array();
        //SALDO DO USUARIO
        foreach ($dividasTotal as $d) {
            if ($d['enviador_id'] == $usuario_id) {
                if ($d['tipo'] == "POSITIVO") {
                    $totalizador += $d['valor'];
                } else if ($d['tipo'] == "NEGATIVO") {
                    $totalizador -= $d['valor'];
                }
            } else {
                if ($d['tipo'] == "POSITIVO") {
                    $totalizador -= $d['valor'];
                } else if ($d['tipo'] == "NEGATIVO") {
                    $totalizador += $d['valor'];
                }
            }
            $retorno['saldoDivida'][$usuario_id][$d['id']] = $totalizador;
        }
        $retorno['total'] = $totalizador;
        return $retorno;

    }

    public function UtilGetQuantidadesDividas($usuario_id)
    {

        $retorno = array();
        $sql = "SELECT * FROM dividas WHERE enviador_id = $usuario_id AND status = 0 AND motivo_reprovacao IS NULL AND tipo='POSITIVO' AND aguardando_pag = 1 ORDER BY data DESC";
        $query = $this->pdo->query($sql);
        $qtdDividasAguardando = $query->rowCount();
        $retorno['qtdDividasAguardando'] = $qtdDividasAguardando;

        $sql = "SELECT * FROM vendas WHERE faturado = 1 AND status = 1 AND usuarios_id = $usuario_id AND motivo_reprovacao IS NULL";
        $query = $this->pdo->query($sql);
        $qtdVendasAguardando = $query->rowCount();
        $retorno['qtdVendasAguardando'] = $qtdVendasAguardando;

        return $retorno;

    }

    public function UtilGetDividasVendasByUsuario($usuario_id)
    {

        $sql = "SELECT di.venda_id, SUM(valor) as total, MAX(di.id) AS id, di.data, di.comissao as comissao FROM dividas as di WHERE (di.enviador_id = $usuario_id OR di.recebedor_id = $usuario_id) AND di.status = 1 AND di.tipo = 'NEGATIVO' AND di.venda_id IS NOT NULL group by di.venda_id ORDER BY id DESC";
        $query = $this->pdo->query($sql);
        $dividas = $query->fetchAll();
        return $dividas;

    }

    public function UtilGetVendaByVendaId($venda_id)
    {
        $sql = "SELECT * FROM vendas WHERE idVendas = " . $venda_id;
        $query = $this->pdo->query($sql);
        $venda = $query->fetch();
        return $venda;

    }

    public function RevendedorSolicitaConvite()
    {
        $usuario = $this->user;
        $usuario_id = $usuario['idUsuarios'];
        $revendedor = $this->UtilBuscaUsuarioById($usuario_id);
        $text = "\xE2\x9C\x85 Solicitação de 10 Convites \xE2\x9C\x85\n\n";
        $text .= "Revendedor: " . $revendedor['nome'] . "\n";

        $sql = "SELECT * FROM token_cadastro WHERE criador_id = " . $usuario_id . " AND status = 1 AND recebedor_id IS NULL";
        $query = $this->pdo->query($sql);
        $tokens = $query->fetchAll();
        $nTokens = count($tokens);

        $sql = "SELECT * FROM usuarios WHERE usuario_indicador_id = " . $usuario_id . " AND bloqueado = 0";
        $query = $this->pdo->query($sql);
        $clientesRevendedor = $query->fetchAll();

        $nClientes = count($clientesRevendedor);
        $totalizador = $this->totalizarSaldo($usuario_id);

        $text .= "Convites Disponíveis: $nTokens\n";
        $text .= "Quantidade de Clientes: $nClientes\n";
        $text .= "Saldo: R$$totalizador\n";

        $inline_keyboard_warnyj = new InlineKeyboard(
            [['text' => "\xE2\x9C\x85 Aprovar pedido", 'callback_data' => "Aprovar_SolicitacaoConvite_$usuario_id"]],
            [['text' => "\xE2\x9D\x8C Reprovar pedido", 'callback_data' => "Reprovar_SolicitacaoConvite_$usuario_id"]]
        );

        $this->sendMessageById(889423113, $text, $inline_keyboard_warnyj);
        $inline_keyboard = new InlineKeyboard();
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x92\xB2 Painel de Revendedor \xF0\x9F\x92\xB2", 'callback_data' => 'Revendedor_Painel'
        ]));

        $text = "\xE2\x9C\x85 Solicitação feita com sucesso \xE2\x9C\x85\n\n Aguarde aprovacação para receber seus convites";
        $this->sendMessage($text, $inline_keyboard);

    }

    public function AprovarSolicitacaoConvite($revendedor_id)
    {
        $convites = 10;
        for ($i = 0; $i < $convites; $i++) {
            $numero_de_bytes = 10;

            $token = $this->randString($numero_de_bytes);
            $token = strtoupper($token);
            $data = array(
                ':datahora' => date('Y-m-d H:i:s'),
                ':token' => $token,
                ':criador_id' => $revendedor_id,
                ':status' => 1,
            );
            $sql = "INSERT INTO token_cadastro (datahora, token, criador_id, status) VALUES (:datahora, :token, :criador_id, :status)";
            //$this->sendMessageById(889423113, json_encode($data). " - ". $sql);
            if ($this->pdo->prepare($sql)->execute($data)) {

            } else {
                $message = "ERRO";

                return $this->sendMessage($message);
            }
        }
        $msgConvite = "Sua soliciração de convites foi aprovada!\n Você recebeu $convites convite(s), convide seus clientes e receba comissão nas compras deles!\n\nClique em <b>\xF0\x9F\x92\xB2 Painel de Revendedor \xF0\x9F\x92\xB2</b> no Menu principal para saber mais.";
        $inline_keyboard_warnyj = new InlineKeyboard(
            [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
        );
        $cliente = $this->UtilBuscaUsuarioById($revendedor_id);
        $this->sendMessageById($cliente['chat_id'], $msgConvite, $inline_keyboard_warnyj);

        $text = "<b>Solicitação reprovada</b>";
        $text .= "Revendedor: ".$cliente['nome'];
        $this->sendMessage($text);
    }

    public function AprovarRevendedor($usuario_id)
    {
        $dataUsuario = array(
            ':permissoes_id' => '4',
            ':revendedor' => '1',
            ':id' => $usuario_id,
        );
        $sql = "UPDATE usuarios set permissoes_id = :permissoes_id, revendedor = :revendedor WHERE idUsuarios = :id";
        $prepSql = $this->pdo->prepare($sql);

        if ($prepSql->execute($dataUsuario)) {

            $text = "<b>Parabéns seu pedido para se tornar revendedor foi aprovado</b>\n\n";
            $text .= "Todos os valores dos produtos foram alterados para você.\n\n";
            $text .= "Agora vá ao menu principal clique em Painel de Revendedor, depois em Solicitar Convites para começar a inserir seus clientes.\n\n";
            $text .= "Você também pode vender normalmente, e você mesmo fazer o pedido por aqui, enviaremos direto para seu cliente.";

            $cliente = $this->UtilBuscaUsuarioById($usuario_id);
            $inline_keyboard = new InlineKeyboard(
                [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
            );
            $this->sendMessageById($cliente['chat_id'], $text, $inline_keyboard);


            $text = "<b>Solicitação aprovada</b>";
            $text .= "Revendedor: ".$cliente['nome'];
            $text .= "Saldo: <b>Solicitação aprovada</b>";
            $text .= "Quantidade de Compras<b>: Solicitação aprovada</b>";
            $this->sendMessage($text);
        }

    }

    public function ReprovarRevendedor($usuario_id)
    {

        $text = "<b>Sua solicitação para se tornar revendedor foi recusada</b>\n\n";
        $text .= "Infelizmente você ainda não atingiu o mínimo para se tornar revendedor.\n\n";

        $cliente = $this->UtilBuscaUsuarioById($usuario_id);

        $inline_keyboard = new InlineKeyboard(
            [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
        );

        $this->sendMessageById($cliente['chat_id'], $text, $inline_keyboard);

        $text = "Solicitação aprovada";
        $this->sendMessage($text);

    }
    public function ReprovarSolicitacaoConvite($revendedor_id)
    {

        $msgConvite = "Sua soliciração de convites foi reprovada!";
        $inline_keyboard_warnyj = new InlineKeyboard(
            [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
        );
        $cliente = $this->UtilBuscaUsuarioById($revendedor_id);
        $this->sendMessageById($cliente['chat_id'], $msgConvite, $inline_keyboard_warnyj);

        $text = "Solicitação reprovada";
        $this->sendMessage($text);
    }

    public function ComprovantesPendentes()
    {
        $adminId = 1;
        $sql = "SELECT * FROM dividas WHERE enviador_id = $adminId OR recebedor_id = $adminId AND status = 0 AND comprovante IS NOT NULL ORDER BY id desc";
        $query = $this->pdo->query($sql);
        $dividas = $query->fetchAll();
        $text = "Comprovantes pendentes:";
        if (!empty($dividas)) {
            $inline_keyboard = new InlineKeyboard();
            foreach ($dividas as $divida) {

                $inline_keyboard->addRow(new InlineKeyboardButton(['text' => "\xE2\x9C\x85 Aprovar comprovante #" . $divida['id'], 'callback_data' => 'Aprovar_Comprovante_' . $divida['id']]));
                $inline_keyboard->addRow(new InlineKeyboardButton(['text' => "\xE2\x9D\x8C Reprovar comprovante #" . $divida['id'], 'callback_data' => 'Reprovar_Comprovante_' . $divida['id']]));
            }
            $inline_keyboard->addRow(new InlineKeyboardButton(['text' => "\xF0\x9F\x94\x99 Voltar ao menu principal / Atualizar \xF0\x9F\x94\x99", 'callback_data' => 'Main_Menu']));
            $this->sendMessage($text, $inline_keyboard);
        } else {
            $this->sendMessage($text);
        }

    }

    public function ListarConvites()
    {
        $idUsuario = $this->user['idUsuarios'];

        $text = "\xF0\x9F\x92\xB0 <b>CONVIDE SEUS AMIGOS GANHE SALDO!</b>\xF0\x9F\x92\xB0\n\nA cada R$500 em um única compra você ganha um convite!\n";
        $text .= "Você recebe uma recomensa toda vez que seus amigos fizerem um pedido acima de R$200\n\n";

        $text .= "\xF0\x9F\x93\xA6 Recompensa:\n";
        $text .= "\xF0\x9F\x92\xB2 R$200 até R$499 = R$5\n";
        $text .= "\xF0\x9F\x92\xB2 R$500 até R$999 = R$25 \n";
        $text .= "\xF0\x9F\x92\xB2 Acima de R$1000 = R$60 \n\n";
        $text .= "<i>\xE2\x9A\xA0 Nenhum saldo pode ser retirado ou transferido, apenas utilizado em compras.</i>\n-\n";

        $sql = "SELECT * FROM usuarios WHERE usuario_indicador_id = " . $idUsuario;
        $query = $this->pdo->query($sql);
        $amigos = $query->fetchAll();
        $nAmigos = count($amigos);
        $text .= "<b>\xF0\x9F\x98\x84 $nAmigos amigo(s) cadastrado(s)</b>\n\n";

        $sql = "SELECT * FROM token_cadastro WHERE criador_id = " . $idUsuario . " AND status = 1 AND recebedor_id IS NULL";
        $query = $this->pdo->query($sql);
        $tokens = $query->fetchAll();


        $nTokens = count($tokens);
        $text .= "\xF0\x9F\x94\x96 Você tem <b>$nTokens convite(s)</b> disponíveis.\n";
        foreach ($tokens as $token) {
            $text .= "\nConvite: " . $token['token'];
        }
        $text .= "\n-\n<i>\xE2\x99\xA5 Basta enviar o bot @NightCompany_Bot com um dos convites para um amigo. Cada código só pode ser utilizado uma vez.</i>\n";
        $text .= "\n<i>\xE2\x9A\xA0 Evite desperdiçar seus convites com quem não vai fazer um pedido.</i>\n";
        $text .= "\nSeu código de usuario: #$idUsuario\n";
        $this->sendMessage($text);
    }


    public function EnviarAviso($usuario_id)
    {
        $this->notes['UsuarioMensagemAviso'] = $usuario_id;
        $this->notes['requestData'] = "MensagemAviso";
        $this->conversation->update();
        $text = "\xF0\x9F\x93\xA2 Infome a mensagem que será enviada: \xF0\x9F\x93\xA2";
        $this->sendMessage($text);
    }

    public function FornecedorPainel()
    {
        $usuario = $this->user;
        $usuario_id = $usuario['idUsuarios'];
        if (!empty($usuario) && $usuario['fornecedor'] == 1) {
            $totalizador = $this->totalizador($usuario_id, 1);
            $inline_keyboard = new InlineKeyboard();
            $text = "\xF0\x9F\x8F\xA2 \xF0\x9F\x92\xB0 <b>Painel de Fornecedor</b> \xF0\x9F\x92\xB0 \xF0\x9F\x8F\xA2\n\n";
            $text .= "Seu saldo: R$$totalizador\n";
            //$text .= "Você tem X Produtos cadastrados\n";
            //$text .= "Estoques:\n";
            //$text .= "Estoque 1 (5 produtos)";
            //$text .= "Produtos Soltos (0 produtos)";
            $text .= "Selecione a opção desejada";

            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xE2\x9E\x95 Adicionar produto \xE2\x9E\x95", 'callback_data' => 'Fornecedor_AdicionarProduto'
            ]));
            if($totalizador < 0){
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x92\xB5 Solicitar Saque \xF0\x9F\x92\xB5", 'callback_data' => 'Solicitar_Saque'
                ]));
            }

            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "	\xF0\x9F\x91\x80 Seus Podutos \xF0\x9F\x91\x80", 'callback_data' => 'Fornecedor_ListarProdutos'
            ]));
            /*
                        $inline_keyboard->addRow(new InlineKeyboardButton([
                            'text' => "\xF0\x9F\x92\xB2 Listar vendas \xF0\x9F\x92\xB2", 'callback_data' => 'Fornecedor_AdicionarProduto'
                        ]));
            */
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\x96 Controle Financeiro \xF0\x9F\x93\x96", 'callback_data' => 'Controle_Dividas'
            ]));


            return $this->sendMessage($text, $inline_keyboard);
        }
    }

    public function SolicitarSaque(){
        $this->notes['usuarioSaque'] = $this->user['idUsuarios'];

        $this->notes['requestData'] = "SolicitarSaqueConta";
        $this->conversation->update();
        $text = "\xF0\x9F\x92\xB0 Qual valor você deseja sacar?";
        $this->sendMessage($text);
    }
    public function FornecedorListarProdutos()
    {

        $usuario = $this->user;
        $usuario_id = $usuario['idUsuarios'];
        $sql = "SELECT * FROM produtos WHERE status = 1 AND idFornecedor = " . $usuario_id . " ORDER BY categoriaId, ordem ASC";
        $query = $this->pdo->query($sql);
        $produtos = $query->fetchAll();
        $cat = 0;
        $inline_keyboard = new InlineKeyboard();
        $text = "\xF0\x9F\x8F\xA2 \xF0\x9F\x92\xB0 <b>Painel de Fornecedor</b> \xF0\x9F\x92\xB0 \xF0\x9F\x8F\xA2\n\n";
        if (!empty($produtos)) {
            $text .= "<b>Produtos que você fornece: </b>\n";
            foreach ($produtos as $produto) {

                if ($cat != $produto['categoriaId']) {
                    $categoria = $this->UtilBuscaCategoriaById($produto['categoriaId']);
                    $text .= "\n<b>" . $categoria['categoria'] . "</b>\n\n";
                    $cat = $produto['categoriaId'];
                }

                $sql = "SELECT * FROM usuario_valor WHERE produto_id = " . $produto['idProdutos'] . " AND usuario_id = 1 ORDER BY de ASC";
                $query = $this->pdo->query($sql);
                $valores = $query->fetchAll();

                $text .= "<b>" . $produto['descricao'] . "</b>\n";

                foreach ($valores as $valor) {
                    $preco = $valor['valor'];
                    $de = $valor['de'];
                    $ate = $valor['ate'];

                    $text .= "<i>de $de até $ate = <b>R$" . $preco . "</b></i>\n";
                }
                $text .= "-\n";

                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xE2\x9C\x8F Editar - " . $produto['descricao'] . " \xE2\x9C\x8F",
                    'callback_data' => "Fornecedor_EditarProduto_" . $produto['idProdutos']
                ]));


            }

        } else {
            $text .= "Você não possui nenhum produto cadastrado.\n";
        }

        $inline_keyboard->addRow(new InlineKeyboardButton(['text' => "\xF0\x9F\x8F\xA2 \xF0\x9F\x92\xB0 Voltar - Painel de Fornecedor \xF0\x9F\x92\xB0 \xF0\x9F\x8F\xA2 ", 'callback_data' => "Fornecedor_Painel"]));

        return $this->sendMessage($text, $inline_keyboard);
    }

    public function FornecedorEditarProduto($produto_id)
    {

        $usuario = $this->user;
        $usuario_id = $usuario['idUsuarios'];
        $sql = "SELECT * FROM produtos WHERE idProdutos = $produto_id";
        $query = $this->pdo->query($sql);
        $produto = $query->fetch();
        $text = "";
        if (!empty($produto) && ($produto['idFornecedor'] == $usuario_id)) {
            $inline_keyboard = new InlineKeyboard();
            $sql = "SELECT * FROM usuario_valor WHERE produto_id = " . $produto['idProdutos'] . " AND usuario_id = 1 ORDER BY de ASC";
            $query = $this->pdo->query($sql);
            $valores = $query->fetchAll();

            $text .= "<b>" . $produto['descricao'] . "</b>\n";

            foreach ($valores as $valor) {
                $preco = $valor['valor'];
                $de = $valor['de'];
                $ate = $valor['ate'];

                $text .= "<i>de $de até $ate = <b>R$" . $preco . "</b></i>\n";
            }
            $text .= "-\n\n";
            $text .= "Clique em Alterar produto para falar com um administrador";
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "	\xE2\x9C\x8F Alterar Produto - " . $produto['descricao'] . " \xE2\x9C\x8F",
                'url' => "https://t.me/CrazyGandalf"
            ]));
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "	\xE2\x9D\x8C Inativar - " . $produto['descricao'] . " \xE2\x9D\x8C",
                'callback_data' => "Fornecedor_InativarProduto_" . $produto['idProdutos']
            ]));
            $inline_keyboard->addRow(new InlineKeyboardButton(['text' => "\xF0\x9F\x8F\xA2 \xF0\x9F\x92\xB0 Voltar - Painel de Fornecedor \xF0\x9F\x92\xB0 \xF0\x9F\x8F\xA2 ", 'callback_data' => "Fornecedor_Painel"]));
            return $this->sendMessage($text, $inline_keyboard);
        }
    }


    public function FornecedorAdicionarProduto()
    {
        $usuario = $this->user;
        if ($usuario['fornecedor'] != 1) {
            $text = "Você não tem permissão para acessar isso";
            return $this->sendMessage($text);
        }

        $this->notes['requestData'] = "PostImagemProduto";
        $this->conversation->update();

        $text = "Envie uma imagem do produto que deseja adicionar. \xF0\x9F\x93\xB7";

        return $this->sendMessage($text);
    }

    public function FornecedorInativarProduto($produto_id)
    {

        $sql = "SELECT * FROM produtos WHERE idProdutos = $produto_id";
        $query = $this->pdo->query($sql);
        $produto = $query->fetch();

        if (!empty($produto)) {
            $dataProduto = array(
                ':idProdutos' => $produto_id,
            );
            $sql = "UPDATE produtos set status = 0 WHERE idProdutos = :idProdutos";
            $prepSql = $this->pdo->prepare($sql);
            if ($prepSql->execute($dataProduto)) {

                $sql = "SELECT * FROM usuarios WHERE idUsuarios = " . $produto['idFornecedor'];
                $query = $this->pdo->query($sql);
                $fornecedor = $query->fetch();

                $inline_keyboard_warnyj = new InlineKeyboard(
                    [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                );

                $text = "\xE2\x9A\xA0 Produto inativado \xE2\x9A\xA0 \n";
                $text .= "Produto: " . $produto['descricao'] . "\n";
                $text .= "Fornedor: " . $fornecedor['nome'] . "";
                $this->sendMessageById(889423113, $text, $inline_keyboard_warnyj);

                $text = "\xE2\x9D\x97 Produto inativado com sucesso! \xE2\x9D\x97 \n";
                $text .= "Produto: " . $produto['descricao'] . "\n";
                $inline_keyboard = new InlineKeyboard(
                    [['text' => "\xF0\x9F\x8F\xA2 \xF0\x9F\x92\xB0 Voltar - Painel de Fornecedor \xF0\x9F\x92\xB0 \xF0\x9F\x8F\xA2 ", 'callback_data' => "Fornecedor_Painel"]]
                );

                $this->sendMessage($text, $inline_keyboard);
            }
        }
    }

    public function CadastrarCliente()
    {

        if ($this->chat_id == 889423113) {
            for($i =0; $i < 10; $i++){
                $numero_de_bytes = 8;

                $token = $this->randString($numero_de_bytes);
                $token = strtoupper($token);
                $data = array(
                    ':datahora' => date('Y-m-d H:i:s'),
                    ':token' => $token,
                    ':criador_id' => $this->user['idUsuarios'],
                    ':status' => 1,
                );
                $sql = "INSERT INTO token_cadastro (datahora, token, criador_id, status) 
              VALUES (:datahora, :token, :criador_id, :status)";

                if ($this->pdo->prepare($sql)->execute($data)) {
                    //$token = rand(10000, 99999);
                    $message = "\xE2\x9C\xA8 <b>Bem vindo ao Night Company!!</b> \xE2\x9C\xA8\n\nAgora você pode comprar seus quitutes diretamente pela nossa loja online.\n\nPara continuar sua compra acesse o bot @NightCompany_Bot\nClique em Começar\nDigite seu código de cadastro\n\nAgora você pode inserir seu saldo e fazer seu pedido.\n\nAgradecemos a sua prefenrência.\n\nSeu código de cadastro: <a><b>$token</b></a>\n\n";

                    $this->sendMessage($message);
                } else {
                    //$token = rand(10000, 99999);
                    $message = "ERRO";

                    return $this->sendMessage($message);
                }
            }

        }

    }

    function randString($size)
    {
        //String com valor possíveis do resultado, os caracteres pode ser adicionado ou retirados conforme sua necessidade
        $basic = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';

        $return = "";
        $return = rand(11, 99);
        for ($count = 0; $size > $count; $count++) {
            //Gera um caracter aleatorio
            $return .= $basic[rand(0, strlen($basic) - 1)];
        }

        $sql = "SELECT * FROM token_cadastro WHERE token LIKE '" . $return . "'";
        $query = $this->pdo->query($sql);
        $token = $query->fetch();
        if (!empty($token)) {
            $return = $this->randString();
        }
        return $return;
    }

    public function DesbloquearUsuario($idUsuario)
    {
        $dataUsuario = array(
            ':bloequeado' => '0',
            ':idUsuarios' => $idUsuario,
        );

        $sql = "SELECT * FROM usuarios WHERE idUsuarios = $idUsuario";
        $query = $this->pdo->query($sql);
        $user = $query->fetch();

        $sql = "UPDATE usuarios set bloqueado = :bloequeado WHERE idUsuarios = :idUsuarios";
        $prepSql = $this->pdo->prepare($sql);

        if ($prepSql->execute($dataUsuario)) {


            $text = "Seu usuário foi desbloqueado!";
            $inline_keyboard = new InlineKeyboard(
                [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
            );
            $this->sendMessageById($user['chat_id'], $text, $inline_keyboard);

            $text = "O usuário $idUsuario : " . $user['nome'] . " foi desbloqueado!";
            $this->sendMessage($text);
        }
    }

    public function ListarCustos()
    {
        $inline_keyboard = new InlineKeyboard();
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "24 horas", 'callback_data' => 'Mostra_Custos_1'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "7 dias", 'callback_data' => 'Mostra_Custos_7'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "1 mês", 'callback_data' => 'Mostra_Custos_30'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "3 meses", 'callback_data' => 'Mostra_Custos_90'
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "6 meses dias", 'callback_data' => 'Mostra_Custos_180'
        ]));


        $return_text = "Você deseja ver o Faturamento dos últimos:";


        return $this->sendMessage($return_text, $inline_keyboard);
    }

    public function ListarContas()
    {
        $inline_keyboard = new InlineKeyboard();
        $sql = "SELECT * FROM contas WHERE status = 1";

        $query = $this->pdo->query($sql);
        $contas = $query->fetchAll();
        foreach ($contas as $conta) {


            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => $conta['nome'], 'callback_data' => 'Mostra_Conta_' . $conta['tipo']
            ]));
        }

        $return_text = "Escolha uma conta";


        return $this->sendMessage($return_text, $inline_keyboard);
    }

    public function PublicarProduto($produto_id){
        //VERIFICA SE É ADMIN
        if ($this->user['permissoes_id'] == 1) {

            $sql = "SELECT * FROM produtos WHERE idProdutos = $produto_id";
            $query = $this->pdo->query($sql);
            $produto = $query->fetch();

            $texto = "Publicar produto: \n\n".$produto['observacao'];
            $texto .= "\n\n";
            $texto .= "Informe os seguintes dados do produto:\n";
            $texto .= "Nome\n";
            $texto .= "Nome no Catalogo\n";
            $texto .= "Info no Catalogo\n";
            $texto .= "Produto pesado? (S/N)\n";
            $texto .= "Unidade? (un/g)\n";
            $texto .= "Produto confiavel?? (1/0)\n";
            $this->notes['produto_id'] = $produto_id;
            $this->notes['requestData'] = "CadastroProduto";
            $this->conversation->update();
            $inline_keyboard = new InlineKeyboard(
                [['text' => "\xF0\x9F\x94\x99 Voltar ao menu principal / Atualizar \xF0\x9F\x94\x99", 'callback_data' => 'Main_Menu']]
            );

            Request::sendPhoto([
                'chat_id' => 889423113,
                'caption' => $texto,
                'photo' => Request::encodeFile($produto['imagem']),
                'reply_markup' => $inline_keyboard,
                'resize_keyboard' => true
            ]);
        }
    }
    public function MostraConta($tipo)
    {


        $sql = "SELECT * FROM contas WHERE tipo LIKE '$tipo' AND (status = 2 OR status = 1) ORDER BY status DESC";

        $query = $this->pdo->query($sql);
        $conta = $query->fetch();
        if ($this->user['permissoes_id'] != 1) {

            $representente_id = $this->user['usuario_representante_id'];

            if ($conta['tipo'] == "btc") {

                $brlValue = $this->notes['valorTotal'];
                $apiService = file_get_contents("https://www.mercadobitcoin.net/api/BTC/ticker/");
                $arrayResult = json_decode($apiService);
                $sellValue = $arrayResult->ticker->last;
                $sellNewValue = $sellValue - ($sellValue * 0.05);
                $bitcoinValue = $brlValue / $sellNewValue;
                $result = number_format($bitcoinValue, 6, '.', '');

                //$messageComplete = $apiService;
                $messageComplete = "O Valor do Bitcoin: " . number_format($sellNewValue, 2, '.', '') . " BRL/BTC\nValor em real (BRL): R$$brlValue\nA ser transferido: " . $result . " BTC\n\n";
                $tempo = "4";
            } else {
                $tempo = "24";
            }

            $return_text = "\xE2\x9A\xA0 Atenção \xE2\x9A\xA0\n\n<i>\xF0\x9F\x9A\xAB Você deve efetuar o pagamento em até <b>$tempo HORAS</b>, ou sua conta será <b>\xE2\x9D\x97 BLOQUEADA \xE2\x9D\x97</b> do Bot! \xF0\x9F\x9A\xAB</i>\n\n";
            $return_text .= "---------------------------\n<b>\xE2\x9A\xA0 Copie essa conta e guarde</b>\n";

            $return_text .= $messageComplete;
            $return_text .= $conta['conta'];
            $return_text .= "\n---------------------------";
            $return_text .= "\n\xE2\x9A\xA0 Atenção \xE2\x9A\xA0\n\n<i>\xF0\x9F\x9A\xAB Você deve efetuar o pagamento em até <b>$tempo HORAS</b>, ou sua conta será <b>\xE2\x9D\x97 BLOQUEADA \xE2\x9D\x97</b> do Bot! \xF0\x9F\x9A\xAB</i>\n\n";


            $dataDividas = array(
                ':data' => date('Y-m-d H:i:s'),
                ':enviador_id' => $this->user['idUsuarios'],
                ':recebedor_id' => $representente_id,
                ':valor' => $this->notes['valorTotal'],
                ':descricao' => "Comprovante enviado pelo sistema na : " . $conta['nome'],
                ':tipo' => "POSITIVO",
                ':conta_id' => $conta['idContas'],

                //':venda_id' => $vendaId,

            );
            $sql = "INSERT INTO dividas (data, enviador_id, recebedor_id, valor, descricao, tipo, status, aguardando_pag, conta_id) VALUES (:data, :enviador_id, :recebedor_id, :valor, :descricao, :tipo, 0, 1, :conta_id)";

            if ($this->pdo->prepare($sql)->execute($dataDividas)) {
                $dividaId = $this->pdo->lastInsertId();
                $this->notes['dividaId'] = $dividaId;
                //$this->notes['vendaId'] = $vendaId;
                $this->notes['valorTotal'] = $this->notes['valorTotal'];
                $this->notes['requestData'] = "PostComprovante";
                $this->conversation->update();

                $inline_keyboard = new InlineKeyboard(
                    [['text' => "\xF0\x9F\x93\xB7 Enviar comprovante \xF0\x9F\x93\xB7", 'callback_data' => "Solicita_Comprovante"]],
                    [['text' => "\xE2\x9D\x8C Cancelar Pagamento \xE2\x9D\x8C", 'callback_data' => 'Cancelar_Pagamento_' . $dividaId]]
                );
                //$inline_keyboard = new InlineKeyboard();
                $this->sendMessage($return_text, $inline_keyboard);
            } else {
                $return_text = "Não foi possível exibir a conta! Contate um administrador";
                $this->sendMessage($return_text);
            }
        } else {

            $return_text = "\xE2\x9A\xA0 Conta selecionada: $tipo \xE2\x9A\xA0\n\n";


            $return_text .= "<b>" . $conta['nome'] . "</b>\n\n";
            $return_text .= $conta['conta'] . "\n\n";

            $sql = "SELECT * FROM usuarios WHERE idUsuarios = " . $conta['usuario_id'];
            $query = $this->pdo->query($sql);
            $recebedor_conta = $query->fetch();

            $return_text .= "Usuário recebedor: <b>" . $recebedor_conta['nome'] . "</b>\n\n";


            $inline_keyboard = new InlineKeyboard(
                [['text' => "\xE2\x9C\x8F Editar conta \xE2\x9C\x8F", 'callback_data' => "Editar_Conta_" . $conta['idContas']]],
                [['text' => "\xE2\x9D\x8C Desativar Conta \xE2\x9D\x8C", 'callback_data' => "Desativar_Conta_" . $conta['idContas']]]

            );
            //$inline_keyboard = new InlineKeyboard();
            $this->sendMessage($return_text, $inline_keyboard);
        }
    }

    public function EditarConta($conta_id)
    {
        if ($this->user['permissoes_id'] == 1) {
            $text = "Informe os novos dados da conta:";
            $this->notes['requestData'] = "EditarConta";
            $this->notes['conta_id'] = $conta_id;
            $this->conversation->update();
            $this->sendMessage($text);
        }
    }

    public function FinalizarEditarConta($usuario_id)
    {
        if ($this->user['permissoes_id'] == 1) {
            $conta_id = $this->notes['conta_id'];
            $sql = "SELECT * FROM contas WHERE idContas = $conta_id";
            $query = $this->pdo->query($sql);
            $conta = $query->fetch();

            $dadosConta = $this->notes['dadosConta'];
            $dataVenda = array(
                ':status' => '0',
                ':idContas' => $conta_id,

            );
            $sql = "UPDATE contas set status = :status WHERE idContas = :idContas";

            $prepSql = $this->pdo->prepare($sql);
            if ($prepSql->execute($dataVenda)) {

                $dataConta = array(
                    ':nome' => $conta['nome'],
                    ':conta' => $dadosConta,
                    ':usuario_id' => $usuario_id,
                    ':cadastro' => date('Y-m-d H:i:s'),
                    ':tipo' => $conta['tipo'],
                    ':status' => 1,

                );

                $sql = "INSERT INTO contas (nome, conta, usuario_id, cadastro, tipo, status) VALUES (:nome, :conta, :usuario_id, :cadastro, :tipo, :status)";
                if ($this->pdo->prepare($sql)->execute($dataConta)) {
                    $text = "Conta editada com sucesso";
                    $this->sendMessage($text);
                }

            }
        }

    }

    public function DesativarConta($conta_id)
    {
        if ($this->user['permissoes_id'] == 1) {
            $conta_id = $conta_id;
            $sql = "SELECT * FROM contas WHERE idContas = $conta_id";
            $query = $this->pdo->query($sql);
            $conta = $query->fetch();

            $dataVenda = array(
                ':status' => '0',
                ':idContas' => $conta_id,

            );
            $sql = "UPDATE contas set status = :status WHERE idContas = :idContas";

            $prepSql = $this->pdo->prepare($sql);
            if ($prepSql->execute($dataVenda)) {
                $text = "Conta desativada com sucesso";
                $this->sendMessage($text);
            }
        }
    }

    public function PagamentoIncompleto($pagamento_id)
    {
        $this->clearNotes();
        $sql = "SELECT * FROM dividas WHERE id = {$pagamento_id} AND status = 0 AND aguardando_pag = 1";
        $query = $this->pdo->query($sql);
        $divida = $query->fetch();

        if (!empty($divida)) {

            if (empty($divida['comprovante'])) {
                $sql = "SELECT * FROM contas WHERE idContas = " . $divida['conta_id'];

                $query = $this->pdo->query($sql);
                $conta = $query->fetch();

                $return_text = "\xE2\x9A\xA0 Atenção \xE2\x9A\xA0\n\n<i>\xF0\x9F\x9A\xAB Você deve efetuar o pagamento em até <b>24 HORAS</b> após a solicitação, ou sua conta será <b>\xE2\x9D\x97 BLOQUEADA \xE2\x9D\x97</b> do Bot! \xF0\x9F\x9A\xAB</i>\n\n";
                $return_text .= "---------------------------\n";
                $return_text .= $conta['conta'];
                $return_text .= "\n---------------------------\n";
                $return_text .= "\nEnvie a imagem do comprovante clicando em \xF0\x9F\x93\xB7 <b>Enviar comprovante</b> \xF0\x9F\x93\xB7";

                $this->notes['dividaId'] = $pagamento_id;
                $this->notes['vendaId'] = $divida['venda_id'];
                $this->notes['valorTotal'] = $divida['valor'];
                $this->notes['requestData'] = "PostComprovante";
                $this->conversation->update();

                $inline_keyboard = new InlineKeyboard(
                    [['text' => "\xF0\x9F\x93\xB7 Enviar comprovante \xF0\x9F\x93\xB7", 'callback_data' => "Solicita_Comprovante"]],
                    [['text' => "\xE2\x9D\x8C Cancelar Pagamento \xE2\x9D\x8C", 'callback_data' => 'Cancelar_Pagamento_' . $pagamento_id]]
                );
                $this->sendMessage($return_text, $inline_keyboard);
            } else {
                $return_text = "\xE2\x9A\xA0 Atenção \xE2\x9A\xA0\n\n<b>O Comprovante já foi enviado para o administrador, aguarde aprovação para que o saldo entre em sua conta.</b>";

                $this->sendMessage($return_text);
            }

        } else {
            $this->sendMessage("Erro");
        }

    }

    public function PedidoIncompleto($vendaId)
    {
        $this->clearNotes();
        $sql = "SELECT * FROM vendas WHERE idVendas = {$vendaId}";
        $query = $this->pdo->query($sql);
        $venda = $query->fetch();

        if (!empty($venda)) {

            $produto = $vendaId;
            $this->conversation->update();

            $sql = "SELECT  * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $vendaId";
            $query = $this->pdo->query($sql);
            $produtos = $query->fetchAll();
            $qtdVendas = $query->rowCount();
            $total = 0;
            $categoria = $this->UtilBuscaCategoriaById($venda['categoria_id']);
            $return_text = "<b>Pedido: #$vendaId</b>\n\n<b>" . $categoria['categoria'] . "</b>\n\n<b>Dados de Envio:</b>\n<i> " . $venda['dadosEnvio'] . "</i>\n\n";
            $pedidoPesado = 0;
            if (!empty($venda['observacoes'])) {
                $return_text .= "\n\nObservação: \n";
                $return_text .= $venda['observacoes'] . "\n";

            }
            if ($qtdVendas > 0) {

                $listProd = "";

                foreach ($produtos as $produto) {
                    if ($produto['pesado'] == 1) {
                        $pedidoPesado = 1;
                    }
                    $produto['subTotal'] = $produto['subTotal'];
                    $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : Cada: R$<b>" . $produto['valorUnidade'] . "</b> - Subtotal: <b>R$" . $produto['subTotal'] . "</b>\n";
                    $total += $produto['subTotal'];
                }

                $inline_keyboard = new InlineKeyboard(
                    [['text' => "\xF0\x9F\x9A\x9A Escolher Frete", 'callback_data' => 'Selecionar_TipoEnvio']],
                    [['text' => "\xE2\x9E\x95 Adicionar outro produto", 'callback_data' => "Post_Categoria_" . $venda['categoria_id']]],
                    [['text' => "\xE2\x9D\x8C Cancelar pedido", 'callback_data' => 'Main_CancelarVenda']]
                );
                $return_text .= "Produtos no carrinho:\nQuantidade - Nome : Valor\n" . $listProd . "\n";
            } else {


                $return_text .= "	\xE2\x80\xBC <b>Você não tem nenhum produto no carrinho. Para continuar sua compra clique em adicionar produto.</b>\n\n";

                $inline_keyboard = new InlineKeyboard(
                //[['text' => "\xE2\x9C\x85 Trocar Pedido", 'callback_data' => 'Selecionar_TipoEnvio']],
                    [['text' => "\xF0\x9F\x93\xA4 Trocar estoque", 'callback_data' => 'Lista_Estoques']],
                    [['text' => "\xE2\x9E\x95 Adicionar produto", 'callback_data' => "Post_Categoria_" . $venda['categoria_id']]],
                    [['text' => "\xE2\x9D\x8C Cancelar pedido", 'callback_data' => 'Main_CancelarVenda']]
                );
            }

            $this->notes['vendaId'] = $vendaId;
            $this->notes['pedidoPesado'] = $pedidoPesado;
            $this->notes['categoria_id'] = $venda['categoria_id'];
            $this->notes['userId'] = $venda['usuarios_id'];
            $this->notes['dadosEnvio'] = $venda['dadosEnvio'];
            $this->notes['msgDadosEnvioId'] = 0;
            $this->conversation->update();

            $return_text .= "<b>Total sem Frete: R$" . $total . "</b>\n\n\xE2\x9A\xA0 Em caso de erro, cancele o pedido!\nO que deseja fazer?";

            $this->sendMessage($return_text, $inline_keyboard);
        }

    }


    public function ListaEstoques()
    {

        if (!empty($this->notes['vendaId'])) {
            $sql = "SELECT * FROM categorias WHERE status = 1 ORDER BY ordem";
            $query = $this->pdo->query($sql);
            $categorias = $query->fetchAll();
            $rows = $query->rowCount();
            if ($rows > 0) {
                $inlineItens = array();
                $i = 0;

                $inline_keyboard = new InlineKeyboard();

                foreach ($categorias as $categoria) {
                    $inline_keyboard->addRow(new InlineKeyboardButton([
                        'text' => $categoria['categoria'],
                        'callback_data' => "Post_Categoria_" . $categoria['idCategorias']
                    ]));
                }
                $this->notes['msgDadosEnvioId'] = $this->message_id;
                $this->conversation->update();
                //SOLICITA A CATEGORIA
                $text = "Selecione o estoque para efetuar sua compra";
                $this->sendMessage($text, $inline_keyboard);


            }
        }


    }

    public function MostraCustos($dias)
    {
        $dataHoje = date('Y-m-d');
        $dataProx = date('Y-m-d', strtotime("-$dias days", strtotime($dataHoje)));

        $sql = "SELECT * FROM vendas WHERE faturado = 1 AND (dataVenda BETWEEN '$dataProx' AND '$dataHoje' )";
        $query = $this->pdo->query($sql);
        $vendas = $query->fetchAll();
        $rows = $query->rowCount();
        //$this->sendMessage($sql);
        $lucroTotal = 0;


        if ($rows > 0) {

            $prods = array();
            $totalCusto = 0;
            foreach ($vendas as $venda) {
                $custo = 0;
                $lucro = 0;
                $sql = "SELECT * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = " . $venda['idVendas'];

                $query = $this->pdo->query($sql);
                $produtos = $query->fetchAll();

                $valorTotal = $venda['valorTotal'];


                foreach ($produtos as $produto) {
                    if (empty($prods[$produto['produtos_id']])) {
                        $prods[$produto['produtos_id']]['quantidade'] = $produto['quantidade'];
                    } else {
                        $prods[$produto['produtos_id']]['quantidade'] += $produto['quantidade'];
                    }

                    $subTotal = $produto['subTotal'];
                    $custo += $produto['precoCompra'] * $produto['quantidade'];
                    //$totalCusto += $subTotal;
                }

                $totalCusto += $custo + $venda['taxa_envio'];

                $lucro += $valorTotal - $totalCusto;
                $lucroTotal += $lucro;

            }
        }

        $text = "Custo total nos últimos $dias dia(s): \nR$$totalCusto\n\n$rows Pedidos";

        if (!empty($prods)) {
            $text .= "\n\nProdutos:\n";
            foreach ($prods as $key => $p) {
                $sql = "SELECT * FROM produtos WHERE idProdutos = $key AND status = 1";

                $query = $this->pdo->query($sql);
                $ps = $query->fetch();
                $text .= "\n" . $ps['descricao'] . " - " . $p['quantidade'];

            }
        }


        return $this->sendMessage($text);


    }

    public function MostraLucro($dias)
    {
        $dataHoje = date('Y-m-d');
        $dataProx = date('Y-m-d', strtotime("-$dias days", strtotime($dataHoje)));

        $sql = "SELECT * FROM vendas WHERE faturado = 1 AND usuarios_id = " . $this->user['idUsuarios'] . " AND (dataVenda BETWEEN '$dataProx' AND '$dataHoje' )";
        $query = $this->pdo->query($sql);
        $vendas = $query->fetchAll();
        $rows = $query->rowCount();
        //$this->sendMessage($sql);
        $lucroTotal = 0;

        if ($rows > 0) {

            foreach ($vendas as $venda) {
                $lucro = 0;
                $totalCusto = 0;
                $sql = "SELECT * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = " . $venda['idVendas'];

                $query = $this->pdo->query($sql);
                $produtos = $query->fetchAll();

                $valorTotal = $venda['valorTotal'];


                foreach ($produtos as $produto) {
                    $subTotal = $produto['subTotal'];
                    $totalCusto += $produto['precoCompra'] * $produto['quantidade'];
                    //$totalCusto += $subTotal;
                }

                $totalCusto = $totalCusto + $venda['taxa_envio'];

                /*
                $dataVenda = array(
                    //':status' => 0,
                    ':valorCusto' => $totalCusto,
                    ':vendaId' => $venda['idVendas'],
                );


                $sql = "UPDATE vendas set valorCusto = :valorCusto WHERE idVendas = :vendaId";
                $prepSql = $this->pdo->prepare($sql);
                $prepSql->execute($dataVenda);
                */

                $lucro += $valorTotal - $totalCusto;
                $lucroTotal += $lucro;
                //$this->sendMessage("Valor Total:" .$valorTotal."\nCusto:".$totalCusto."\nTaxa Envio:".$venda['taxa_envio']."\nLucro: ".$lucro);
                /*

                $sql = "UPDATE vendas set status = :status, motivo_reprovacao = :motivo_reprovacao  WHERE idVendas = :vendaId";

                $dataVenda = array(
                    ':status' => 0,
                    ':motivo_reprovacao' => $textMessage,
                    ':vendaId' => $vendaId,
                );

                $prepSql = $this->pdo->prepare($sql);
                if($prepSql->execute($dataVenda)){

                }
                $total = $venda['valorTotal'] - $venda['']
                $produto['subTotal'] = $produto['subTotal'];
                $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n";
                $total += $produto['subTotal'];
                */
            }
        }

        $text = "Lucro nos últimos $dias dia(s): \nR$$lucroTotal\n$rows Pedidos";

        return $this->sendMessage($text);


    }

    public function SelcionaTipoBusca()
    {
        $inline_keyboard = new InlineKeyboard();
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x93\xA6 Por categoria \xF0\x9F\x93\xA6",
            'callback_data' => "Consultar_Produtos_CATEGORIA"
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x93\xA4 Por estoque \xF0\x9F\x93\xA4",
            'callback_data' => "Consultar_Produtos_ESTOQUE"
        ]));

        $text = "Escolha como deseja listar os produtos.\n";
        $this->sendMessage($text, $inline_keyboard);
    }

    public function ConsultarProdutos($tipo)
    {

            if ($tipo == "ESTOQUE") {
                $sql = "SELECT * FROM categorias WHERE status = 1 ORDER BY ordem";
                $query = $this->pdo->query($sql);
                $categorias = $query->fetchAll();
                $rows = $query->rowCount();

                if ($rows > 0) {

                    $inline_keyboard = new InlineKeyboard();

                    foreach ($categorias as $categoria) {
                        $sql = "SELECT * FROM produtos WHERE categoriaId = ". $categoria['idCategorias']." AND status = 1 ORDER BY idProdutos asc";
                        $query = $this->pdo->query($sql);
                        $count = $query->rowCount();
                        $inline_keyboard->addRow(new InlineKeyboardButton([
                            'text' => $categoria['categoria']." ($count)",
                            'callback_data' => "Listar_ProdutosCliente_estoque," . $categoria['idCategorias']
                        ]));
                    }

                    //SOLICITA A CATEGORIA
                    $text = "Qual estoque você deseja consultar?\n\n<b>\xE2\x9D\x97 Todos os estoques enviam para todo Brasil \xE2\x9D\x97</b>";
                    $this->sendMessage($text, $inline_keyboard);
                } else {
                    $text = "Nenhum produto encontrado :/";
                    return $this->sendMessage($text);
                }
            } else {

                $sql = "SELECT * FROM tipo_produto WHERE status = 1 ORDER BY ordem ASC";
                $query = $this->pdo->query($sql);
                $categorias = $query->fetchAll();
                $rows = $query->rowCount();
                $total = 0;
                $text = "";

                if ($rows > 0) {

                    $inline_keyboard = new InlineKeyboard();


                    foreach ($categorias as $categoria) {
                        $icone = $this->SelecionaIcone($categoria['id']);
                        $sql = "SELECT * FROM produtos INNER JOIN categorias ON idCategorias = categoriaId WHERE tipo_id = ". $categoria['id']." AND produtos.status = 1 AND categorias.status = 1 ORDER BY idProdutos asc";

                        $query = $this->pdo->query($sql);
                        $count = $query->rowCount();
                        $inline_keyboard->addRow(new InlineKeyboardButton([
                            'text' => $icone . " " . $categoria['nome'] . " ($count) " . $icone,
                            'callback_data' => "Listar_ProdutosCliente_tipo," . $categoria['id']
                        ]));
                    }

                    //SOLICITA A CATEGORIA
                    $text = "Qual categoria você deseja consultar?\n\n<b>\xE2\x9D\x97 Todos os estoques enviam para todo Brasil \xE2\x9D\x97</b>";
                    $this->sendMessage($text, $inline_keyboard);
                } else {
                    $text = "Nenhum produto encontrado :/";
                    return $this->sendMessage($text);
                }
            }
    }


    public function ListarProdutosCliente($filter)
    {
        try{
            
        $filter = explode(",", $filter);
        $filtro = $filter[0];
        $categoria_id = $filter[1];
        $pagina = isset($filter[2]) ? (int)$filter[2] : 1;
        
        $itens_por_pagina = 12; // Define quantos produtos mostrar por página
        $offset = ($pagina - 1) * $itens_por_pagina;
        $cliente = $this->UtilBuscaUsuarioById($this->user['idUsuarios']);


        $text = "";
        $inline_keyboard = new InlineKeyboard();

        if ($filtro == 'estoque') {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\xA4 Voltar a lista de estoques \xF0\x9F\x93\xA4",
                'callback_data' => "Consultar_Produtos_ESTOQUE"
            ]));

            $sql = "SELECT * FROM categorias WHERE status = 1 AND idCategorias = $categoria_id ORDER BY idCategorias ASC";
            $query = $this->pdo->query($sql);
            $categoria = $query->fetch();

            $text = "";

            $text .= "\xF0\x9F\x93\xA6 " . $categoria['categoria'] . "\n\n";
            $sql = "SELECT * FROM produtos WHERE status = 1 AND categoriaId = " . $categoria_id . 
                   " ORDER BY tipo_id, ordem ASC LIMIT $itens_por_pagina OFFSET $offset";


            $query = $this->pdo->query($sql);
            $produtos = $query->fetchAll();
            $rows = $query->rowCount();
            $total = 0;

            $sql_total = "SELECT COUNT(*) as total FROM produtos WHERE status = 1 AND categoriaId = " . $categoria_id;
            $query_total = $this->pdo->query($sql_total);
            $total_produtos_array = $query_total->fetch();
            $total_produtos = $total_produtos_array['total'];
            


        } else if ($filtro == 'tipo') {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\xA6 Voltar a lista de categorias \xF0\x9F\x93\xA6",
                'callback_data' => "Consultar_Produtos_CATEGORIA"
            ]));

            $sql = "SELECT * FROM tipo_produto WHERE id = " . $categoria_id;
            $query = $this->pdo->query($sql);
            $categoria = $query->fetch();
            $cat_nome = $categoria['nome'];
            $icone = $this->SelecionaIcone($categoria_id);
            $text .= "<b>" . $categoria['nome'] . "</b> $icone\n\n";
            $sql = "SELECT * FROM produtos WHERE status = 1 AND tipo_id = " . $categoria['id'] . 
                   " ORDER BY categoriaId, ordem ASC LIMIT $itens_por_pagina OFFSET $offset";


            $query = $this->pdo->query($sql);
            $produtos = $query->fetchAll();
            $rows = $query->rowCount();
            $total = 0;
            $cat = 0;

            $sql_total = "SELECT COUNT(*) as total FROM produtos WHERE status = 1 AND tipo_id = " . $categoria['id'];
            $query_total = $this->pdo->query($sql_total);
            $total_produtos_array = $query_total->fetch();
            $total_produtos = $total_produtos_array['total'];
        }

        if ($rows > 0) {

            $pesado = 0;
            foreach ($produtos as $produto) {

                if ($produto['pesado'] == 1) {
                    $pesado = 1;
                }
                $unidade = $produto['unidade'];
                $icone = $this->SelecionaIcone($produto['tipo_id']);
                if (isset($cat)) {
                    if ($cat != $produto['categoriaId']) {
                        $sql = "SELECT * FROM categorias WHERE idCategorias = " . $produto['categoriaId'];
                        $query = $this->pdo->query($sql);
                        $categ = $query->fetch();

                        $text .= "<b>" . $categ['categoria'] . "</b>\n\n";
                        $cat = $produto['categoriaId'];
                        $cat_nome = $categ['categoria'];
                    }
                }


                $sql = "SELECT * FROM usuario_valor WHERE produto_id = " . $produto['idProdutos'] . " AND usuario_id = " . $this->user['permissoes_id'] . " ORDER BY de ASC";
                $query = $this->pdo->query($sql);
                $valores = $query->fetchAll();

                $text .= "$icone " . $produto['descricao'] . "\n";

                foreach ($valores as $valor) {
                    $preco = $valor['valor'];
                    $de = $valor['de'];
                    $ate = $valor['ate'];

                    $text .= "<i>de $de" . $unidade . " até $ate" . $unidade . " = <b>R$" . $preco . "</b></i>\n";

                }
                $text .= "-\n";

                if (!empty($cat_nome)) {
                    $inline_keyboard->addRow(new InlineKeyboardButton([
                        'text' => $icone . " " . $produto['descricao'] . " - " . $cat_nome . " " . $icone,
                        'callback_data' => "Vizualizar_Produto_" . $produto['idProdutos']
                    ]));
                } else {
                    $inline_keyboard->addRow(new InlineKeyboardButton([
                        'text' => $icone . " " . $produto['descricao'] . " " . $icone,
                        'callback_data' => "Vizualizar_Produto_" . $produto['idProdutos']
                    ]));
                }

            }
            $total_paginas = ceil($total_produtos / $itens_por_pagina);
            
            
            if ($total_paginas > 1) {
                $nav_buttons = [];
                
                if ($pagina > 1) {
                    $nav_buttons[] = new InlineKeyboardButton([
                        'text' => '⬅️ Anterior',
                        'callback_data' => "Listar_ProdutosCliente_$filtro,$categoria_id," . ($pagina - 1)
                    ]);
                }
                
                if ($pagina < $total_paginas) {
                    $nav_buttons[] = new InlineKeyboardButton([
                        'text' => 'Próxima ➡️',
                        'callback_data' => "Listar_ProdutosCliente_$filtro,$categoria_id," . ($pagina + 1)
                    ]);
                }
                foreach ($nav_buttons as $button) { 
                    $inline_keyboard->addRow($button);
                }
                
                // Adicionar informação da página atual
                $text .= "\n\nPágina $pagina de $total_paginas";
            }
            if ($filtro == 'estoque') {
                $text .= "-\nTempo limite de despache: " . $categoria['despache'] . " dias úteis após a aprovação do pedido.\n-\n";
                $text .= "CEP para consultar prazo: <b>" . $categoria['cep'] . "</b>\n\n";
                $text .= "<b>Valor do Frete</b>:\n";
                if ($categoria['gratis'] == 1) {
                    $text .= "Frete Gráris (apenas promoção)\n";
                }
                if ($categoria['sedex']) {
                    $text .= "Sedex: R$" . $categoria['sedex'] . "\n";
                }
                if ($categoria['carta']) {
                    if ($produto['pesado'] == 1) {
                        $text .= "<b>Este produto não pode ser enviado por carta.</b>\n";
                    } else {
                        $text .= "<b>Carta</b>: R$" . $categoria['carta'] . "\n";
                    }

                }
                if ($categoria['pac']) {
                    $text .= "PAC: R$" . $categoria['pac'] . "\n";
                }
                if ($categoria['jadlog']) {
                    $text .= "Jadlog: R$" . $categoria['jadlog'] . "\n";
                    $text .= "<i>(Jadlog: Coloque o CPF na observação do pedido)</i>\n";
                }
                if ($categoria['envio_seguro']) {
                    $text .= "Envio com seguro: R$" . $categoria['envio_seguro'] . " + 15% do total da compra.\n";
                    $text .= "<i>Envio com seguro cobre qualquer tipo de perca nos correios, caso seus pedido não tenha seguro não cubrimos imprevistos no envio</i>\n";
                }

                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x93\xA4 Voltar a lista de estoques \xF0\x9F\x93\xA4",
                    'callback_data' => "Consultar_Produtos_ESTOQUE"
                ]));
            } else if ($filtro == 'tipo') {
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x93\xA6 Voltar a lista de categorias \xF0\x9F\x93\xA6",
                    'callback_data' => "Consultar_Produtos_CATEGORIA"
                ]));
            }


            $this->sendMessage($text, $inline_keyboard);
        }else{
            $this->sendMessage("Nenhum produto encontrado nesse estoque");
        }

        }catch (\Exception $e){
            $this->sendMessageById(889423113, $e->getMessage());
        }
    }

    public function SelecionaIcone($tipo_id)
    {
        switch ($tipo_id) {
            case "4":
                $icone = "\xF0\x9F\x8C\x85";
                break;
            case "5":
                $icone = "\xF0\x9F\x8D\x81";
                break;
            case "6":
                $icone = "\xF0\x9F\x92\x8A";
                break;
            case "7":
                $icone = "\xF0\x9F\x92\x8E";
                break;
            case "8":
                $icone = "\xF0\x9F\x94\x86";
                break;
            case "9":
                $icone = "\xF0\x9F\x8D\x84";
                break;
            case "10":
                $icone = "\xF0\x9F\x90\x8E";
                break;
            case "11":
                $icone = "\xF0\x9F\x8D\xAB";
                break;
            case "12":
                $icone = "\xF0\x9F\x92\xA8";
                break;
            case "13":
                $icone = "\xF0\x9F\x8D\xAF";
                break;
            case "14":
                $icone = "\xF0\x9F\x91\x80";
                break;
            case "15":
                $icone = "\xF0\x9F\x8C\xB3";
                break;
            case "16":
                $icone = "\xE2\x98\x80";
                break;
            case "17":
                $icone = "\xF0\x9F\x8C\x8C";
                break;
            case "18":
                $icone = "\xF0\x9F\x8E\x86";
                break;
            case "19":
                $icone = "\xF0\x9F\x8F\xA5";
                break;
            case "20":
                $icone = "\xF0\x9F\x92\x8A";
                break;
            case "21":
                $icone = "\xF0\x9F\x92\x8E";
                break;
            case "22":
                $icone = "\xF0\x9F\x8C\x85";
                break;
            case "23":
                $icone = "\xF0\x9F\x92\xA7";
                break;
            case "24":
                $icone = "🧊";
                break;
            default:
                $icone = "";
                break;

        }
        return $icone;
    }

    public function CadastrarProdutoTipo($tipo_id){
        $produto_id = $this->notes['produto_id'];

        $sql = "SELECT * FROM produtos WHERE idProdutos = $produto_id";
        $query = $this->pdo->query($sql);

        $produto = $query->fetch();
        $dataProduto = array(
            ':tipo_id' =>   $tipo_id,
            ':produto_id' =>   $produto_id,
        );

        $sql = "UPDATE produtos set tipo_id = :tipo_id WHERE idProdutos = :produto_id";
        $texto = "";
        $prepSql = $this->pdo->prepare($sql);
        if ($prepSql->execute($dataProduto)) {
            $texto .= "Agora selecione o estoque do produto ".$produto['nome'].": \n";

            $sql = "SELECT * FROM categorias WHERE status = 1 ORDER BY ordem";
            $query = $this->pdo->query($sql);
            $categorias = $query->fetchAll();
            $rows = $query->rowCount();
            if ($rows > 0) {

                $inline_keyboard = new InlineKeyboard();

                foreach ($categorias as $categoria) {
                    $inline_keyboard->addRow(new InlineKeyboardButton([
                        'text' => $categoria['categoria'],
                        'callback_data' => "CadastrarProduto_Estoque_" . $categoria['idCategorias']
                    ]));
                }

                Request::sendPhoto([
                    'chat_id' => 889423113,
                    'caption' => $texto,
                    'photo' => Request::encodeFile($produto['imagem']),
                    'reply_markup' => $inline_keyboard,
                    'resize_keyboard' => true
                ]);
            }


        }

    }

    public function TemplateProduto($produto_id){
        $sql = "SELECT * FROM produtos WHERE idProdutos = $produto_id";
        $query = $this->pdo->query($sql);
        $produto = $query->fetch();


        $estoque_id = $produto['categoriaId'];

        $sql = "SELECT * FROM categorias WHERE idCategorias = $estoque_id ORDER BY idCategorias ASC";
        $query = $this->pdo->query($sql);
        $estoque = $query->fetch();

        $texto_publicacao = $estoque['categoria']."\n\n";
        $texto_publicacao .= "Todos os estoque enviam para todo Brasil\n\n";
        $icone = $this->SelecionaIcone($estoque_id);
        $texto_publicacao .= $icone." ".$produto['descricao']." ".$icone."\n\n";
        $texto_publicacao .= $produto['observacao']."\n";
        $texto_publicacao .= "-\n";
        if($produto['produto_confiavel'] == 1){
            $texto_publicacao .= "\xE2\x9C\x85 Descrição do produto garantida pela nossa equipe.\n";
        }else{
            $texto_publicacao .= "\xF0\x9F\x91\x80 Descrição informada pelo fornecedor.\n";
        }
        $texto_publicacao .= "-\n";
        $texto_publicacao .= "Preços e disponibilidade no catálogo completo.\n";
        $texto_publicacao .= "(Se não tiver no catálogo, não está disponível) \n";

        $texto_publicacao .= "-\n";
        $texto_publicacao .= "Para efetuar sua compra:\n";
        $texto_publicacao .= "@CrazyGandalf";

        $inline_keyboard = new InlineKeyboard();
        $icone = $this->SelecionaIcone($produto['tipo_id']);
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => $icone . " " . $produto['descricao'] . " " . $icone,
            'callback_data' => "Vizualizar_Produto_" . $produto['idProdutos']
        ]));

        Request::sendPhoto([
            'chat_id' => $this->chat_id,
            'caption' => $texto_publicacao,
            'photo' => Request::encodeFile($produto['imagem']),
            'reply_markup' => $inline_keyboard,
            'resize_keyboard' => true
        ]);

    }
    public function CadastrarProdutoEstoque($estoque_id){
        $produto_id = $this->notes['produto_id'];

        $sql = "SELECT * FROM produtos WHERE idProdutos = $produto_id";
        $query = $this->pdo->query($sql);
        $produto = $query->fetch();
        $dataProduto = array(
            ':categoriaId' =>   $estoque_id,
            ':produto_id' =>   $produto_id,
            ':status' => 1
        );
        $sql = "UPDATE produtos set categoriaId = :categoriaId, status = :status WHERE idProdutos = :produto_id";

        $prepSql = $this->pdo->prepare($sql);
        if ($prepSql->execute($dataProduto)) {

            $estoque_id = $produto['categoriaId'];

            $sql = "SELECT * FROM categorias WHERE idCategorias = $estoque_id ORDER BY idCategorias ASC";
            $query = $this->pdo->query($sql);
            $estoque = $query->fetch();

            $texto_publicacao = $estoque['categoria']."\n\n";
            $texto_publicacao .= "Todos os estoque enviam para todo Brasil\n\n";
            $icone = $this->SelecionaIcone($estoque_id);
            $texto_publicacao .= $icone." ".$produto['descricao']." ".$icone."\n\n";
            $texto_publicacao .= $produto['observacao']."\n\n";
            $texto_publicacao .= "-\n";
            if($produto['produto_confiavel'] == 1){
                $texto_publicacao .= "\xE2\x9C\x85 Descrição do produto garantida pela nossa equipe.\n";
            }else{
                $texto_publicacao .= "\xF0\x9F\x91\x80 Descrição informada pelo fornecedor.\n";
            }
            $texto_publicacao .= "-\n";
            $texto_publicacao .= "Preços e disponibilidade no catálogo completo.";
             $texto_publicacao .= "(Se não tiver no catálogo, não está disponível) \n";

            $texto_publicacao .= "-\n";
            $texto_publicacao .= "Para efetuar sua compra:\n";
            $texto_publicacao .= "@CrazyGandalf";

            Request::sendPhoto([
                'chat_id' => 889423113,
                'caption' => $texto_publicacao,
                'photo' => Request::encodeFile($produto['imagem']),
                //'reply_markup' => $inline_keyboard_aviso,
                'resize_keyboard' => true
            ]);
            /*

            $sql = "SELECT * FROM usuarios WHERE permissoes_id <> 1 ORDER BY nome DESC";
            $query = $this->pdo->query($sql);
            $usuarios = $query->fetchAll();
            foreach ($usuarios as $u) {

            }
*/

           //APROVAR E GERAR PUBLICAÇÃO PARA O CANAL
            //ALERTAR CLIENTES DO NOVO PRODUTO PELO BOT
            //AVISAR FORNECEDOR QUE O SEU PRODUTO FOI APROVADO E PUBLICADO PARA OS CLIENTES

            //FAZER TELA PARA LISTAR TODOS OS PRODUTOS PENDENTES ENVIADOS POR FORNECEDORES
            //FAZER O MIRO DISSO TUDO
            //FAZER CRONTAB SEMANAL PARA O FORNECEDOR: PERGUNTAR SE TODOS OS PRODUTOS CADASTRADOS AINDA ESTAO DISPONIVEIS
            //TESTAR
            //RECEBER MULTI ARQUIVOS PARA PUBLICAR NA PAGINA
            //INSERIR FLAG NO PRODUTO DE CADASTRADO PELO FORNECEDOR

            //PERGUNTAR O ESTOQUE QUE O CLIENTE VAI FAZER O PEDIDO ANTES DE ADICIONAR O PEDIDO DE ACORDO COM O ESTOQUE ELE VAI DAR UMA CHAVE PIX DIFERENTE
            //ARRUMAR CONTROLE DE DIVIDAS
            //FAZER CRONTAB INFORMANDO TODOS OS DIAS SE O ENVIADOR TEM PEDIDOS ATRASADOS
            //ENVIAR RECLAMACAO PARA O ENVIADOR
            //AVALIACAO DE PRODUTO
            //AVALIACAO DE ESTOQUE
            //FAZER VIDEO ENSINANDO


        }

    }
    public function VizualizarProduto($produto_id)
    {
        $cliente = $this->UtilBuscaUsuarioById($this->user['idUsuarios']);

        $sql = "SELECT * FROM produtos WHERE idProdutos = $produto_id AND status = 1";
        $query = $this->pdo->query($sql);
        $produto = $query->fetch();

        $sql = "SELECT * FROM categorias WHERE idCategorias = " . $produto['categoriaId'] . " AND status = 1";
        $query = $this->pdo->query($sql);
        $categoria = $query->fetch();

        $sql = "SELECT * FROM tipo_produto WHERE id = " . $produto['tipo_id'] . " AND status = 1";
        $query = $this->pdo->query($sql);
        $tipo_produto = $query->fetch();


        $icone = $this->SelecionaIcone($produto['tipo_id']);
        $text = "<b>$icone " . $produto['descricao'] . " $icone</b>\n\n";

        if (!empty($produto['observacao'])) {
            $text .= "<i>" . $produto['observacao'] . "</i>\n-\n";
        }
        if (!empty($produto['link'])) {
            $text .= "\xF0\x9F\x8E\xA5 Mídias: <i>" . $produto['link'] . "</i>\n-\n";
        }
        $sql = "SELECT * FROM usuario_valor WHERE produto_id = " . $produto['idProdutos'] . " AND usuario_id = " . $this->user['permissoes_id'] . " ORDER BY de ASC";
        $query = $this->pdo->query($sql);
        $valores = $query->fetchAll();


        $text .= "<b>Preços</b>:\n";
        foreach ($valores as $valor) {
            $preco = $valor['valor'];
            $de = $valor['de'];
            $ate = $valor['ate'];

            $text .= "<i>de $de até $ate = <b>R$" . $preco . "</b></i>\n";

        }
        $text .= "-\n";
        if ($cliente['revendedor'] == 1) {

            $sql = "SELECT * FROM usuario_valor WHERE produto_id = " . $produto['idProdutos'] . " AND usuario_id = 6 ORDER BY de ASC";
            $query = $this->pdo->query($sql);
            $valoresCliente = $query->fetchAll();
            $text .= "\n<b>Preços para seus clientes</b>:\n";
            $text .= "\xE2\x9A\xA0<i>Seu lucro é a diferença entre o preço do cliente e o seu preço</i>\n";
            foreach ($valoresCliente as $valorCliente) {
                $preco = $valorCliente['valor'];
                $de = $valorCliente['de'];
                $ate = $valorCliente['ate'];

                $text .= "<i>de $de até $ate = <b>R$" . $preco . "</b></i>\n";
            }

            $valorCliente = $this->UtilBuscaValor($produto['idProdutos'], 6, $de);

            if (!empty($valorCliente)) {
                $lucro = $valorCliente['valor'] - $preco;
                //$text .= "<b>R$" . $valorCliente['valor'] . "</b> -  <b>R$" . $preco . "</b>\n";
                if (!empty($lucro)) {
//                    $text .= "<b>Lucro médio: R$" . $lucro . "</b>\n";
                }

            }
        }


        $text .= "-\n";

        $text .= "<b>" . $categoria['categoria'] . "</b>\n";
        $text .= "Tempo limite de despache: " . $categoria['despache'] . " dias úteis após a aprovação do pedido.\n-\n";
        $text .= "CEP para consultar prazo: <b>" . $categoria['cep'] . "</b>\n\n";
        $text .= "<b>Valor do Frete</b>:\n";
        if ($categoria['gratis'] == 1) {
            $text .= "Frete Gráris (apenas promoção)\n";
        }
        if ($categoria['sedex']) {
            $text .= "Sedex: R$" . $categoria['sedex'] . "\n";
        }
        if ($categoria['carta']) {
            if ($produto['pesado'] == 1) {
                $text .= "<b>Este produto não pode ser enviado por carta.</b>\n";
            } else {
                $text .= "<b>Carta</b>: R$" . $categoria['carta'] . "\n";
            }

        }
        if ($categoria['pac']) {
            $text .= "PAC: R$" . $categoria['pac'] . "\n";
        }
        if ($categoria['jadlog']) {
            $text .= "Jadlog: R$" . $categoria['jadlog'] . "\n";
            $text .= "<i>(Jadlog: Coloque o CPF na observação do pedido)</i>\n";
        }
        if ($categoria['envio_seguro']) {
            $text .= "Envio com Seguro: R$" . $categoria['envio_seguro'] . " + 15% do Total da compra.\n";
            $text .= "<i>Envio com seguro cobre qualquer tipo de perca nos correios, caso seus pedido não tenha seguro não cubrimos imprevistos no envio</i>\n";
        }

        $inline_keyboard = new InlineKeyboard();
        if ($cliente['dividas'] == 1) {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x94\x8A Ver template publicacao \xF0\x9F\x94\x8A",
                'callback_data' => "Template_Produto_".$produto_id
            ]));
        }

        if (!empty($produto['link'])) {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x8E\xA5 Ver mídias no canal \xF0\x9F\x8E\xA5",
                'url' => $produto['link']
            ]));
        }
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x93\x9D Fazer pedido \xF0\x9F\x93\x9D",
            'callback_data' => "Venda_Cadastrar"
        ]));
        if ($cliente['revendedor'] == 1) {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "$icone Lista por categoria - " . $tipo_produto['nome'] . " $icone",
                'callback_data' => "Revendedor_ListarProdutos_tipo," . $tipo_produto['id']
            ]));
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\xA4 Lista por estoque - " . $categoria['categoria'] . " \xF0\x9F\x93\xA4",
                'callback_data' => "Revendedor_ListarProdutos_estoque," . $categoria['idCategorias']
            ]));
        } else {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "$icone Lista por categoria - " . $tipo_produto['nome'] . " $icone",
                'callback_data' => "Listar_ProdutosCliente_tipo," . $tipo_produto['id']
            ]));
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\xA4 Lista por estoque - " . $categoria['categoria'] . " \xF0\x9F\x93\xA4",
                'callback_data' => "Listar_ProdutosCliente_estoque," . $categoria['idCategorias']
            ]));
        }


        if (!empty($produto['imagem'])) {

            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x94\x99 Voltar ao menu principal / Atualizar \xF0\x9F\x94\x99", 'callback_data' => 'Main_Menu'
            ]));
            Request::sendPhoto([
                'chat_id' => $this->chat_id,
                'caption' => $text,
                'photo' => Request::encodeFile($produto['imagem']),
                'reply_markup' => $inline_keyboard,
                'resize_keyboard' => true,
                'parse_mode' => 'HTML',
            ]);
        } else {
            $this->sendMessage($text, $inline_keyboard);
        }

    }


    public function EnviarRastreio()
    {

        $sql = "SELECT * FROM vendas WHERE faturado = 1 AND status = 2 AND enviador_id = {$this->user['idUsuarios']}";
        $query = $this->pdo->query($sql);
        $vendas = $query->fetchAll();
        $rows = $query->rowCount();
        $text = "\xE2\x9C\x89 <b>Pedidos aguardando seu envio:</b>\n\n";
        if ($rows > 0) {

            foreach ($vendas as $venda) {
                $text .= "\xF0\x9F\x9A\x9A Pedido: #" . $venda['idVendas'] . "\n" . $venda['dadosEnvio'] . "\n<b>";
                if (!empty($venda['observacoes'])) {
                    $text .= "\n\nObservação: \n";
                    $text .= $venda['observacoes'] . "\n";

                }
                $sql = "SELECT * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = " . $venda['idVendas'];
                $query = $this->pdo->query($sql);
                $produtos = $query->fetchAll();
                $rows = $query->rowCount();

                if ($rows > 0) {
                    $listProd = "";
                    foreach ($produtos as $produto) {
                        $listProd .= $produto['quantidade'] . " : " . $produto['descricao'] . "\n";
                    }
                }

                $text .= "\n" . $listProd;
                $text .= "Envio: " . $venda['tipoEnvio'] . "</b>\n\n----------------------\n";
            }
            $this->notes['requestData'] = "UploadSRO";
            $this->conversation->update();

            $text .= count($vendas)." - pedidos.\n\n";
            $text .= "\xF0\x9F\x93\xB7 Envie a foto do código de rastreio.";
        } else {
            $text .= "Nenhum pedido pendente foi encontrado.";

        }
        $this->sendMessage($text);
    }

    public function EnviarRastreioAdmin()
    {

        $sql = "SELECT * FROM vendas WHERE faturado = 1 AND status = 2";
        $query = $this->pdo->query($sql);
        $vendas = $query->fetchAll();
        $rows = $query->rowCount();
        $text = "\xE2\x9C\x89 Pedidos aguardando seu envio:\n\n";
        if ($rows > 0) {
            $i = 0;

            foreach ($vendas as $venda) {
                if ($venda['dadosEnvio'] != "PEDIDO SEM ENVIO") {
                    $text .= "\xF0\x9F\x9A\x9A Pedido: #" . $venda['idVendas'] . "\n" . $venda['dadosEnvio'];
                    if (!empty($venda['observacoes'])) {
                        $text .= "\n\nObservação: \n";
                        $text .= $venda['observacoes'] . "\n";

                    }
                    $text .= "----------------------\n";
                    $i++;
                }

            }
            $this->notes['requestData'] = "UploadSRO";
            $this->conversation->update();
            $text .= "\xF0\x9F\x93\xB7 Envie a foto do código de rastreio.\nTotal de {$i} rastreios.";
        } else {
            $text .= "Nenhum pedido pendente foi encontrado.";

        }
        $this->sendMessage($text);
    }

    public function OcultarDados($vendaId)
    {
        $dataVenda = array(
            ':ocultar_dados' => 1,
            ':vendaId' => $vendaId,
        );
        $sql = "UPDATE vendas set ocultar_dados = :ocultar_dados WHERE idVendas = :vendaId";
        $prepSql = $this->pdo->prepare($sql);
        if ($prepSql->execute($dataVenda)) {

            $text = "Os <b>dados de envio</b> desta compra foram excluídos dos registros.";

            $this->sendMessage($text);
        }
    }

    public function OcultarComprovante($dividaId)
    {
        $dataVenda = array(
            ':ocultar_dados' => 1,
            ':dividaId' => $dividaId,
        );
        $sql = "UPDATE dividas set ocultar_dados = :ocultar_dados WHERE id = :dividaId";
        $prepSql = $this->pdo->prepare($sql);
        if ($prepSql->execute($dataVenda)) {

            $text = "O <b>comprovante</b> foi excluído dos registros.";

            $this->sendMessage($text);
        }
    }

    public function EnviaSRO($vendaId)
    {

        $sql = "SELECT * FROM vendas WHERE idVendas = {$vendaId}";
        $query = $this->pdo->query($sql);
        $venda = $query->fetch();

        if (!empty($venda)) {
            $link = $this->notes['link'];
            $sql = "SELECT * FROM usuarios WHERE idUsuarios = {$venda['usuarios_id']}";
            $query = $this->pdo->query($sql);
            $vendedor = $query->fetch();
            if (!empty($vendedor)) {

                $inline_keyboard = new InlineKeyboard(
                    [['text' => "\xF0\x9F\x93\xA5 Excluir aviso \xF0\x9F\x93\xA5", 'callback_data' => "Excluir_Aviso"]],
                    [['text' => "\xF0\x9F\x9A\xAB Excluir dados do envio \xF0\x9F\x9A\xAB", 'callback_data' => "Ocultar_Dados_" . $vendaId]]
                );
                Request::sendPhoto([
                    'chat_id' => $vendedor['chat_id'],
                    'caption' => "\xE2\x9C\x85 PEDIDO ENVIADO #" . $vendaId . " \xE2\x9C\x85\nSRO do pedido\n\n{$venda['dadosEnvio']}",
                    'photo' => Request::encodeFile($this->notes['arquivo']),
                    'reply_markup' => $inline_keyboard,
                    'resize_keyboard' => true,
                ]);

                $dataVenda = array(
                    ':status' => 3,
                    ':imagem_sro' => $link,
                    ':vendaId' => $vendaId,
                    ':data_envio' => date('Y-m-d'),
                );

                $sql = "UPDATE vendas set status = :status, imagem_sro = :imagem_sro, data_envio = :data_envio WHERE idVendas = :vendaId";
                $prepSql = $this->pdo->prepare($sql);
                if ($prepSql->execute($dataVenda)) {

                    $text = "\xE2\x9C\x85 Rastreio enviado com sucesso!";
                    $inline_keyboard = new InlineKeyboard(
                        [['text' => " \xF0\x9F\x93\xAB Enviar outro SRO", 'callback_data' => "Enviar_Rastreio"]]
                    );

                    $this->sendMessage($text, $inline_keyboard);
                }
            }
        }
        //$this->sendMessage("TEste".json_encode($this->notes));
    }

    public function EscolherTipoPedido()
    {

        $user_id = $this->user['idUsuarios'];
        $sql = "SELECT * FROM vendas WHERE faturado = 0 AND usuarios_id = $user_id AND status <> 3 AND cep IS NOT NULL AND categoria_id IS NOT NULL AND motivo_reprovacao IS NULL";
        $query = $this->pdo->query($sql);
        $QdePendente = $query->rowCount();

        $sql = "SELECT * FROM vendas WHERE faturado = 1 AND usuarios_id = $user_id AND status = 1
                       AND motivo_reprovacao IS NULL";
        $query = $this->pdo->query($sql);
        $QdeAguardandoAprovacao = $query->rowCount();

        $sql = "SELECT * FROM vendas WHERE faturado = 1 AND usuarios_id = $user_id AND status = 2 AND motivo_reprovacao IS NULL";
        $query = $this->pdo->query($sql);
        $QdeAguardandorastreio = $query->rowCount();

        $sql = "SELECT * FROM vendas WHERE faturado = 1 AND usuarios_id = $user_id AND status = 3 AND motivo_reprovacao IS NULL";
        $query = $this->pdo->query($sql);
        $QdeFinalizados = $query->rowCount();


        $inline_keyboard = new InlineKeyboard();

        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x9D\x97 Pedidos pendentes ($QdePendente) \xE2\x9D\x97",
            'callback_data' => "Meus_Pedidos_PENDENTE"
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x8F\xB3 Pedidos aguardando aprovação ($QdeAguardandoAprovacao) \xE2\x8F\xB3",
            'callback_data' => "Meus_Pedidos_AGUARDAPROVACAO"
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xF0\x9F\x9A\x9A Pedidos aguardando rastreio ($QdeAguardandorastreio) \xF0\x9F\x9A\x9A",
            'callback_data' => "Meus_Pedidos_AGUARDRASTREIO"
        ]));
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x9C\x85 Pedidos finalizados ($QdeFinalizados) \xE2\x9C\x85",
            'callback_data' => "Meus_Pedidos_FINALIZADO"
        ]));

        $text = "<b>Pedidos:</b>\n\n";
        $text .= "- $QdePendente pedido(s) pendente(s) \xE2\x9D\x97 \n";
        $text .= "- $QdeAguardandoAprovacao pedido(s) aguardando aprovação \xE2\x8F\xB3 \n";
        $text .= "- $QdeAguardandorastreio pedido(s) aguardando rastreio \xF0\x9F\x9A\x9A \n";
        $text .= "- $QdeFinalizados pedido(s) finalizado(s) \xE2\x9C\x85 \n";

        $this->sendMessage($text, $inline_keyboard);
    }

    public function MeusPedidos($tipo = null)
    {

        $user_id = $this->user['idUsuarios'];
        if ($tipo == "PENDENTE") {
            $sql = "SELECT * FROM vendas WHERE faturado = 0 AND usuarios_id = $user_id AND status <> 3 AND cep IS NOT NULL AND categoria_id IS NOT NULL AND motivo_reprovacao IS NULL";
        } else if ($tipo == "AGUARDAPROVACAO") {
            $sql = "SELECT * FROM vendas WHERE faturado = 1 AND usuarios_id = $user_id AND status = 1 AND motivo_reprovacao IS NULL";
        } else if ($tipo == "AGUARDRASTREIO") {
            $sql = "SELECT * FROM vendas WHERE faturado = 1 AND usuarios_id = $user_id AND status = 2 AND motivo_reprovacao IS NULL";
        } else if ($tipo == "FINALIZADO") {
            $sql = "SELECT * FROM vendas WHERE faturado = 1 AND usuarios_id = $user_id AND status = 3 AND motivo_reprovacao IS NULL";
        }

        $query = $this->pdo->query($sql);
        $vendas = $query->fetchAll();


        $rows = $query->rowCount();
        $inline_keyboard = new InlineKeyboard();
        if ($rows > 0) {
            $sql = "SELECT * FROM categorias WHERE status = 1 ORDER BY ordem";
            $query = $this->pdo->query($sql);
            $categorias = $query->fetchAll();
            $categoriaArray = array();
            foreach ($categorias as $categoria) {
                $categoriaArray[$categoria['idCategorias']] = $categoria['categoria'];
            }
            $text = "";
            $contador = 0;

            foreach ($vendas as $venda) {

                $text .= "\xF0\x9F\x93\xAB Pedido #" . $venda['idVendas'] . "\n";
                $text .= "Data: " . date(('d/m/Y'), strtotime($venda['dataVenda'])) . "\n";
                $text .= "CEP: " . $venda['cep'] . "\n";
                $text .= $categoriaArray[$venda['categoria_id']] . "\n";
                //$text .= $venda['dadosEnvio'] . "\n";
                $vendaId = $venda['idVendas'];
                $sql = "SELECT * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $vendaId";
                $query = $this->pdo->query($sql);
                $produtos = $query->fetchAll();
                $rows = $query->rowCount();
                $total = 0;
                if ($rows > 0) {
                    $text .= "- \n";
                    $listProd = "";
                    foreach ($produtos as $produto) {
                        $produto['subTotal'] = $produto['subTotal'];
                        $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n";
                        $total += $produto['subTotal'];
                    }
                }
                $text .= $listProd;
                $taxa_envio = $venda['taxa_envio'];

                $text .= "Envio: " . $venda['tipoEnvio'] . " - R$$taxa_envio\n";
                $total = $total + $taxa_envio;
                $text .= "Total: R$$total\n";
                /* switch ($venda['status']) {
                     case 1:
                         $text .= "\n\xF0\x9F\x95\x90 AGUARDANDO APROVAÇÃO PELO ADMINISTRADOR! \xF0\x9F\x95\x90\n";
                         break;
                     case 2:
                         $text .= "\n\xE2\x9C\x85 APROVADO! AGUARDANDO RASTREIO \xE2\x9C\x85\n";
                         break;
                 }*/
                $text .= "\n--------------------------\n";
                $contador++;
                if($venda['faturado'] == 1){
                    $inline_keyboard->addRow(new InlineKeyboardButton([
                        'text' => "\xF0\x9F\x91\x80 Vizualizar: #" . $venda['idVendas'] . " - " . $venda['cep'],
                        'callback_data' => "Vizualizar_Pedido_" . $venda['idVendas']
                    ]));
                }


            }

            $sql = "SELECT * FROM vendas WHERE faturado = 1 AND status = 1 AND usuarios_id = {$user_id} AND motivo_reprovacao IS NULL";
            $query = $this->pdo->query($sql);
            $vendasAguardandoQtd = $query->fetchAll();
            $qtdVendasAguardando = $query->rowCount();

            $text .= "\xF0\x9F\x93\x96 Encontrei $contador pedidos pendentes.";
            $text .= "\n\xF0\x9F\x95\x90 Você possui $qtdVendasAguardando pedidos aguardando aprovação.\n\n";

        } else {
            $text = "\xF0\x9F\x94\x8D Nenhum pedido pendente foi encontrado";

        }
        $caracteres = strlen($text);
        if ($caracteres > 4000) {
            $text = substr($text, 0, 4000);
            $text .= "...\n\n\xE2\x9A\xA0 Mensagem muito grande! Contate um administrador!\nVocê tem $contador pedidos pendentes.\n\n";
            $text .= "\xF0\x9F\x95\x90 Você possui $qtdVendasAguardando pedidos aguardando aprovação.\n\n";
        }


        $this->sendMessage($text, $inline_keyboard);
    }


    public function ListarPedidosPendentes($todos = null)
    {

        $user_id = $this->user['idUsuarios'];
        $text = "";
        $endText = "";
        $inline_keyboard = new InlineKeyboard();
        //$sql = "SELECT * FROM vendas WHERE faturado = 1 AND (enviador_id = $user_id OR usuarios_id = $user_id) AND status <> 3 AND motivo_reprovacao IS NULL";
        if ($todos == null) {
            $sql = "SELECT * FROM vendas WHERE faturado = 1 AND usuarios_id = $user_id AND status = 2 AND motivo_reprovacao IS NULL";
        } else {
            $sql = "SELECT * FROM vendas WHERE faturado = 1 AND status = 2 AND motivo_reprovacao IS NULL AND enviador_id <> 0";
        }
        $query = $this->pdo->query($sql);
        $vendas = $query->fetchAll();

        $rows = $query->rowCount();
        if ($rows > 0) {
            $text .= "<b>Pedidos Pendentes:</b>\n";
            $contador = 0;

            foreach ($vendas as $venda) {

                $text .= "\xF0\x9F\x93\xAB Pedido #" . $venda['idVendas'] . "\n";
                $text .= "Data: " . date(('d/m/Y'), strtotime($venda['dataVenda'])) . "\n";
                $text .= "CEP: " . $venda['cep'] . "\n";
                //$text .= $venda['dadosEnvio'] . "\n";
                $vendaId = $venda['idVendas'];
                $sql = "SELECT * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $vendaId";
                $query = $this->pdo->query($sql);
                $produtos = $query->fetchAll();
                $rows = $query->rowCount();
                $total = 0;
                if ($rows > 0) {
                    $listProd = "";
                    foreach ($produtos as $produto) {
                        $produto['subTotal'] = $produto['subTotal'];
                        $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n";
                        $total += $produto['subTotal'];
                    }
                }
                $text .= $listProd;
                /* switch ($venda['status']) {
                     case 1:
                         $text .= "\n\xF0\x9F\x95\x90 AGUARDANDO APROVAÇÃO PELO ADMINISTRADOR! \xF0\x9F\x95\x90\n";
                         break;
                     case 2:
                         $text .= "\n\xE2\x9C\x85 APROVADO! AGUARDANDO RASTREIO \xE2\x9C\x85\n";
                         break;
                 }*/
                $text .= "\n--------------------------\n";
                $contador++;
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x91\x80 Vizualizar: #" . $venda['idVendas'] . " - " . $venda['cep'],
                    'callback_data' => "Vizualizar_Pedido_" . $venda['idVendas']
                ]));

            }

            $sql = "SELECT * FROM vendas WHERE faturado = 1 AND status = 1 AND usuarios_id = {$user_id} AND motivo_reprovacao IS NULL";
            $query = $this->pdo->query($sql);
            $vendasAguardandoQtd = $query->fetchAll();
            $qtdVendasAguardando = $query->rowCount();

            $endText .= "\xF0\x9F\x93\x96 Encontrei $contador pedidos pendentes.";
            $endText .= "\n\xF0\x9F\x95\x90 Você possui $qtdVendasAguardando pedidos aguardando aprovação.\n\n";

        } else {
            $endText = "\xF0\x9F\x94\x8D Nenhum pedido pendente foi encontrado";

        }

        if($todos == null){
            $sql = "SELECT * FROM vendas WHERE faturado = 1 AND usuarios_id = $user_id AND imagem_sro IS NOT NULL AND motivo_reprovacao IS NULL AND ocultar_dados <> 1 ORDER BY dataVenda ASC";
            $query = $this->pdo->query($sql);
            $rows = $query->rowCount();
    
            $sql = "SELECT * FROM vendas WHERE faturado = 1 AND usuarios_id = $user_id AND imagem_sro IS NOT NULL AND motivo_reprovacao IS NULL";
            $query = $this->pdo->query($sql);
            $vendas = $query->fetchAll();
            if ($rows > 0) {
                $text .= "<b>Pedidos Finalizados: </b>$rows\n";
                $contador = 0;
    
                foreach ($vendas as $venda) {
    
                    if ($venda['ocultar_dados'] != 1) {
                        $text .= "\xF0\x9F\x93\xAB Pedido #" . $venda['idVendas'] . "\n";
                        $text .= "Data: " . date(('d/m/Y'), strtotime($venda['dataVenda'])) . "\n";
                        $text .= "CEP: " . $venda['cep'] . "\n";
    
                        $vendaId = $venda['idVendas'];
                        $sql = "SELECT * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $vendaId";
                        $query = $this->pdo->query($sql);
                        $produtos = $query->fetchAll();
                        $rows = $query->rowCount();
                        $total = 0;
                        if ($rows > 0) {
                            $listProd = "";
                            foreach ($produtos as $produto) {
                                $produto['subTotal'] = $produto['subTotal'];
                                $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n";
                                $total += $produto['subTotal'];
                            }
                        }
                        $text .= $listProd;
    
                        $text .= "\n-----------\n";
                        $contador++;
                        $inline_keyboard->addRow(new InlineKeyboardButton([
                            'text' => "\xE2\x9D\x97 Vizualizar: #" . $venda['idVendas'] . " - " . $venda['cep'],
                            'callback_data' => "Vizualizar_Pedido_" . $venda['idVendas']
                        ]));
                    }
    
                }
            }
        }

      
        $text = $text . "\n" . $endText;


        $caracteres = strlen($text);
        if ($caracteres > 4000) {
            $text = substr($text, 0, 4000);
            $text .= "...\n\n\xE2\x9A\xA0 Mensagem muito grande! Contate um administrador!\nVocê tem $contador pedidos pendentes.\n\n";
            $text .= "\xF0\x9F\x95\x90 Você possui $qtdVendasAguardando pedidos aguardando aprovação.\n\n";
        }


        $this->sendMessage($text, $inline_keyboard);
    }

    public function VizualizarPedido($idVendas = 0)
    {
        $this->notes['vendaId'] = $idVendas;
        $this->conversation->update();
        $user_id = $this->user['idUsuarios'];
        $sql = "SELECT * FROM vendas WHERE faturado = 1 AND idVendas = $idVendas AND motivo_reprovacao IS NULL";
        $query = $this->pdo->query($sql);
        $venda = $query->fetch();
        if (!empty($venda)) {

            $sql = "SELECT * FROM categorias WHERE status = 1 ORDER BY ordem";
            $query = $this->pdo->query($sql);
            $categorias = $query->fetchAll();
            $categoriaArray = array();
            foreach ($categorias as $categoria) {
                $categoriaArray[$categoria['idCategorias']] = $categoria['categoria'];
            }

            $inline_keyboard = new InlineKeyboard();
            $text = "";
            $text .= "\xF0\x9F\x93\xAB Pedido #" . $venda['idVendas'] . "\n";
            $text .= "Data: " . date(('d/m/Y'), strtotime($venda['dataVenda'])) . "\n";
            $text .= "CEP: " . $venda['cep'] . "\n\n";
            $text .= $categoriaArray[$venda['categoria_id']] . "\n";
            $text .= "Dados de envio: \n";
            if ($venda['imagem_sro'] != 1) {
                $text .= $venda['dadosEnvio'] . "\n";
                if (!empty($venda['observacoes'])) {
                    $text .= "\n\nObservação: \n";
                    $text .= $venda['observacoes'] . "\n";

                }
            }

            $taxa_envio = $venda['taxa_envio'];
            $text .= "Envio: " . $venda['tipoEnvio'] . " -  R$$taxa_envio\n\n";
            $vendaId = $venda['idVendas'];
            $sql = "SELECT * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $vendaId";
            $query = $this->pdo->query($sql);
            $produtos = $query->fetchAll();
            $rows = $query->rowCount();
            $total = 0;
            if ($rows > 0) {
                $listProd = "";
                foreach ($produtos as $produto) {
                    $produto['subTotal'] = $produto['subTotal'];
                    $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n";
                    $total += $produto['subTotal'];
                }
            }

            $text .= $listProd;

            if( $user_id == 1){
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x93\xA2 Enviar mensagem \xF0\x9F\x93\xA2",
                    'callback_data' => "Enviar_Aviso_" . $venda['usuarios_id']
                ]));
            }


            if( $venda['status'] != 0){
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x92\x94 Problema no meu pedido \xF0\x9F\x92\x94",
                    'callback_data' => "Reclamar_Pedido_" . $venda['idVendas']
                ]));
            }


            if (!empty($venda['imagem_sro'])) {
                $text .= "\nPara manter sua privacidade limpe todos os dados de envio clicando no botão \n\n\xF0\x9F\x9A\xAB Limpar rastros do envio \xF0\x9F\x9A\xAB\n";
                $text .= "\n<b>Antes de fazer isso salve a imagem de rastreio no seu celular, pois era ficara inacessível!</b>";

                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x9A\xAB Limpar rastros do envio \xF0\x9F\x9A\xAB",
                    'callback_data' => "Ocultar_Dados_" . $venda['idVendas']
                ]));
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x94\x99 Voltar ao menu principal / Atualizar \xF0\x9F\x94\x99", 'callback_data' => 'Main_Menu'
                ]));

                Request::sendPhoto([
                    'chat_id' => $this->user['chat_id'],
                    'caption' => $text,
                    'photo' => Request::encodeFile($venda['imagem_sro']),
                    'reply_markup' => $inline_keyboard,
                    'resize_keyboard' => true,
                    'parse_mode' => 'HTML',
                ]);

            } else {
                $text .= "\nVocê pode editar ou cancelar o pedido.\n";

                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xE2\x9C\x8F Editar dados do envio: #" . $venda['idVendas'],
                    'callback_data' => "Solicitar_EditarPedido_" . $venda['idVendas']
                ]));
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xE2\x9D\x8C Cancelar pedido: #" . $venda['idVendas'],
                    'callback_data' => "Solicitar_CancelamentoPedido_" . $venda['idVendas']
                ]));

                $this->sendMessage($text, $inline_keyboard);
            }


        }
    }

    public function ReclamarPedido($idVendas)
    {
        $sql = "SELECT * FROM vendas WHERE idVendas = $idVendas";
        $query = $this->pdo->query($sql);
        $venda = $query->fetch();
        if (!empty($venda)) {
            $this->notes['reclamacaoIdVenda'] = $idVendas;
            $this->notes['requestData'] = "inserirMotivoReclamacaoPedido";
            $this->conversation->update();
            $text = "<b>Dicas para evitar erros</b> ";
            $text .= "- Filme a abertura do pacote.";
            $text = "<b>Reclamar - Pedido #$idVendas:</b> ";
            $text .= "Digite qual o problema com o pedido: ";
            $this->sendMessage($text);
        }
    }
    public function EnviarReclamacao($reclamacao_id, $usuario_id){
        //$texto_reclamacao = $this->notes['texto_reclamacao'];
        /*
        $inline_keyboard = new InlineKeyboard(
            [['text' => "\xF0\x9F\x91\x8D Responder reclamação \xF0\x9F\x91\x8D", 'callback_data' => "Responder_Reclamacao_".$reclamacao_id."_".$usuario_id]],
        );
        //ENVIAR PARA O USUARIO ID
        //CRIAR REGISTRO NO TABELA RECLAMACAO_COMENTARIOS VINCULADO COM A RECLAMAÇÃO ATUAL
        //ALTERAR PAGINA DO PEDIDO, PARA QUE O CLIENTE VEJA O HISTORICO DA RECLAMAÇÃO E FINALIZA-LA COM UM COMENTARIO
        //FINALIZAR INTERAÇÃO PARA QUE O ENVIADOR RESPONDA A RECLAMAÇÃO
        //FAZER COM QUE O COMENTARIO DO ENVIADOR PASSE PELA MIHA APROVAÇÃO
        //FAZER COM QUE EU POSSA EDITAR A MENSAGEM ENVIADA PELO ENVIADOR
        //FAZER COM QUE EU POSSA EDITAR A MENSAGEM ENVIADA PELO CLIENTE

        //FAZER UM CRONTAB PARA TODOS OS DIAS 6 HORAS DA MANHÃ -> VERIFICAR QUANTOS PEDIDOS CADA ENVIADOR TEM ATRASADO
        //FAZER O ENVIO DE UMA MENSAGEM COM A QUANTIDADE DE PEDIDOS ATRASADOS COM TEMPO DE ATRASO
        //FAZER ENVIO DE UMA MENSAGEM COM TODAS AS RECLAMAÇÕES QUE AINDA NÃO FORAM RESPONDIDAS

        $texto_reclamacao = "OI";
        $this->sendMessage($texto_reclamacao, $inline_keyboard);
        */
    }

    public function SolicitarEditarPedido($idVendas)
    {
        $vendaId = $idVendas;

        $sql = "SELECT * FROM vendas WHERE idVendas = $idVendas";
        $query = $this->pdo->query($sql);
        $venda = $query->fetch();
        if (!empty($venda)) {
            $text = "\xE2\x9C\x8F Pedido de edição dos dados do pedido.\n";
            $text .= "Pedido: #$idVendas\n\n";
            $text .= $venda['dadosEnvio'] . "\n";

            $text .= "----------------\n\n";
            $text .= "Informe aqui os dados do cliente no seguinte padrão:\n
Nome: 
Endereço: 
Número: 
Complemento: 
Bairro:  
Cidade: 
Estado: 
Cep: 
";
            $this->notes['vendaId'] = $idVendas;
            $this->notes['requestData'] = "editarDadosEnvio";
            $this->sendMessage($text);
            $this->conversation->update();
        }


    }

    public function SolicitarCancelamentoPedido($idVendas)
    {
        $vendaId = $idVendas;

        $sql = "SELECT * FROM vendas WHERE idVendas = $idVendas";
        $query = $this->pdo->query($sql);
        $venda = $query->fetch();
        if (!empty($venda)) {
            $text = "\xE2\x9D\x8C Pedido de cancelamento\n";
            $text .= "Pedido: #$idVendas\n\n";
            $text .= $venda['dadosEnvio'] . "\n\n";
            if (!empty($venda['observacoes'])) {
                $text .= "\n\nObservação: \n";
                $text .= $venda['observacoes'] . "\n";

            }
            //ENVIANDO PEDIDO PARA APROVAÇÃO
            $sql = "SELECT * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $vendaId";
            $query = $this->pdo->query($sql);
            $produtos = $query->fetchAll();
            $rows = $query->rowCount();
            $total = 0;

            $listProd = "";
            if ($rows > 0) {
                foreach ($produtos as $produto) {
                    $produto['subTotal'] = $produto['subTotal'];
                    $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n";
                    $total += $produto['subTotal'];
                }
            }

            $text .= "\n" . $listProd;
        }

        //$this->deleteMessage($this->notes['msgDadosEnvioId']);
        $inline_keyboard_warnyj = new InlineKeyboard(
            [['text' => "\xE2\x9C\x85 Aprovar cancelamento", 'callback_data' => "Aprovar_Cancelamento_$vendaId"]],
            [['text' => "\xE2\x9D\x8C Reprovar cancelamento", 'callback_data' => "Reprovar_Cancelamento_$vendaId"]]
        );
        $this->sendMessageById(889423113, $text, $inline_keyboard_warnyj);


        $text = "Cancelamento do pedido #$vendaId solicitado com sucesso.\nAguarde aprovação do administrador.";
        //$this->sendMessageById($this->chat_id, $text, $inline_keyboard);
        $this->sendMessage($text);

    }

    public function AprovarCancelamentoPagamento($divida_id)
    {

        $sql = "SELECT * FROM dividas WHERE id = $divida_id";
        $query = $this->pdo->query($sql);
        $divida = $query->fetch();

        if (!empty($divida['comprovante'])) {
            $text = "ESTE PAGAMENTO JA FOI EFETUADO! IMPOSSÍVEL CANCELAR.\n\nDivida: #$divida_id";
            $this->sendMessage($text);
            exit;
        }

        $dataDivida = array(
            ':divida_id' => $divida_id,
        );
        $sql = "UPDATE dividas set status = 0, aguardando_pag = 0 WHERE id = :divida_id";
        $prepSql = $this->pdo->prepare($sql);

        if ($prepSql->execute($dataDivida)) {
            $cliente_id = $divida['usuario_id'];
            $sql = "SELECT * FROM usuarios WHERE idUsuarios = $cliente_id";
            $query = $this->pdo->query($sql);
            $cliente = $query->fetch();

            $inline_keyboard_warnyj = new InlineKeyboard(
                [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
            );
            $text = "O cancelamento do seu pagamento foi aprovado!";

            $this->sendMessageById($cliente['chat_id'], $text, $inline_keyboard_warnyj);
            $text = "Pagamento cancelado com sucesso!";
            $this->sendMessage($text);
        }


    }

    public function AprovarCancelamento($idVendas)
    {

        $vendaId = $idVendas;

        $sql = "SELECT * FROM itens_de_vendas as idv WHERE idv.vendas_id = $vendaId";
        $query = $this->pdo->query($sql);
        $itensVenda = $query->fetchAll();
        $rows = $query->rowCount();
        if ($rows > 0) {
            foreach ($itensVenda as $iv) {
                $quantidade = $iv['quantidade'];
                $sql = "SELECT * FROM produtos WHERE idProdutos = {$iv['produtos_id']}";
                $query = $this->pdo->query($sql);
                $produto = $query->fetch();
                if (!empty($produto)) {
                    $dataProd = array(
                        ':estoque' => $produto['estoque'] + $quantidade,
                        ':produto_id' => $iv['produtos_id'],
                    );
                    $sql = "UPDATE produtos set estoque = :estoque WHERE idProdutos = :produto_id";

                    $prepSql = $this->pdo->prepare($sql);
                    if ($prepSql->execute($dataProd)) {
                        $dataIV = array(
                            ':idItens' => $iv['idItens']

                        );
                        $sql = "DELETE FROM itens_de_vendas WHERE idItens = :idItens";
                        if ($this->pdo->prepare($sql)->execute($dataIV)) {
                            $dataDivida = array(
                                ':venda_id' => $vendaId

                            );
                            $sql = "DELETE FROM dividas WHERE venda_id = :venda_id";
                            if ($this->pdo->prepare($sql)->execute($dataDivida)) {

                            }
                        }
                    }
                }
            }
        }

        $sql = "SELECT * FROM vendas WHERE idVendas = $vendaId";
        $query = $this->pdo->query($sql);
        $venda = $query->fetch();

        if (!empty($venda)) {
            $usuarios_id = $venda['usuarios_id'];
            $dadosEnvio = $venda['dadosEnvio'];
        }

        $dataVenda = array(
            ':idVendas' => $vendaId
        );
        $sql = "DELETE FROM vendas WHERE idVendas = :idVendas";
        if ($this->pdo->prepare($sql)->execute($dataVenda)) {

            $sql = "SELECT * FROM usuarios WHERE idUsuarios = " . $usuarios_id;
            $query = $this->pdo->query($sql);
            $user = $query->fetch();
            if (!empty($user)) {
                $inline_keyboard_warnyj = new InlineKeyboard(
                    [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                );
                $text = "\xE2\x9C\x85 PEDIDO #$idVendas CANCELADO!\nA solicitação de cancelamento foi APROVADA pelo administrador.\n\n" . $dadosEnvio;
                $this->sendMessageById($this->chat_id, $text, $inline_keyboard_warnyj);
                //$this->sendMessage($text);


                $this->sendMessageById($user['chat_id'], $text, $inline_keyboard_warnyj);
            }

        }
    }

    public function ReprovarCancelamento($idVendas)
    {
        $sql = "SELECT * FROM vendas WHERE idVendas = $idVendas";
        $query = $this->pdo->query($sql);
        $venda = $query->fetch();
        if (!empty($venda)) {

            $sql = "SELECT * FROM usuarios WHERE idUsuarios = " . $venda['usuarios_id'];
            $query = $this->pdo->query($sql);
            $user = $query->fetch();
            if (!empty($user)) {
                $text = "\xE2\x9D\x8C ATENÇÃO! O PEDIDO #$idVendas NÃO FOI CANCELADO!\nA solicitação de cancelamento foi REPROVADA pelo administrador.\n\n" . $venda['dadosEnvio'];

                $inline_keyboard_warnyj = new InlineKeyboard(
                    [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                );
                $this->sendMessageById($this->chat_id, $text, $inline_keyboard_warnyj);
                $this->sendMessageById($user['chat_id'], $text, $inline_keyboard_warnyj);
            } else {
                $this->sendMessage($venda['usuarios_id']);
            }
        } else {
            $this->sendMessage($idVendas);
        }


    }

    public function ConversaReclamacao($reclamacaoId){
        $sql = "SELECT * FROM reclamacao WHERE id = $reclamacaoId";
        
        $query = $this->pdo->query($sql);
        $reclamacao = $query->fetch();
        $usuario_id = $reclamacao['usuario_id'];
        $sql = "SELECT * FROM usuarios WHERE idUsuarios = $usuario_id";
        $query = $this->pdo->query($sql);
        $cliente = $query->fetch();
        $inline_keyboard = new InlineKeyboard(
            [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
        );
        $text = "Sua reclamação foi lida. \nFavor entrar em contato com @CrazyGandalf";
        

        $this->sendMessageById($cliente['chat_id'], $text, $inline_keyboard);


        $this->sendMessage('Mensagem enviada para '.$cliente['nome']. ', aguarde o contato.');
    }

    public function AprovarEdicao($idVendas)
    {
        $sql = "SELECT * FROM vendas WHERE idVendas = $idVendas";
        $query = $this->pdo->query($sql);
        $venda = $query->fetch();
        if (!empty($venda)) {
            $vendaId = $idVendas;
            if (preg_match('/[0-9]{5,5}-[0-9]{3}?/', $venda['dadosEditar'], $matches)) {

                $dadosAntigos = $venda['dadosEnvio'];

                //if (preg_match('/[0-9]{5,5}([- ]?[0-9]{3,3})?/', $textMessage, $matches)) {
                $cep = $matches[0];
                $dataVenda = array(
                    ':dadosEnvio' => $venda['dadosEditar'],
                    ':cep' => $cep,
                    ':vendaId' => $vendaId,

                );
                $sql = "UPDATE vendas set dadosEnvio = :dadosEnvio, cep = :cep WHERE idVendas = :vendaId";

                $prepSql = $this->pdo->prepare($sql);
                if ($prepSql->execute($dataVenda)) {

                    $sql = "SELECT * FROM usuarios WHERE idUsuarios = " . $venda['usuarios_id'];
                    $query = $this->pdo->query($sql);
                    $user = $query->fetch();
                    if (!empty($user)) {

                        $text = "\xE2\x9C\x85 ATENÇÃO! DADOS DO PEDIDO #$idVendas FORÃO ALETAROS!\nO Administrador aprovou sua solicitação\n\nDados Antigos:\n$dadosAntigos\n\nNovos dados de envio:\n" . $venda['dadosEditar'];
                        $inline_keyboard_warnyj = new InlineKeyboard(
                            [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                        );
                        $this->sendMessageById($user['chat_id'], $text, $inline_keyboard_warnyj);

                        $text = "\xE2\x9C\x85 ATENÇÃO! PEDIDO #$idVendas EDITADO.";
                        $this->sendMessageById($this->chat_id, $text, $inline_keyboard_warnyj);
                    }
                }
            }
        } else {
            $this->sendMessage($idVendas);
        }


    }

    public function ReprovarEdicao($idVendas)
    {
        $sql = "SELECT * FROM vendas WHERE idVendas = $idVendas";
        $query = $this->pdo->query($sql);
        $venda = $query->fetch();
        if (!empty($venda)) {

            $sql = "SELECT * FROM usuarios WHERE idUsuarios = " . $venda['usuarios_id'];
            $query = $this->pdo->query($sql);
            $user = $query->fetch();
            if (!empty($user)) {
                $text = "\xE2\x9D\x8C ATENÇÃO! O PEDIDO #$idVendas NÃO FOI ALTERADO!\nA solicitação de aleteração de endereço foi REPROVADA pelo administrador.\n\n" . $venda['dadosEnvio'];

                $inline_keyboard_warnyj = new InlineKeyboard(
                    [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                );
                $this->sendMessageById($this->chat_id, $text, $inline_keyboard_warnyj);
                $this->sendMessageById($user['chat_id'], $text, $inline_keyboard_warnyj);
            } else {
                $this->sendMessage($venda['usuarios_id']);
            }
        } else {
            $this->sendMessage($idVendas);
        }


    }

    public function CancelarPagamento($divida_id)
    {


        $sql = "SELECT * FROM dividas WHERE id = $divida_id";
        $query = $this->pdo->query($sql);
        $divida = $query->fetch();
        if (!empty($divida)) {


            $sql = "SELECT * FROM contas WHERE idContas = " . $divida['conta_id'];
            $query = $this->pdo->query($sql);
            $conta = $query->fetch();

            $text = "\xE2\x9D\x8C <b>Solicitação de cancelamento do pagamento</b> \xE2\x9D\x8C\n\n";
            $text .= "Divida: #$divida_id\n\n";
            $text .= "Data: " . date(('d/m/Y'), strtotime($divida['data'])) . "\n-\n";
            $text .= "Conta: " . $conta['nome'] . "\n";
            $text .= "" . $conta['conta'] . "\n\n";
            $text .= "<b>Valor: R$" . $divida['valor'] . "</b>\n\n";
            $text .= $this->user['nome'] . "\n\n";
            $inline_keyboard_warnyj = new InlineKeyboard(
                [['text' => "\xE2\x9C\x85 Aprovar cancelamento", 'callback_data' => "Aprovar_CancelamentoPagamento_$divida_id"]],
                [['text' => "\xE2\x9D\x8C Reprovar cancelamento", 'callback_data' => "Reprovar_CancelamentoPagamento_$divida_id"]]
            );
            $this->sendMessageById(889423113, $text, $inline_keyboard_warnyj);
            $text = "O seu pedido de cancelamento foi enviado para o suporte, aguarde retorno!";
            $this->sendMessage($text);
        }

        //$this->deleteMessage($this->notes['msgDadosEnvioId']);

    }

    public function MainCancelarPagamento()
    {

        if (($this->notes['msgDadosEnvioId'] != $this->message_id) or ($this->notes['msgStart'] != $this->message_id)) {
            $this->deleteMessage($this->notes['msgDadosEnvioId']);
        }

        $vendaId = $this->notes['vendaId'];

        $sql = "SELECT * FROM itens_de_vendas as idv WHERE idv.vendas_id = $vendaId";
        $query = $this->pdo->query($sql);
        $itensVenda = $query->fetchAll();
        $rows = $query->rowCount();
        if ($rows > 0) {
            foreach ($itensVenda as $iv) {
                $quantidade = $iv['quantidade'];
                $sql = "SELECT * FROM produtos WHERE idProdutos = {$iv['produtos_id']}";
                $query = $this->pdo->query($sql);
                $produto = $query->fetch();
                if (!empty($produto)) {
                    $dataProd = array(
                        //':estoque' => $produto['estoque'] + $quantidade,
                        ':estoque' => $produto['estoque'],
                        ':produto_id' => $iv['produtos_id'],
                    );
                    $sql = "UPDATE produtos set estoque = :estoque WHERE idProdutos = :produto_id";

                    $prepSql = $this->pdo->prepare($sql);
                    if ($prepSql->execute($dataProd)) {
                        $dataIV = array(
                            ':idItens' => $iv['idItens']

                        );
                        $sql = "DELETE FROM itens_de_vendas WHERE idItens = :idItens";
                        if ($this->pdo->prepare($sql)->execute($dataIV)) {

                        }
                    }
                }
            }
        }
        $dataVenda = array(
            ':idVendas' => $vendaId
        );
        $sql = "DELETE FROM vendas WHERE idVendas = :idVendas";
        if ($this->pdo->prepare($sql)->execute($dataVenda)) {
            $this->conversation->stop();
            $this->conversation = new Conversation($this->chat_id, $this->chat_id, $this->getName());

            $text = "\xE2\x9C\x85 O pedido foi cancelado com sucesso!";


            return $this->sendMessage($text);

        }
    }

    //CANCELAR VENDA
    public function MainCancelarVenda()
    {

        if (($this->notes['msgDadosEnvioId'] != $this->message_id) or ($this->notes['msgStart'] != $this->message_id)) {
            $this->deleteMessage($this->notes['msgDadosEnvioId']);
        }

        $vendaId = $this->notes['vendaId'];

        $sql = "SELECT * FROM itens_de_vendas as idv WHERE idv.vendas_id = $vendaId";
        $query = $this->pdo->query($sql);
        $itensVenda = $query->fetchAll();
        $rows = $query->rowCount();
        if ($rows > 0) {
            foreach ($itensVenda as $iv) {
                $quantidade = $iv['quantidade'];
                $sql = "SELECT * FROM produtos WHERE idProdutos = {$iv['produtos_id']}";
                $query = $this->pdo->query($sql);
                $produto = $query->fetch();
                if (!empty($produto)) {
                    $dataProd = array(
                        //':estoque' => $produto['estoque'] + $quantidade,
                        ':estoque' => $produto['estoque'],
                        ':produto_id' => $iv['produtos_id'],
                    );
                    $sql = "UPDATE produtos set estoque = :estoque WHERE idProdutos = :produto_id";

                    $prepSql = $this->pdo->prepare($sql);
                    if ($prepSql->execute($dataProd)) {
                        $dataIV = array(
                            ':idItens' => $iv['idItens']

                        );
                        $sql = "DELETE FROM itens_de_vendas WHERE idItens = :idItens";
                        if ($this->pdo->prepare($sql)->execute($dataIV)) {

                        }
                    }
                }
            }
        }
        $dataVenda = array(
            ':idVendas' => $vendaId
        );
        $sql = "DELETE FROM vendas WHERE idVendas = :idVendas";
        if ($this->pdo->prepare($sql)->execute($dataVenda)) {
            $this->conversation->stop();
            $this->conversation = new Conversation($this->chat_id, $this->chat_id, $this->getName());

            $text = "\xE2\x9C\x85 O pedido foi cancelado com sucesso!";


            return $this->sendMessage($text);

        }
    }

    // VENDA / PEDIDO
    public function VendaCadastrar($data)
    {
        $this->clearNotes();
        if (empty($this->notes['vendaId'])) {

            $dataPedido = date('Y-m-d');
            $vendedor_id = $this->user['idUsuarios'];
            $dataVenda = array(
                ':dataVenda' => $dataPedido,
                ':clientes_id' => 1,
                ':usuarios_id' => $vendedor_id,
                ':faturado' => 0,
                ':desconto' => 0.00,
            );

            $sql = "INSERT INTO vendas (dataVenda, clientes_id, usuarios_id, faturado, desconto) 
              VALUES (:dataVenda, :clientes_id, :usuarios_id, :faturado, :desconto)";

            if ($this->pdo->prepare($sql)->execute($dataVenda)) {
                $vendaId = $this->pdo->lastInsertId();

            } else {
                $textError = "Erro ao cadastrar o pedido!";
                return $this->sendErrorMessage($textError);
            }
        } else {
            return $this->sendErrorMessage();
        }

        if (isset($vendaId)) {
            $this->notes['vendaId'] = $vendaId;
            $this->notes['userId'] = $vendedor_id;
            $this->conversation->update();
        } else {
            $textError = "Erro ao gravar o numero do pedido";
            return $this->sendErrorMessage($textError);
        }

        $text = "Informe aqui os dados de envio no seguinte padrão:\n
Nome: 
CPF: (Obrigatório no estoque 3 ou qualquer pedido Jadlog)
Telefone: (apenas Jadlog)
Endereço: 
Número: 
Complemento: 
Bairro:  
Cidade: 
Estado: 
Cep: 00000-000 
";

        $this->notes['requestData'] = "informarDadosEnvio";
        $this->notes['vendaId'] = $vendaId;
        $this->conversation->update();
        $this->sendMessage($text);

    }

    public function VendaSemEnvio()
    {

        unset($this->conversation->notes);
        $this->conversation->update();
        $this->conversation->stop();
        $this->conversation = new Conversation($this->chat_id, $this->chat_id, $this->getName());
        $this->notes = &$this->conversation->notes;
        !is_array($this->notes) && $this->notes = [];
        $cep = 00000000;
        if (empty($this->notes['vendaId'])) {

            $dataPedido = date('Y-m-d');
            $vendedor_id = $this->user['idUsuarios'];
            $dataVenda = array(
                ':dataVenda' => $dataPedido,
                ':clientes_id' => 1,
                ':usuarios_id' => $vendedor_id,
                ':faturado' => 0,
                ':desconto' => 0.00,
                ':cep' => $cep,
                ':dadosEnvio' => "PEDIDO SEM ENVIO",
            );

            $sql = "INSERT INTO vendas (dataVenda, clientes_id, usuarios_id, faturado, desconto, cep, dadosEnvio) 
              VALUES (:dataVenda, :clientes_id, :usuarios_id, :faturado, :desconto, :cep, :dadosEnvio)";

            if ($this->pdo->prepare($sql)->execute($dataVenda)) {
                $vendaId = $this->pdo->lastInsertId();
            } else {
                $textError = "Erro ao cadastrar o pedido!";
                return $this->sendErrorMessage($textError);
            }
        } else {
            return $this->sendErrorMessage();
        }

        if (isset($vendaId)) {
            $this->notes['vendaId'] = $vendaId;
            $this->notes['userId'] = $vendedor_id;
        } else {
            $textError = "Erro ao gravar o numero do pedido";
            return $this->sendErrorMessage($textError);
        }
        $this->conversation->update();

        $sql = "SELECT * FROM categorias WHERE status = 1";
        $query = $this->pdo->query($sql);
        $categorias = $query->fetchAll();
        $rows = $query->rowCount();

        if ($rows > 0) {
            $inlineItens = array();
            $i = 0;

            $inline_keyboard = new InlineKeyboard();

            foreach ($categorias as $categoria) {
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => $categoria['categoria'],
                    'callback_data' => "Post_Categoria_" . $categoria['idCategorias']
                ]));
            }

            //SOLICITA A CATEGORIA

            $text = "De qual estoque são os produtos deste pedido?\n\n<b>\xE2\x9D\x97 Todos os estoques enviam para todo Brasil \xE2\x9D\x97</b>";
            $this->sendMessage($text, $inline_keyboard);


        }

    }

    public function FinzalizarEnvioAviso()
    {

       
        $text = $this->notes['MensagemAviso'];
        $inline_keyboard = new InlineKeyboard(
            [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
        );
        $textFinal = "Enviado para: \n\n";

        if($this->notes['UsuarioMensagemAviso'] !== null){
            $usuario = $this->UtilBuscaUsuarioById($this->user['idUsuarios']);
            if (empty($this->notes['link'])) {
    
                @$this->sendMessageById($usuario['chat_id'], $text, $inline_keyboard);
            } else {

                @Request::sendPhoto([
                    'chat_id' => $usuario['chat_id'],
                    'caption' => $text,
                    'photo' => Request::encodeFile($this->notes['link']),
                    'reply_markup' => $inline_keyboard,
                    'resize_keyboard' => true,
                    'parse_mode' => 'HTML',
                ]);
            }

        }else{

             $sql = "SELECT * FROM usuarios WHERE bloqueado = 0 AND chat_id IS NOT NULL";

        $query = $this->pdo->query($sql);
        $users = $query->fetchAll();

            foreach ($users as $usuario) {

                $adminText = $usuario['idUsuarios'] . " - " . $usuario['nome'] . "\n\n";
                @$this->sendMessageById(889423113, $adminText, $inline_keyboard);
    
                if (empty($this->notes['link'])) {
    
                    @$this->sendMessageById($usuario['chat_id'], $text, $inline_keyboard);
                } else {
    
                    @Request::sendPhoto([
                        'chat_id' => $usuario['chat_id'],
                        'caption' => $text,
                        'photo' => Request::encodeFile($this->notes['link']),
                        'reply_markup' => $inline_keyboard,
                        'resize_keyboard' => true,
                        'parse_mode' => 'HTML',
                    ]);
                }
    
                $textFinal .= $usuario['chat_id'] . "\n";
            }
        }
       
        //$text = "Aviso enviado com suceso!";
        $this->sendMessage($textFinal);
    }

    public function ControleEstoque()
    {

        $userId = 1;
        $text = "";
        $sql = "SELECT * FROM usuarios WHERE idUsuarios <> $userId ORDER BY nome DESC";
        $query = $this->pdo->query($sql);
        $usuarios = $query->fetchAll();
        $totais = array();
        $totalizador = 0;
        foreach ($usuarios as $u) {
            $idUsuario = $u['idUsuarios'];
            $totais[$idUsuario]['valor'] = 0;
            $totais[$idUsuario]['nome'] = $u['nome'];

            $sql = "SELECT * FROM dividas WHERE ((enviador_id = $userId AND recebedor_id = " . $idUsuario . ") OR (recebedor_id = $userId AND enviador_id = " . $idUsuario . ")) AND status = 1";

            //$this->sendMessage($sql);

            $query = $this->pdo->query($sql);
            $dividasTotal = $query->fetchAll();
            foreach ($dividasTotal as $d) {
                if ($d['enviador_id'] == $userId) {
                    if ($d['tipo'] == "POSITIVO") {
                        $totais[$idUsuario]['valor'] += $d['valor'];
                    } else if ($d['tipo'] == "NEGATIVO") {
                        $totais[$idUsuario]['valor'] -= $d['valor'];
                    }
                } else {
                    if ($d['tipo'] == "POSITIVO") {
                        $totais[$idUsuario]['valor'] -= $d['valor'];
                    } else if ($d['tipo'] == "NEGATIVO") {
                        $totais[$idUsuario]['valor'] += $d['valor'];
                    }
                }
            }
            //$this->sendMessage(json_encode($totais));
        }


        $text = "Controle de dividas geral\n\n";
        foreach ($totais as $t) {
            $totalizador += $t['valor'];
            if ($t['valor'] > 0) {
                $text .= "\xE2\x9C\x85 " . $t['nome'] . " : R$" . abs($t['valor']) . "\n";
            } else if ($t['valor'] < 0) {
                $text .= "\xE2\x9D\x8C " . $t['nome'] . " : R$" . abs($t['valor']) . "\n";
            } else {
                $text .= "\xE2\x9D\x84 " . $t['nome'] . " : R$" . abs($t['valor']) . "\n";
            }

        }
        $tot = abs($totalizador);
        if ($totalizador < 0) {

            $rodape = "\n\xE2\x9D\x8C Você deve R$$tot";
        } else {
            $rodape = "\n\xE2\x9C\x85 Seu saldo é de R$$tot";
        }

        $text = $text . $rodape;


        //$sql = "SELECT * FROM vendas WHERE faturado = 1 AND (enviador_id = $user_id OR usuarios_id = $user_id) AND status <> 3 AND motivo_reprovacao IS NULL";
        $sql = "SELECT * FROM produtos WHERE controleEstoque = 1 ORDER BY categoriaId";
        $query = $this->pdo->query($sql);
        $produtos = $query->fetchAll();
        $text .= "\n\n--------------------------------\nEstoque de produtos\n";

        $totalEstoque = 0;
        foreach ($produtos as $produto) {
            $valorCusto = $produto['precoCompra'];
            $valorTotal = $valorCusto * $produto['estoque'];
            $text .= "\n" . $produto['descricao'] . " - " . $produto['estoque'] . " : R$" . $valorTotal;
            $totalEstoque += $valorTotal;

        }

        $text .= "\n\nEstoque em dinheiro: R$" . $totalEstoque . "\n\n";
        $text .= "--------------------------------\n";
        $saldoGeral = $totalEstoque + $totalizador;

        if ($saldoGeral < 0) {
            $saldoGeral = abs($saldoGeral);
            $text .= "\xE2\x9D\x8C Você deve R$$saldoGeral";
        } else {
            $text .= "\xE2\x9C\x85 Seu saldo é de R$$saldoGeral";
        }

        $this->sendMessage($text);
    }

    public function ListaUsuarios()
    {
        //$sql = "SELECT * FROM vendas WHERE faturado = 1 AND (enviador_id = $user_id OR usuarios_id = $user_id) AND status <> 3 AND motivo_reprovacao IS NULL";
        $inline_keyboard = new InlineKeyboard();
        $sql = "SELECT * FROM permissoes";
        $query = $this->pdo->query($sql);
        $permissoes = $query->fetchAll();
        $permArray = array();
        $text = "Usuários: \n\n";
        foreach ($permissoes as $permissao) {
            $idPermissao = $permissao['idPermissao'];
            $nome = $permissao['nome'];
            $permArray[$idPermissao] = $nome;
        }

        $sql = "SELECT * FROM usuarios ORDER by fornecedor, permissoes_id, dataCadastro ASC";
        $query = $this->pdo->query($sql);
        $users = $query->fetchAll();

        foreach ($users as $usuario) {

            if ($usuario['bloqueado'] == 1) {
                $text .= "\xE2\x9D\x8C ";
            }
            $sql = "SELECT * FROM vendas WHERE usuarios_id = " . $usuario['idUsuarios'] . " AND (status = 2 OR status = 3)";
            $query = $this->pdo->query($sql);
            $compras = $query->fetchAll();
            $comprasAprovados = count($compras);


            $text .= "#" . $usuario['idUsuarios'] . " - " . $usuario['nome'] . "(\xE2\x9C\x85 " . $comprasAprovados . ")  : " . $permArray[$usuario['permissoes_id']] . " : " . $usuario['chat_id'] . "\n---\n";
        }

        $sql = "SELECT * FROM usuarios WHERE bloqueado = 1";
        $query = $this->pdo->query($sql);
        $users = $query->fetchAll();


        foreach ($users as $usuario) {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xE2\x9D\x8E Desbloquear #" . $usuario['idUsuarios'] . " - " . $usuario['nome'], 'callback_data' => 'Desbloquear_Usuario_' . $usuario['idUsuarios']
            ]));
        }

        $text .= "\nPara acessar o menu do usuario, digite o Chat ID:";
        $this->notes['requestData'] = "MenuUsuario";
        $this->conversation->update();
        $this->sendMessage($text, $inline_keyboard);

    }


    public function ControleDividasTodos()
    {
        //$sql = "SELECT * FROM vendas WHERE faturado = 1 AND (enviador_id = $user_id OR usuarios_id = $user_id) AND status <> 3 AND motivo_reprovacao IS NULL";
        $sql = "SELECT * FROM usuarios WHERE dividas = 1";
        $query = $this->pdo->query($sql);
        $users = $query->fetchAll();
        $inline_keyboard = new InlineKeyboard();
        foreach ($users as $usuario) {
            if ($this->checkPermission($this->user['idUsuarios'], "verTodosControles")) {

                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => $usuario['nome'], 'callback_data' => 'Controle_Dividas_' . $usuario['idUsuarios']
                ]));
            }
        }
        $text = "Escolha o usuário para ver as dívidas:";
        $this->sendMessage($text, $inline_keyboard);

    }

    public function ControleDividas($usuario_id)
    {


        $this->inline_keyboard = new InlineKeyboard();
        if (empty($usuario_id)) {
            $usuario_id = $this->user['idUsuarios'];
        }
        $totais = array();


        if ($usuario_id == 1) {
            $totalizador = 0;
            $text = "";
            $sql = "SELECT * FROM usuarios WHERE idUsuarios <> 1 ORDER BY nome DESC";
            $query = $this->pdo->query($sql);
            $usuarios = $query->fetchAll();


            foreach ($usuarios as $u) {
                $idUsuario = $u['idUsuarios'];
                $totais[$idUsuario]['valor'] = 0;
                $totais[$idUsuario]['nome'] = $u['nome'];

                $sql = "SELECT * FROM dividas WHERE status = 1 AND enviador_id = $idUsuario OR recebedor_id = $idUsuario";
                $query = $this->pdo->query($sql);
                $dividasTotal = $query->fetchAll();
                $saldoDivida = array();

                foreach ($dividasTotal as $d) {
                    if ($d['enviador_id'] == $idUsuario) {
                        if ($d['tipo'] == "POSITIVO") {
                            $totais[$idUsuario]['valor'] += $d['valor'];
                        } else if ($d['tipo'] == "NEGATIVO") {
                            $totais[$idUsuario]['valor'] -= $d['valor'];
                        }
                    } else {
                        if ($d['tipo'] == "POSITIVO") {
                            $totais[$idUsuario]['valor'] -= $d['valor'];
                        } else if ($d['tipo'] == "NEGATIVO") {
                            $totais[$idUsuario]['valor'] += $d['valor'];
                        }
                    }
                    $saldoDivida[$idUsuario][$d['id']] = $totais[$idUsuario]['valor'];

                    $totalizador = $totais[$idUsuario]['valor'];
                };
                //$this->sendMessage(json_encode($totais));
            }


            if ($totalizador < 0) {
                $totalizador = abs($totalizador);
                $rodape = "\n\n\xF0\x9F\x92\xB2 \xE2\x9D\x8C Você deve R$$totalizador";
            } else {
                $rodape = "\n\n\xF0\x9F\x92\xB2 \xE2\x9C\x85 Seu saldo é de R$$totalizador";
            }
            $text = "";
            foreach ($totais as $t) {

                if ($t['valor'] > 0) {
                    $text .= "\xE2\x9C\x85 " . $t['nome'] . " : R$" . abs($t['valor']) . "\n";
                } else if ($t['valor'] < 0) {
                    $text .= "\xE2\x9D\x8C " . $t['nome'] . " : R$" . abs($t['valor']) . "\n";
                } else {
                    //$text .= "\xE2\x9D\x84 " . $t['nome'] . " : R$" . abs($t['valor']) . "\n";
                }

            }

            $text = $text . $rodape;


        } else {


            $text = $this->TextoDividasCompleto($usuario_id, false);

        }


        if (!empty($this->inline_keyboard)) {

            $this->sendMessage($text, $this->inline_keyboard);
        } else {
            $this->sendMessage($text);
        }


    }

    public function TextoDividasCompleto($usuario_id, $imprime)
    {

        $totalizadorSaldo = $this->UtilTotalizarSaldo($usuario_id);
        $saldoDivida = $totalizadorSaldo['saldoDivida'];

        $totais[$usuario_id]['valor'] = $totalizadorSaldo['total'];

        $quantidadeDivdas = $this->UtilGetQuantidadesDividas($usuario_id);
        $qtdDividasAguardando = $quantidadeDivdas['qtdDividasAguardando'];
        $qtdVendasAguardando = $quantidadeDivdas['$qtdVendasAguardando'];

        $dividas = $this->UtilGetDividasVendasByUsuario($usuario_id);

        $listDividas = array();

        $textCompleto = "";

        //VENDAS
        foreach ($dividas as $d) {

            $divida_id = $d['id'];
            $venda = $this->UtilGetVendaByVendaId($d['venda_id']);
            $listaPrdutos = $this->UtilGetListaProdutos($venda);

            $total = $listaPrdutos['total'];
            $listProd = $listaPrdutos['textListaProdutos'];
            $fornecedor = $listaPrdutos['fornecedor'];

            $textProd = "";

            $data = date(('d/m/Y'), strtotime($d['data']));

            if ($d['comissao'] == 1) {
                $textProd .= "\xF0\x9F\x92\xB0 Comissão: #" . $d['id'] .
                    "\n<b>Revenda</b> " .
                    "\nData: " . $data .
                    "\n" . $listProd .
                    "\n<b>Valor: R$" . $d['total'] . "</b>" .
                    "\n<i>Saldo: R$" . $saldoDivida[$usuario_id][$divida_id] . "</i>" .
                    "\n-----------\n";
            } else {
                if ($fornecedor == 1) {
                    $textProd .= "\xE2\x9C\x85 \xF0\x9F\x8F\xA2 ";
                } else {
                    $textProd .= "\xE2\x9D\x8C ";
                }
                $taxa_envio = $venda['taxa_envio'];
                $textProd .= "\xF0\x9F\x93\xA6 Pedido: #" . $venda['idVendas'] .
                    "\nData: " . $data .
                    "\n" . $listProd . "Envio:" . $venda['tipoEnvio'];

                if ($venda['tipoEnvio'] == "SEGURO" && $venda['enviador_id'] == $usuario_id) {
                    $cat = $this->UtilBuscaCategoriaById($venda['categoria_id']);
                    $taxa_envio = $cat['envio_seguro'];
                }

                //$total = $d['total'] + $taxa_envio;
                $textProd .=  " - R$" . $taxa_envio . "\n" .
                    "\n<b>Total: R$" . $total . "</b>" .
                    "\n<i>Saldo: R$" . $saldoDivida[$usuario_id][$divida_id] . "</i>" .
                    "\n-----------\n";
            }

            //$this->sendMessage(json_encode($saldoDivida[$usuario_id]));
            $listDividas[$divida_id] = $textProd;

            if (!empty($d['comprovante']) && $d['ocultar_dados'] != 1) {

                $this->inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x93\x84 Ver Comprovante #$divida_id", 'callback_data' => 'Ver_Comprovante_' . $divida_id
                ]));

            }
        }


        if ($this->user['revendedor'] == 1) {

            $this->inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x92\xB2 Painel de Revendedor \xF0\x9F\x92\xB2", 'callback_data' => 'Revendedor_Painel'
            ]));

        }

        //$this->sendMessage("\n\n$total === ".$venda['valorTotal']."\n\n");
        //$this->sendMessage(json_encode($listDividas));

        $sql = "SELECT di.venda_id, valor as total, di.id, di.data, di.descricao, di.comprovante, di.ocultar_dados FROM dividas as di WHERE ((di.enviador_id = $usuario_id AND di.tipo = 'POSITIVO') OR (di.recebedor_id = $usuario_id AND di.tipo = 'NEGATIVO')) AND di.status = 1 AND venda_id IS NULL ORDER BY di.data DESC";

        $query = $this->pdo->query($sql);
        $dividas = $query->fetchAll();
        $rows = $query->rowCount();

        $a = array();
        foreach ($dividas as $d) {
            $textComprovantes = "";
            $divida_id = $d['id'];

            $textComprovantes .= "\xE2\x9C\x85 \xF0\x9F\x92\xB0 Controle: #" . $divida_id .
                "\nData: " . date(('d/m/Y'), strtotime($d['data'])) . "" .
                "\n<b>Valor: R$" . $d['total'] . "</b>" .
                // "\n<b>Motivo: " . $d['descricao'] . "</b>" .
                "\n<i>Saldo: R$" . $saldoDivida[$usuario_id][$divida_id] . "</i>" .
                "\n-----------\n";

            $listDividas[$divida_id] = $textComprovantes;
            if (!empty($d['comprovante']) && $d['ocultar_dados'] != 1) {
                $this->inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x93\x84 Ver Comprovante #$divida_id - R$" . $d['total'], 'callback_data' => 'Ver_Comprovante_' . $divida_id
                ]));
            }
        }

        //ENVIADOR = 1
        $sql = "SELECT di.venda_id, valor as total, di.id, di.data, di.descricao, di.comprovante, di.ocultar_dados FROM dividas as di WHERE di.enviador_id = 1 AND di.recebedor_id = $usuario_id AND di.status = 1 AND di.tipo = 'POSITIVO' AND venda_id IS NULL ORDER BY di.data DESC";


        $query = $this->pdo->query($sql);
        $dividas = $query->fetchAll();
        $rows = $query->rowCount();

        $a = array();
        foreach ($dividas as $d) {
            $textComprovantes = "";
            $divida_id = $d['id'];
            $textComprovantes .=
                "\xF0\x9F\x92\xB0 Comprovante: #" . $divida_id .
                "\nData: " . date(('d/m/Y'), strtotime($d['data'])) .
                "\n\nMotivo: " . $d['descricao'] .
                "\n<b>Valor total: R$" . $d['total'] . "</b>" .
                "\n<i>Saldo: R$" . $saldoDivida[$usuario_id][$divida_id] . "</i>" .
                "\n-----------\n\n";
            $listDividas[$divida_id] = $textComprovantes;

            if (!empty($d['comprovante']) && $d['ocultar_dados'] != 1) {
                $this->inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x93\x84 Ver Comprovante #$divida_id - R$" . $d['total'], 'callback_data' => 'Ver_Comprovante_' . $divida_id
                ]));
            }
        }

        $text = "";
        $totalizador = $totais[$usuario_id]['valor'];
        $textInicio = "";
        if ($totalizador < 0) {
            $totalizador = abs($totalizador);
            $textTotalizador = "\xF0\x9F\x92\xB2 \xE2\x9D\x8C Você deve R$$totalizador";
        } else {
            $textTotalizador = "\xF0\x9F\x92\xB2 \xE2\x9C\x85 Seu saldo é de R$$totalizador";
        }
        //$textInicio .= $textTotalizador."\n\nVocê possui $qtdDividasAguardando COMPROVANTE(S) aguardando aprovação\n";
        //$textInicio .= "\nVocê possui $qtdVendasAguardando PEDIDO(S) aguardando aprovação\n\n";


        //$this->sendMessage(json_encode($listDividas));
        ksort($listDividas);
        $listDividas = array_reverse($listDividas);
        $listText = "";
        foreach ($listDividas as $listDivida) {
            $listText .= $listDivida;
        }
        if($imprime === false){

            $caracteres = strlen($listText);
            if ($caracteres > 3400) {

                $listText = substr($listText, 0, 3200);
                $listText .= "...\n\xE2\x9A\xA0 Mensagem muito grande!\n\n";
                $listText .= "Clique em \xF0\x9F\x94\xBD Baixar relatório completo \xF0\x9F\x94\xBD para ver o relatório completo \n\n";

                $this->inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x94\xBD Baixar relatório completo \xF0\x9F\x94\xBD", 'callback_data' => 'Dividas_BaixarRelatorioCompletoDividas_'.$usuario_id
                ]));

            }

            $text = $textTotalizador."\n\n".$listText."\n".$textTotalizador;
        }
        $text = $listText;

        return $text;
    }

    public function DividasBaixarRelatorioCompletoDividas($usuario_id = null)
    {
        if(empty($usuario_id)){
            $usuario_id = $this->user['idUsuarios'];
        }
        $this->inline_keyboard = new InlineKeyboard();

        $text = strip_tags($this->TextoDividasCompleto($usuario_id, true));

        $dateTime = md5(date('Ymdhis'));
        $fileName = "Relatorio_$dateTime.txt";

        $myfile = fopen("../assets/documents/$fileName", "w") or die("Unable to open file!");
        fwrite($myfile, $text);
        fclose($myfile);

        $inline_keyboard = new InlineKeyboard(
            [['text' => "\xF0\x9F\x94\x99 Voltar ao menu principal / Atualizar \xF0\x9F\x94\x99", 'callback_data' => 'Main_Menu']]
        );
        Request::sendDocument([
            'chat_id' => $this->user['chat_id'],
            'document' => Request::encodeFile("https://receitasdarkblog.icu/market/assets/documents/$fileName"),
            'caption' => "Relatório - " . date('d/m/Y'),
            'reply_markup' => $inline_keyboard,
            'parse_mode' => 'HTML',
        ]);
    }

    public function VerComprovante($divida_id)
    {
        $sql = "SELECT * FROM dividas as di WHERE id = $divida_id";

        $query = $this->pdo->query($sql);
        $divida = $query->fetch();

        if (!empty($divida)) {
            $inline_keyboard = new InlineKeyboard();
            $text = "Comprovante: #" . $divida['id'] . "";
            $text .= "\nData: " . date(('d/m/Y'), strtotime($divida['data']));
            $text .= "\nValor: R$" . $divida['valor'];
            $text .= "\n\nPara manter sua privacidade exclua o comprovante dos nossos registros clicando no botão:\n\xF0\x9F\x9A\xAB Excluir comprovante dos registros \xF0\x9F\x9A\xAB\n";

            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x9A\xAB Excluir comprovante dos registros \xF0\x9F\x9A\xAB",
                'callback_data' => "Ocultar_Comprovante_" . $divida['id']
            ]));

            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\x96 Voltar ao Controle de dívidas", 'callback_data' => 'Controle_Dividas'
            ]));
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x94\x99 Voltar ao menu principal / Atualizar \xF0\x9F\x94\x99", 'callback_data' => 'Main_Menu'
            ]));

            Request::sendPhoto([
                'caption' => $text,
                'chat_id' => $this->user['chat_id'],
                'photo' => Request::encodeFile($divida['comprovante']),
                'reply_markup' => $inline_keyboard,
                'parse_mode' => 'HTML',
            ]);
        }

    }

    public function SelecionarTipoEnvio($tipo_envio)
    {

        $inline_keyboard = new InlineKeyboard();
        $text = "";
        $categoria_id = $this->notes['categoria_id'];
        $sql = "SELECT * FROM categorias WHERE idCategorias = " . $categoria_id;
        $query = $this->pdo->query($sql);
        $categoria = $query->fetch();
        if (!empty($categoria['sedex'])) {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\xA6 Sedex R$" . $categoria['sedex'] . " \xF0\x9F\x93\xA6", 'callback_data' => 'Post_TipoEnvio_SEDEX'
            ]));
        }
        if ($this->notes['pedidoPesado'] != 1) {
            if (!empty($categoria['carta'])) {
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xE2\x9C\x89 Carta R$" . $categoria['carta'] . " \xE2\x9C\x89", 'callback_data' => 'Post_TipoEnvio_CARTA'
                ]));
            }
            if ($categoria['gratis'] == 1) {
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xE2\x9C\x89 Frete Grátis (APENAS PROMOÇÕES) \xE2\x9C\x89", 'callback_data' => 'Post_TipoEnvio_GRATIS'
                ]));
            }
        }

        if (!empty($categoria['pac'])) {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\xA6 PAC R$" . $categoria['pac'] . " \xF0\x9F\x93\xA6", 'callback_data' => 'Post_TipoEnvio_PAC'
            ]));
        }
        if (!empty($categoria['jadlog'])) {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\xA6 Jadlog R$" . $categoria['jadlog'] . " \xF0\x9F\x93\xA6", 'callback_data' => 'Post_TipoEnvio_JADLOG'
            ]));
        }

        if (!empty($categoria['envio_seguro'])) {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x9A\x80 Envio com seguro R$" . $categoria['envio_seguro'] . " + 15% do pedido \xF0\x9F\x9A\x80", 'callback_data' => 'Post_TipoEnvio_SEGURO'
            ]));
        }

        $text = "\xF0\x9F\x9A\x9A Para calcular o prazo de entrega acesse o link: \n<b>https://calcularfretecorreios.com/#/calcular-correios</b>\n e preencha o formulário com as seguintes informações:\n\n";
        $text .= "CEP de Origem: <b>" . $categoria['cep'] . "</b>\n";
        $text .= "Formato: <b>Caixa / Pacote</b>\n";
        $text .= "Altura: <b>5</b>\n";
        $text .= "Largura: <b>11</b>\n";
        $text .= "Comprimento: <b>16</b>\n";
        $text .= "CEP de Origem: <b>COLOQUE O CEP SEU CEP</b>\n\n";

        $text .= "Clique em <b>CALCULAR FRETE</b>\n";
        $text .= "\xE2\x9A\xA0 <i>Atente-se apenas ao prazo em dias úteis, o valor do frete é fixo para cada estoque</i>\n\n";
        $text .= "\xE2\x9A\xA0 <i>Cobrimos qualquer tipo de perca nos correios apenas no envio com seguro.</i>\n\n";
        $text .= "\xF0\x9F\x9A\x9A Agora escolha o frete deste pedido.\n\n";
        return $this->sendMessage($text, $inline_keyboard);
    }

    public function AprovarPedido($vendaId)
    {
        $dataVenda = array(
            ':status' => 2,
            ':data_aprovacao' => date('Y-m-d H:i:s'),
            ':vendaId' => $vendaId,
        );

        $sql = "UPDATE vendas set status = :status, data_aprovacao = :data_aprovacao WHERE idVendas = :vendaId";
        $prepSql = $this->pdo->prepare($sql);
        $lucro = 0;

        $sql = "SELECT * FROM vendas WHERE idVendas = {$vendaId}";
        $query = $this->pdo->query($sql);
        $venda = $query->fetch();

        if (!empty($venda)) {

            $user = $this->UtilBuscaUsuarioById($venda['usuarios_id']);
            $indicador = $this->UtilBuscaUsuarioById($user['usuario_indicador_id']);

            if ($prepSql->execute($dataVenda)) {

                $sql = "SELECT * FROM itens_de_vendas as idv WHERE idv.vendas_id = $vendaId";
                $query = $this->pdo->query($sql);
                $itensVenda = $query->fetchAll();
                $rows = $query->rowCount();
                $listProd = "";
                $comissaoRevenda = 0;
                if ($rows > 0) {

                    foreach ($itensVenda as $iv) {
                        $lucro += $iv['subTotal'] - $iv['totalCusto'];
                        $quantidade = $iv['quantidade'];
                        $sql = "SELECT * FROM produtos WHERE idProdutos = {$iv['produtos_id']}";
                        $query = $this->pdo->query($sql);
                        $produto = $query->fetch();
                        if (!empty($produto)) {
                            //RETIRA DO ESTOQUE
                            $dataProd = array(
                                ':estoque' => $produto['estoque'] - $quantidade,
                                ':produto_id' => $iv['produtos_id'],
                            );
                            $sql = "UPDATE produtos set estoque = :estoque WHERE idProdutos = :produto_id";
                            $listProd .= $iv['quantidade'] . " - " . $produto['descricao'] . "\n";
                            $prepSql = $this->pdo->prepare($sql);
                            $prepSql->execute($dataProd);

                            //CALCULA REVENDA
                            if ($indicador['revendedor'] == "1") {
                                $valorCliente = $this->UtilBuscaValor($produto['idProdutos'], $user['permissoes_id'], $quantidade);
                                $valorRevendor = $this->UtilBuscaValor($produto['idProdutos'], $indicador['permissoes_id'], $quantidade);
                                $valorComissao = ($valorCliente['valor'] * $quantidade) - ($valorRevendor['valor'] * $quantidade);
                                $comissaoRevenda += $valorComissao;
                            }
                        }
                    }
                }
                $msgConvite = "\n\n";
                $convites = floor($venda['valorTotal'] / 500);
                if ($convites < 1) {
                    $convites = 1;
                }
                if ($convites > 0) {


                    for ($i = 0; $i < $convites; $i++) {
                        $numero_de_bytes = 8;

                        $token = $this->randString($numero_de_bytes);
                        $token = strtoupper($token);
                        $data = array(
                            ':datahora' => date('Y-m-d H:i:s'),
                            ':token' => $token,
                            ':criador_id' => $venda['usuarios_id'],
                            ':status' => 1,
                        );
                        $sql = "INSERT INTO token_cadastro (datahora, token, criador_id, status) VALUES (:datahora, :token, :criador_id, :status)";
                        //$this->sendMessageById(889423113, json_encode($data). " - ". $sql);
                        if ($this->pdo->prepare($sql)->execute($data)) {

                        } else {
                            $message = "ERRO";

                            return $this->sendMessage($message);
                        }
                    }
                    $msgConvite .= "Você recebeu $convites convite(s), convide seus amigos e receba comissão nas compras deles!\n\nClique em <b>\xF0\x9F\x98\x84 Convidar amigos \xF0\x9F\x98\x84</b> no Menu principal para saber mais.";
                }

                $text = "\xE2\x9C\x85 Pedido #$vendaId aprovado!\xE2\x9C\x85";
                //$text .= "\n\n\xF0\x9F\x95\x90 AGUARDANDO RASTREIO!\n\nLucro: R$" . $lucro;
                $text .= "\n\n\xF0\x9F\x95\x90 AGUARDANDO RASTREIO!\n\n";
                $sql = "SELECT * FROM vendas WHERE idVendas = {$vendaId}";
                $query = $this->pdo->query($sql);
                $venda = $query->fetch();


                $dataDivida = array(
                    ':vendaId' => $vendaId,
                );
                $sql = "UPDATE dividas set status = 1 WHERE venda_id = :vendaId";
                $prepSql = $this->pdo->prepare($sql);
                if ($prepSql->execute($dataDivida)) {

                    if ($indicador['revendedor'] == "1") {
                        //COMISSAO DE REVENDA

                        $alertaText = "Comissão de revenda!\nRevededor: " . $indicador['nome'] . "\nUsuário: " . $user['nome'] . " \nValor: R$$comissaoRevenda";
                        $this->sendMessageById(889423113, $alertaText);

                        $dataDividas = array(
                            ':data' => date('Y-m-d'),
                            ':enviador_id' => 1,
                            ':recebedor_id' => $user['usuario_indicador_id'],
                            ':valor' => $comissaoRevenda,
                            ':descricao' => "Comissão de revenda recebida pela venda #" . $vendaId,
                            ':tipo' => "NEGATIVO",
                            ':comissao' => 1,
                            ':venda_id' => $vendaId
                            //':comprovante' => $this->notes['link'],
                        );
                        $sql = "INSERT INTO dividas (data, enviador_id, recebedor_id, valor, descricao, tipo, comissao, venda_id, status) VALUES (:data, :enviador_id, :recebedor_id, :valor, :descricao, :tipo, :comissao, :venda_id, 1)";

                        if ($this->pdo->prepare($sql)->execute($dataDividas)) {
                            $inline_keyboard_warnyj = new InlineKeyboard(
                                [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                            );
                            $textAmigo = "\xF0\x9F\x8E\x89 \xF0\x9F\x8E\x89 Um cliente seu fez uma compra.\n\n<b>Você recebeu R$" . $comissaoRevenda . "</b>";
                            $this->sendMessageById($indicador['chat_id'], $textAmigo, $inline_keyboard_warnyj);
                        }

                    } else {
                        //COMISSAO DE INDICACAO
                        $comissao = 0;
                        if ($user['usuario_indicador_id'] != "1") {

                            if ($venda['valorTotal'] > 199 && $venda['valorTotal'] < 500) {
                                $comissao = 5;
                            } else if ($venda['valorTotal'] > 499 && $venda['valorTotal'] < 1000) {
                                $comissao = 25;
                            } else if ($venda['valorTotal'] > 999) {
                                $comissao = 60;
                            }
                        }
                        if ($comissao > 0) {

                            $alertaText = "Comissão!!!\nAnfitrião: " . $indicador['nome'] . "\nUsuário: " . $user['nome'] . " \nValor: R$$comissao";
                            $this->sendMessageById(889423113, $alertaText);

                            $dataDividas = array(
                                ':data' => date('Y-m-d'),
                                ':enviador_id' => 1,
                                ':recebedor_id' => $user['usuario_indicador_id'],
                                ':valor' => $comissao,
                                ':descricao' => "Comissão recebida pela venda #" . $vendaId,
                                ':tipo' => "NEGATIVO",
                                ':indicacao' => 1,
                                ':venda_id' => $vendaId
                                //':comprovante' => $this->notes['link'],
                            );
                            $sql = "INSERT INTO dividas (data, enviador_id, recebedor_id, valor, descricao, tipo, indicacao, venda_id,status) VALUES (:data, :enviador_id, :recebedor_id, :valor, :descricao, :tipo, :indicacao, :venda_id, 1)";

                            if ($this->pdo->prepare($sql)->execute($dataDividas)) {
                                $inline_keyboard_warnyj = new InlineKeyboard(
                                    [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                                );
                                $textAmigo = "\xF0\x9F\x8E\x89 \xF0\x9F\x8E\x89 Um amigo seu fez uma compra.\n\n<b>Você recebeu R$" . $comissao . "</b>";
                                $this->sendMessageById($indicador['chat_id'], $textAmigo, $inline_keyboard_warnyj);
                            }
                        }
                    }

                }
            } else {
            }

            //$this->deleteMessage($this->notes['msgDadosEnvioId']);
            $inline_keyboard_warnyj = new InlineKeyboard(
                [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
            );
            $this->sendMessageById($this->chat_id, $text, $inline_keyboard_warnyj);

            if (!empty($user['chat_id'])) {

                $inline_keyboard_warnyj = new InlineKeyboard(
                    [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                );


                $text .= "Dados do pedido:\n" . $venda['dadosEnvio'];

                $text .= "---\n";
                $text .= "Produtos: \n";


                $sql = "SELECT * FROM usuarios WHERE idUsuarios = " . $venda['enviador_id'];
                $query = $this->pdo->query($sql);
                $enviador = $query->fetch();

                $this->sendMessageById($enviador['chat_id'], $text . "\n" . $listProd . "\nEnvio: ".$venda['tipoEnvio'] , $inline_keyboard_warnyj);

                $this->sendMessageById($user['chat_id'], $text . $msgConvite, $inline_keyboard_warnyj);


            }

        } else {
            $inline_keyboard = new InlineKeyboard(
                [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
            );
            $text = "Ocorreu um erro ao modificar o pedido.";
            $this->sendMessage($text, $inline_keyboard);
        }
    }


    public function ReprovarPedido($vendaId)
    {
        $this->notes['pedidoReprovado'] = $vendaId;
        $this->notes['requestData'] = "PostReprovacaoMotivo";
        $this->conversation->update();
        $inline_keyboard = new InlineKeyboard(
            [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
        );
        $text = "Informe o motivo pelo qual você reprovou o pedido $vendaId";
        $this->sendMessageById($this->chat_id, $text, $inline_keyboard);
        //$this->sendMessage($text);

    }


    public function AprovarComprovante($divida_id)
    {
        $dataDivida = array(
            ':status' => 1,
            ':divida_id' => $divida_id,
            ':data' => date('Y-m-d H:i:s'),
        );
        $sql = "UPDATE dividas set status = :status, data =  :data WHERE id = :divida_id";
        $prepSql = $this->pdo->prepare($sql);
    if ($prepSql->execute($dataDivida)) {

            $sql = "SELECT * FROM dividas WHERE id = {$divida_id}";
            $query = $this->pdo->query($sql);
            $divida = $query->fetch();

            $url = $divida['comprovante'];
            $urlArray = explode("/", $url);
            $file = end($urlArray);
            $dir_file = __DIR__ . "/../../assets/comprovantes/photos/" . $file;
            //$this->sendMessage($dir_file);
            $inline_keyboard_comprovante = new InlineKeyboard(
                [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
            );
            $text = "\xE2\x9C\x85 <b>Comprovante aprovado</b> \xE2\x9C\x85\n";
            $text .= "\nData de envio do comprovante: " . date(('d/m/Y'), strtotime($divida['data'])) . "\n";
            $text .= "\nValor: R$" . $divida['valor'] . "\n";
            $text .= "\nPara ver seu novo saldo, exclua esse aviso e Atualize o Menu Principal\n";

            $sql = "SELECT * FROM usuarios WHERE idUsuarios = " . $divida['enviador_id'];
            $query = $this->pdo->query($sql);
            $enviador = $query->fetch();


            Request::sendPhoto([
                'chat_id' => $enviador['chat_id'],
                'caption' => $text,
                'photo' => Request::encodeFile($dir_file),
                'reply_markup' => $inline_keyboard_comprovante,
                'resize_keyboard' => true,
                'parse_mode' => 'HTML',
            ]);
            if (!empty($divida['conta_id']) && !empty($enviador['usuario_representante_id'])) {
                $sql = "SELECT * FROM contas WHERE idContas = " . $divida['conta_id'];
                $query = $this->pdo->query($sql);
                $conta = $query->fetch();
                $donoConta_id = $conta['usuario_id'];
                $idContas = $conta['idContas'];

                if ($donoConta_id != $enviador['usuario_representante_id']) {
                    $dataDividas = array(
                        ':data' => date('Y-m-d H:i:s'),
                        ':enviador_id' => 1,
                        ':recebedor_id' => $donoConta_id,
                        'comprovante' => "https://receitasdarkblog.icu/market/assets/comprovantes/photos/" . $file,
                        ':valor' => $divida['valor'],
                        ':descricao' => "Comprovante enviado via Telegram. Conta #" . $idContas,
                        ':conta_id' => $idContas,
                        ':tipo' => "POSITIVO",
                        //':venda_id' => $vendaId,
                    );
                    if (!empty($divida['venda_id'])) {
                        $dataDividas[':venda_id'] = $divida['venda_id'];
                        $sql = "INSERT INTO dividas (data, enviador_id, recebedor_id, valor, descricao, tipo, venda_id, status, comprovante, conta_id) VALUES (:data, :enviador_id, :recebedor_id, :valor, :descricao, :tipo, :venda_id, 1, :comprovante, :conta_id)";
                    } else {
                        $sql = "INSERT INTO dividas (data, enviador_id, recebedor_id, valor, descricao, tipo, status, comprovante, conta_id) VALUES (:data, :enviador_id, :recebedor_id, :valor, :descricao, :tipo, 1, :comprovante, :conta_id)";
                    }


                    if ($this->pdo->prepare($sql)->execute($dataDividas)) {

                        $text = "\xE2\x9C\x85 <b>Comprovante RECEBIDO</b> \xE2\x9C\x85\n";
                        $text .= "\nData de envio do comprovante: " . date(('d/m/Y'), strtotime($divida['data'])) . "\n";
                        $text .= "\nValor: R$" . $divida['valor'] . "\n";


                        $sql = "SELECT * FROM usuarios WHERE idUsuarios = {$donoConta_id}";
                        $query = $this->pdo->query($sql);
                        $donoConta = $query->fetch();

                        Request::sendPhoto([
                            'chat_id' => $donoConta['chat_id'],
                            'caption' => $text,
                            'photo' => Request::encodeFile($dir_file),
                            'reply_markup' => $inline_keyboard_comprovante,
                            'resize_keyboard' => true,
                            'parse_mode' => 'HTML',
                        ]);

                    }
                }


            }


            if ($enviador['idUsuarios'] == 1) {
                $sql = "SELECT * FROM usuarios WHERE idUsuarios = " . $divida['recebedor_id'];
                $query = $this->pdo->query($sql);
                $recebedor = $query->fetch();
                $text = "\xE2\x9C\x85 Comprovante enviado\xE2\x9C\x85";
                $text .= "\nValor: R$" . $divida['valor'] . "\n";
                Request::sendPhoto([
                    'chat_id' => $recebedor['chat_id'],
                    'caption' => $text,
                    'photo' => Request::encodeFile($dir_file),
                    'reply_markup' => $inline_keyboard_comprovante,
                    'resize_keyboard' => true,
                    'parse_mode' => 'HTML',
                ]);
            }

            $inline_keyboard_comprovante = new InlineKeyboard(
                [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
            );
            if ($this->user['permissoes_id'] == 1) {
                $text = "\xE2\x9C\x85 Comprovante enviado por {$enviador['nome']}\xE2\x9C\x85";
            }

            $text .= "\n Valor: R$" . $divida['valor'] . "\n";
            $this->sendMessageById($this->chat_id, $text, $inline_keyboard_comprovante);


        } else {
            $inline_keyboard = new InlineKeyboard(
                [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
            );
            $text = "Ocorreu um erro ao modificar o pedido.";
            $this->sendMessage($text, $inline_keyboard);
        }

    }

    public
    function ReprovarComprovante($divida_id)
    {
        $this->notes['comprovanteReprovado'] = $divida_id;
        $this->notes['requestData'] = "PostComprovanteReprovacaoMotivo";
        $this->conversation->update();
        /*$inline_keyboard = new InlineKeyboard(
            [['text' => "\xF0\x9F\x93\xA5 Exluir Aviso", 'callback_data' => 'Reprovar_Pedido_'.$vendaId]]
        );*/
        $text = "Informe o motivo pelo qual você reprovou o o comprovante $divida_id";
        $this->sendMessageById($this->user['chat_id'], $text);
        //$this->sendMessage($text);


    }

    public
    function FaturarPedido()
    {

        //return $this->sendMessage("Oi".json_encode($this->notes));
        $vendaId = $this->notes['vendaId'];
        $usuario = $this->user;

        $representente_id = $usuario['usuario_representante_id'];
        $valorTotal = $this->notes['valorTotal'];


        $categoria_id = 0;
        $faturado = 1;
        $dataVenda = array(
            ':valorTotal' => $valorTotal,
            ':faturado' => $faturado,
            ':vendaId' => $vendaId,
        );
        if (!empty($this->notes['valor_envio']) || $this->notes['valor_envio'] === 0) {

            $valor_envio = $this->notes['valor_envio'];
            $dataHoje = date('Y-m-d H:i:s');

            $sql = "UPDATE vendas set valorTotal = :valorTotal, taxa_envio = '$valor_envio', faturado = :faturado, dataVenda = '" . $dataHoje . "' WHERE idVendas = :vendaId";
            $prepSql = $this->pdo->prepare($sql);
            if ($prepSql->execute($dataVenda)) {

                //ENVIANDO PEDIDO PARA APROVAÇÃO
                $sql = "SELECT * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $vendaId";
                $query = $this->pdo->query($sql);
                $produtos = $query->fetchAll();
                $rows = $query->rowCount();
                $total = 0;

                $listProd = "";
                if ($rows > 0) {
                    foreach ($produtos as $produto) {
                        $categoria_id = $produto['categoriaId'];
                        $produto['subTotal'] = $produto['subTotal'];
                        $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n";
                        $total += $produto['subTotal'];
                    }
                }
                $total += $valor_envio;

                $inline_keyboard = new InlineKeyboard(
                    [['text' => 'Finalizar pedido', 'callback_data' => 'Faturar_Pedido']],
                    [['text' => 'Enviar pagamento deste pedido', 'callback_data' => 'Input_ValorComprovante']],
                    [['text' => 'Cancelar pedido', 'callback_data' => 'Main_CancelarVenda']]
                );

                $textWarnyj = "\xF0\x9F\x93\x8A " . $this->user['nome'] . "\nUma venda foi realizada!\nPedido #$vendaId\nConfira os dados de envio e cadastros.\n\n" . $this->notes['dadosEnvio'];

                if (!empty($venda['observacoes'])) {
                    $textWarnyj .= "\n\nObservação: \n";
                    $textWarnyj .= $venda['observacoes'] . "\n";

                }
                $tipo_envio = $venda['tipoEnvio'];
                //$cat = $this->UtilBuscaCategoriaById($venda['categoria_id']);
                //$cat_nome = $cat['categoria'];
                $cat_nome = "ID da Categoria: ".$categoria_id;
                $textWarnyj .= "\n-----------------------------------------\n\n#$vendaId\n<b>$cat_nome</b>\n\nProdutos no carrinho:\n\nQuantidade - Nome : Valor\n" .
                    $listProd . "\nTipo de Envio: $tipo_envio - R$$valor_envio\nTotal com Frete: R$" .
                    $total . "\n";
                if (($this->user['controle_completo'] == 1) && !empty($this->notes['valorTotal'])) {
                    $textWarnyj .= "\n\nTotal informado de depósito: R$" . $this->notes['valorTotal'] . "\n\n";
                }
                $totalizadorDivida = $this->totalizador($this->user['idUsuarios'], 1);
                $saldoPosAprovacao = $totalizadorDivida - $this->notes['valorTotal'];
                $textWarnyj .= "\n\nSaldo atual de " . $this->user['nome']." : R$" . $totalizadorDivida . "\n\n";
                $textWarnyj .= "\n\nSaldo após aprovação : R$" . $saldoPosAprovacao . "\n\n";

                //617711684
                //ENVIAR PEDIDO O ADM
                $inline_keyboard_warnyj = new InlineKeyboard(
                    [['text' => "\xE2\x9C\x85 Aprovar pedido", 'callback_data' => "Aprovar_Pedido_$vendaId"]],
                    [['text' => "\xE2\x9D\x8C Reprovar pedido", 'callback_data' => "Reprovar_Pedido_$vendaId"]]
                );

                $this->sendMessageById(889423113, $textWarnyj, $inline_keyboard_warnyj);

                //---------------------------------------


                $sql = "SELECT * FROM itens_de_vendas as idv INNER JOIN produtos p on idv.produtos_id = p.idProdutos WHERE idv.vendas_id = $vendaId";
                $query = $this->pdo->query($sql);
                $itensVenda = $query->fetchAll();
                $rows = $query->rowCount();
                if ($rows > 0) {
                    $cadastroDividEnvio = 0;
                    $enviador = 0;

                    foreach ($itensVenda as $iv) {
                        if ($iv['idFornecedor'] != $this->user['idUsuarios']) {

                            $uV = $this->UtilBuscaValor($iv['produtos_id'], $this->user['permissoes_id'], $iv['quantidade']);
                            $preco = $uV['valor'];
                            $valorVenda = ($preco * $iv['quantidade']);

                            $sql = "SELECT * FROM usuario_valor WHERE produto_id = " . $iv['produtos_id'] . " AND usuario_id = 1 AND de <= " . $iv['quantidade'] . " AND ate >= " . $iv['quantidade'];
                            $query = $this->pdo->query($sql);
                            $admVal = $query->fetch();
                            $admPreco = $admVal['valor'];
                            $valorCusto = ($admPreco * $iv['quantidade']);

                            $descricao = "Venda #$vendaId + " . $iv['quantidade'] . " " . $iv['descricao'] . " | R$" . $preco . " cada";

                            if (!empty($representente_id)) {

                                $descricao = "Venda #$vendaId : " . $this->user['nome'] . "\n" . $iv['quantidade'] . " " . $iv['descricao'] . " | R$" . $preco . " cada";
                                $this->UtilInserirDivida($this->user['idUsuarios'], $representente_id, $valorVenda, $descricao, "NEGATIVO", $vendaId, 0);

                                if ($iv['idFornecedor'] != $representente_id) {
                                    $this->UtilInserirDivida($representente_id, $iv['idFornecedor'], $valorCusto, $descricao, "NEGATIVO", $vendaId, 0);
                                }

                            } else {
                                $dataDividas = array(
                                    ':data' => date('Y-m-d H:i:s'),
                                    ':enviador_id' => 1,
                                    ':recebedor_id' => $iv['idFornecedor'],
                                    ':valor' => $valorCusto,
                                    ':descricao' => $descricao,
                                    ':tipo' => "NEGATIVO",
                                    ':venda_id' => $vendaId,
                                );
                                $sql = "INSERT INTO dividas (data, enviador_id, recebedor_id, valor, descricao, tipo, venda_id, status) VALUES (:data, :enviador_id, :recebedor_id, :valor, :descricao, :tipo, :venda_id, 0)";

                                $this->pdo->prepare($sql)->execute($dataDividas);
                            }

                        }

                        if ($cadastroDividEnvio != 1) {
                            if ($enviador != $iv['usuarioEnvio_id']) {
                                $enviador = $iv['usuarioEnvio_id'];


                                $sql = "SELECT * FROM vendas WHERE idVendas = {$vendaId}";
                                $query = $this->pdo->query($sql);
                                $venda = $query->fetch();
                                $taxa_envio = $venda['taxa_envio'];

                                $descricao = "Venda #$vendaId - Frete: " . $venda['tipoEnvio'] . " - Valor R$$taxa_envio";

                                if (!empty($enviador)) {

                                    $dataDividas = array(
                                        ':data' => date('Y-m-d H:i:s'),
                                        ':enviador_id' => $usuario['idUsuarios'],
                                        ':recebedor_id' => 1,
                                        ':valor' => $taxa_envio,
                                        ':descricao' => $descricao,
                                        ':tipo' => "NEGATIVO",
                                        ':venda_id' => $vendaId,
                                    );


                                    $sql = "INSERT INTO dividas (data, enviador_id, recebedor_id, valor, descricao, tipo, venda_id) VALUES (:data, :enviador_id, :recebedor_id, :valor, :descricao, :tipo, :venda_id)";

                                    $this->pdo->prepare($sql)->execute($dataDividas);

                                    if ($iv['usuarioEnvio_id'] != 1) {

                                        if ($venda['tipoEnvio'] == "SEGURO") {
                                            $cat = $this->UtilBuscaCategoriaById($venda['categoria_id']);
                                            $taxa_envio_enviador = $cat['envio_seguro'];
                                            $descricao = "Venda #$vendaId - Frete: " . $venda['tipoEnvio'] . " - Valor R$$taxa_envio_enviador";
                                        }else{
                                            $taxa_envio_enviador = $taxa_envio;
                                        }
                                        $dataDividas = array(
                                            ':data' => date('Y-m-d H:i:s'),
                                            ':enviador_id' => $representente_id,
                                            ':recebedor_id' => $iv['usuarioEnvio_id'],
                                            ':valor' => $taxa_envio_enviador,
                                            ':descricao' => $descricao,
                                            ':tipo' => "NEGATIVO",
                                            ':venda_id' => $vendaId,
                                        );
                                        $sql = "INSERT INTO dividas (data, enviador_id, recebedor_id, valor, descricao, tipo, venda_id, frete) VALUES (:data, :enviador_id, :recebedor_id, :valor, :descricao, :tipo, :venda_id, 1)";

                                        $this->pdo->prepare($sql)->execute($dataDividas);
                                    }

                                } else {
                                    $dataDividas = array(
                                        ':data' => date('Y-m-d H:i:s'),
                                        ':enviador_id' => 1,
                                        ':recebedor_id' => $iv['usuarioEnvio_id'],
                                        ':valor' => $taxa_envio,
                                        ':descricao' => $descricao,
                                        ':tipo' => "NEGATIVO",
                                        ':venda_id' => $vendaId,
                                    );
                                    $sql = "INSERT INTO dividas (data, enviador_id, recebedor_id, valor, descricao, tipo, venda_id, frete) VALUES (:data, :enviador_id, :recebedor_id, :valor, :descricao, :tipo, :venda_id, 1)";

                                    $this->pdo->prepare($sql)->execute($dataDividas);
                                }
                                $cadastroDividEnvio = 1;


                            }

                        }

                    }


                    $sql = "SELECT * FROM vendas WHERE idVendas = {$vendaId}";
                    $query = $this->pdo->query($sql);
                    $venda = $query->fetch();

                    if ($venda['enviador_id'] != 0) {
                        $enviador = $venda['enviador_id'];
                    }

                    $dataVenda = array(
                        ':enviador_id' => $enviador,
                        ':vendaId' => $vendaId,
                    );

                    $sql = "UPDATE vendas set enviador_id = :enviador_id WHERE idVendas = :vendaId";

                    $prepSql = $this->pdo->prepare($sql);
                    if ($prepSql->execute($dataVenda)) {

                        $dataUsuario = array(
                            ':user_telegram'=>"$this->chat_username",
                            ':id' => $usuario['idUsuarios'],
                        );
                        $sql = "UPDATE usuarios set user_telegram = :user_telegram WHERE idUsuarios = :id";
                        $prepSql = $this->pdo->prepare($sql);

                        if ($prepSql->execute($dataUsuario)) {

                        }

                        $text = "\xE2\x9C\x85 <b>Pedido cadastrado com sucesso</b>\xE2\x9C\x85\n\nO pedido foi enviado para avaliação, em breve você será notificado.";

                        //$this->deleteMessage($this->notes['msgDadosEnvioId']);
                        $this->sendMessage($text);
                    }
                } else {
                    $text = "Nenhum produto encontrado neste pedido.";
                    $this->sendErrorMessage($text);
                }
            }
        } else {
            $text = "Taxa de envio não cadastrada!";
            $this->sendErrorMessage($text);
        }


    }

    public function SelecionaEmojiPermissao($permisssao_id)
    {
        switch ($permisssao_id) {
            case "1":
                //ADMIN - ESTRELA
                $icone = "\xE2\xAD\x90";
                break;
            case "2":
                //SOCIO - CORAÇÃO
                $icone = "\xE2\x9D\xA4";
                break;
            case "3":
                //SUPER - AVIAO
                $icone = "	\xE2\x9C\x88";
                break;
            case "4":
                //TELECRAZY - CAMINHAO
                $icone = "\xF0\x9F\x9A\x9A";
                break;
            case "5":
                //OFICIAIS - CARRO
                $icone = "	\xF0\x9F\x9A\x97";
                break;
            case "6":
                //FINAL - BANDEIRA
                $icone = "\xF0\x9F\x9A\xA9";
                break;

        }
        return $icone;
    }

    public function UtilInserirDivida($enviador_id, $recebedor_id, $valor, $descricao, $tipo = "POSITIVO", $venda_id = null, $status)
    {

        $data = date('Y-m-d H:i:s');
        $dataDividas = array(
            ':data' => $data,
            ':enviador_id' => $enviador_id,
            ':recebedor_id' => $recebedor_id,
            ':valor' => $valor,
            ':descricao' => $descricao,
            ':tipo' => $tipo,
            ':venda_id' => $venda_id,
            ':status' => $status,
        );
        $sql = "INSERT INTO dividas (data, enviador_id, recebedor_id, valor, descricao, tipo, venda_id, status) VALUES (:data, :enviador_id, :recebedor_id, :valor, :descricao, :tipo, :venda_id, :status)";

        return $this->pdo->prepare($sql)->execute($dataDividas);
    }

    public function UtilBuscaDivida($usuario1 = null, $usuario2 = null, $status)
    {

        if ($usuario1 != null && $usuario2 != null) {
            $sql = "SELECT * FROM dividas WHERE ((enviador_id = $usuario1 AND recebedor_id = $usuario2) OR (recebedor_id = $usuario1 AND enviador_id = " . $usuario2 . ")) AND status = " . $status;
        }
        $query = $this->pdo->query($sql);
        return $query->fetchAll();
    }


    public function UtilBuscaValor($produto_id, $permissao_id, $quantidade)
    {
        $sql = "SELECT * FROM usuario_valor WHERE produto_id = " . $produto_id . " AND usuario_id = " . $permissao_id . " AND de <= " . $quantidade . " AND ate >= " . $quantidade;
        $query = $this->pdo->query($sql);
        return $query->fetch();
    }

    public function UtilBuscaItensVendaByVendaId($venda_id)
    {
        $sql = "SELECT * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $venda_id";
        $query = $this->pdo->query($sql);
        return $query->fetchAll();
    }

    public function UtilGetListaProdutos($venda = array())
    {
        $retorno = array();
        $produtos = $this->UtilBuscaItensVendaByVendaId($venda['idVendas']);
        $rows = count($produtos);
        $retorno['textListaProdutos'] = "";
        $retorno['total'] = 0;
        $retorno['fornecedor'] = 0;
        if ($rows > 0) {
            foreach ($produtos as $produto) {
                $subTotal = 0;
                if ($produto['idFornecedor'] == $this->user['idUsuarios']) {
                    $retorno['fornecedor'] = 1;
                }

                if (($venda['enviador_id'] == $this->user['idUsuarios']) && ($retorno['fornecedor'] == 0)) {
                    $retorno['textListaProdutos'] .= $produto['quantidade'] . $produto['unidade'] . " - " . $produto['descricao'] . "\n";
                    $subTotal = $produto['subTotal'];
                } else {
                    if($retorno['fornecedor'] == 1){
                        $valorAdm = $this->UtilBuscaValor($produto['idProdutos'], 1, $produto['quantidade']);
                        $valorAdm = $valorAdm['valor'] * $produto['quantidade'];
                        $retorno['textListaProdutos'] .= $produto['quantidade'] . $produto['unidade'] . " A - " . $produto['descricao'] . " : R$" . $valorAdm . "\n";
                        $subTotal = $valorAdm;
                    }else{
                        $retorno['textListaProdutos'] .= $produto['quantidade'] . $produto['unidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n";
                        $subTotal = $produto['subTotal'];
                    }

                }

                $retorno['total'] += $subTotal;
            }
        }

        if ($venda['tipoEnvio'] == "SEGURO" && $venda['enviador_id'] == $this->user['idUsuarios']) {
            $cat = $this->UtilBuscaCategoriaById($venda['categoria_id']);
            $taxa_envio = $cat['envio_seguro'];
        }else{
            $taxa_envio = $venda['taxa_envio'];
        }

        $retorno['total'] += $taxa_envio;

        return $retorno;
    }


    public function UtilBuscaCategoriaById($categoria_id)
    {
        $sql = "SELECT * FROM categorias WHERE idCategorias = $categoria_id";
        $query = $this->pdo->query($sql);
        return $query->fetch();

    }

    public function UtilBuscaUsuarioByChat($chat_id)
    {
        $sql = "SELECT * FROM usuarios WHERE chat_id = {$chat_id}";
        $query = $this->pdo->query($sql);
        return $query->fetch();
    }

    public function UtilBuscaUsuarioById($usuario_id)
    {
        $sql = "SELECT * FROM usuarios WHERE idUsuarios = {$usuario_id}";
        $query = $this->pdo->query($sql);
        return $query->fetch();
    }

    public function UtilBuscaPermissaoById($usuario_id)
    {
        $sql = "SELECT * FROM usuarios WHERE idUsuarios = {$usuario_id}";
        $query = $this->pdo->query($sql);
        return $query->fetch();
    }

    public function ConfirmarDados()
    {
        $vendaId = $this->notes['vendaId'];
        $idUsuario = $this->user['idUsuarios'];
        $userId = 1;
        $sql = "SELECT * FROM vendas WHERE idVendas = {$vendaId}";
        $query = $this->pdo->query($sql);
        $venda = $query->fetch();

        $tipo_envio = $this->notes['tipo_envio'];

        $valor_envio = $this->notes['valor_envio'];

        $sql = "SELECT * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $vendaId";
        $query = $this->pdo->query($sql);
        $produtos = $query->fetchAll();
        $rows = $query->rowCount();
        $total = 0;
        $pedidoPesado = 0;
        if ($rows > 0) {
            $listProd = "";
            foreach ($produtos as $produto) {
                if ($produto['pesado'] == 1) {
                    $pedidoPesado = 1;
                }
                $produto['subTotal'] = $produto['subTotal'];
                $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n";
                $total += $produto['subTotal'];
            }
        }
        $total += $valor_envio;

        if (empty($this->notes['valorTotal'])) {
            $this->notes['valorTotal'] = $total;
        }
        $this->notes['pedidoPesado'] = $pedidoPesado;
        $this->conversation->update();


        $text = "\xF0\x9F\x9A\xA8 <b>ATENÇÃO!</b> \xF0\x9F\x9A\xA8\n\nConfira os dados de envio, e produtos selecionados!\n\nDados de envio:\n\n" . $this->notes['dadosEnvio'];

        if (!empty($venda['observacoes'])) {
            $text .= "\n\nObservação: \n";
            $text .= $venda['observacoes'] . "\n";

        }


        $text .= "\n-----------------------------------------\n\nPedido #$vendaId\nProdutos no carrinho:\n\nQuantidade - Nome : Valor\n" .
            $listProd . "\nTipo de Envio: $tipo_envio - <b>R$$valor_envio\nTotal com Frete: R$" .
            $total . "</b>";

        if (($this->user['controle_completo'] == 1) && !empty($this->notes['valorTotal'])) {
            $text .= "\n\nTotal informado de depósito: R$ \n\n";
        }
        $text .= "\n\n\xF0\x9F\x9A\xA8 <b>ATENÇÃO!</b> \xF0\x9F\x9A\xA8\nPEDIDOS COM PRODUTOS NÃO CADASTRADOS NÃO SERÃO ACEITOS!\n\n";
        $text .= "NÃO NOS RESPONSABILIZAMOS POR PERCAS NO CORREIOS!\n\n";
        $text .= "EM ALGUNS DIAS VOCÊ RECEBERÁ UMA MENSAGEM COM O CÓDIGO DE RASTREIO!\n\n";
        $text .= "\xF0\x9F\x9A\xA8 <b>Confira todos os dados!</b> \xF0\x9F\x9A\xA8\n\n";


        $sql = "SELECT * FROM dividas WHERE ((enviador_id = $idUsuario AND recebedor_id = $userId) OR (recebedor_id = $idUsuario AND enviador_id = " . $userId . ")) AND status = 1";
        $query = $this->pdo->query($sql);
        $dividasTotal = $query->fetchAll();
        $totalizador = 0;
        foreach ($dividasTotal as $d) {
            if ($d['enviador_id'] == $userId) {
                if ($d['tipo'] == "POSITIVO") {
                    $totalizador += $d['valor'];
                } else if ($d['tipo'] == "NEGATIVO") {
                    $totalizador -= $d['valor'];
                }
            } else {
                if ($d['tipo'] == "POSITIVO") {
                    $totalizador -= $d['valor'];
                } else if ($d['tipo'] == "NEGATIVO") {
                    $totalizador += $d['valor'];
                }
            }
        }

        $totalizador = abs($totalizador);
        $total = abs($total);
        if ($totalizador < $total && $this->user['dividas'] != 1) {

            $diff = $total - $totalizador;
            $text .= "------------------------------\n";
            $text .= "\xF0\x9F\x9A\xAB Você <b>NÃO POSSUI SALDO</b> para realizar essa compra!\xF0\x9F\x9A\xAB\n\nSeu saldo: <b>R$" . $totalizador . "</b>\nValor total da compra: <b>R$" . $total . "</b>\nFaltam: <b>R$" . $diff . "</b> para finalizar a compra.\n\nPara inserir saldo clique em \xF0\x9F\x92\xB5 <b>Inserir saldo</b> \xF0\x9F\x92\xB5";
            $inline_keyboard = new InlineKeyboard(
                [['text' => "\xF0\x9F\x92\xB5 Inserir saldo \xF0\x9F\x92\xB5", 'callback_data' => 'Input_ValorComprovante']],
                [['text' => "\xF0\x9F\x93\x8B Inserir / alterar observação \xF0\x9F\x93\x8B", 'callback_data' => 'Obseravacao_Pedido']],
                //[['text' => 'Enviar pagamento deste pedido', 'callback_data' => 'Input_ValorComprovante']],
                [['text' => "\xE2\x9D\x8C Cancelar pedido \xE2\x9D\x8C", 'callback_data' => 'Main_CancelarVenda']]
            );
        } else {
            $inline_keyboard = new InlineKeyboard(
                [['text' => "\xE2\x9C\x85 Finalizar pedido", 'callback_data' => 'Faturar_Pedido']],
                [['text' => "\xF0\x9F\x93\x8B Inserir / alterar observação \xF0\x9F\x93\x8B", 'callback_data' => 'Obseravacao_Pedido']],
                //[['text' => 'Enviar pagamento deste pedido', 'callback_data' => 'Input_ValorComprovante']],
                [['text' => "\xE2\x9D\x8C Cancelar pedido \xE2\x9D\x8C", 'callback_data' => 'Main_CancelarVenda']]
            );
        }


        return $this->sendMessage($text, $inline_keyboard);
    }

    public function ObseravacaoPedido()
    {

        $this->notes['requestData'] = "ObseravacaoPedido";
        $this->conversation->update();

        $text = "Coloque aqui observações do pedido";
        $this->sendMessage($text);

    }

//METODOS DE POST
    public
    function PostCategoria($categoria_id = 0)
    {
        if (!empty($this->notes['vendaId'])) {
            $this->notes['categoria_id'] = $categoria_id;
            $this->conversation->update();
            $dataVenda = array(
                ':categoria_id' => $categoria_id,
                ':idVendas' => $this->notes['vendaId'],
            );
            $sql = "UPDATE vendas set categoria_id = :categoria_id WHERE idVendas = :idVendas";
            $prepSql = $this->pdo->prepare($sql);
            if ($prepSql->execute($dataVenda)) {

            }
            $sql = "SELECT * FROM produtos WHERE categoriaId = $categoria_id AND status = 1 ORDER BY descricao asc";
            $query = $this->pdo->query($sql);
            $produtos = $query->fetchAll();
            $rows = $query->rowCount();

            if ($rows > 0) {

                $inline_keyboard = new InlineKeyboard();
                foreach ($produtos as $produto) {

                    $sql = "SELECT * FROM usuario_valor WHERE produto_id = " . $produto['idProdutos'] . " AND usuario_id = " . $this->user['permissoes_id'] . " ORDER BY valor DESC";
                    $query = $this->pdo->query($sql);
                    $uV = $query->fetch();

                    $val = $uV['valor'];
                    $icone = $this->SelecionaIcone($produto['tipo_id']);
                    $inline_keyboard->addRow(new InlineKeyboardButton([
                        'text' => $icone . " " . $produto['descricao'] . " - R$$val" . " cada",
                        'callback_data' => "Post_Produto_" . $produto['idProdutos']
                    ]));
                }
                $sql = "SELECT * FROM categorias WHERE idCategorias = " . $produto['categoriaId'] . " AND status = 1";
                $query = $this->pdo->query($sql);
                $categoria = $query->fetch();
                $text = "<b>" . $categoria['categoria'] . "</b>\n";
                $text .= "Tempo limite de despache: " . $categoria['despache'] . " dias úteis após a aprovação do pedido.\n\n";
                $text .= "CEP para consultar prazo: <b>" . $categoria['cep'] . "</b>\n\n";
                $text .= "<b>Valor do Frete</b>:\n";
                if ($categoria['gratis'] == 1) {
                    $text .= "Frete Gráris (apenas promoção)\n";
                }
                if ($categoria['sedex']) {
                    $text .= "Sedex: R$" . $categoria['sedex'] . "\n";
                }
                if ($categoria['carta']) {
                    $text .= "Carta: R$" . $categoria['carta'] . "\n";
                }
                if ($categoria['pac']) {
                    $text .= "PAC: R$" . $categoria['pac'] . "\n";
                }
                if ($categoria['jadlog']) {
                    $text .= "Jadlog: R$" . $categoria['jadlog'] . "\n";
                    $text .= "<i>(Jadlog: Coloque o CPF na observação do pedido)</i>\n";
                }
                if ($categoria['envio_seguro']) {
                    $text .= "Envio com seguro: R$" . $categoria['envio_seguro'] . " + 15% do total os produtos.\n";
                    $text .= "<i>Envio com seguro cobre qualquer tipo de perca nos correios, caso seus pedido não tenha seguro não cubrimos imprevistos no envio</i>\n";
                }

                /*
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "\xF0\x9F\x93\xA4 Trocar estoque",
                    'callback_data' => 'Lista_Estoques'
                ]));
                */
                $text .= "Selecione o produto que deseja comprar.";

                $this->sendMessage($text, $inline_keyboard);
            }
        } else {
            $text = "Pedido não encontrado!";
            $this->sendErrorMessage($text);
        }
    }

    public
    function PostProduto($produto_id)
    {
        $this->notes['produto_id'] = $produto_id;
        $idUsuario = $this->user['idUsuarios'];
        $this->conversation->update();

        $sql = "SELECT * FROM produtos WHERE idProdutos = {$produto_id}";
        $query = $this->pdo->query($sql);
        $produto = $query->fetch();
        if (!empty($produto)) {


            $sql = "SELECT * FROM usuarios WHERE idUsuarios = {$idUsuario}";
            $query = $this->pdo->query($sql);
            $user = $query->fetch();
            $idPermissao = $user['permissoes_id'];
            $icone = $this->SelecionaIcone($produto['tipo_id']);
            $text = "<b>$icone " . $produto['descricao'] . " $icone</b>\n\n";
            if (!empty($produto['observacao'])) {
                $text .= $produto['observacao'] . "\n\n";
            }

            $text .= "<b>Valores</b>:\n";

            $sql = "SELECT * FROM usuario_valor WHERE produto_id = " . $produto['idProdutos'] . " AND usuario_id = " . $this->user['permissoes_id'] . " ORDER BY de ASC";
            $query = $this->pdo->query($sql);
            $valores = $query->fetchAll();


            foreach ($valores as $valor) {
                $preco = $valor['valor'];
                $de = $valor['de'];
                $ate = $valor['ate'];
                $unidade = $valor['unidade'];

                $text .= "<i>de " . $de . $unidade . " até " . $ate . $unidade . " = <b>R$" . $preco . "</b></i>\n";
            }
            $text .= "\n";
            $sql = "SELECT * FROM categorias WHERE idCategorias = " . $produto['categoriaId'] . " AND status = 1";
            $query = $this->pdo->query($sql);
            $categoria = $query->fetch();
            $text .= "<b>" . $categoria['categoria'] . "</b>\n";
            $text .= "Tempo limite de despache: " . $categoria['despache'] . " dias úteis após a aprovação do pedido.\n-\n";
            $text .= "CEP para consultar prazo: <b>" . $categoria['cep'] . "</b>\n\n";
            $text .= "<b>Valor do Frete</b>:\n";
            if ($categoria['gratis'] == 1) {
                $text .= "<b>Frete Gráris</b> (apenas promoção)\n";
            }
            if ($categoria['sedex']) {
                $text .= "<b>Sedex</b>: R$" . $categoria['sedex'] . "\n";
            }
            if ($categoria['carta']) {
                if ($produto['pesado'] == 1) {
                    $text .= "<b>Este produto não pode ser enviado por carta.</b>\n";
                } else {
                    $text .= "<b>Carta</b>: R$" . $categoria['carta'] . "\n";
                }

            }
            if ($categoria['pac']) {
                $text .= "<b>PAC</b>: R$" . $categoria['pac'] . "\n";
            }
            if ($categoria['jadlog']) {
                $text .= "<b>Jadlog</b>: R$" . $categoria['jadlog'] . "\n";
                $text .= "<i>(Jadlog: Coloque o CPF na observação do pedido)</i>\n\n";
            }
            if ($categoria['envio_seguro']) {
                $text .= "<b>Envio com seguro</b>: R$" . $categoria['envio_seguro'] . " + 15% do total da compra.\n";
                $text .= "<i>Envio com seguro cobre qualquer tipo de perca nos correios, caso seus pedido não tenha seguro não cubrimos imprevistos no envio</i>\n\n";
            }

            $text .= "Informe a quantidade de " . $produto['descricao'] . " que você deseja comprar.";
            //$this->sendMessage($text);
            $inline_keyboard = new InlineKeyboard();
            if (!empty($produto['imagem'])) {
             
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "	\xE2\x9E\x95 Voltar ao menu principal / Atualizar \xF0\x9F\x94\x99", 'callback_data' => 'Main_Menu'
                ]));
                
                $result = Request::sendPhoto([
                    'chat_id' => $this->chat_id,
                    'caption' => $text,
                    'photo' => Request::encodeFile($produto['imagem']),
                    'reply_markup' => $inline_keyboard,
                    'resize_keyboard' => true,
                    'parse_mode' => 'HTML',
                ]);
                $this->notes['lastMsgId'] = $result->getResult()->getMessageId();
            } else {
              
                $this->sendMessage($text, $inline_keyboard);
                $this->conversation->update();
            }

        
            $this->notes['requestData'] = "informarQuantidadeProduto";
            $this->conversation->update();
        }
    }

    public function PostTipoEnvio($tipo_envio)
    {
        $vendaId = $this->notes['vendaId'];

        $sql = "SELECT * FROM itens_de_vendas WHERE vendas_id = $vendaId";
        $query = $this->pdo->query($sql);
        $produtos = $query->fetchAll();
        $rows = $query->rowCount();
        $totalProdutos = 0;
        foreach ($produtos as $produto) {
            $totalProdutos += $produto['subTotal'];
        }

        $dataVenda = array(
            ':tipoEnvio' => $tipo_envio,
            ':vendaId' => $vendaId,
        );
        $sql = "UPDATE vendas set tipoEnvio = :tipoEnvio WHERE idVendas = :vendaId";

        $prepSql = $this->pdo->prepare($sql);
        if ($prepSql->execute($dataVenda)) {
            $sql = "SELECT * FROM categorias WHERE idCategorias = " . $this->notes['categoria_id'];
            $query = $this->pdo->query($sql);
            $categoria = $query->fetch();

            if ($tipo_envio == "SEDEX") {
                $valor_envio = $categoria['sedex'];
            } else if ($tipo_envio == "CARTA") {
                $valor_envio = $categoria['carta'];
            } else if ($tipo_envio == "NENHUM") {
                $valor_envio = 1;
            } else if ($tipo_envio == "GRATIS") {
                $valor_envio = 0;
            } else if ($tipo_envio == "JADLOG") {
                $valor_envio = $categoria['jadlog'];
            } else if ($tipo_envio == "SEGURO") {
                $valor_envio = $categoria['envio_seguro'];
                $valor_envio = $valor_envio + ($totalProdutos * 0.15);
            }

            $this->notes['tipo_envio'] = $tipo_envio;
            $this->notes['valor_envio'] = $valor_envio;
            $this->conversation->update();

            //$this->sendMessage(json_encode($this->user));
            if ($this->user['controle_completo'] == 1) {
                $this->InputValorComprovante();
            } else {
                $this->ConfirmarDados();
            }
        }
    }

    public
    function InputValorComprovante($usuarioComprovante)
    {

        if ($this->checkPermission($this->user['idUsuarios'], "cUsuario") && empty($usuarioComprovante)) {
            $sql = "SELECT * FROM usuarios ORDER BY nome DESC";
            $query = $this->pdo->query($sql);
            $usuarios = $query->fetchAll();
            $inline_keyboard = new InlineKeyboard();
            foreach ($usuarios as $u) {
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => $u['nome'],
                    'callback_data' => "Input_ValorComprovante_" . $u['idUsuarios']
                ]));
            }
            $this->sendMessage("Selecione quem receberá esse comprovante", $inline_keyboard);
        } else {
            if (empty($usuarioComprovante)) {
                $usuarioComprovante = 1;
            }

            $this->notes['usuarioComprovante'] = $usuarioComprovante;

            $this->notes['requestData'] = "solicitarValorComprovante";
            $this->conversation->update();
            $text = "\xF0\x9F\x92\xB0 Qual valor você deseja adicionar?";
            $this->sendMessage($text);
        }

    }

    public
    function SolicitaComprovante($usuarioComprovante)
    {
        $this->notes['requestData'] = "PostComprovante";
        $this->conversation->update();

        $text = "Me envie a imagem do comprovante. \xF0\x9F\x93\xB7";
        $this->sendMessage($text);
    }

    public
    function InputConta($usuarioComprovante)
    {

        $this->notes['usuarioComprovante'] = 1;

        $this->notes['requestData'] = "solicitarImagemComprovanteCliente";
        $this->conversation->update();


        $sql = "SELECT * FROM contas";
        $query = $this->pdo->query($sql);
        $contas = $query->fetchAll();
        $rows = $query->rowCount();

        if ($rows > 0) {
            $inlineItens = array();
            $i = 0;

            $inline_keyboard = new InlineKeyboard();

            foreach ($contas as $conta) {
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => $conta['nome'],
                    'callback_data' => "Post_Conta_" . $conta['idContas']
                ]));
            }

            //SOLICITA A CATEGORIA
            $text = "Selecione o tipo de conta que deseja efetuar o pagamento.";
            $this->sendMessage($text, $inline_keyboard);


        }

    }

    public
    function totalizador($usr1, $usr2)
    {
        $pdo = DB::getPdo();
        $totalizador = 0;

        $sql = "SELECT * FROM dividas WHERE ((enviador_id = $usr1 AND recebedor_id = " . $usr2 . ") OR (recebedor_id = $usr1 AND enviador_id = " . $usr2 . ")) AND status = 1";

        //$this->sendMessage($sql);

        $query = $this->pdo->query($sql);
        $dividasTotal = $query->fetchAll();
        foreach ($dividasTotal as $d) {
            if ($d['enviador_id'] == $usr1) {
                if ($d['tipo'] == "POSITIVO") {
                    $totalizador += $d['valor'];
                } else if ($d['tipo'] == "NEGATIVO") {
                    $totalizador -= $d['valor'];
                }
            } else {
                if ($d['tipo'] == "POSITIVO") {
                    $totalizador -= $d['valor'];
                } else if ($d['tipo'] == "NEGATIVO") {
                    $totalizador += $d['valor'];
                }
            }
        }

        return $totalizador;
    }

    public
    function getUserValue($user_id, $product_id)
    {

        $pdo = DB::getPdo();

        $sql = "SELECT * FROM usuario_valor WHERE usuario_id = $user_id AND produto_id = $product_id";
        $query = $pdo->query($sql);
        $userValue = $query->fetch();
        $userValue = $userValue->valor;
        return $userValue;

    }

//METODOS COMPLEMENTARES
    public
    function ExcluirAviso()
    {
        $this->deleteMessage($this->message_id);
    }

    public
    function InlineKeyboardDB($dataResult, $dataPrefix, $dataCallback, $dataText, $limitPerLine)
    {
        $keyboard = array();
        $line = array();
        $limit = false;

        $j = 0;
        $i = 0;
        foreach ($dataResult as $row) {
            $dataID = $row[$dataCallback];

            $line[$i]['text'] = $row[$dataText];
            $line[$i]['callback_data'] = "$dataPrefix" . "_" . "$dataID";
            $i++;
            if ($i == $limitPerLine) {
                $limit = true;
                $keyboard[] = $line;
                $line = array();
                $i = 0;
            }
            $j++;
        }

        if ($limit === false) {
            $keyboard = $line;
        }
        /*
                $keyboard = array([
                    ['text' => 'asdasdas', 'callback_data' => 'identifier'],
                    ['text' => 'adasdasd url', 'url' => 'https://github.com/akalongman/php-telegram-bot'],
                ], [
                ['text' => 'callback', 'callback_data' => 'identifier'],
                ['text' => 'open url', 'url' => 'https://github.com/akalongman/php-telegram-bot'],
            ]);*/
        return $keyboard;
    }

    public
    function sendMessageWarnyj($chat_id, $text, $inline_keyboard = null)
    {
        $botToken = "604380777:AAE-NdEyylxNfa1_luGYM4ad3V4nvtgVktU";
        $api_url = 'https://api.telegram.org/bot' . $botToken . '/';
        $parameters['chat_id'] = $chat_id;
        $parameters['text'] = $text;

        if (!empty($inline_keyboard)) {
            $parameters['reply_markup']['inline_keyboard'] = $inline_keyboard;
        }

        $options = array(
            'http' => array(
                'method' => 'POST',
                'content' => json_encode($parameters),
                'header' => "Content-Type: application/json\r\n" .
                    "Accept: application/json\r\n"
            )
        );

        $context = stream_context_create($options);
        file_get_contents($api_url . "sendMessage", false, $context);

    }

    public
    function sendMessageById($chat_id, $text, $inline_keyboard = null)
    {
        //$text .= "\nUltimo ID: ".$this->notes['lastMsgId'];
        if (!empty($inline_keyboard)) {
            $data = [
                'chat_id' => $chat_id,
                'text' => $text,
                'reply_markup' => $inline_keyboard,
                'resize_keyboard' => true,
                'parse_mode' => 'HTML',
            ];
        } else {
            $data = [
                'chat_id' => $chat_id,
                'text' => $text,
                'parse_mode' => 'HTML',
            ];
        }

        $result = Request::sendMessage($data);
        $this->notes['lastMsgId'] = $result->getResult()->getMessageId();
        $this->conversation->update();
        return $this->notes['lastMsgId'];
    }

    public
    function sendMessage($text, InlineKeyboard $inline_keyboard = null)
    {
        try{
        //$text .= "\nUltimo ID: ".$this->notes['lastMsgId'];
        if (empty($inline_keyboard)) {
            $inline_keyboard = new InlineKeyboard(
                [['text' => "\xF0\x9F\x94\x99 Voltar ao menu principal / Atualizar \xF0\x9F\x94\x99", 'callback_data' => 'Main_Menu']]
            );
        } else {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x94\x99 Voltar ao menu principal / Atualizar \xF0\x9F\x94\x99", 'callback_data' => 'Main_Menu'
            ]));
        }

        //$util = new UploadCommand();

        //if (empty($this->notes['msgInicialId'])) {
        $dataSend = [
            'message_id' => $this->notes['lastMsgId'],
            'chat_id' => $this->chat_id,
            //'text' => $this->notes['vendaId']." - ".$text,
            'text' => $text,
            'reply_markup' => $inline_keyboard,
            'resize_keyboard' => true,
            'parse_mode' => 'HTML',
            'disable_web_page_preview' => true

        ];
        //$this->notes['msgInicialId'] =  $this->notes['lastMsgId'];
        $result = Request::sendMessage($dataSend);
        //$result = Request::editMessageText($dataSend);
        $this->notes['lastMsgId'] = $result->getResult()->getMessageId();

        if ($result->isOk()) {
            /* $data = [
                 'chat_id' => $this->chat_id,
                 'message_id' => $this->notes['lastMsgId'],
                 'text' => $result->getResult()->getMessageId().' - This message was edited. - '.$this->notes['msgInicialId']
             ];
             Request::editMessageText($data);
            */

        } else {
            Request::emptyResponse();
        }
        /* }else{
             $data = [
                 'inline_message_id' =>$this->notes['lastMsgId'],
                 'text' => $this->notes['msgInicialId']." - ".$text,
                 'reply_markup' => $inline_keyboard,
                 'resize_keyboard' => true,
                 'parse_mode' => 'HTML'

             ];
             Request::editMessageText($data);
         }*/


        //Request::sendMessage(array('chat_id' => $this->chat_id, 'text' => "Send : ".json_encode($this->notes)));
        //$this->sendMessage("Send : ".json_encode($this->notes));
        //Request::editMessageText($data);

        if (empty($this->notes['msgInicialId'])) {
            $this->notes['msgInicialId'] = $this->notes['lastMsgId'];

        }
        $this->conversation->update();
        return $this->notes['lastMsgId'];
        }catch(Exception $e){
            $this->sendMessage("ERROR: " . $e->getMessage());
        }
    }

    public
    function sendErrorMessage($text = "")
    {
        $return_text = $text . "\nOps, ocorreu um erro aqui \xF0\x9F\x98\xAA \nLimpe esse chat, caso o erro persista contate um administrador.";
        if (!empty($text)) {
            $return_text .= "\nErro: " . $text;
        }

        return $this->sendMessage($return_text);
    }

    public
    function deleteMessage($message_id)
    {
        Request::deleteMessage([
            'chat_id' => $this->chat_id,
            'message_id' => $message_id

        ]);
    }

    public
    function checkPermission($idUsuario = null, $atividade = null)
    {
        if ($idUsuario == null || $atividade == null) {
            return false;
        }
        $pdo = DB::getPdo();
        $this->pdo = $pdo;

        $sql = "SELECT * FROM usuarios WHERE idUsuarios = $idUsuario";
        $query = $pdo->query($sql);
        $user = $query->fetch();
        $idPermissao = $user['permissoes_id'];
        // Se as permissões não estiverem carregadas, requisita o carregamento

        // Se não carregar retorna falso
        if (!$this->loadPermission($idPermissao)) {
            return false;
        }

        $permissoes = $this->loadPermission($idPermissao);

        if (is_array($permissoes)) {
            if (array_key_exists($atividade, $permissoes)) {
                // compara a atividade requisitada com a permissão.
                if ($permissoes[$atividade] == 1) {
                    return true;
                }
                return false;

            }
            return false;
        }
        return false;

    }

    public
    function loadPermission($id = null)
    {

        if ($id != null) {
            $pdo = DB::getPdo();
            $this->pdo = $pdo;
            $this->pdo->setAttribute($pdo::ATTR_ERRMODE, $pdo::ERRMODE_WARNING);

            $sql = "SELECT * FROM permissoes WHERE idPermissao = $id";
            $query = $pdo->query($sql);
            $permissao = $query->fetch();
            //$rows = $query->rowCount();
            //$this->sendMessage($permissao['permissoes']);
            if (!empty($permissao)) {
                //$this->sendMessage($permissao['permisssoes']);
                $array = unserialize($permissao['permissoes']);
                //Atribui as permissoes ao atributo permission
                //$this->Permission = array($array);
                return $array;
            }
            return false;

        }
        return false;
    }


}

