<?php
/**
 * This file is part of the TelegramBot package.
 *
 * (c) Avtandil Kikabidze aka LONGMAN <akalongman@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Longman\TelegramBot\Commands\SystemCommands;

use Longman\TelegramBot\Commands\SystemCommand;
use Longman\TelegramBot\Entities\InlineQuery\InlineQueryResultArticle;
use Longman\TelegramBot\Entities\InputMessageContent\InputTextMessageContent;
use Longman\TelegramBot\Request;

/**
 * Inline query command
 *
 * Command that handles inline queries.
 */
class InlinequeryCommand extends SystemCommand
{
    /**
     * @var string
     */
    protected $name = 'inlinequery';

    /**
     * @var string
     */
    protected $description = 'Reply to inline query';

    /**
     * @var string
     */
    protected $version = '1.1.1';

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {


        $inline_query = $this->getInlineQuery();
        $query        = $inline_query->getQuery();
        //$this->chat_id = $this->callback_query->getFrom()->getId();
        //$chat_id = $inline_query->getFrom()->getId();

        $data    = ['inline_query_id' => $inline_query->getId()];
        $results = [];
        /*
           $pdo = DB::getPdo();
           $this->pdo = $pdo;
           $this->pdo->setAttribute($pdo::ATTR_ERRMODE, $pdo::ERRMODE_WARNING);

           $sql = "SELECT * FROM usuarios WHERE chat_id = 889423113";
           $query = $pdo->query($sql);
           $this->user = $query->fetch();
           $rows = $query->rowCount();
   */
        $rows = 1;
        if ($rows > 0) {
            if ($query !== '') {
                //$query
                $token = rand(10000, 99999);
                $token = $query.$token;
                $message = "\xE2\x9C\xA8 Bem vindoaaaaa ao Night Company! \xE2\x9C\xA8\n\nAgora você pode comprar seus quitutes diretamente pela nossa loja online.\n\nPara continuar sua compra acesse o bot @NightCompany_Bot\nClique em Começar\nDigite seu código de cadastro\n\nAgora você pode inserir seu saldo e fazer seu pedido.\n\nAgradecemos a sua prefenrência.\n\nSeu código de cadastro: $token\n\n";
                        $articles = [
                            [
                                'id'                    => '001',
                                'title'                 => 'Liberar Token de cadastro',
                                'description'           => "Token: $token",
                                'input_message_content' => new InputTextMessageContent(['message_text' => $message]),
                            ],
                        ];

                }
                foreach ($articles as $article) {
                    $results[] = new InlineQueryResultArticle($article);
                }

            }


        $data['results'] = '[' . implode(',', $results) . ']';

        return Request::answerInlineQuery($data);
    }
}
