<?php
/**
 * This file is part of the TelegramBot package.
 *
 * (c) Avtandil Kikabidze aka LONGMAN <akalongman@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Longman\TelegramBot\Commands\SystemCommands;

use Longman\TelegramBot\Commands\SystemCommand;
use Longman\TelegramBot\Conversation;
use Longman\TelegramBot\Entities\InlineKeyboard;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;



/**
 * Start command
 *
 * Gets executed when a user first starts using the bot.
 */
class StartCommand extends SystemCommand
{
    /**
     * @var string
     */
    protected $name = 'start';

    /**
     * @var string
     */
    protected $description = 'Start command';

    /**
     * @var string
     */
    protected $usage = '/start';

    /**
     * @var string
     */
    protected $version = '1.1.0';

    /**
     * @var bool
     */
    protected $private_only = true;
    protected $need_mysql = true;
    protected $conversation;
    public $notes;

    public $message;
    public $message_id;
    public $chat;
    public $user;
    public $text;
    public $chat_id;
    public $user_id;

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {

        $this->message = $this->getMessage();
        $this->message_id = $this->message->getMessageId();
        $this->chat_id = $this->message->getChat()->getId();

        $pdo = DB::getPdo();
        $this->pdo = $pdo;
        $this->pdo->setAttribute($pdo::ATTR_ERRMODE, $pdo::ERRMODE_WARNING);
        $this->pdo->setAttribute($pdo::ATTR_EMULATE_PREPARES, false);
        $this->conversation = new Conversation(
            $this->getMessage()->getFrom()->getId(),
            $this->getMessage()->getChat()->getId()
        );

        $this->notes = &$this->conversation->notes;
        !is_array($this->notes) && $this->notes = [];

        $data['chat_id'] = $this->chat_id;
        $data['text'] = json_encode($this->notes);
        //return Request::sendMessage($data);

        if (!empty($this->notes['lastMsgId'])){
            Request::deleteMessage([
                'chat_id' => $this->chat_id,
                'message_id' => $this->notes['lastMsgId'],
            ]);
        }
        if (!empty($this->notes['msgInicialId'])){
            Request::deleteMessage([
                'chat_id' => $this->chat_id,
                'message_id' => $this->notes['msgInicialId'],
            ]);
        }
        if (!empty($this->notes['msgDadosEnvioId'])){
            Request::deleteMessage([
                'chat_id' => $this->chat_id,
                'message_id' => $this->notes['msgDadosEnvioId'],
            ]);
        }

        $this->conversation->stop();
        $this->conversation = new Conversation(
            $this->getMessage()->getFrom()->getId(),
            $this->getMessage()->getChat()->getId(),
            $this->getName()
        );
        $this->notes = &$this->conversation->notes;
        !is_array($this->notes) && $this->notes = [];

        $pdo = DB::getPdo();
        $sql = "SELECT * FROM usuarios WHERE chat_id = {$this->chat_id}";
        $query = $pdo->query($sql);
        $return = $query->fetch();
        $rows = $query->rowCount();
        if($rows > 0){

            $text = "Seja bem vindo! \nClique em \xF0\x9F\x8F\xA0 Menu principal \xF0\x9F\x8F\xA0";

            $inline_keyboard = new InlineKeyboard(
                [['text' => "\xF0\x9F\x8F\xA0 Menu principal \xF0\x9F\x8F\xA0", 'callback_data' => 'Main_Menu']]

            );
            $data = [
                'chat_id'      => $this->chat_id,
                'text'         => $text,
                'reply_markup' => $inline_keyboard,
                'resize_keyboard' => true,
                'parse_mode' => 'HTML'
            ];


        }else{
            $text = "\xF0\x9F\x94\x92 <b>Usuário não cadastrado!</b> \xF0\x9F\x94\x92\nDigite o código de cadastro";

            $inline_keyboard = new InlineKeyboard(
                [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
            );

            $data = [
                'chat_id' => $this->chat_id,
                'text'    => $text,
                //'reply_markup' => $inline_keyboard,
                'resize_keyboard' => true,
                'parse_mode' => 'HTML',
                'disable_web_page_preview'=>true
            ];


            $this->notes['requestData'] = "informarCodigoCadastro";
            $this->conversation->update();
        }

/*
        Request::deleteMessage([
            'chat_id' => $this->chat_id,
            'message_id' => $this->message_id,
        ]);
*/
        $result = Request::sendMessage($data);
        $this->conversation->notes['msgInicialId'] = $result->getResult()->getMessageId();
        $this->conversation->notes['msgStart'] = $result->getResult()->getMessageId();


        /*
        Request::sendMessage([
            'chat_id' => $this->chat_id,
            'message_id' => $this->message_id,
            'text' => $this->conversation->notes['msgInicialId'],
        ]);
        */
        $this->conversation->update();


        //$data['text'] = json_encode($this->conversation->notes);
        //Request::sendMessage($data);

        //$notes['msgInicialId'] = $result->getResult()->getMessageId();

        //$data['text'] = $conversation->notes['msgInicialId'];
        //Request::sendMessage($data);
    }
}
