<?php

namespace Telegram\Repository;

use PDO;

class UsuarioRepository
{
    private $pdo;

    public function __construct(PDO $pdo)
    {
        $this->pdo = $pdo;
    }

    public function buscaUsuarioByChat($chat_id)
    {
        $sql = "SELECT * FROM usuarios WHERE chat_id = :chat_id";
        $stmt = $this->pdo->prepare($sql);
        $stmt->bindParam(':chat_id', $chat_id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetch();
    }
}